/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardPager<T> {
    private Iterator<T> iterator;
    private int pageSize;
    private int itemsRetrieved;

    public ForwardPager(Iterator<T> iterator, int pageSize) {
        this.pageSize = pageSize;
        if (iterator != null && iterator.hasNext()) {
            this.iterator = iterator;
        }
    }

    public boolean isEndReached() {
        return this.iterator == null;
    }

    public boolean isMaxResultsReached() {
        return false;
    }

    public List<T> loadItems(int count) {
        ArrayList<T> results = new ArrayList<T>(count);
        if (this.iterator != null) {
            for (int i = 0; i < count; ++i) {
                if (this.iterator.hasNext()) {
                    T nextElement = this.iterator.next();
                    results.add(nextElement);
                    ++this.itemsRetrieved;
                    continue;
                }
                this.iterator = null;
                break;
            }
        }
        return results;
    }

    public List<T> loadNextPage() {
        return this.loadItems(this.pageSize);
    }

    public int getNumberOfItemsRetrieved() {
        return this.itemsRetrieved;
    }
}

