/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public final class DateUtil {
    private static DateFormat gmtIsoDateFormatter;
    private static DateFormat noTimezoneIsoDateFormatter;
    private static DateFormat xqueryDateFormatter;

    public static String getISODateString(Date date, boolean timeZoneAdjust) {
        String isoDateString = timeZoneAdjust ? gmtIsoDateFormatter.format(date) + "Z" : noTimezoneIsoDateFormatter.format(date);
        return isoDateString;
    }

    public static Date parseISODate(String isoDateString, boolean timeZoneAdjust) throws ParseException, DatatypeConfigurationException {
        Date date = timeZoneAdjust ? DatatypeFactory.newInstance().newXMLGregorianCalendar(isoDateString).toGregorianCalendar().getTime() : DatatypeFactory.newInstance().newXMLGregorianCalendar(isoDateString.substring(0, 19)).toGregorianCalendar().getTime();
        return date;
    }

    public static String getXQueryDateString(Date date) {
        String xqueryDate = xqueryDateFormatter.format(date);
        return xqueryDate;
    }

    public static Date parseXQueryDateString(String xqueryDateString) throws ParseException {
        return xqueryDateFormatter.parse(xqueryDateString);
    }

    static {
        xqueryDateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
        gmtIsoDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        gmtIsoDateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        noTimezoneIsoDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }
}

