/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ColumnUtil {
    public static final String DECLARED = "isDeclared";
    public static final String MAJORMINOR = "hasMinorVersion";
    public static final String LOCKED = "isLocked";
    public static final String SUSPENDED = "isSuspended";
    public static final String DEADLINE = "hasDeadline";
    public static final String ONHOLD = "hasHold";
    public static final String NOTE = "hasNote";
    public static final String BOOKMARK = "hasBookmark";
    public static int MAX_COLUMN_SIZE = 30;
    public static int MIN_COLUMN_SIZE = 5;
    public static int DEFAULT_COLUMN_SIZE = 15;
    public static int DEFAULT_DATE_TIME_SIZE = 10;
    public static int DEFAULT_NUMERIC_SIZE = 5;
    public static double AVERAGE_CHAR_WIDTH = 0.6;
    public static double COLUMN_PADDING = 2.0;

    public static Map buildColumnProperty(String name, String width, String symbolicName, String styles, Boolean removeSorting) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("name", name);
        propertyMap.put("width", width);
        propertyMap.put("field", symbolicName);
        if (styles != null) {
            propertyMap.put("styles", styles);
        }
        if (removeSorting.booleanValue()) {
            propertyMap.put("nosort", removeSorting);
        }
        propertyMap.put("sortable", removeSorting == false);
        if (symbolicName != null && symbolicName.equals("mimeTypeIcon")) {
            propertyMap.put("cellClasses", "ecmIconCell");
            propertyMap.put("headerClasses", "ecmIconCell");
            propertyMap.put("decorator", "DetailsViewDecorator.mimeTypeDecorator");
        }
        if (symbolicName != null && symbolicName.equals("icon")) {
            propertyMap.put("decorator", "DetailsViewDecorator.iconDecorator");
        }
        return propertyMap;
    }

    public static Map buildStateColumnProperty(HttpServletRequest request, String name, String symbolicName, Boolean nosort, Boolean supportsWorkflow, Boolean supportsDeclare) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("name", name);
        propertyMap.put("field", symbolicName);
        propertyMap.put("nosort", nosort);
        propertyMap.put("sortable", nosort == false);
        propertyMap.put("cellClasses", "ecmIconCell");
        propertyMap.put("headerClasses", "ecmIconCell");
        propertyMap.put("decorator", "DetailsViewDecorator.multiStateDecorator");
        DesktopConfig desktopConfig = Config.getDesktopConfig(request);
        String repositoryId = request.getParameter("repositoryId");
        RepositoryConfig repositoryConfig = desktopConfig.getRepository(repositoryId);
        if (repositoryConfig != null) {
            String type = repositoryConfig.getType();
            if (type.equalsIgnoreCase("p8")) {
                if (!supportsWorkflow.booleanValue()) {
                    ColumnUtil.buildP8StateList(repositoryConfig, propertyMap, supportsDeclare);
                } else {
                    ColumnUtil.buildP8WorkflowStateList(repositoryConfig, propertyMap);
                }
            } else if (type.equalsIgnoreCase("cm")) {
                ColumnUtil.buildCMStateList(repositoryConfig, propertyMap, supportsWorkflow, supportsDeclare);
            } else if (type.equalsIgnoreCase("od")) {
                ColumnUtil.buildODStateList(repositoryConfig, propertyMap, supportsDeclare);
            } else if (type.equalsIgnoreCase("cmis")) {
                ColumnUtil.buildCMISStateList(repositoryConfig, propertyMap, supportsDeclare);
            }
        } else {
            ColumnUtil.buildStateList(propertyMap);
        }
        return propertyMap;
    }

    private static void addColumnWidths(Map propertyMap, ArrayList states) {
        int marginSize = 0;
        if (states.size() > 1) {
            marginSize = (states.size() - 1) * 2;
        }
        String width = Integer.toString(states.size() * 16 + marginSize) + "px";
        propertyMap.put("width", width);
        width = Integer.toString(states.size() * 25 + marginSize) + "px";
        propertyMap.put("widthWebKit", width);
    }

    private static void buildP8StateList(RepositoryConfig repositoryConfig, Map propertyMap, Boolean supportsDeclare) {
        ArrayList<String> states = new ArrayList<String>();
        if (repositoryConfig.getStatusDocDeclaredRecord() && supportsDeclare.booleanValue()) {
            states.add(DECLARED);
        }
        if (repositoryConfig.getStatusDocMinorVersions()) {
            states.add(MAJORMINOR);
        }
        if (repositoryConfig.getStatusDocCheckedOut()) {
            states.add(LOCKED);
        }
        propertyMap.put("states", states);
        ColumnUtil.addColumnWidths(propertyMap, states);
    }

    private static void buildCMStateList(RepositoryConfig repositoryConfig, Map propertyMap, Boolean supportsWorkflow, Boolean supportsDeclare) {
        ArrayList<String> states = new ArrayList<String>();
        if (repositoryConfig.getStatusDocDeclaredRecord() && supportsDeclare.booleanValue()) {
            states.add(DECLARED);
        }
        if (supportsWorkflow.booleanValue() && repositoryConfig.getStatusWorkItemSuspended()) {
            states.add(SUSPENDED);
        }
        if (repositoryConfig.getStatusDocBookmarks()) {
            states.add(BOOKMARK);
        }
        if (supportsWorkflow.booleanValue()) {
            if (repositoryConfig.getStatusWorkItemCheckedOut()) {
                states.add(LOCKED);
            }
        } else if (repositoryConfig.getStatusDocCheckedOut()) {
            states.add(LOCKED);
        }
        propertyMap.put("states", states);
        ColumnUtil.addColumnWidths(propertyMap, states);
    }

    private static void buildODStateList(RepositoryConfig repositoryConfig, Map propertyMap, Boolean supportsDeclare) {
        ArrayList<String> states = new ArrayList<String>();
        if (repositoryConfig.getStatusDocHold()) {
            states.add(ONHOLD);
        }
        if (repositoryConfig.getStatusDocNotes()) {
            states.add(NOTE);
        }
        propertyMap.put("states", states);
        ColumnUtil.addColumnWidths(propertyMap, states);
    }

    private static void buildCMISStateList(RepositoryConfig repositoryConfig, Map propertyMap, Boolean supportsDeclare) {
        ArrayList<String> states = new ArrayList<String>();
        if (repositoryConfig.getStatusDocDeclaredRecord() && supportsDeclare.booleanValue()) {
            states.add(DECLARED);
        }
        if (repositoryConfig.getStatusDocCheckedOut()) {
            states.add(LOCKED);
        }
        propertyMap.put("states", states);
        ColumnUtil.addColumnWidths(propertyMap, states);
    }

    private static void buildP8WorkflowStateList(RepositoryConfig repositoryConfig, Map propertyMap) {
        ArrayList<String> states = new ArrayList<String>();
        if (repositoryConfig.getStatusWorkItemDeadline()) {
            states.add(DEADLINE);
        }
        if (repositoryConfig.getStatusWorkItemLocked()) {
            states.add(LOCKED);
        }
        propertyMap.put("states", states);
        ColumnUtil.addColumnWidths(propertyMap, states);
    }

    private static void buildStateList(Map propertyMap) {
        ArrayList<String> states = new ArrayList<String>();
        states.add(LOCKED);
        propertyMap.put("states", states);
        ColumnUtil.addColumnWidths(propertyMap, states);
    }

    public static String getColumnWidth(int nameLength, int valueLength, boolean isDateTime, boolean isNumeric) {
        double size = isDateTime ? DEFAULT_DATE_TIME_SIZE : (isNumeric ? DEFAULT_NUMERIC_SIZE : DEFAULT_COLUMN_SIZE);
        if (valueLength > 0) {
            if (isDateTime || isNumeric) {
                size = Math.max((double)valueLength, size);
            } else if ((double)valueLength > size) {
                size = Math.min(valueLength, MAX_COLUMN_SIZE);
            } else if ((double)valueLength < size) {
                size = Math.max(valueLength, MIN_COLUMN_SIZE);
            }
        }
        if (nameLength > 0) {
            size = Math.max((double)Math.min(nameLength, MAX_COLUMN_SIZE), size);
        }
        return size * AVERAGE_CHAR_WIDTH + COLUMN_PADDING + "em";
    }
}

