/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.Results;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.CollationKey;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class BaseUtil {
    private String className = this.getClass().getName();
    private ServletContext controllerServletContext = null;

    public ServletContext getControllerServletContext() {
        return this.controllerServletContext;
    }

    public void setControllerServletContext(ServletContext controllerServletContext) {
        this.controllerServletContext = controllerServletContext;
    }

    public Object getAttribute(ServletRequest request, String name) {
        String methodName = "getAttribute";
        Object property = request.getParameter(name);
        if (property == null || property instanceof String && ((String)property).length() == 0) {
            property = this.getAttributeWithoutParameter(request, name);
        }
        return property;
    }

    public Object getAttributeWithoutParameter(ServletRequest request, String name) {
        ServletContext servletContext;
        String methodName = "getAttributeWithoutParameter";
        HttpSession session = this.getSession(request);
        Object property = request.getAttribute(name);
        if ((property == null || property instanceof String && ((String)property).length() == 0) && session != null) {
            property = session.getAttribute(name);
        }
        if ((property == null || property instanceof String && ((String)property).length() == 0) && (servletContext = this.getControllerServletContext()) != null) {
            property = servletContext.getAttribute(name);
        }
        return property;
    }

    public void setAttribute(ServletRequest request, Object value, String name) {
        String methodName = "setAttribute";
        Logger.logEntry((Object)this.className, methodName, request);
        HttpSession session = this.getSession(request);
        Object property = null;
        if (session != null && "true".equals(property)) {
            Logger.logDebug((Object)this, methodName, request, "storing attribtue in session, session store is enabled");
            session.setAttribute(name, value);
        } else {
            Logger.logDebug((Object)this, methodName, request, "storing attribtue in request, session store is disabled");
            request.setAttribute(name, value);
        }
        Logger.logExit((Object)this.className, methodName, request);
    }

    public String getDelimiter(ServletContext application) {
        return ";";
    }

    public String getValidFilename(String fileName) {
        fileName = fileName.replace('\\', '-');
        fileName = fileName.replace('/', '-');
        fileName = fileName.replace(':', '-');
        fileName = fileName.replace('*', '-');
        fileName = fileName.replace('?', '-');
        fileName = fileName.replace('\"', '-');
        fileName = fileName.replace('<', '-');
        fileName = fileName.replace('>', '-');
        fileName = fileName.replace('|', '-');
        return fileName;
    }

    public static String replaceString(String message, String token, String replacementText) {
        StringTokenizer st = new StringTokenizer(message, token);
        StringBuffer newMessage = new StringBuffer(message.length());
        int pos = 0;
        int len = token.length();
        pos = message.indexOf(token);
        while (pos != -1) {
            String preString = message.substring(0, pos);
            String postString = message.substring(pos + len, message.length());
            message = preString + replacementText + postString;
            pos = message.indexOf(token);
        }
        return message.toString().trim();
    }

    public String replaceText(String message, String token, String replacementText) {
        return BaseUtil.replaceString(message, token, replacementText);
    }

    public String[] convertFromVectortoStringArray(Vector vec) {
        String[] tmpArray = new String[vec.size()];
        for (int counter = 0; counter < vec.size(); ++counter) {
            tmpArray[counter] = (String)vec.elementAt(counter);
        }
        return tmpArray;
    }

    public String[] sortStringArray(String[] array, boolean descending, Locale locale) {
        if (array != null && locale != null) {
            String[] tmpArray = new String[array.length];
            Arrays.sort(array, Collator.getInstance(locale));
            if (descending) {
                int counter = 0;
                int counter2 = array.length - 1;
                while (counter < array.length) {
                    tmpArray[counter] = array[counter2];
                    ++counter;
                    --counter2;
                }
                array = tmpArray;
            }
        }
        return array;
    }

    protected HttpSession getSession(ServletRequest request) {
        HttpSession session = null;
        if (request instanceof HttpServletRequest) {
            session = ((HttpServletRequest)request).getSession(false);
        }
        return session;
    }

    public String getEncoding(HttpServletRequest request) {
        return "UTF-8";
    }

    public Results invokeAction(HttpServletRequest request, String actionURL, String queryStringData) throws Exception {
        String methodName = "invokeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        URL url = null;
        Cookie[] cookies = request.getCookies();
        StringBuffer cookieProperty = new StringBuffer();
        for (int j = 0; j < cookies.length; ++j) {
            cookieProperty.append(cookies[j].getName());
            cookieProperty.append("=");
            cookieProperty.append(cookies[j].getValue());
            cookieProperty.append(",");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            // empty catch block
        }
        url = new URL(actionURL);
        HttpURLConnection urlConn = null;
        if (request.isSecure()) {
            urlConn = (HttpsURLConnection)url.openConnection();
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "request is secure");
        } else {
            urlConn = (HttpURLConnection)url.openConnection();
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "request is not secure");
        }
        urlConn.setRequestProperty("COOKIE", cookieProperty.toString());
        urlConn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(urlConn.getOutputStream());
        wr.write(queryStringData);
        wr.flush();
        wr.close();
        int contentLength = urlConn.getContentLength();
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "content length =" + contentLength);
        byte[] results = null;
        int bufsize = 4096;
        byte[] buf = new byte[bufsize];
        int size = 0;
        if (contentLength != -1) {
            results = new byte[contentLength];
            size = contentLength;
        } else {
            results = new byte[]{};
        }
        BufferedInputStream bis = new BufferedInputStream(urlConn.getInputStream());
        int numRead = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "content size=" + size);
        while ((numRead = bis.read(buf, 0, bufsize)) != -1 && numRead <= size) {
            baos.write(buf, 0, numRead);
        }
        bis.close();
        results = baos.toByteArray();
        baos.flush();
        baos.close();
        Results resultObject = new Results();
        resultObject.setResults(results);
        String contentType = urlConn.getContentType();
        resultObject.setContentType(contentType);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "content type=" + contentType);
        return resultObject;
    }

    public boolean isEven(int tokens) {
        String methodName = "isEven";
        float tempNumb = (float)tokens / 2.0f;
        boolean isEven = (double)tempNumb - Math.floor(tempNumb) == 0.0;
        return isEven;
    }

    public static int toIntType(Object intV, int defaultValue) {
        int iVal = defaultValue;
        if (intV == null) {
            iVal = defaultValue;
        } else if (intV instanceof String) {
            try {
                iVal = Integer.parseInt((String)intV);
            }
            catch (NumberFormatException e) {
                iVal = defaultValue;
            }
        } else if (intV instanceof Integer) {
            try {
                iVal = (Integer)intV;
            }
            catch (Exception e) {
                iVal = defaultValue;
            }
        } else {
            iVal = defaultValue;
        }
        return iVal;
    }

    public static boolean toBooleanType(Object truefalse, boolean defaultValue) {
        boolean bVal = defaultValue;
        if (truefalse == null) {
            bVal = defaultValue;
        } else if (truefalse instanceof String) {
            try {
                Boolean tmpBoolean = new Boolean((String)truefalse);
                bVal = tmpBoolean;
            }
            catch (Exception e) {
                bVal = defaultValue;
            }
        } else if (truefalse instanceof Boolean) {
            try {
                bVal = (Boolean)truefalse;
            }
            catch (Exception e) {
                bVal = defaultValue;
            }
        } else {
            bVal = defaultValue;
        }
        return bVal;
    }

    public static boolean validateDate(String date1) {
        int day;
        int month;
        int year;
        try {
            StringTokenizer tk = new StringTokenizer(date1, "-");
            year = Integer.parseInt(tk.nextToken());
            month = Integer.parseInt(tk.nextToken());
            day = Integer.parseInt(tk.nextToken());
        }
        catch (Exception e) {
            return false;
        }
        if (year < 1970) {
            return false;
        }
        if (month > 12 || month < 1) {
            return false;
        }
        return !(month == 2 ? (year % 4 == 0 ? day > 28 || day < 1 : day > 29 || day < 1) : (month == 4 || month == 6 || month == 9 || month == 11 ? day > 30 || day < 1 : day > 31 || day < 1));
    }

    public static String changeTimeZone(String tmStr, String tmFormat, TimeZone fromTimeZone, TimeZone toTimeZone) {
        try {
            tmStr = tmStr.substring(0, tmFormat.length() - 1);
            SimpleDateFormat dateFormat = new SimpleDateFormat(tmFormat);
            dateFormat.setTimeZone(fromTimeZone);
            Date convertedDate = dateFormat.parse(tmStr);
            dateFormat.setTimeZone(toTimeZone);
            return dateFormat.format(convertedDate);
        }
        catch (Exception e) {
            return tmStr;
        }
    }

    public static String[] sort(String[] array, Locale locale) {
        if (array == null || array.length == 0) {
            return array;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(array));
        WCComparator comparator = new WCComparator();
        Collator localCollator = BaseUtil.getCollator(locale);
        comparator.setCollator(localCollator);
        Collections.sort(list, comparator);
        return BaseUtil.getArrayFromList(list);
    }

    private static String[] getArrayFromList(List list) {
        if (list.size() == 0) {
            return new String[0];
        }
        int size = list.size();
        String[] tempArray = new String[size];
        for (int a = 0; a < size; ++a) {
            tempArray[a] = (String)list.get(a);
        }
        return tempArray;
    }

    public static boolean isMatch(String checkString, String pattern) {
        int j;
        int patternPos = 0;
        for (int i = 0; i < checkString.length(); ++i) {
            if (patternPos >= pattern.length()) {
                return false;
            }
            char patternChar = pattern.charAt(patternPos);
            char thisChar = checkString.charAt(i);
            switch (patternChar) {
                case '*': {
                    if (patternPos >= pattern.length() - 1) {
                        return true;
                    }
                    for (j = i; j < checkString.length(); ++j) {
                        if (!BaseUtil.isMatch(checkString.substring(j), pattern.substring(patternPos + 1))) continue;
                        return true;
                    }
                    return false;
                }
                case '?': {
                    break;
                }
                case '[': {
                    if (patternPos >= pattern.length() - 1) {
                        return false;
                    }
                    char lastPatternChar = '\u0000';
                    for (j = patternPos + 1; j < pattern.length(); ++j) {
                        patternChar = pattern.charAt(j);
                        if (patternChar == ']') {
                            return false;
                        }
                        if (patternChar == '-') {
                            if (++j == pattern.length()) {
                                return false;
                            }
                            patternChar = pattern.charAt(j);
                            if (patternChar == ']') {
                                return false;
                            }
                            if (thisChar >= lastPatternChar && thisChar <= patternChar) {
                                break;
                            }
                        } else if (thisChar == patternChar) break;
                        lastPatternChar = patternChar;
                    }
                    for (j = patternPos = j; j < pattern.length() && pattern.charAt(j) != ']'; ++j) {
                    }
                    patternPos = j;
                    break;
                }
                default: {
                    if (thisChar == patternChar) break;
                    return false;
                }
            }
            ++patternPos;
        }
        for (j = patternPos; j < pattern.length() && pattern.charAt(j) == '*'; ++j) {
        }
        patternPos = j;
        return patternPos == pattern.length();
    }

    private static Collator getCollator(Locale locale) {
        Collator localCollator = null;
        localCollator = locale == null ? Collator.getInstance() : Collator.getInstance(locale);
        return localCollator;
    }

    public static String[] toStringArray(Collection coll) {
        if (coll == null) {
            return new String[0];
        }
        String[] retVal = new String[coll.size()];
        Iterator iter = coll.iterator();
        int i = 0;
        while (iter.hasNext()) {
            retVal[i++] = (String)iter.next();
        }
        return retVal;
    }

    public String getMimeTypeFromFileName(HttpServletRequest request, String fileName) throws Exception {
        String methodName = "getMimeTypeFromFileName";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String partMimeType = null;
        try {
            int index = fileName.lastIndexOf(".");
            if (index != -1) {
                String fileExtension = fileName.substring(index + 1, fileName.length());
                partMimeType = MimeTypeUtil.getMimeType(fileExtension);
            } else {
                partMimeType = null;
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return partMimeType;
    }

    public static String getCustomLabelValue(HttpServletRequest request, String id) {
        String applicationName = request.getParameter("application");
        InterfaceTextConfig labelUI = null;
        String customLabel = null;
        try {
            labelUI = Config.getInterfaceTextConfig(applicationName, id);
            customLabel = labelUI.getLocaleData().getPropertyValue(request.getLocale().getLanguage());
        }
        catch (Exception e) {
            customLabel = null;
        }
        return customLabel;
    }

    private class HttpException
    extends Exception {
        int statusCode;

        HttpException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    private static class WCComparator
    implements Comparator {
        Collator collator = Collator.getInstance();

        private WCComparator() {
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = this.collator.getCollationKey(element1.toString());
            CollationKey key2 = this.collator.getCollationKey(element2.toString());
            return key1.compareTo(key2);
        }

        public void setCollator(Collator collator) {
            this.collator = collator;
        }
    }
}

