/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.util;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.extension.PluginAction;
import com.ibm.ecm.extension.PluginMenu;
import com.ibm.ecm.util.PluginUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUtil {
    public static List<MenuConfig> getActionsIdsAsMenuConfig(HttpServletRequest request, ApplicationConfig appConfig, String[] actionIds) throws ConfigurationException, MissingValueException {
        if (actionIds == null) {
            return new ArrayList<MenuConfig>();
        }
        MenuConfig config = new MenuConfig(appConfig.getConfigurationObject(), appConfig.getObjectId(), "dummyId");
        config.setItems(actionIds);
        config.loadSubMenus(request);
        Config.removeConfigurationFromCache(config);
        return config.getSubMenus();
    }

    public static List<MenuConfig> getActionsForMenuId(HttpServletRequest request, ApplicationConfig appConfig, String menuId) throws ConfigurationException, MissingValueException {
        Map<String, PluginMenu> pluginMenuMap = PluginUtil.getPluginMenus(request);
        PluginMenu pluginMenu = pluginMenuMap.get(menuId);
        if (pluginMenu != null) {
            MenuConfig menuConfig = new MenuConfig(appConfig.getConfigurationObject(), appConfig.getObjectId(), "dummyId");
            menuConfig.loadPluginMenu(request, pluginMenu);
            Config.removeConfigurationFromCache(menuConfig);
            return menuConfig.getSubMenus();
        }
        return MenuConfig.getClonedMenu(request, appConfig.getObjectId(), menuId);
    }

    public static void loadData(List<MenuConfig> menus, List<MenuConfig> listToAddTo, boolean firstLevelOnly) {
        for (int i = 0; i < menus.size(); ++i) {
            MenuConfig menuConfig = menus.get(i);
            if (firstLevelOnly) {
                listToAddTo.add(menuConfig);
                continue;
            }
            if (!menuConfig.getId().equals("Separator") && menuConfig.getSubMenus().size() == 0) {
                listToAddTo.add(menuConfig);
            }
            if (menuConfig.getSubMenus().size() <= 0) continue;
            ActionUtil.loadData(menuConfig.getSubMenus(), listToAddTo, firstLevelOnly);
        }
    }

    public static String[] getAllActionIds() {
        String[] actionIds = new String[]{"ApplyHold", "SendLinksToDocs", "CheckIn", "CheckOutLabelWithDownload", "CheckOutDownload", "CheckOutNoDownload", "DeleteWorkspace", "DeleteItem", "Download", "DownloadAsPdf", "EditWorkspace", "OpenSearch", "OpenSearchInTab", "OpenFolder", "ViewStep", "OpenSearchNewTab", "Preview", "EditSearch", "SearchProperties", "SendLinksToSearches", "MoveToInbox", "CreateTeamSpace", "CreateTemplate", "RefreshInbasket", "ReturnToSender", "Reassign", "DeleteTracker", "AddFolderAttachment", "SelectFolderAttachment", "AddDocumentAttachment", "SelectDocumentAttachment", "ExportBasic", "ExportCustom", "Launch", "RefreshGrid", "CreateFolder", "CreateFolderUsingTemplate", "Edit", "Help", "About", "ChangePassword", "LogOut", "LogIn", "ConnectRepository", "Import", "ImportUsingTemplate", "CreateHold", "MoveDocumentToFolder", "DemoteVersion", "PromoteVersion", "View", "AddToFavorites", "RenameFavorite", "AddToFolder", "PrintDoc", "EditDoc", "RemoveFromFolder", "SendAttachments", "ViewAnnotation", "StartWF", "ResumeWF", "RemoveWF", "ContinueWF", "EditWF", "SuspendWF", "Unlock", "ShowHyperlink", "MoveFolderToFolder", "ServerPrint", "RemoveHold", "DisableWorkspace", "EnableWorkspace", "EditTeamspaceTeam", "EditTeamspaceSearches", "EditTeamspaceClasses", "WorkspaceProperties", "SendLinksToFolders", "DeleteFavorite", "MakeWorkspaceTemplateDefault", "ViewRecordInfo", "OpenTeamspace", "LaunchWorkflowAction"};
        return actionIds;
    }

    public static String[] getAllLabelIds() {
        String[] actionIds = new String[]{"DefaultDownload", "DefaultCheckOut", "DefaultFolderActions", "DefaultSendEmail", "DefaultHolds", "DefaultExport", "DefaultMoreActions", "DefaultTeamspaceManageActions"};
        return actionIds;
    }

    public static List<MenuConfig> getAllActions(HttpServletRequest request, String applicationName) throws Exception {
        ApplicationConfig appConfig = Config.getApplicationConfig(applicationName);
        MenuConfig allActionsMenuConfig = new MenuConfig(appConfig.getConfigurationObject(), appConfig.getObjectId(), "allActions");
        allActionsMenuConfig.setItems(ActionUtil.getAllActionIds());
        allActionsMenuConfig.loadSubMenus(request);
        List<MenuConfig> menuActions = allActionsMenuConfig.getSubMenus();
        ActionUtil.addPluginActionsToMenuConfigList(request, appConfig, menuActions, PluginUtil.getPluginActions(request));
        return menuActions;
    }

    public static void addPluginActionsToMenuConfigList(HttpServletRequest request, ApplicationConfig appConfig, List<MenuConfig> menuActions, Map<String, PluginAction> pluginActions) throws Exception {
        ActionUtil.getActionAttributes(request, menuActions, pluginActions);
        for (String key : pluginActions.keySet()) {
            PluginAction pluginAction = pluginActions.get(key);
            MenuConfig actionMenuConfig = new MenuConfig(appConfig.getConfigurationObject(), appConfig.getObjectId(), pluginAction.getId());
            actionMenuConfig.copy(request, pluginAction);
            menuActions.add(actionMenuConfig);
        }
    }

    public static void getActionAttributes(HttpServletRequest request, List<MenuConfig> clonedActions, Map<String, PluginAction> pluginActions) throws Exception {
        for (MenuConfig menu : clonedActions) {
            if (menu.getSubMenus().size() == 0) {
                if (pluginActions != null && pluginActions.size() > 0) {
                    PluginAction pluginAction = pluginActions.get(menu.getObjectId());
                    if (pluginAction != null) {
                        menu.copy(request, pluginAction);
                        continue;
                    }
                    menu = ActionUtil.addAction(menu);
                    continue;
                }
                menu = ActionUtil.addAction(menu);
                continue;
            }
            ActionUtil.getActionAttributes(request, menu.getSubMenus(), pluginActions);
        }
    }

    public static String getDesktopMenuId(HttpServletRequest request, String desktopName, String menuType) {
        DesktopConfig desktopConfig;
        String retValue = null;
        if (desktopName != null && (desktopConfig = Config.getDesktopConfig(request)).getProperty(menuType) != null) {
            retValue = desktopConfig.getProperty(menuType);
        }
        if (retValue == null) {
            retValue = "Default" + menuType;
        }
        return retValue;
    }

    public static MenuConfig addAction(MenuConfig config) {
        String actionId = config.getObjectId();
        String icon = actionId + ".png";
        String pluginId = "";
        String actionFunction = "action" + actionId;
        boolean isMultiDoc = false;
        boolean isGlobal = false;
        String privilegeName = "";
        String widgetType = "";
        String widgetFunction = "";
        String serverTypes = "";
        if (actionId.equals("Properties")) {
            actionFunction = "actionProperties";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("View")) {
            actionFunction = "actionView";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privViewDoc";
            serverTypes = "";
        } else if (actionId.equals("Preview")) {
            actionFunction = "actionPreview";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privViewDoc";
            serverTypes = "";
        } else if (actionId.equals("Edit")) {
            actionFunction = "actionEdit";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,od,p8,cmis";
        } else if (actionId.equals("DemoteVersion")) {
            actionFunction = "actionDemoteVersion";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("DeleteVersions")) {
            actionFunction = "actionDeleteVersions";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("MoreActions")) {
            actionFunction = "";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("SendLinksToDocs")) {
            actionFunction = "actionSendLinksToDocs";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("SendLinksToFolders")) {
            actionFunction = "actionSendLinksToFolders";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("SendAttachments")) {
            actionFunction = "actionSendAttachments";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privEmailDoc";
            serverTypes = "";
        } else if (actionId.equals("ViewAnnotation")) {
            actionFunction = "actionViewAnnotation";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privViewNotes";
            serverTypes = "od";
        } else if (actionId.equals("ServerPrint")) {
            actionFunction = "actionServerPrint";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privPrintDoc";
            serverTypes = "od";
        } else if (actionId.equals("PrintDoc")) {
            actionFunction = "actionPrintDoc";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privPrintDoc";
            serverTypes = "cm,p8,od";
        } else if (actionId.equals("FolderActions")) {
            actionFunction = "";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("Holds")) {
            actionFunction = "";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privHold";
            serverTypes = "od";
        } else if (actionId.equals("ApplyHold")) {
            actionFunction = "actionApplyHold";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privHold";
            serverTypes = "od";
        } else if (actionId.equals("RemoveHold")) {
            actionFunction = "actionRemoveHold";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privHold";
            serverTypes = "od";
        } else if (actionId.equals("CreateHold")) {
            actionFunction = "actionCreateHold";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "privCreateHold";
            serverTypes = "od";
        } else if (actionId.equals("ViewRecordInfo")) {
            actionFunction = "actionViewRecordInfo";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privNoCheck";
            serverTypes = "od";
        } else if (actionId.equals("EditWF")) {
            actionFunction = "actionEditWF";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privEditWF";
            serverTypes = "cm";
        } else if (actionId.equals("ContinueWF")) {
            actionFunction = "actionContinueWF";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privContinueWF";
            serverTypes = "cm";
        } else if (actionId.equals("SuspendWF")) {
            actionFunction = "actionSuspendWF";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privSuspendWF";
            serverTypes = "cm";
        } else if (actionId.equals("ResumeWF")) {
            actionFunction = "actionResumeWF";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privResumeWF";
            serverTypes = "cm";
        } else if (actionId.equals("RemoveWF")) {
            actionFunction = "actionRemoveWF";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privRemoveWF";
            serverTypes = "cm";
        } else if (actionId.equals("WFVars")) {
            actionFunction = "actionWFVars";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privViewWFVariables";
            serverTypes = "cm";
        } else if (actionId.equals("RefreshWF")) {
            actionFunction = "actionRefreshWF";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privRefreshWorkflow";
            serverTypes = "cm";
        } else if (actionId.equals("EditDoc")) {
            actionFunction = "actionEditDoc";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privCheckInOutDoc,privCheckOutDoc,privEditDoc";
            serverTypes = "cm";
        } else if (actionId.equals("Download")) {
            actionFunction = "actionDownload";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privExport";
            serverTypes = "";
        } else if (actionId.equals("DownloadAsOriginal")) {
            actionFunction = "actionDownloadAsOriginal";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privExport";
            serverTypes = "";
        } else if (actionId.equals("DownloadAsPdf")) {
            actionFunction = "actionDownloadAsPdf";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privExport";
            serverTypes = "cm,od,p8";
        } else if (actionId.equals("Lock")) {
            actionFunction = "actionLock";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privCheckInOutDoc";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("Unlock")) {
            actionFunction = "actionUnlock";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privCancelCheckOutDoc";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("CheckOut")) {
            actionFunction = "actionCheckOut";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privCheckOutDoc,privExport";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("CheckOutDownload")) {
            actionFunction = "actionCheckOut";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privCheckOutDoc,privExport";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("CheckOutNoDownload")) {
            actionFunction = "actionCheckOutNoDownload";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privCheckOutDoc,privExport";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("CheckIn")) {
            actionFunction = "actionCheckIn";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privCheckInOutDoc,privEditDoc";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("Import")) {
            actionFunction = "actionImport";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "addDoc";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("ImportUsingTemplate")) {
            actionFunction = "actionImportUsingTemplate";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "addDoc";
            serverTypes = "p8";
        } else if (actionId.equals("AddToFavorites")) {
            actionFunction = "actionAddToFavorites";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("CreateFolder")) {
            actionFunction = "actionCreateFolder";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "addItem";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("CreateFolderUsingTemplate")) {
            actionFunction = "actionCreateFolderUsingTemplate";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "addItem,foldering";
            serverTypes = "p8";
        } else if (actionId.equals("AddToFolder")) {
            actionFunction = "actionAddToFolder";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privAddToFolder";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("MoveFolderToFolder")) {
            actionFunction = "actionMoveFolderToFolder";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privMoveToFolder";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("MoveDocumentToFolder")) {
            actionFunction = "actionMoveDocumentToFolder";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privMoveToFolder";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("RemoveFromFolder")) {
            actionFunction = "actionRemoveFromFolder";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("DeleteItem")) {
            actionFunction = "actionDeleteItem";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privDelete";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("ShowHyperlink")) {
            actionFunction = "actionShowHyperlink";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("RefreshGrid")) {
            actionFunction = "actionRefreshGrid";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "privNoCheck";
            serverTypes = "";
        } else if (actionId.equals("Separator")) {
            actionFunction = "";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "privNoCheck";
            serverTypes = "";
        } else if (actionId.equals("StartWF")) {
            actionFunction = "actionStartWF";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privStartWorkflow";
            serverTypes = "cm";
        } else if (actionId.equals("Launch")) {
            actionFunction = "actionLaunch";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("ExportBasic")) {
            actionFunction = "actionExportBasic";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("ExportCustom")) {
            actionFunction = "actionExportCustom";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("ChangePassword")) {
            actionFunction = "actionChangePassword";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "privChangePassword";
            serverTypes = "cm,od";
        } else if (actionId.equals("Undo")) {
            actionFunction = "actionUndo";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("Redo")) {
            actionFunction = "actionRedo";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("RefreshInbasket")) {
            actionFunction = "actionRefreshInbasket";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "privRefreshInbasket";
            serverTypes = "cm";
        } else if (actionId.equals("ViewStep")) {
            actionFunction = "actionViewStep";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8,cmis";
        } else if (actionId.equals("MoveToInbox")) {
            actionFunction = "actionMoveToInbox";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("ReturnToSender")) {
            actionFunction = "actionReturnToSender";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("Reassign")) {
            actionFunction = "actionReassign";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("DeleteTracker")) {
            actionFunction = "actionDeleteTracker";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("AddExistingAttachment")) {
            actionFunction = "actionAddExistingAttachment";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("AddDocumentAttachment")) {
            actionFunction = "actionAddDocumentAttachment";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("AddFolderAttachment")) {
            actionFunction = "actionAddFolderAttachment";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("RemoveAttachment")) {
            actionFunction = "actionRemoveAttachment";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("EditWorkspace")) {
            actionFunction = "actionEditWorkspace";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privEdit";
            serverTypes = "cm,p8";
        } else if (actionId.equals("DeleteWorkspace")) {
            actionFunction = "actionDeleteWorkspace";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privDelete";
            serverTypes = "cm,p8";
        } else if (actionId.equals("OpenTeamspace")) {
            actionFunction = "actionOpenTeamspace";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("DisableWorkspace")) {
            actionFunction = "actionDisableWorkspace";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("EnableWorkspace")) {
            actionFunction = "actionEnableWorkspace";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("WorkspaceProperties")) {
            actionFunction = "actionWorkspaceProperties";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privEdit";
            serverTypes = "cm,p8";
        } else if (actionId.equals("EditTeamspaceTeam")) {
            actionFunction = "actionEditTeamspaceTeam";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "addRemoveRoleParticipants";
            serverTypes = "cm,p8";
        } else if (actionId.equals("EditTeamspaceSearches")) {
            actionFunction = "actionEditTeamspaceSearches";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "addNewSearches";
            serverTypes = "cm,p8";
        } else if (actionId.equals("EditTeamspaceClasses")) {
            actionFunction = "actionEditTeamspaceClasses";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "addRemoveClassesOrEntryTemplates";
            serverTypes = "cm,p8";
        } else if (actionId.equals("OpenSearch")) {
            actionFunction = "actionOpenSearch";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("OpenSearchInTab")) {
            actionFunction = "actionOpenSearchInTab";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("OpenSearchNewTab")) {
            actionFunction = "actionOpenSearchNewTab";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("EditSearch")) {
            actionFunction = "actionEditSearch";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("SearchProperties")) {
            actionFunction = "actionSearchProperties";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("SendLinksToSearches")) {
            actionFunction = "actionSendLinksToSearches";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("OpenFolder")) {
            actionFunction = "actionOpenFolder";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("CreateTeamSpace")) {
            actionFunction = "actionCreateTeamSpace";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privAddTeamspace";
            serverTypes = "cm,p8";
        } else if (actionId.equals("CreateTemplate")) {
            actionFunction = "actionCreateTemplate";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privAddTeamspaceTemplate";
            serverTypes = "cm,p8";
        } else if (actionId.equals("ManageTeamspaces")) {
            actionFunction = "actionManageTeamspaces";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "cm,p8";
        } else if (actionId.equals("SelectFolderAttachment")) {
            actionFunction = "actionSelectFolderAttachment";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("SelectDocumentAttachment")) {
            actionFunction = "actionSelectDocumentAttachment";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("Help")) {
            actionFunction = "actionHelp";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("About")) {
            actionFunction = "actionAbout";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("LogOut")) {
            actionFunction = "actionLogOut";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("TabbedLayout")) {
            actionFunction = "actionTabbedLayout";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("SplitHorizontalLayout")) {
            actionFunction = "actionSplitHorizontalLayout";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("SplitVerticalLayout")) {
            actionFunction = "actionSplitVerticalLayout";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("ItemActions")) {
            actionFunction = "actionItemActions";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("PreviousInResults")) {
            actionFunction = "actionPreviousInResults";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("NextInResults")) {
            actionFunction = "actionNextInResults";
            isMultiDoc = true;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("CheckOutLabelWithDownload")) {
            actionFunction = "actionCheckOutLabelWithDownload";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privCheckOutDoc,privExport";
            serverTypes = "cm,p8,cmis";
        } else if (actionId.equals("PromoteVersion")) {
            actionFunction = "actionPromoteVersion";
            isMultiDoc = false;
            isGlobal = false;
            privilegeName = "";
            serverTypes = "p8";
        } else if (actionId.equals("RenameFavorite")) {
            actionFunction = "actionRenameFavorite";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privAddDoc";
            serverTypes = "cm,p8";
        } else if (actionId.equals("DeleteFavorite")) {
            actionFunction = "actionDeleteFavorite";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privAddDoc";
            serverTypes = "cm,p8";
        } else if (actionId.equals("PrintDoc")) {
            actionFunction = "actionPrintDoc";
            isMultiDoc = true;
            isGlobal = false;
            privilegeName = "privPrintDoc";
            serverTypes = "od";
        } else if (actionId.equals("MakeWorkspaceTemplateDefault")) {
            actionFunction = "actionMakeWorkspaceTemplateDefault";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "privEdit";
            serverTypes = "p8,cm";
        } else if (actionId.equals("EditTeamspaceEntryTemplates")) {
            actionFunction = "actionEditTeamspaceEntryTemplates";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "";
        } else if (actionId.equals("LaunchWorkflowAction")) {
            actionFunction = "actionLaunchWorkflowAction";
            isMultiDoc = false;
            isGlobal = true;
            privilegeName = "";
            serverTypes = "p8";
        }
        if (actionFunction != null) {
            config.setAction(actionFunction);
            config.setGlobal(isGlobal);
            config.setIcon(icon);
            config.setMultiDoc(isMultiDoc);
            config.setPrivilegeNames(privilegeName.split(","));
            config.setPluginId(pluginId);
            config.setWidgetType(widgetType);
            config.setWidgetFunction(widgetFunction);
            config.setServerTypes(serverTypes.split(","));
            config.setId(actionId);
        }
        return config;
    }
}

