/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace.p8;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;

public class TestTeamspaceService {
    public static void main(String[] args) {
        Connection conn = Factory.Connection.getConnection((String)"http://grnvm15.svl.ibm.com:9080/wsi/FNCEWS40MTOM");
        try {
            Subject subject = UserContext.createSubject((Connection)conn, (String)"p8admin", (String)"dingo4FVT", (String)"FileNetP8WSI");
            UserContext.get().pushSubject(subject);
            Domain domain = Factory.Domain.getInstance((Connection)conn, (String)"P8");
            System.out.println("Obtained the P8 Domain.");
            Logger.setLogLevel(4);
            PropertyFilter pf = new PropertyFilter();
            ObjectStore objectStore = Factory.ObjectStore.fetchInstance((Domain)domain, (String)"CMTOS", null);
            System.out.println("Obtained realm");
            P8TeamspaceService workspaceService = new P8TeamspaceService(conn, domain, objectStore, null, null);
            pf = new PropertyFilter();
            pf.addIncludeProperty(1, null, Boolean.valueOf(true), "EDMSecurityAdapter", null);
            pf.addIncludeProperty(1, null, null, "Id", null);
            pf.addIncludeProperty(1, null, null, "Permissions", null);
            pf.addIncludeProperty(1, null, null, "AccessMask", null);
            pf.addIncludeProperty(1, null, null, "AccessType", null);
            pf.addIncludeProperty(1, null, null, "GranteeName", null);
            pf.addIncludeProperty(1, null, null, "GranteeType", null);
            pf.addIncludeProperty(1, null, null, "InheritableDepth", null);
            Object acl = null;
            TestTeamspaceService.retreiveTeamspaceById(workspaceService, "D44CD380-0E8A-4366-B782-FD58A28F116B");
            UserContext.get().popSubject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Teamspace createTeamspaceTemplate(P8TeamspaceService workspaceService) {
        Object id = null;
        Teamspace workspace = null;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonTeamspaces = new JSONArray();
            jsonObject.put("name", "Michael");
            workspace = new Teamspace(null, "Michael", "bad workspace", "template", "ClbTeamspaceTemplate", jsonObject.toString(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspace;
    }

    public static Teamspace createTeamspaceInstance(P8TeamspaceService workspaceService) {
        Object id = null;
        Teamspace workspace = null;
        try {
            String jsonTemplate = "{\"id\":\"{F7D825C3-47BB-4564-B1A4-D5FA7BA0F034}\",\"name\":\"i9_folderTest1\",\"type\":\"instance\",\"state\":\"published\",\"description\":\"i9_folderTest1\",\"templateName\":\"\",\"folders\":[{\"name\":\"i9_folderTest1\",\"path\":\"/\",\"type\":\"folder\"},{\"name\":\"test\",\"path\":\"/test\",\"type\":\"folder\",\"properties\":{\"folderName\":\"test\",\"docid\":\"\",\"criterias\":[{\"name\":\"FolderName\",\"values\":[\"test\"],\"dataType\":\"xs:string\",\"label\":\"Folder Name\"},{\"name\":\"FolderName\",\"values\":[\"test\"],\"dataType\":\"xs:string\",\"label\":\"Folder Name\"}],\"documentType\":\"Folder\"}}],\"contentClasses\":[],\"searchTemplates\":[],\"roles\":[]}";
            workspace = new Teamspace(null, "Michael_2", "mike folder test 2", "instance", "ClbTeamspace", jsonTemplate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspace;
    }

    public static Teamspace retreiveTeamspaces(P8TeamspaceService workspaceService, String type, boolean delete) {
        Teamspace workspaceObject = null;
        try {
            int i = 0;
            List<Teamspace> workspaces = workspaceService.retrieveTeamspaces(type, "published");
            Iterator<Teamspace> iterator = workspaces.iterator();
            while (iterator.hasNext()) {
                if (delete && i == 0) {
                    Teamspace tmpTeamspace = iterator.next();
                    TestTeamspaceService.printTeamspaceProps(tmpTeamspace);
                    workspaceService.deleteTeamspace(tmpTeamspace);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspaceObject;
    }

    public static Teamspace retreiveTeamspaceByName(P8TeamspaceService workspaceService, Teamspace workspace) {
        Teamspace workspaceObject = null;
        try {
            workspaceObject = workspaceService.retrieveTeamspaceByName(workspace.getName(), workspace.getType());
            TestTeamspaceService.printTeamspaceProps(workspaceObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspaceObject;
    }

    public static Teamspace retreiveTeamspaceById(P8TeamspaceService workspaceService, String id) {
        Teamspace workspaceObject = null;
        try {
            workspaceObject = workspaceService.retrieveTeamspace(id, null, "instance");
            TestTeamspaceService.printTeamspaceProps(workspaceObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspaceObject;
    }

    public static void printTeamspaceProps(Teamspace workspace) {
        System.out.println("------------------------------");
        System.out.println("Name: \t\t" + workspace.getName());
        System.out.println("Type: \t\t" + workspace.getType());
        System.out.println("State: \t\t" + workspace.getState());
        System.out.println("Description:" + workspace.getDescription());
        System.out.println("Id: \t\t" + workspace.getId());
        System.out.println("json: \t\t" + workspace.getJson());
    }
}

