/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.FolderSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.core.Scope;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.core.Versionable;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.Group;
import com.filenet.api.security.User;
import com.filenet.api.util.Id;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.Subject;
import com.ibm.ecm.security.UserGroup;
import com.ibm.ecm.security.p8.P8SecurityService;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.teamspace.BaseTeamspaceService;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.TeamspaceDB;
import com.ibm.ecm.teamspace.TeamspaceException;
import com.ibm.ecm.teamspace.TeamspaceUtil;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8FolderTemplates;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8TeamspaceService
extends BaseTeamspaceService {
    public static final String TEAMSPACE_PARENT_FOLDER = "/ClbTeamspaces";
    public static final String TEAMSPACE_TEMPLATE_PARENT_FOLDER = "/ClbTeamspace Templates";
    public static final String ROLE_PARENT_FOLDER = "/ClbRoles";
    public static final String TEAMSPACE_CLASS = "ClbTeamspace";
    public static final String TEAMSPACE_TEMPLATE_CLASS = "ClbTeamspaceTemplate";
    public static final String TEAMSPACE_PROP_DESCRIPTION = "Description";
    public static final String TEAMSPACE_PROP_NAME = "ClbTeamspaceName";
    public static final String TEAMSPACE_PROP_JSON = "ClbJSONData";
    public static final String TEAMSPACE_PROP_STATE = "ClbTeamspaceState";
    public static final String SECURITY_ADAPTER_OVP = "ClbSecurityAdapter";
    private TeamspaceDB teamspaceDB;
    private Connection connection;
    private ObjectStore objectStore;
    private Domain domain;
    private P8SecurityService securityService;
    private P8Connection p8connection;
    private HttpServletRequest request;

    public P8TeamspaceService(Connection connection, Domain domain, ObjectStore objectStore, P8Connection p8connection, HttpServletRequest request) {
        this.connection = connection;
        this.objectStore = objectStore;
        this.domain = domain;
        this.p8connection = p8connection;
        this.securityService = new P8SecurityService(request, connection, objectStore);
        this.request = request;
    }

    public String editTeamspace(Teamspace teamspace, List<Role> roles, AccessControlList secObjACL, boolean modifyUsers, AccessControlList teamspaceObjACL) throws TeamspaceException {
        String methodName = "editTeamspace";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            String teamspaceId = P8Util.getObjectIdentity(teamspace.getId());
            Folder teamspaceFolderObject = Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (String)teamspaceId, null);
            Properties props = teamspaceFolderObject.getProperties();
            if (modifyUsers) {
                this.securityService.applyACL(teamspaceObjACL, (AccessPermissionList)props.getDependentObjectListValue("Permissions"));
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getName() : " + teamspace.getName());
            props.putValue(TEAMSPACE_PROP_NAME, teamspace.getName());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getDescription() : " + teamspace.getDescription());
            props.putValue(TEAMSPACE_PROP_DESCRIPTION, teamspace.getDescription());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getJson() : " + teamspace.getJson());
            if (teamspace.getState() != null && teamspace.getState().length() > 0) {
                props.putValue(TEAMSPACE_PROP_STATE, BaseTeamspaceService.State.getEnum(teamspace.getState()).getValue());
                if (teamspace.getState().equals("default")) {
                    List<Teamspace> teamspaces = this.retrieveTeamspaces("template", "default", "template");
                    if (teamspaces.iterator() != null && teamspaces.iterator().hasNext()) {
                        Teamspace defaultTeamspace = teamspaces.iterator().next();
                        if (teamspaces != null && !teamspaces.isEmpty() && !defaultTeamspace.getId().equalsIgnoreCase(teamspace.getId())) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "defaultTeamspace : " + defaultTeamspace.getName());
                            String defaultTeamspaceId = P8Util.getObjectIdentity(defaultTeamspace.getId());
                            Folder defaultTeamspaceFolderObject = Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (String)defaultTeamspaceId, null);
                            Properties defaultProps = defaultTeamspaceFolderObject.getProperties();
                            defaultProps.putValue(TEAMSPACE_PROP_STATE, BaseTeamspaceService.State.PUBLISHED.getValue());
                            defaultTeamspaceFolderObject.save(RefreshMode.REFRESH, null);
                        }
                    }
                    teamspace.setState("published");
                }
            }
            props.putObjectValue(TEAMSPACE_PROP_JSON, (Object)teamspace.getJson().getBytes());
            PropertyFilter pfId = new PropertyFilter();
            pfId.addIncludeProperty(new FilterElement(null, null, null, "Id", null));
            pfId.addIncludeProperty(new FilterElement(null, null, null, SECURITY_ADAPTER_OVP, null));
            pfId.setMaxRecursion(1);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "saving teamspace");
            teamspaceFolderObject.setUpdateSequenceNumber(null);
            teamspaceFolderObject.save(RefreshMode.REFRESH, pfId);
            String type = teamspace.getType();
            String id = teamspaceFolderObject.get_Id().toString();
            if (type.equalsIgnoreCase("instance")) {
                JSONObject templateJsonObject = this.createJsonObjectFromJsonString(teamspace.getJson());
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "json: " + teamspace.getJson());
                this.associateEntryTemplatesToTeampace(templateJsonObject, id);
                if (modifyUsers) {
                    IndependentlyPersistableObject secAdapter = (IndependentlyPersistableObject)teamspaceFolderObject.getProperties().getObjectValue(SECURITY_ADAPTER_OVP);
                    if (secAdapter != null) {
                        this.securityService.deleteSecurityAdapter(secAdapter);
                    }
                    this.applyRoles(teamspaceFolderObject, teamspace, roles, secObjACL);
                }
            }
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
            throw new TeamspaceException("Failed to edit teamspace!", ex, 1089);
        }
        return teamspace.getId();
    }

    public String createTeamspace(Teamspace teamspace, List<Role> roles, AccessControlList secObjACL, AccessPermissionList permissions, AccessControlList teamspaceObjACL) throws TeamspaceException {
        String methodName = "createTeamspace";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceType : " + teamspace.getType());
        String teamspaceJson = teamspace.toJSON().toString();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceJson : " + teamspaceJson);
        this.teamspaceDB = new TeamspaceDB((ServletRequest)this.request, teamspaceJson);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceType : " + teamspace.getType());
        try {
            String type = teamspace.getType();
            String className = TEAMSPACE_CLASS;
            String parentFolderPath = TEAMSPACE_PARENT_FOLDER;
            if (teamspace.getType().equals("template")) {
                parentFolderPath = TEAMSPACE_TEMPLATE_PARENT_FOLDER;
                className = TEAMSPACE_TEMPLATE_CLASS;
            }
            Folder folder = Factory.Folder.createInstance((ObjectStore)this.objectStore, (String)className);
            Properties props = folder.getProperties();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "uniqueId for : " + teamspace.getName());
            String folderName = TeamspaceUtil.getUniqueId(teamspace.getName());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "folderName : " + folderName);
            folder.set_FolderName(folderName);
            folder.set_Parent(Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (String)parentFolderPath, null));
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentFolderPath : " + parentFolderPath);
            String description = teamspace.getDescription();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getDescription() : " + description);
            if (teamspace.getDescription() != null) {
                props.putValue(TEAMSPACE_PROP_DESCRIPTION, description);
            }
            String name = teamspace.getName();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getName() : " + name);
            props.putValue(TEAMSPACE_PROP_NAME, name);
            byte[] jsonBytes = teamspace.getJson().getBytes();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getJson() : " + teamspace.getJson());
            props.putObjectValue(TEAMSPACE_PROP_JSON, (Object)jsonBytes);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getState() : " + teamspace.getState());
            if (type.equalsIgnoreCase("instance")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getTemplateId() : " + teamspace.getTemplateId());
                if (teamspace.getTemplateId() != null && teamspace.getTemplateId().length() > 0) {
                    this.teamspaceDB.setTeamspaceTemplateId(teamspace.getTemplateId());
                }
                props.putValue(TEAMSPACE_PROP_STATE, BaseTeamspaceService.State.PUBLISHED.getValue());
            } else if (teamspace.getState() != null && teamspace.getState().length() > 0) {
                props.putValue(TEAMSPACE_PROP_STATE, BaseTeamspaceService.State.getEnum(teamspace.getState()).getValue());
            }
            PropertyFilter pfId = new PropertyFilter();
            pfId.addIncludeProperty(new FilterElement(null, null, null, "Id", null));
            pfId.addIncludeProperty(new FilterElement(null, null, null, "DateLastModified", null));
            pfId.addIncludeProperty(new FilterElement(null, null, null, "LastModifier", null));
            pfId.addIncludeProperty(new FilterElement(null, null, null, "PathName", null));
            pfId.addIncludeProperty(new FilterElement(null, null, null, SECURITY_ADAPTER_OVP, null));
            pfId.addIncludeProperty(new FilterElement(null, null, null, "Permissions", null));
            pfId.setMaxRecursion(1);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking save");
            folder.save(RefreshMode.REFRESH, pfId);
            String id = folder.getProperties().getIdValue("Id").toString();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "id: " + id);
            if (type.equals("template") && permissions != null) {
                AccessPermissionList apl = folder.get_Permissions();
                for (AccessPermission ap : permissions) {
                    apl.add((Object)ap);
                }
                folder.set_Permissions(apl);
                folder.save(RefreshMode.REFRESH);
            }
            teamspace.setId(id);
            Date lastModifiedDate = folder.getProperties().getDateTimeValue("DateLastModified");
            String lastModified = DateUtil.getISODateString(lastModifiedDate, true);
            String lastModifiedUser = folder.getProperties().getStringValue("LastModifier");
            teamspace.setLastModified(lastModified);
            teamspace.setLastModifiedUser(lastModifiedUser);
            if (type.equals("instance")) {
                this.applyRoles(folder, teamspace, roles, secObjACL);
                this.applyACL(teamspace, teamspaceObjACL);
            }
            if (type.equalsIgnoreCase("instance")) {
                JSONObject templateJsonObject = this.createJsonObjectFromJsonString(teamspace.getJson());
                this.createTeamspaceItemsFromTemplateJson(folder, templateJsonObject);
                this.associateEntryTemplatesToTeampace(templateJsonObject, id);
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
            return id;
        }
        catch (EngineRuntimeException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            if (e.getExceptionCode().equals(ExceptionCode.E_NOT_UNIQUE) || e.getExceptionCode().equals(ExceptionCode.DB_NOT_UNIQUE)) {
                throw new TeamspaceException("teamspace \"" + teamspace.getName() + "\" already exists!", e, 1091);
            }
            throw new TeamspaceException("Failed to create teamspace!", e, 1088);
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
            throw new TeamspaceException("Failed to create teamspace!", ex, 1088);
        }
    }

    private void applyACL(Teamspace teamspace, AccessControlList teamspaceObjACL) throws SecurityException {
        if (teamspace.getType().equals("instance")) {
            String teamspaceId = P8Util.getObjectIdentity(teamspace.getId());
            Folder ipo = Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (Id)new Id(teamspaceId), null);
            this.securityService.applyACL(teamspaceObjACL, (AccessPermissionList)ipo.getProperties().getObjectValue("Permissions"));
            ipo.save(RefreshMode.REFRESH);
        }
    }

    private void applyRoles(Folder folder, Teamspace teamspace, List<Role> roles, AccessControlList secObjACL) throws SecurityException {
        String methodName = "applyRoles";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Applying role-based security to teamspace...");
        if (roles != null && roles.size() > 0) {
            ArrayList<String> roleIds = new ArrayList<String>();
            for (Role role : roles) {
                this.securityService.createRole(role, null, secObjACL);
                roleIds.add(role.getId());
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "adding role: " + role.getId());
            }
            String teamspaceId = P8Util.getObjectIdentity(teamspace.getId());
            this.securityService.applyRolesToObject(teamspaceId + "_adapter", (IndependentlyPersistableObject)folder, roleIds, secObjACL);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void associateEntryTemplatesToTeampace(JSONObject templateJsonObject, String folderId) throws TeamspaceException {
        String methodName = "associateEntryTemplatesToTeampace";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray entryTemplatesJsonArray = (JSONArray)templateJsonObject.get("entryTemplates");
        String usesClasses = (String)templateJsonObject.get("usesClasses");
        if (templateJsonObject != null && !templateJsonObject.isEmpty() && usesClasses != null && usesClasses.equals("false")) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "templateJsonObject size: " + templateJsonObject.size());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "templateJsonObject: " + templateJsonObject.toString());
            ListIterator iterator = entryTemplatesJsonArray.listIterator();
            ArrayList<String> entryTemplateList = new ArrayList<String>();
            while (iterator.hasNext()) {
                JSONObject jsonClass = (JSONObject)iterator.next();
                String name = (String)jsonClass.get("name");
                String description = (String)jsonClass.get("description");
                String id = (String)jsonClass.get("id");
                String strIsDefault = (String)jsonClass.get("isDefault");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "description: " + description);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "docId: " + id);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "name: " + name);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "isDefault: " + strIsDefault);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "id: " + id);
                if (strIsDefault != null && !strIsDefault.equalsIgnoreCase("")) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "defaultClass = " + name);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "id: " + id);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "save default class: " + id);
                }
                try {
                    entryTemplateList.add(id);
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
            }
            try {
                P8FolderTemplates.associateTemplatesWithFolder(this.p8connection, this.objectStore, entryTemplateList, folderId);
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entryTemplateJsonArray is null or empty");
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private JSONObject createJsonObjectFromJsonString(String jsonString) throws TeamspaceException {
        String methodName = "createJsonObjectFromJsonString";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonObject = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "jsonString: " + jsonString);
        try {
            jsonObject = (JSONObject)JSON.parse(jsonString);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new TeamspaceException(e, 1087);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonObject;
    }

    private void createTeamspaceItemsFromTemplateJson(Folder rootFolder, JSONObject templateJsonObject) throws TeamspaceException {
        String methodName = "createTeamspaceItemsFromTemplateJson";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Folder parentFolder = null;
        boolean isRoot = true;
        JSONArray itemsJsonArray = (JSONArray)templateJsonObject.get("folders");
        if (itemsJsonArray != null && !itemsJsonArray.isEmpty()) {
            ListIterator iterator = itemsJsonArray.listIterator();
            while (iterator.hasNext()) {
                boolean isCopy;
                JSONObject jsonItem = (JSONObject)iterator.next();
                String path = (String)jsonItem.get("path");
                String type = (String)jsonItem.get("type");
                String name = (String)jsonItem.get("name");
                JSONObject properties = (JSONObject)jsonItem.get("properties");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "path: " + path);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type: " + type);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "name: " + name);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "properties: " + properties);
                if (path.equalsIgnoreCase("/") || properties == null) continue;
                if (parentFolder == null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentFolder was null, setting it to the root folder");
                    parentFolder = rootFolder;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentFolder path: " + parentFolder.get_PathName());
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "is not root folder");
                    isRoot = false;
                }
                path = rootFolder.get_PathName() + path;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "updated path with teamspace root path to form full path: " + path);
                String parentPath = this.getParentFldPath(path, name);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentPath: " + parentPath);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Fetch parent folder using path: " + parentPath);
                PropertyFilter pf = new PropertyFilter();
                pf.addIncludeProperty(new FilterElement(null, null, null, "Id", null));
                pf.addIncludeProperty(new FilterElement(null, null, null, "PathName", null));
                pf.setMaxRecursion(1);
                if (!isRoot && parentFolder != null) {
                    parentFolder = Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (String)parentPath, (PropertyFilter)pf);
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "found folder: " + parentFolder.get_PathName());
                if (type != null && type.equals("folder")) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "create folder");
                    String className = (String)properties.get("documentType");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "className = " + className);
                    String criterias = properties.get("criterias").toString();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criterias: " + criterias);
                    ClassDescription classDescription = Factory.ClassDescription.fetchInstance((Scope)this.objectStore, (String)className, null);
                    Id classDescId = classDescription.get_Id();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, " classDescription.get_Id(); = " + classDescId);
                    Folder folder = Factory.Folder.createInstance((ObjectStore)this.objectStore, (String)classDescId.toString());
                    folder.set_Parent(parentFolder);
                    try {
                        JSONArray criteriasJsonArray = JSONArray.parse(criterias);
                        P8Util.setProperties(this.request, (IndependentObject)folder, criteriasJsonArray, classDescription);
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Error setting the citeria data on the folder object");
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        throw new TeamspaceException(e, 1088);
                    }
                    folder.save(RefreshMode.NO_REFRESH);
                    continue;
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "about to add a document: " + name);
                String docId = (String)properties.get("docid");
                Id id = new Id(P8Util.getObjectIdentity(docId));
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "fetching the item");
                Document originalDocument = Factory.Document.fetchInstance((ObjectStore)this.objectStore, (Id)id, null);
                Boolean copy = (Boolean)jsonItem.get("IsCopy");
                boolean bl = isCopy = copy != null && copy != false;
                if (isCopy) {
                    this.createDocumentCopy(parentFolder, originalDocument);
                    continue;
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "about to file document id: " + id);
                ReferentialContainmentRelationship rcr = parentFolder.file((IndependentlyPersistableObject)originalDocument, AutoUniqueName.AUTO_UNIQUE, null, DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
                rcr.save(RefreshMode.NO_REFRESH);
            }
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "foldersJsonArray is null or empty");
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private String getParentFldPath(String path, String objName) {
        String parentPath;
        String methodName = "getParentFldPath";
        int indxName = path.lastIndexOf(objName);
        if (indxName >= 0) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "indxName: " + indxName);
            if (path.charAt(indxName - 1) == '/') {
                --indxName;
            }
            parentPath = path.substring(0, indxName);
        } else {
            int lastIndexofPathSymbol = path.lastIndexOf("/");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "lastIndexofPathSymbol: " + lastIndexofPathSymbol);
            parentPath = path.substring(0, lastIndexofPathSymbol);
        }
        return parentPath;
    }

    private void createDocumentCopy(Folder parentFolder, Document originalDocument) {
        Property[] originalPropsArray;
        String classId = originalDocument.get_ClassDescription().getObjectReference().getObjectIdentity();
        Document newCopy = Factory.Document.createInstance((ObjectStore)this.objectStore, (String)classId);
        Properties originalProps = originalDocument.getProperties();
        Properties copyProps = newCopy.getProperties();
        for (Property p : originalPropsArray = originalProps.toArray()) {
            String propertyName = p.getPropertyName();
            boolean settable = p.isSettable();
            if (!settable) continue;
            Object value = p.getObjectValue();
            copyProps.putObjectValue(propertyName, value);
        }
        ContentElementList originalContentElements = originalDocument.get_ContentElements();
        int numberOfContentElements = originalContentElements.size();
        ContentElementList newCopyContentElements = Factory.ContentElement.createList();
        for (int i = 0; i < numberOfContentElements; ++i) {
            ContentTransfer element = (ContentTransfer)originalContentElements.get(i);
            String contentType = element.get_ContentType();
            InputStream originalContentInputStream = element.accessContentStream();
            ContentTransfer ctObject = Factory.ContentTransfer.createInstance();
            ctObject.setCaptureSource(originalContentInputStream);
            ctObject.set_ContentType(contentType);
            newCopyContentElements.add((Object)ctObject);
        }
        newCopy.set_ContentElements(newCopyContentElements);
        newCopy.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        newCopy.set_SecurityFolder(parentFolder);
        newCopy.save(RefreshMode.NO_REFRESH);
        ReferentialContainmentRelationship rcr = parentFolder.file((IndependentlyPersistableObject)newCopy, AutoUniqueName.AUTO_UNIQUE, null, DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
        rcr.save(RefreshMode.NO_REFRESH);
    }

    public Teamspace retrieveTeamspaceByName(String teamspaceName, String type) throws SecurityException, TeamspaceException {
        Teamspace teamSpace = null;
        String className = TEAMSPACE_CLASS;
        if (type.equals("template")) {
            className = TEAMSPACE_TEMPLATE_CLASS;
        }
        SearchSQL sqlObject = new SearchSQL();
        sqlObject.setSelectList("*");
        sqlObject.setMaxRecords(100);
        sqlObject.setFromClauseInitialValue(className, "e", false);
        sqlObject.setWhereClause("ClbTeamspaceName='" + teamspaceName + "'");
        SearchScope search = new SearchScope(this.objectStore);
        IndependentObjectSet myObjects = search.fetchObjects(sqlObject, Integer.valueOf(100), null, null);
        for (IndependentlyPersistableObject ipo : myObjects) {
            teamSpace = this.createTeamspaceObject(ipo, null, type);
        }
        return teamSpace;
    }

    public void addSearchTemplate(String teamspaceId, String templateId, String templateName, String templateDesc) throws TeamspaceException {
        String methodName = "addSearchTemplate";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_NAME, null);
            pf.addIncludeProperty(1, null, null, "Name", null);
            pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_JSON, null);
            Folder teamspaceFolderObject = Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (String)teamspaceId, (PropertyFilter)pf);
            Properties props = teamspaceFolderObject.getProperties();
            byte[] jsonBytes = props.getBinaryValue(TEAMSPACE_PROP_JSON);
            if (jsonBytes != null) {
                String jsonDB = new String(jsonBytes);
                this.teamspaceDB = new TeamspaceDB((ServletRequest)this.request, jsonDB);
                JSONObject search = new JSONObject();
                search.put("id", templateId);
                search.put("name", templateName);
                search.put("description", templateDesc);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "search: " + search.toString());
                this.teamspaceDB.addSearch(search);
                props.putObjectValue(TEAMSPACE_PROP_JSON, (Object)this.teamspaceDB.toJson().getBytes());
            } else {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, "No teamspace db was found");
            }
            teamspaceFolderObject.save(RefreshMode.NO_REFRESH);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public List<Teamspace> retrieveTeamspaces(String type, String retrievalOption) throws SecurityException, TeamspaceException {
        return this.retrieveTeamspaces(type, "all", retrievalOption);
    }

    public List<Teamspace> retrieveTeamspaces(String type, String state, String retrievalOption) throws SecurityException, TeamspaceException {
        String extraCondition;
        String methodName = "retrieveTeamspaces";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<Teamspace> teamspaces = new ArrayList<Teamspace>();
        SearchSQL sqlObject = new SearchSQL();
        sqlObject.setSelectList("*");
        sqlObject.setMaxRecords(2000);
        String className = TEAMSPACE_CLASS;
        if (type.equals("template")) {
            className = TEAMSPACE_TEMPLATE_CLASS;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type: " + type);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "state: " + state);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrievalOption" + retrievalOption);
        sqlObject.setFromClauseInitialValue(className, null, false);
        String whereClause = "";
        if (retrievalOption == "instance") {
            extraCondition = "ClbTeamspaceState = " + BaseTeamspaceService.State.getEnum("published").getValue();
            whereClause = whereClause + extraCondition;
        } else if (!state.equalsIgnoreCase("all")) {
            extraCondition = "ClbTeamspaceState = " + BaseTeamspaceService.State.getEnum(state).getValue();
            whereClause = whereClause + extraCondition;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "whereClause" + whereClause);
        if (whereClause.length() > 0) {
            sqlObject.setWhereClause(whereClause);
        }
        SearchScope search = new SearchScope(this.objectStore);
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_STATE, null);
        pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_DESCRIPTION, null);
        pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_NAME, null);
        if (retrievalOption.equals("template")) {
            pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_JSON, null);
        }
        pf.addIncludeProperty(1, null, null, "Id", null);
        pf.addIncludeProperty(1, null, null, "Name", null);
        pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_DESCRIPTION, null);
        pf.addIncludeProperty(1, null, null, "DateLastModified", null);
        pf.addIncludeProperty(1, null, null, "LastModifier", null);
        Date date = Logger.logPerf((Object)this, methodName, (ServletRequest)this.request, "teamspaces retrieve started");
        IndependentObjectSet myObjects = retrievalOption.equals("template") || retrievalOption.equals("instance") ? search.fetchObjects(sqlObject, null, pf, Boolean.valueOf(false)) : search.fetchObjects(sqlObject, null, null, Boolean.valueOf(false));
        Logger.logPerf(this, methodName, (ServletRequest)this.request, date, "teamspaces retrieve completed");
        for (IndependentlyPersistableObject ipo : myObjects) {
            Teamspace teamspace = this.createTeamspaceObject(ipo, retrievalOption, type);
            this.logTeamspaceObject(teamspace, methodName);
            if (type == null || type.length() == 0) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "add teamspace w/o type: " + teamspace.toJSON());
                teamspaces.add(teamspace);
                continue;
            }
            if (teamspace == null || !teamspace.getType().equalsIgnoreCase(type)) continue;
            teamspaces.add(teamspace);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "add teamspace w/ type: " + teamspace.toJSON());
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return teamspaces;
    }

    private void logTeamspaceObject(Teamspace teamspace, String methodName) {
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "-----------------------------------------------------------------");
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getName(): " + teamspace.getName());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getDescription(): " + teamspace.getDescription());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getType(): " + teamspace.getType());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getId(): " + teamspace.getId());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getState(): " + teamspace.getState());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getTemplateId(): " + teamspace.getTemplateId());
        if (teamspace.getTeam() != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getTeam(): " + teamspace.getTeam().toArray().toString());
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "-----------------------------------------------------------------");
    }

    public void deleteTeamspace(Teamspace teamspace) throws TeamspaceException {
        this.deleteTeamspace(teamspace.getId(), teamspace.getType());
    }

    public void deleteTeamspace(String teamspaceId, String type) throws TeamspaceException {
        String methodName = "markTeamspaceInstanceDeleted";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            teamspaceId = P8Util.getObjectIdentity(teamspaceId);
            Folder folder = Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (String)teamspaceId, null);
            Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "Delete teamspace called " + folder.get_FolderName());
            Properties folderProps = folder.getProperties();
            if (StringUtils.equals((String)type, (String)"template")) {
                folder.delete();
                folder.save(RefreshMode.REFRESH);
                Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "Teamspace template " + teamspaceId + " was deleted");
            } else {
                Property stateProp = folderProps.get(TEAMSPACE_PROP_STATE);
                stateProp.setObjectValue((Object)BaseTeamspaceService.State.getEnum("deleted").getValue());
                folder.save(RefreshMode.NO_REFRESH);
                Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "Teamspace instance " + teamspaceId + " was marked as deleted");
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                throw new TeamspaceException("Teamspace with id \"" + teamspaceId + "\" does not exist!", e, 1093);
            }
            throw new TeamspaceException("Failed to delete the teamspace!", e, 1090);
        }
        catch (Exception e) {
            throw new TeamspaceException("Failed to delete the teamspace !", e, 1090);
        }
    }

    public Teamspace retrieveTeamspace(String teamspaceId, String retrievalOptions, String type) throws TeamspaceException {
        String methodName = "retrieveTeamspace";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Teamspace teamspace = null;
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceId: " + teamspaceId);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrievalOptions: " + retrievalOptions);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type: " + type);
            PropertyFilter pf = new PropertyFilter();
            pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_STATE, null);
            pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_DESCRIPTION, null);
            pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_NAME, null);
            pf.addIncludeProperty(1, null, null, "Id", null);
            pf.addIncludeProperty(1, null, null, "Name", null);
            pf.addIncludeProperty(1, null, null, TEAMSPACE_PROP_DESCRIPTION, null);
            teamspaceId = P8Util.getObjectIdentity(teamspaceId);
            Folder teamspaceFolderObject = Factory.Folder.fetchInstance((ObjectStore)this.objectStore, (String)teamspaceId, null);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace name: " + teamspaceFolderObject.get_Name());
            teamspace = this.createTeamspaceObject((IndependentlyPersistableObject)teamspaceFolderObject, retrievalOptions, type);
            this.logTeamspaceObject(teamspace, methodName);
        }
        catch (EngineRuntimeException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                throw new TeamspaceException("teamspace with id \"" + teamspaceId + "\" does not exist!", e, 1093);
            }
        }
        catch (Throwable e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, e);
            throw new TeamspaceException("Failed to retrieve the teamspace !", e, 1092);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return teamspace;
    }

    public void recursiveCopyFolder(Folder srcFolder, Folder destFolder) {
        UpdatingBatch updateBatch = UpdatingBatch.createUpdatingBatchInstance((Domain)this.domain, (RefreshMode)RefreshMode.REFRESH);
        FolderSet childrenFolderSet = srcFolder.get_SubFolders();
        for (Folder subFolder : childrenFolderSet) {
            destFolder.createSubFolder(subFolder.get_FolderName());
            updateBatch.add((IndependentlyPersistableObject)destFolder, null);
            this.recursiveCopyFolder(subFolder, destFolder);
        }
        updateBatch.updateBatch();
    }

    private Teamspace createTeamspaceObject(IndependentlyPersistableObject ipo, String retrievalOptions, String type) throws SecurityException {
        String methodName = "createTeamspaceObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace retrievalOptions = " + retrievalOptions);
        Properties props = ipo.getProperties();
        String id = props.getIdValue("Id").toString();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace id = " + id);
        ObjectReference objRef = ipo.getObjectReference();
        id = P8Util.getDocId(objRef);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace pid = " + id);
        Date lastModifiedDate = props.getDateTimeValue("DateLastModified");
        String lastModified = DateUtil.getISODateString(lastModifiedDate, true);
        String lastModifiedUser = props.getStringValue("LastModifier");
        Integer state = props.getInteger32Value(TEAMSPACE_PROP_STATE);
        String usesClasses = "";
        String teamspaceName = props.getStringValue(TEAMSPACE_PROP_NAME);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto teamspaceName = " + teamspaceName);
        String description = props.getStringValue(TEAMSPACE_PROP_DESCRIPTION);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto description = " + description);
        String json = null;
        byte[] jsonBytes = props.getBinaryValue(TEAMSPACE_PROP_JSON);
        if (jsonBytes != null) {
            json = new String(jsonBytes);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto json: " + json);
            json = TeamspaceUtil.localizeRoleNames((ServletRequest)this.request, json);
            this.teamspaceDB = new TeamspaceDB((ServletRequest)this.request, json);
            usesClasses = this.teamspaceDB.getUsesClasses();
        }
        Teamspace teamspace = null;
        if (teamspaceName != null) {
            IndependentlyPersistableObject adapter;
            List<Subject> team = null;
            if (retrievalOptions == null || retrievalOptions != null && retrievalOptions.equals("allData")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto retrieved ACL");
                AccessControlList acl = this.securityService.retrieveACL(ipo, false);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, new StringBuffer().append("cto new Teamspace(").append(teamspaceName).append(", ").append(description).append(", ").append(ipo.getClassName()).append(", ").append(json).append(", ").append(team).append(")").toString());
            if (retrievalOptions.equals("template") || retrievalOptions.equals("allData")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "create teamspace object and set json data");
                teamspace = new Teamspace(this.request, teamspaceName, description, type, ipo.getClassName(), json, null);
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "create teamspace object without setting json data");
                teamspace = new Teamspace(this.request, teamspaceName, description, type, ipo.getClassName(), null, null);
            }
            try {
                teamspace.setState(BaseTeamspaceService.State.getEnum(state).getStringValue());
            }
            catch (TeamspaceException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
            teamspace.setId(id);
            if (lastModified != null) {
                teamspace.setLastModified(lastModified.toString());
            }
            if (lastModifiedUser != null) {
                teamspace.setLastModifiedUser(lastModifiedUser);
            }
            if (this.teamspaceDB != null && this.teamspaceDB.getTeamspaceTemplateId() != null) {
                teamspace.setTemplateId(this.teamspaceDB.getTeamspaceTemplateId());
            }
            String defaultEntryTemplate = "";
            String defaultClass = "";
            if (this.teamspaceDB != null) {
                defaultClass = this.teamspaceDB.getDefaultClass();
                defaultEntryTemplate = this.teamspaceDB.getDefaultEntryTemplate();
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto defaultClass = " + defaultClass);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto defaultEntryTemplate = " + defaultEntryTemplate);
            if (defaultClass != null) {
                teamspace.setDefaultClass(defaultClass);
            }
            if (defaultEntryTemplate != null) {
                teamspace.setDefaultEntryTemplate(defaultEntryTemplate);
            }
            if (usesClasses != null) {
                teamspace.setUsesClasses(usesClasses);
            }
            if (props.isPropertyPresent(SECURITY_ADAPTER_OVP) && retrievalOptions.equals("allData") && (adapter = (IndependentlyPersistableObject)props.getObjectValue(SECURITY_ADAPTER_OVP)) != null) {
                String securityAdapterId = adapter.getProperties().getIdValue("Id").toString();
                teamspace.setSecurityAdapterId(securityAdapterId);
            }
            if (this.teamspaceDB != null && retrievalOptions != null) {
                List<Subject> teamList;
                if (retrievalOptions.equals("allData")) {
                    this.retrieveTeamspaceSearches(teamspace);
                    teamspace.setJson(this.teamspaceDB.toJson());
                    this.retrieveTeamspaceClasses(teamspace);
                    this.retrieveTeamspaceEntryTemplates(teamspace);
                    this.retrieveTeamspaceColumns(teamspace);
                    teamList = this.getTeam(teamspace);
                    teamspace.setTeam(teamList);
                    teamspace.setJson(this.teamspaceDB.toJson());
                } else if (retrievalOptions.equals("searches")) {
                    this.retrieveTeamspaceSearches(teamspace);
                    teamspace.setJson(this.teamspaceDB.toJson());
                } else if (retrievalOptions.equals("classes")) {
                    this.retrieveTeamspaceClasses(teamspace);
                } else if (retrievalOptions.equals("entryTemplates")) {
                    this.retrieveTeamspaceEntryTemplates(teamspace);
                } else if (retrievalOptions.equals("columns")) {
                    this.retrieveTeamspaceColumns(teamspace);
                } else if (retrievalOptions.equals("team")) {
                    teamList = this.getTeam(teamspace);
                    teamspace.setTeam(teamList);
                }
            }
            String currentUserName = this.p8connection.getUserName();
            team = teamspace.getTeam();
            if (team != null) {
                for (Subject m : team) {
                    String name = m.getName();
                    if (!name.equals(currentUserName)) continue;
                    teamspace.setCurrentUser((com.ibm.ecm.security.User)m);
                    break;
                }
            }
        } else {
            teamspace = null;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return teamspace;
    }

    private String getCurrentSearchVersionId(String templateId) {
        String methodName = "getReleasedSearchVersionId";
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Name", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Id", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "CurrentVersion", null));
        Id id = new Id(templateId);
        Document document = Factory.Document.fetchInstance((ObjectStore)this.p8connection.getObjectStore(), (Id)id, (PropertyFilter)pf);
        Versionable versionable = document.get_CurrentVersion();
        Properties props = ((Document)versionable).getProperties();
        String latestId = props.getIdValue("Id").toString();
        return latestId;
    }

    private void retrieveTeamspaceSearches(Teamspace teamspace) {
        String methodName = "retrieveTeamspaceSearches";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray searchJsonArray = this.teamspaceDB.getSearches();
        this.teamspaceDB.clearSearches();
        ArrayList<String> searches = new ArrayList<String>();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto _searches = " + searchJsonArray);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto number of searches = " + searchJsonArray.size());
        if (searchJsonArray != null) {
            ListIterator iterator = searchJsonArray.listIterator();
            while (iterator.hasNext()) {
                JSONObject object = (JSONObject)iterator.next();
                String searchId = (String)object.get("id");
                String templateName = (String)object.get("name");
                String templateDesc = (String)object.get("description");
                searchId = P8Util.getObjectIdentity(searchId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto id = " + searchId);
                String currentVersionId = this.getCurrentSearchVersionId(searchId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Id in teamspace = " + searchId + " : Latest search Id: " + currentVersionId);
                searches.add(currentVersionId);
                JSONObject search = new JSONObject();
                search.put("id", P8Util.getDocId("StoredSearch", this.objectStore.get_ObjectStoreId().toString(), currentVersionId));
                search.put("name", templateName);
                search.put("description", templateDesc);
                this.teamspaceDB.addSearch(search);
            }
        }
        teamspace.setSearches(searches);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private List<Subject> getTeam(Teamspace teamspace) {
        int i;
        String methodName = "retrieveTeam";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        HashMap<String, Subject> map = new HashMap<String, Subject>();
        JSONArray membersJson = this.teamspaceDB.getMembers();
        JSONArray rolesArray = this.teamspaceDB.getRoles();
        HashMap<String, Role> rolesMap = new HashMap<String, Role>();
        for (i = 0; i < rolesArray.size(); ++i) {
            JSONObject roleObj = (JSONObject)rolesArray.get(i);
            String roleId = (String)roleObj.get("id");
            String messageId = (String)roleObj.get("messageId");
            String roleName = (String)roleObj.get("name");
            String roleDesc = (String)roleObj.get("description");
            JSONArray privsArray = (JSONArray)roleObj.get("privileges");
            ArrayList<String> privileges = new ArrayList<String>();
            for (int j = 0; j < privsArray.size(); ++j) {
                String priv = (String)privsArray.get(j);
                privileges.add(priv);
            }
            Role role = new Role(roleId, roleName, roleDesc, privileges);
            role.setRoleType(SecurityConstants.RoleType.TEAMSPACE);
            role.setMessageId(messageId);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "add role to roleMap: " + role.toJSON());
            rolesMap.put(roleId, role);
        }
        for (i = 0; i < membersJson.size(); ++i) {
            JSONObject member = (JSONObject)membersJson.get(i);
            String principalId = (String)member.get("id");
            String principalName = (String)member.get("name");
            SecurityConstants.PrincipalType principalType = SecurityConstants.PrincipalType.valueOf(((String)member.get("type")).toUpperCase());
            ArrayList<Role> usrRoles = new ArrayList<Role>();
            if (principalType == SecurityConstants.PrincipalType.USER) {
                String principalSrcId = principalId;
                if (principalId.equals("CURRENT_USER")) {
                    principalSrcId = principalName;
                }
                User usr = Factory.User.fetchInstance((Connection)this.connection, (String)principalSrcId, null);
                com.ibm.ecm.security.User user = new com.ibm.ecm.security.User(usr.get_Id(), usr.get_Name(), usr.get_ShortName(), usr.get_DisplayName(), usr.get_Email(), usrRoles);
                P8TeamspaceService.addMember(map, user);
            } else if (principalType == SecurityConstants.PrincipalType.GROUP) {
                Group group = Factory.Group.fetchInstance((Connection)this.connection, (String)principalName, null);
                UserGroup userGroup = new UserGroup(group.get_Id(), group.get_Name(), group.get_ShortName(), group.get_DisplayName(), null, usrRoles);
                P8TeamspaceService.addMember(map, userGroup);
            }
            JSONArray memberRolesArray = (JSONArray)member.get("roles");
            for (int j = 0; j < memberRolesArray.size(); ++j) {
                String roleId = (String)memberRolesArray.get(j);
                Role role = (Role)rolesMap.get(roleId);
                usrRoles.add(role);
                HashMap<String, SecurityConstants.PrincipalType> assignees = role.getAssignees();
                if (assignees == null) {
                    assignees = new HashMap();
                    role.setAssigness(assignees);
                }
                if (assignees.containsKey(principalId) || assignees.containsKey(principalName)) continue;
                if (principalId.equals("CURRENT_USER") || principalType == SecurityConstants.PrincipalType.GROUP) {
                    assignees.put(principalName, principalType);
                    continue;
                }
                assignees.put(principalId, principalType);
            }
        }
        ArrayList<Subject> members = new ArrayList<Subject>(map.values());
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return members;
    }

    private void retrieveTeamspaceClasses(Teamspace teamspace) {
        String methodName = "retrieveTeamspaceClasses";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray classesJsonArray = this.teamspaceDB.getClasses();
        ArrayList<String> classes = new ArrayList<String>();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto _classes = " + classesJsonArray);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto number of classes = " + classesJsonArray.size());
        if (classesJsonArray != null) {
            ListIterator iterator = classesJsonArray.listIterator();
            while (iterator.hasNext()) {
                JSONObject object = (JSONObject)iterator.next();
                String classesId = (String)object.get("id");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto classes Id = " + classesId);
                classes.add(classesId);
            }
        }
        teamspace.setClasses(classes);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void retrieveTeamspaceEntryTemplates(Teamspace teamspace) {
        String methodName = "retrieveTeamspaceEntryTemplates";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray entryTemplatesJsonArray = this.teamspaceDB.getEntryTemplates();
        ArrayList<String> entryTemplates = new ArrayList<String>();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto entryTemplates = " + entryTemplatesJsonArray);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto number of entry templates = " + entryTemplatesJsonArray.size());
        if (entryTemplatesJsonArray != null) {
            ListIterator iterator = entryTemplatesJsonArray.listIterator();
            while (iterator.hasNext()) {
                JSONObject object = (JSONObject)iterator.next();
                String entryTemplateId = (String)object.get("id");
                entryTemplateId = P8Util.getObjectIdentity(entryTemplateId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "cto entryTemplateId= " + entryTemplateId);
                entryTemplates.add(entryTemplateId);
            }
        }
        teamspace.setEntryTemplates(entryTemplates);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void retrieveTeamspaceColumns(Teamspace teamspace) {
        String methodName = "retrieveTeamspaceColumns";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        SearchTemplate.ResultsDisplay colProps = this.teamspaceDB.getColumnProperties();
        teamspace.setColumnProperties(colProps);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }
}

