/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace.cm8;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.cm8.CM8AddItemUtil;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKACLData;
import com.ibm.mm.sdk.common.DKAccessControlListICM;
import com.ibm.mm.sdk.common.DKAuthorizationMgmtICM;
import com.ibm.mm.sdk.common.DKChildCollection;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreAdminICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKFolder;
import com.ibm.mm.sdk.common.DKImageICM;
import com.ibm.mm.sdk.common.DKLink;
import com.ibm.mm.sdk.common.DKLinkCollection;
import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKParts;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKPrivilegeSetICM;
import com.ibm.mm.sdk.common.DKProjectionListICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKStreamICM;
import com.ibm.mm.sdk.common.DKTextICM;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.DKVideoStreamICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkResource;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TestTeamspaceService {
    public static void main(String[] args) {
        try {
            WCDateFormat wcDateFormats = new WCDateFormat();
            String database = "grnvm138";
            String userName = "icmadmin";
            String password = "dingo4FVT";
            DKDatastoreICM dsICM = new DKDatastoreICM();
            CMConnection connection = new CMConnection(dsICM, userName, dsICM.languageCode());
            dsICM.connect(database, userName, password, "");
            Logger.setLogLevel(4);
            CM8TeamspaceService teamspaceService = new CM8TeamspaceService(null, connection, wcDateFormats);
            Object acl = null;
            TestTeamspaceService.retreiveTeamspaces(teamspaceService, "template", true);
            TestTeamspaceService.delACLs(dsICM);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void listACLs(DKDatastoreICM dsICM) {
        try {
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)dsICM);
            DKDatastoreDefICM dsDef = (DKDatastoreDefICM)dsICM.datastoreDef();
            DKDatastoreAdminICM dsAdmin = (DKDatastoreAdminICM)dsDef.datastoreAdmin();
            DKAuthorizationMgmtICM dsAclMgmt = (DKAuthorizationMgmtICM)dsAdmin.authorizationMgmt();
            dkCollection coll = dsAclMgmt.listUserAccessControlLists((short)1);
            dkIterator it = coll.createIterator();
            System.out.println("Has user ACLs " + it.more());
            while (it.more()) {
                DKAccessControlListICM tAcl = (DKAccessControlListICM)it.next();
                TestTeamspaceService.printACL(tAcl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printACL(DKAccessControlListICM acl_1) throws DKException, Exception {
        System.out.println("  ACL = " + acl_1.getName() + " (" + acl_1.getDescription() + ")");
        System.out.println("Contains " + acl_1.getACLType() + " type");
        System.out.println("ID " + acl_1.getID());
        System.out.println("Has acl rules:  " + acl_1.getACLData().isEmpty());
        dkCollection coll = acl_1.listACLData();
        dkIterator iter = coll.createIterator();
        System.out.println("Has user data " + iter.more());
        while (iter.more()) {
            DKACLData aclData = (DKACLData)iter.next();
            DKPrivilegeSetICM _privSet = (DKPrivilegeSetICM)aclData.getPrivilegeSet();
            System.out.println("    " + _privSet + " --> " + _privSet.getName());
            short patronType = aclData.getPatronType();
            System.out.println("    " + patronType + " --> " + patronType);
            String usrGrpName = aclData.getUserGroupName();
            if (patronType == 0) {
                System.out.println("    " + usrGrpName + " --> " + _privSet.getName());
                continue;
            }
            System.out.println("    " + usrGrpName + " --> " + _privSet.getName());
        }
    }

    public static void delACLs(DKDatastoreICM dsICM) {
        try {
            CM8SecurityService service = new CM8SecurityService(null, dsICM);
            service.deleteAllUserACLs();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public static void listRoles(DKDatastoreICM dsICM, boolean delete) {
        try {
            CM8SecurityService service = new CM8SecurityService(null, dsICM);
            List<Role> templateRoles = service.retrieveRoles(SecurityConstants.RoleType.TEMPLATE, false);
            for (Role role : templateRoles) {
                System.out.println("role.getName(): " + role.getName());
                System.out.println("role.getDescription(): " + role.getDescription());
                if (!delete) continue;
                service.deleteRole(role);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyItem(DKDatastoreICM dsICM, WCDateFormat wcDateFormats) {
        String methodName = "copyItem";
        try {
            CM8AddItemUtil addItemUtil = new CM8AddItemUtil(null, dsICM, wcDateFormats);
            CM8AddItemUtil utils = new CM8AddItemUtil(null, dsICM, wcDateFormats);
            DKDDO sourceDdo = dsICM.createDDOFromPID("86 3 ICM8 grnvm1387 NOINDEX59 26 A1001001A11L13B63812A6787718 A11L13B63812A678771 04 1000");
            String itemTypeName = CMBaseUtil._getEntityName(sourceDdo.getPidObject().getObjectType());
            System.out.println("itemTypeName: " + itemTypeName);
            DKDDO targetDdo = dsICM.createDDO(itemTypeName, 1);
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
            dkRetrieveOptions.linksOutbound(false);
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.childAttributes(false);
            dkRetrieveOptions.childListOneLevel(false);
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            dkRetrieveOptions.resourceContent(true);
            dkRetrieveOptions.partsList(true);
            dkRetrieveOptions.partsAttributes(true);
            DKPidICM pid = (DKPidICM)sourceDdo.getPidObject();
            if (pid.getVersionNumber().equals("0")) {
                pid.setVersionNumber("1");
                dkRetrieveOptions.functionVersionLatest(true);
            }
            sourceDdo.retrieve(dkRetrieveOptions.dkNVPair());
            block7: for (short dataid = 1; dataid <= sourceDdo.dataCount(); dataid = (short)(dataid + 1)) {
                System.out.println("                  Data:     Name:  " + sourceDdo.getDataName(dataid) + "  (" + sourceDdo.getDataNameSpace(dataid) + ")");
                String name = sourceDdo.getDataName(dataid);
                String namesp = sourceDdo.getDataNameSpace(dataid);
                Object value = sourceDdo.getData(dataid);
                Short type = (Short)sourceDdo.getDataPropertyByName(dataid, "type");
                switch (type.intValue()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        System.out.println("value: " + value);
                        if (name.equalsIgnoreCase("USER_ID")) {
                            value = "MikeMitchell8";
                        }
                        targetDdo.setData(targetDdo.dataId("ATTR", name), value);
                        continue block7;
                    }
                }
            }
            addItemUtil.copyResourceAndPartContent(sourceDdo, targetDdo);
            targetDdo.add();
            TestTeamspaceService.printDDO(targetDdo);
        }
        catch (DKUsageError e) {
            e.printStackTrace();
        }
        catch (DKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Teamspace createTeamspaceTemplate(CM8TeamspaceService workspaceService) {
        Object id = null;
        Teamspace workspace = null;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONArray jsonTeamspaces = new JSONArray();
            jsonObject.put("name", "Michael");
            workspace = new Teamspace(null, "Michael", "bad workspace", "template", "ICMTeamspaceTemplate", jsonObject.toString(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspace;
    }

    public static Teamspace createTeamspaceInstance(CM8TeamspaceService workspaceService) {
        Object id = null;
        Teamspace workspace = null;
        try {
            String jsonTemplate = "{\"id\":\"{F7D825C3-47BB-4564-B1A4-D5FA7BA0F034}\",\"name\":\"i9_folderTest1\",\"type\":\"instance\",\"state\":\"published\",\"description\":\"i9_folderTest1\",\"templateName\":\"\",\"folders\":[{\"name\":\"i9_folderTest1\",\"path\":\"/\",\"type\":\"folder\"},{\"name\":\"test\",\"path\":\"/test\",\"type\":\"folder\",\"properties\":{\"folderName\":\"test\",\"docid\":\"\",\"criterias\":[{\"name\":\"FolderName\",\"values\":[\"test\"],\"dataType\":\"xs:string\",\"label\":\"Folder Name\"},{\"name\":\"FolderName\",\"values\":[\"test\"],\"dataType\":\"xs:string\",\"label\":\"Folder Name\"}],\"documentType\":\"Folder\"}}],\"contentClasses\":[],\"searchTemplates\":[],\"roles\":[]}";
            workspace = new Teamspace(null, "Michael_2", "mike folder test 2", "instance", "ICMTeamspace", jsonTemplate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspace;
    }

    public static Teamspace retreiveTeamspaces(CM8TeamspaceService workspaceService, String type, boolean delete) {
        Teamspace workspaceObject = null;
        try {
            int i = 0;
            List<Teamspace> workspaces = workspaceService.retrieveTeamspaces(type, "published");
            System.out.println("teamspace size: " + workspaces.size());
            Iterator<Teamspace> iterator = workspaces.iterator();
            while (iterator.hasNext()) {
                if (delete) {
                    Teamspace tmpTeamspace = iterator.next();
                    workspaceService.deleteTeamspace(tmpTeamspace, type);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspaceObject;
    }

    public static Teamspace retreiveTeamspaceByName(CM8TeamspaceService workspaceService, Teamspace workspace) {
        Teamspace workspaceObject = null;
        return workspaceObject;
    }

    public static Teamspace retreiveTeamspaceById(CM8TeamspaceService workspaceService, String id) {
        Teamspace workspaceObject = null;
        try {
            workspaceObject = workspaceService.retrieveTeamspace(id, null, "template");
            TestTeamspaceService.printTeamspaceProps(workspaceObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workspaceObject;
    }

    public static void printTeamspaceProps(Teamspace workspace) {
        System.out.println("------------------------------");
        System.out.println("Name: \t\t" + workspace.getName());
        System.out.println("Type: \t\t" + workspace.getType());
        System.out.println("State: \t\t" + workspace.getState());
        System.out.println("Description:" + workspace.getDescription());
        System.out.println("Id: \t\t" + workspace.getId());
        System.out.println("json: \t\t" + workspace.getJson());
    }

    public static void printDDO(DKDDO ddo) throws DKException, Exception {
        int i;
        short dataid;
        if (ddo == null) {
            System.out.println("    *** DDO is 'null' *** ");
            return;
        }
        ArrayList<DKChildCollection> childCollections = new ArrayList<DKChildCollection>();
        ArrayList<DKLinkCollection> linkCollections = new ArrayList<DKLinkCollection>();
        DKPidICM pid = (DKPidICM)ddo.getPidObject();
        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)ddo.getDatastore().datastoreDef();
        DKComponentTypeDefICM compType = (DKComponentTypeDefICM)dsDefICM.retrieveComponentTypeView(pid.getObjectType());
        System.out.println("--------------------------------------------------");
        System.out.println("                       DDO");
        System.out.println("--------------------------------------------------");
        System.out.println("PID:");
        System.out.println("        Component Type:  " + pid.getObjectType());
        System.out.println("               Item ID:  " + pid.getItemId());
        System.out.println("          Component ID:  " + pid.getComponentId());
        System.out.println("     Component Type ID:  " + pid.getComponentTypeId());
        System.out.println("            Primary ID:  " + pid.getPrimaryId());
        System.out.println("        Datastore Type:  " + pid.getDatastoreType());
        System.out.println("               Version:  " + pid.getVersionNumber());
        System.out.println("Item Info:");
        if (!compType.isRoot()) {
            if (ddo.getParent() == null) {
                System.out.println("                Parent:  Exists, But Unknown to Object in Memory");
            } else {
                System.out.println("                Parent:     Type:  " + ddo.getParent().getObjectType());
                System.out.println("                         Item ID:  " + ((DKPidICM)((DKDDO)ddo.getParent()).getPidObject()).getItemId());
            }
        } else {
            System.out.println("                Parent:  None, Is Root");
        }
        if (ddo instanceof dkResource) {
            if (ddo instanceof DKTextICM) {
                System.out.println("          Resource XDO:  Yes - Text");
            } else if (ddo instanceof DKImageICM) {
                System.out.println("          Resource XDO:  Yes - Image");
            } else if (ddo instanceof DKVideoStreamICM) {
                System.out.println("          Resource XDO:  Yes - Video Stream");
            } else if (ddo instanceof DKStreamICM) {
                System.out.println("          Resource XDO:  Yes - Stream");
            } else if (ddo instanceof DKLobICM) {
                System.out.println("          Resource XDO:  Yes - Lob");
            } else {
                System.out.println("          Resource XDO:  Yes - dkResource");
            }
        } else {
            System.out.println("          Resource XDO:  No");
        }
        if (compType.isRoot()) {
            short propIdSemanticType = ddo.propertyId("semantic-type");
            short propIdItemPropertyType = ddo.propertyId("item-type");
            int semanticType = -2;
            int itemPropertyType = -2;
            if (propIdSemanticType > 0) {
                semanticType = (Integer)ddo.getProperty(propIdSemanticType);
            }
            if (propIdItemPropertyType > 0) {
                itemPropertyType = ((Short)ddo.getProperty(propIdItemPropertyType)).shortValue();
            }
            switch (itemPropertyType) {
                case 1: {
                    System.out.println("         Item Property:  Document");
                    break;
                }
                case 2: {
                    System.out.println("         Item Property:  Folder");
                    break;
                }
                case 4: {
                    System.out.println("         Item Property:  Item");
                    break;
                }
                case -2: {
                    System.out.println("         Item Property:  <not retrieved>");
                    break;
                }
                default: {
                    System.out.println("         Item Property:  Other (" + itemPropertyType + ")");
                }
            }
            switch (semanticType) {
                case 1: {
                    System.out.println("         Semantic Type:  Document");
                    break;
                }
                case 2: {
                    System.out.println("         Semantic Type:  Folder");
                    break;
                }
                case 4: {
                    System.out.println("         Semantic Type:  Folder");
                    break;
                }
                case 8: {
                    System.out.println("         Semantic Type:  Annotation");
                    break;
                }
                case 16: {
                    System.out.println("         Semantic Type:  History");
                    break;
                }
                case 64: {
                    System.out.println("         Semantic Type:  Note");
                    break;
                }
                case 128: {
                    System.out.println("         Semantic Type:  Base");
                    break;
                }
                case 256: {
                    System.out.println("         Semantic Type:  Base Text");
                    break;
                }
                case 512: {
                    System.out.println("         Semantic Type:  Base Stream");
                    break;
                }
                case -2: {
                    System.out.println("         Semantic Type:  <not retrieved>");
                    break;
                }
                default: {
                    System.out.println("         Semantic Type:  Other (" + semanticType + ")");
                }
            }
        }
        System.out.println("Properties:");
        System.out.println("                Number:  " + ddo.propertyCount());
        for (short propid = 1; propid <= ddo.propertyCount(); propid = (short)(propid + 1)) {
            String name = ddo.getPropertyName(propid);
            Object value = ddo.getProperty(propid);
            System.out.println("              Property:     Name:  " + name);
            System.out.println("                           Value:  " + TestTeamspaceService.obj2String(value));
        }
        System.out.println("Attributes / Data Items:");
        System.out.println("                Number:  " + ddo.dataCount());
        for (dataid = 1; dataid <= ddo.dataCount(); dataid = (short)(dataid + 1)) {
            System.out.println("                  Data:     Name:  " + ddo.getDataName(dataid) + "  (" + ddo.getDataNameSpace(dataid) + ")");
            String name = ddo.getDataName(dataid);
            String namesp = ddo.getDataNameSpace(dataid);
            Object value = ddo.getData(dataid);
            Short type = (Short)ddo.getDataPropertyByName(dataid, "type");
            switch (type.intValue()) {
                case 0: {
                    System.out.println("                            Type:  Undefined");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 1: {
                    System.out.println("                            Type:  String");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 3: {
                    System.out.println("                            Type:  Short");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 4: {
                    System.out.println("                            Type:  Long");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 5: {
                    System.out.println("                            Type:  Float");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 6: {
                    System.out.println("                            Type:  Decimal");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 7: {
                    System.out.println("                            Type:  Date");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 8: {
                    System.out.println("                            Type:  Time");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 9: {
                    System.out.println("                            Type:  Timestamp");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 10: {
                    System.out.println("                            Type:  Double");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                case 11: {
                    System.out.println("                            Type:  Byte Array (Blob)");
                    if (value == null) break;
                    System.out.println("                           Value:  <Byte Array Object>");
                    break;
                }
                case 48: {
                    System.out.println("                            Type:  DDO");
                    if (value == null) break;
                    System.out.println("                           Value:  DDO of type '" + ((DKDDO)value).getPidObject().getObjectType() + "'");
                    System.out.println("                                       Item ID '" + ((DKPidICM)((DKDDO)value).getPidObject()).getItemId() + "'");
                    break;
                }
                case 49: {
                    System.out.println("                            Type:  XDO");
                    if (value == null) break;
                    System.out.println("                           Value:  XDO of type '" + ((DKDDO)value).getPidObject().getObjectType() + "'");
                    System.out.println("                                       Item ID '" + ((DKPidICM)((DKDDO)value).getPidObject()).getItemId() + "'");
                    break;
                }
                case 50: {
                    System.out.println("                            Type:  Data Object Base");
                    if (value == null) break;
                    System.out.println("                           Value:  <Data Object Base Object>");
                    break;
                }
                case 1024: {
                    System.out.println("                            Type:  Collection");
                    if (value == null) break;
                    System.out.println("                           Value:  Collection with '" + ((dkCollection)value).cardinality() + "' Objects.");
                    break;
                }
                case 1072: {
                    System.out.println("                            Type:  DDO Collection");
                    if (value == null) break;
                    System.out.println("                           Value:  DDO Collection with '" + ((dkCollection)value).cardinality() + "' DDOs.");
                    if (!(value instanceof DKChildCollection)) break;
                    childCollections.add((DKChildCollection)value);
                    break;
                }
                case 1073: {
                    System.out.println("                            Type:  XDO Collection");
                    if (value == null) break;
                    System.out.println("                           Value:  XDO Collection with '" + ((dkCollection)value).cardinality() + "' XDOs.");
                    break;
                }
                case 1071: {
                    System.out.println("                            Type:  Link Collection");
                    if (value == null) break;
                    System.out.println("                           Value:  Link Collection with '" + ((dkCollection)value).cardinality() + "' Links.");
                    if (!(value instanceof DKLinkCollection)) break;
                    linkCollections.add((DKLinkCollection)value);
                    break;
                }
                case 2048: {
                    System.out.println("                            Type:  Array");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                    break;
                }
                default: {
                    System.out.println("                            Type:  Unknown (" + type + ")");
                    if (value == null) break;
                    System.out.println("                           Value:  " + value);
                }
            }
            if (value == null) {
                System.out.println("                           Value:  null");
            }
            System.out.println("");
        }
        System.out.println("Children / Multivalue Attributes:");
        for (int i2 = 0; i2 < childCollections.size(); ++i2) {
            DKChildCollection childCollection = (DKChildCollection)childCollections.get(i2);
            dkIterator iter = childCollection.createIterator();
            while (iter.more()) {
                DKDDO child = (DKDDO)iter.next();
                System.out.println("                 Child:     Type:  " + child.getPidObject().getObjectType());
                System.out.println("                         Item ID:  " + ((DKPidICM)child.getPidObject()).getItemId());
                System.out.println("");
            }
        }
        dataid = ddo.dataId("ATTR", "DKParts");
        if (dataid > 0) {
            DKParts dkParts = (DKParts)ddo.getData(dataid);
            System.out.println("Parts:");
            System.out.println("                Number:  " + dkParts.cardinality());
            dkIterator iter = dkParts.createIterator();
            while (iter.more()) {
                DKDDO part = (DKDDO)iter.next();
                System.out.println("                  Part:     Type:  " + part.getPidObject().getObjectType());
                System.out.println("                         Item ID:  " + ((DKPidICM)part.getPidObject()).getItemId());
                System.out.println("");
            }
        }
        if ((dataid = ddo.dataId("ATTR", "DKFolder")) > 0) {
            DKFolder dkFolder = (DKFolder)ddo.getData(dataid);
            System.out.println("Folder Contents:");
            System.out.println("                Number: " + dkFolder.cardinality());
            dkIterator iter = dkFolder.createIterator();
            while (iter.more()) {
                DKDDO contents = (DKDDO)iter.next();
                System.out.println("                  Item:     Type:  " + contents.getPidObject().getObjectType());
                System.out.println("                         Item ID:  " + ((DKPidICM)contents.getPidObject()).getItemId());
                System.out.println("");
            }
        }
        System.out.println("Links:");
        for (i = 0; i < linkCollections.size(); ++i) {
            DKLinkCollection linkCollection = (DKLinkCollection)linkCollections.get(i);
            dkIterator iter = linkCollection.createIterator();
            while (iter.more()) {
                DKLink dkLink = (DKLink)iter.next();
                System.out.println("                  Link:     Type:  " + dkLink.getTypeName());
                System.out.println("                       Source ID:  " + ((DKPidICM)((DKDDO)dkLink.getSource()).getPidObject()).getItemId() + "(" + ((DKDDO)dkLink.getSource()).getPidObject().getObjectType() + ")");
                System.out.println("                       Target ID:  " + ((DKPidICM)((DKDDO)dkLink.getTarget()).getPidObject()).getItemId() + "(" + ((DKDDO)dkLink.getTarget()).getPidObject().getObjectType() + ")");
                if (dkLink.getLinkItem() != null) {
                    System.out.println("                     LinkItem ID:  " + ((DKPidICM)((DKDDO)dkLink.getLinkItem()).getPidObject()).getObjectType());
                } else {
                    System.out.println("                     LinkItem ID:  null");
                }
                System.out.println("");
            }
        }
        System.out.println("--------------------------------------------------------");
        System.out.println("");
        for (i = 0; i < childCollections.size(); ++i) {
            DKChildCollection childCollection = (DKChildCollection)childCollections.get(i);
            dkIterator iter = childCollection.createIterator();
            while (iter.more()) {
                DKDDO child = (DKDDO)iter.next();
                TestTeamspaceService.printDDO(child);
            }
        }
    }

    public static String obj2String(Object object) {
        if (object == null) {
            return "NULL";
        }
        if (object.getClass().getName().compareTo(String.class.getName()) == 0) {
            return (String)object;
        }
        if (object.getClass().getName().compareTo(DKFolder.class.getName()) == 0) {
            return "DKFolder[Size: " + ((DKFolder)object).cardinality() + "]";
        }
        if (object.getClass().getName().compareTo(DKLinkCollection.class.getName()) == 0) {
            return "DKLinkCollection[Size: " + ((DKLinkCollection)object).cardinality() + "]";
        }
        if (object.getClass().getName().compareTo(DKChildCollection.class.getName()) == 0) {
            return "DKChildeCollection[Size: " + ((DKChildCollection)object).cardinality() + "]";
        }
        if (object.getClass().getName().compareTo(DKParts.class.getName()) == 0) {
            return "DKParts[Size: " + ((DKParts)object).cardinality() + "]";
        }
        if (object.getClass().getName().compareTo(DKSequentialCollection.class.getName()) == 0) {
            return "DKSequentialCollection[Size: " + ((DKSequentialCollection)object).cardinality() + "]";
        }
        if (object instanceof dkCollection) {
            return "dkCollection[Size: " + ((dkCollection)object).cardinality() + "]";
        }
        if (object.getClass().getName().compareTo(Vector.class.getName()) == 0) {
            return "Vector[Size: " + ((Vector)object).size() + "]";
        }
        if (object.getClass().getName().compareTo(ArrayList.class.getName()) == 0) {
            return "ArrayList[Size: " + ((ArrayList)object).size() + "]";
        }
        if (object.getClass().getName().compareTo(DKNVPair[].class.getName()) == 0) {
            return "DKNVPair[" + ((DKNVPair[])object).length + "]";
        }
        if (object.getClass().getName().compareTo(DKNVPair.class.getName()) == 0) {
            return "DKNVPair{\"" + TestTeamspaceService.obj2String(((DKNVPair)object).getName()) + "\" = '" + TestTeamspaceService.obj2String(((DKNVPair)object).getValue()) + "'}";
        }
        if (object.getClass().getName().compareTo(DKDatastoreICM.class.getName()) == 0) {
            try {
                return "DKDatastoreICM[name='" + ((DKDatastoreICM)object).datastoreName() + "',type='" + ((DKDatastoreICM)object).datastoreType() + "',more=" + (DKDatastoreICM)object + "]";
            }
            catch (Exception exc) {
                return "DKDatastoreICM(" + (DKDatastoreICM)object + ")";
            }
        }
        if (object.getClass().getName().compareTo(DKRetrieveOptionsICM.class.getName()) == 0) {
            return object.toString();
        }
        if (object.getClass().getName().compareTo(DKProjectionListICM.class.getName()) == 0) {
            return object.toString();
        }
        return object.getClass().getName() + ' ' + object.toString();
    }
}

