/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace.cm8;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.dm.CMDataModel;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.Subject;
import com.ibm.ecm.security.UserGroup;
import com.ibm.ecm.security.cm8.CM8AccessControlListData;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.security.cm8.CM8SecurityUtils;
import com.ibm.ecm.security.cm8.CM8User;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.teamspace.BaseTeamspaceService;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.TeamspaceDB;
import com.ibm.ecm.teamspace.TeamspaceException;
import com.ibm.ecm.teamspace.TeamspaceUtil;
import com.ibm.ecm.teamspace.cm8.CM8AddItemUtil;
import com.ibm.ecm.teamspace.cm8.CM8FolderUtils;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKChildCollection;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkResultSetCursor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CM8TeamspaceService
extends BaseTeamspaceService {
    public static final String TEAMSPACE_ACL_PREFIX = "clb";
    public static final String TEAMSPACE_PARENT_FOLDER = "Teamspaces";
    public static final String TEAMSPACE_TEMPLATE_PARENT_FOLDER = "Teamspace Templates";
    public static final String TEAMSPACE_CLASS = "ICMTeamspace";
    public static final String TEAMSPACE_TEMPLATE_CLASS = "ICMTeamspaceTemplate";
    public static final String TEAMSPACE_CLASS_CHILD = "ICMTeamspaceData";
    public static final String TEAMSPACE_TEMPLATE_CLASS_CHILD = "ICMTeamspaceTemplateData";
    public static final String TEAMSPACE_PROP_DESCRIPTION = "clbDescription";
    public static final String TEAMSPACE_PROP_TYPE = "clbTeamspace";
    public static final String TEAMSPACE_PROP_NAME = "clbTitle";
    public static final String TEAMSPACE_PROP_CM_ITEM_NAME = "ICM$NAME";
    public static final String TEAMSPACE_PROP_JSON = "clbJSONData";
    public static final String TEAMSPACE_PROP_DEFAULT_CLASS = "clbDefaultDocType";
    public static final String TEAMSPACE_PROP_GROUP_NAME = "clbGroupName";
    public static final String TEAMSPACE_PROP_MAPPED_FOLDER = "clbMappedFolder";
    public static final String TEAMSPACE_PROP_STATE = "clbState";
    private TeamspaceDB teamspaceDB;
    private CMConnection connection;
    private CM8SecurityService securityService;
    private WCDateFormat wcDateFormats;
    private HttpServletRequest request;
    private CM8AddItemUtil addItemUtil;

    public CM8TeamspaceService(HttpServletRequest request, CMConnection connection, WCDateFormat wcDateFormats) {
        String methodName = "CM8TeamspaceService";
        this.request = request;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this.connection = connection;
        this.wcDateFormats = wcDateFormats;
        this.securityService = new CM8SecurityService(request, connection.getDatastore());
        this.addItemUtil = new CM8AddItemUtil(request, connection.getDatastore(), wcDateFormats);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private DKDDO retrieveTeamspaceDDO(String id) throws Exception {
        String methodName = "retrieveTeamspaceDDO";
        DKDDO icmddo = null;
        icmddo = this.connection.getDatastore().createDDOFromPID(id);
        dkDatastoreExt dsExt = (dkDatastoreExt)this.connection.getDatastore().getExtension("DATASTORE_EXTENSION");
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
        dkRetrieveOptions.linksOutbound(false);
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.childAttributes(true);
        dkRetrieveOptions.basePropertyAclName(true);
        dkRetrieveOptions.childListOneLevel(true);
        dkRetrieveOptions.linksTypeFilter("DKFolder");
        dkRetrieveOptions.basePropertyCheckedOutDetails(true);
        DKPidICM pid = (DKPidICM)icmddo.getPidObject();
        if (pid.getVersionNumber().equals("0")) {
            pid.setVersionNumber("1");
            dkRetrieveOptions.functionVersionLatest(true);
        }
        icmddo.retrieve(dkRetrieveOptions.dkNVPair());
        String currentUser = dsExt.getDatastore().userName();
        String checkedOutBy = dsExt.checkedOutUserid((dkDataObject)icmddo);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "checked out by =" + checkedOutBy);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "user name currently logged on=" + currentUser);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace id= " + id);
        if (!dsExt.isCheckedOut((dkDataObject)icmddo)) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "item not checked out.  About to check it out ");
            this.connection.getDatastore().checkOut((dkDataObject)icmddo);
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "item already checked out");
        }
        return icmddo;
    }

    /*
     * Loose catch block
     */
    public String editTeamspace(Teamspace teamspace, List<Role> roles, AccessControlList secObjACL, boolean modifyUsers) throws TeamspaceException {
        block20: {
            String methodName = "editTeamspace";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            DKDDO icmddo = null;
            dkDatastoreExt dsExt = null;
            try {
                dsExt = (dkDatastoreExt)this.connection.getDatastore().getExtension("DATASTORE_EXTENSION");
            }
            catch (Exception e1) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e1);
            }
            icmddo = this.retrieveTeamspaceDDO(teamspace.getId());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getName() : " + teamspace.getName());
            icmddo.setData(icmddo.dataId("ATTR", TEAMSPACE_PROP_NAME), (Object)teamspace.getName());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getDescription() : " + teamspace.getDescription());
            icmddo.setData(icmddo.dataId("ATTR", TEAMSPACE_PROP_DESCRIPTION), (Object)teamspace.getDescription());
            if (teamspace.getState() != null && teamspace.getState().length() > 0) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "updating state to : " + teamspace.getState());
                Integer state = new Integer(BaseTeamspaceService.State.getEnum(teamspace.getState()).getValue());
                icmddo.setData(icmddo.dataId("ATTR", TEAMSPACE_PROP_STATE), (Object)state);
                if (teamspace.getState().equals("default")) {
                    DKDDO previousDefaultDdo = this.findTeamspace("template", "default");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "previousDefaultDdo : " + previousDefaultDdo);
                    if (previousDefaultDdo != null && !icmddo.getPidObject().pidString().equalsIgnoreCase(previousDefaultDdo.getPidObject().pidString())) {
                        if (!dsExt.isCheckedOut((dkDataObject)previousDefaultDdo)) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Item is not checked out ");
                            this.connection.getDatastore().checkOut((dkDataObject)previousDefaultDdo);
                        }
                        state = new Integer(BaseTeamspaceService.State.PUBLISHED.getValue());
                        previousDefaultDdo.setData(previousDefaultDdo.dataId("ATTR", TEAMSPACE_PROP_STATE), (Object)state);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "updating previous default item");
                        previousDefaultDdo.update(8192);
                    }
                    teamspace.setState("published");
                }
            }
            String type = teamspace.getType();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = " + type);
            String teamspaceChild = TEAMSPACE_CLASS_CHILD;
            if (type.equals("template")) {
                teamspaceChild = TEAMSPACE_TEMPLATE_CLASS_CHILD;
            }
            short dataid = icmddo.dataId("CHILD", teamspaceChild);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "child data id = " + dataid);
            DKChildCollection children = (DKChildCollection)icmddo.getData(dataid);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "children = " + children);
            if (children != null) {
                dkIterator iter = children.createIterator();
                DKDDO jsonDDO = (DKDDO)iter.next();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Setting json data" + teamspace.getJson());
                jsonDDO.setData(jsonDDO.dataId("ATTR", TEAMSPACE_PROP_JSON), (Object)teamspace.getJson());
            }
            if (dsExt.isCheckedOut((dkDataObject)icmddo)) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Item is checked out ");
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Updating the item ");
            if (teamspace.getType().equalsIgnoreCase("instance") && modifyUsers) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrieve current ACL");
                AccessControlList oldACL = this.securityService.retrieveACL(icmddo);
                secObjACL.setName(oldACL.getName());
                if (secObjACL != null && secObjACL.getAclData().size() > 0) {
                    this.securityService.updateACL(secObjACL, secObjACL.getName());
                }
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
            Object var15_16 = null;
            try {
                if (icmddo != null && dsExt.isCheckedOut((dkDataObject)icmddo)) {
                    icmddo.update(8192);
                }
                break block20;
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
            break block20;
            {
                catch (Exception ex) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
                    throw new TeamspaceException("Failed to edit teamspace!", ex, 1089);
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    if (icmddo != null && dsExt.isCheckedOut((dkDataObject)icmddo)) {
                        icmddo.update(8192);
                    }
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
                throw throwable;
            }
        }
        return teamspace.getId();
    }

    public String createTeamspace(Teamspace teamspace, List<Role> roles, AccessControlList secObjACL) throws TeamspaceException, SecurityException {
        String methodName = "createTeamspace";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceType : " + teamspace.getType());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceJson : " + teamspace.getJson());
        String teamspaceJson = teamspace.toJSON().toString();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.toJSON : " + teamspaceJson);
        this.teamspaceDB = new TeamspaceDB((ServletRequest)this.request, teamspaceJson);
        String id = null;
        try {
            String type = teamspace.getType();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceType : " + type);
            String parentFolderPath = TEAMSPACE_PARENT_FOLDER;
            String teamspaceClass = TEAMSPACE_CLASS;
            String teamspaceChild = TEAMSPACE_CLASS_CHILD;
            if (type.equals("template")) {
                parentFolderPath = TEAMSPACE_TEMPLATE_PARENT_FOLDER;
                teamspaceClass = TEAMSPACE_TEMPLATE_CLASS;
                teamspaceChild = TEAMSPACE_TEMPLATE_CLASS_CHILD;
            }
            String folderName = TeamspaceUtil.getUniqueId(teamspace.getName());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "folderName: " + folderName + ", len: " + folderName.length());
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put(TEAMSPACE_PROP_CM_ITEM_NAME, folderName);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getDescription() : " + teamspace.getDescription());
            if (teamspace.getDescription() != null) {
                props.put(TEAMSPACE_PROP_DESCRIPTION, teamspace.getDescription());
            }
            String defaultClass = this.teamspaceDB.getDefaultClass();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "defaultClass : " + defaultClass);
            props.put(TEAMSPACE_PROP_DEFAULT_CLASS, defaultClass);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getName() : " + teamspace.getName());
            props.put(TEAMSPACE_PROP_NAME, teamspace.getName());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getState() : " + teamspace.getState());
            if (type.equalsIgnoreCase("instance")) {
                props.put(TEAMSPACE_PROP_STATE, BaseTeamspaceService.State.PUBLISHED.getValue() + "");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getTemplateId() : " + teamspace.getTemplateId());
                if (teamspace.getTemplateId() != null && teamspace.getTemplateId().length() > 0) {
                    this.teamspaceDB.setTeamspaceTemplateId(teamspace.getTemplateId());
                }
            } else if (type.equalsIgnoreCase("template")) {
                props.put(TEAMSPACE_PROP_STATE, BaseTeamspaceService.State.getEnum(teamspace.getState()).getValue() + "");
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "createHierarchicalFolder");
            DKDDO systemRootFolder = this.connection.getDatastore().getRootFolder();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "dump system root folder");
            this.dumpDdo(systemRootFolder);
            DKDDO teamspaceParentFolder = CM8FolderUtils.getChild((ServletRequest)this.request, this.connection.getDatastore(), systemRootFolder, teamspaceClass, parentFolderPath);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "dump parent folder");
            this.dumpDdo(teamspaceParentFolder);
            DKDDO teamspaceDDO = this.addItemUtil.createTeamspace(teamspaceClass, teamspaceChild, props, teamspaceParentFolder, teamspace.getJson(), TEAMSPACE_PROP_JSON);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getProperties() : " + teamspace.getJson());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceDDO.getPidObject().pidString() : " + teamspaceDDO.getPidObject().pidString());
            this.connection.getDatastore().addObject((dkDataObject)teamspaceDDO, 0);
            teamspaceDDO = this.retrieveTeamspaceDDO(teamspaceDDO.getPidObject().pidString());
            secObjACL.setName(teamspaceDDO.getPidObject().getPrimaryId());
            if (type.equalsIgnoreCase("instance")) {
                secObjACL.setDescription(TEAMSPACE_PROP_TYPE);
            }
            this.setTeamspaceSecurity(teamspaceDDO, teamspace, roles, secObjACL, teamspaceDDO.getPidObject().getPrimaryId());
            teamspaceDDO.update(8192);
            String lastModifiedUser = "";
            short propID = teamspaceDDO.propertyId("SYSROOTATTRS.CREATEUSERID");
            if (propID != 0) {
                Object obj = teamspaceDDO.getProperty(propID);
                lastModifiedUser = (String)obj;
            }
            teamspace.setLastModifiedUser(lastModifiedUser);
            propID = teamspaceDDO.propertyId("SYSROOTATTRS.LASTCHANGEDTS");
            Timestamp lastModifiedTimeStamoObject = null;
            String lastModified = null;
            if (propID != 0) {
                lastModifiedTimeStamoObject = (Timestamp)teamspaceDDO.getProperty(propID);
                lastModified = DateUtil.getISODateString(lastModifiedTimeStamoObject, true);
            }
            teamspace.setLastModified(lastModified);
            id = teamspaceDDO.getPidObject().pidString();
            teamspace.setId(id);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "id: " + id);
            if (type.equalsIgnoreCase("instance")) {
                String aclName = this.retrieveACLName(teamspaceDDO);
                this._createTeamspaceItemsFromTemplateJson(teamspaceDDO, teamspace.getJson(), aclName);
            }
        }
        catch (DKUsageError e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, "message: " + e.getMessage());
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Error code: " + e.errorCode());
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            if (e.errorCode() == 7215) {
                throw new SecurityException(e.getMessage(), e, 1088);
            }
            throw new TeamspaceException("Failed to create teamspace!", e, 1088);
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
            throw new TeamspaceException("Failed to create teamspace!", ex, 1088);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return id;
    }

    private String retrieveACLName(DKDDO teamspaceDDO) {
        String methodName = "retrieveACLName";
        String aclName = null;
        try {
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.basePropertyAclName(true);
            DKPidICM pid = (DKPidICM)teamspaceDDO.getPidObject();
            if (pid.getVersionNumber().equals("0")) {
                pid.setVersionNumber("1");
                dkRetrieveOptions.functionVersionLatest(true);
            }
            teamspaceDDO.retrieve(dkRetrieveOptions.dkNVPair());
            short propertyID = teamspaceDDO.propertyId("SYSROOTATTRS.ACLCODE");
            aclName = (String)teamspaceDDO.getProperty(propertyID);
        }
        catch (DKUsageError e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        return aclName;
    }

    private void setTeamspaceSecurity(DKDDO item, Teamspace teamspace, List<Role> roles, AccessControlList secObjACL, String uniqueName) throws SecurityException {
        String methodName = "applyTeamspaceSecurity";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Applying security to teamspace... ACL name: " + secObjACL.getName());
        if (secObjACL != null && secObjACL.getAclData().size() > 0) {
            if (teamspace.getType().equals("template")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Applying security to teamspace template");
                this.securityService.setACL(secObjACL, item, false, false);
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Applying security to teamspace");
                this.securityService.setACL(secObjACL, item, true, true);
            }
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Default ACL from Item tyep or User def will be used");
        }
    }

    private JSONObject _createJsonObjectFromJsonString(String jsonString) throws TeamspaceException {
        String methodName = "_createJsonObjectFromJsonString";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject jsonObject = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "jsonString: " + jsonString);
        try {
            jsonObject = (JSONObject)JSON.parse(jsonString);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new TeamspaceException(e, 1087);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return jsonObject;
    }

    private void _createTeamspaceItemsFromTemplateJson(DKDDO rootFolder, String templateJsonString, String aclName) throws TeamspaceException {
        String methodName = "_createTeamspaceItemsFromTemplateJson";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject templateJsonObject = this._createJsonObjectFromJsonString(templateJsonString);
        DKDDO parentFolder = null;
        Hashtable<String, DKDDO> folderPathMap = new Hashtable<String, DKDDO>();
        boolean isRoot = true;
        JSONArray foldersJsonArray = (JSONArray)templateJsonObject.get("folders");
        if (foldersJsonArray != null && !foldersJsonArray.isEmpty()) {
            ListIterator iterator = foldersJsonArray.listIterator();
            while (iterator.hasNext()) {
                JSONObject jsonItem = (JSONObject)iterator.next();
                String path = (String)jsonItem.get("path");
                String type = (String)jsonItem.get("type");
                String name = (String)jsonItem.get("name");
                JSONObject properties = (JSONObject)jsonItem.get("properties");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "path: " + path);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type: " + type);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "name: " + name);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "properties: " + properties);
                if (path.equalsIgnoreCase("/") && (type == null || type.equalsIgnoreCase("folder")) || properties == null) continue;
                if (parentFolder == null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentFolder was null, setting it to the root folder");
                    parentFolder = rootFolder;
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "is not root folder");
                    isRoot = false;
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "dumping root folder");
                int lastIndexofPathSymbol = path.lastIndexOf("/");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "lastIndexofPathSymbol: " + lastIndexofPathSymbol);
                String parentPath = path.substring(0, lastIndexofPathSymbol);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentPath = " + parentPath);
                if (!isRoot) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "get folder from cache: " + parentPath);
                    Enumeration collection = folderPathMap.keys();
                    while (collection.hasMoreElements()) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "path cache contains key : " + collection.nextElement());
                    }
                    parentFolder = (DKDDO)folderPathMap.get(parentPath);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentFolder: " + parentFolder);
                    if (parentFolder == null) {
                        parentFolder = rootFolder;
                    }
                } else {
                    parentPath = path;
                }
                if (Logger.getLogLevel() > 3) {
                    this.debugData(parentFolder);
                }
                if (type != null && type.equals("folder")) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "create folder");
                    String className = (String)properties.get("documentType");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "className = " + className);
                    String criterias = properties.get("criterias").toString();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criterias: " + criterias);
                    String childCriterias = properties.get("childComponentValues").toString();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "childCriterias: " + childCriterias);
                    try {
                        DKDDO folder = this.connection.getDatastore().createDDO(className, 2);
                        CM8FolderUtils.setHierarchicalAttrs(folder, parentFolder, name);
                        JSONArray criteriasJsonArray = JSONArray.parse(criterias);
                        JSONArray childCriteriasJsonArray = JSONArray.parse(childCriterias);
                        this.addItemUtil.setItemTypeAttributes(className, criteriasJsonArray, childCriteriasJsonArray, folder);
                        CMEntity entity = this.connection.getEntity(CMBaseUtil._getEntityName(folder.getPidObject().getObjectType()));
                        boolean isItemTypeLevelSec = entity.isItemTypeLevelACL();
                        if (!isItemTypeLevelSec) {
                            short propertyID = folder.propertyId("SYSROOTATTRS.ACLCODE");
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "set acl property name:  " + aclName);
                            folder.setProperty(propertyID, (Object)aclName);
                        }
                        this.connection.getDatastore().addObject((dkDataObject)folder, 0);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "add folder to cache: " + parentPath);
                        folderPathMap.put(path, folder);
                        this.dumpDdo(folder);
                        continue;
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Error setting the citeria data on the folder object");
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        throw new TeamspaceException(e, 1088);
                    }
                }
                try {
                    String docId = (String)properties.get("docid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "about to file document: " + name);
                    DKDDO ddoItem = this.connection.getDatastore().createDDOFromPID(docId);
                    CMItem item = new CMItem(this.request, this.connection, ddoItem, "");
                    item.setItemState(1);
                    item.setDateFormats(WCDateFormat.getDefaultDateFormats(this.request));
                    item.getAttrName();
                    item.getAttrValues();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "fetching the item");
                    String itemName = item.getName();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "item name: " + itemName);
                    Boolean copy = (Boolean)jsonItem.get("IsCopy");
                    boolean isCopy = copy != null && copy != false;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "isCopy: " + isCopy);
                    if (isCopy) {
                        this.createDocumentCopy(parentFolder, item.getDDO(), aclName);
                    } else {
                        if (Logger.getLogLevel() > 3) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "dump doc item");
                            this.debugData(item.getDDO());
                        }
                        this.addItemUtil.addItemToFolder(parentFolder, item.getDDO(), this.request);
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "item name afer making it a supported format: " + itemName);
                }
                catch (Throwable e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, e);
                }
            }
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "foldersJsonArray is null or empty");
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void debugData(DKDDO itemDDO) {
        String methodName = "debugData";
        this.dumpDdo(itemDDO);
        try {
            String itemTypeName = CMBaseUtil._getEntityName(itemDDO.getObjectType());
            DKDatastoreDefICM dsDef = (DKDatastoreDefICM)this.connection.getDatastore().datastoreDef();
            DKItemTypeDefICM itemType = (DKItemTypeDefICM)dsDef.retrieveEntity(itemTypeName);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "parentFolder: " + itemTypeName);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "itemType.isHierarchical(): " + itemType.isHierarchical());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "itemType.foldersOnly()(): " + itemType.foldersOnly());
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
    }

    private void createDocumentCopy(DKDDO parentFolder, DKDDO sourceDDO, String aclName) {
        String methodName = "createDocumentCopy";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            CM8AddItemUtil utils = new CM8AddItemUtil(null, this.connection.getDatastore(), this.wcDateFormats);
            String itemTypeName = CMBaseUtil._getEntityName(sourceDDO.getPidObject().getObjectType());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "itemTypeName: " + itemTypeName);
            DKDDO targetDdo = this.connection.getDatastore().createDDO(itemTypeName, 1);
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
            dkRetrieveOptions.linksOutbound(false);
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.childAttributes(false);
            dkRetrieveOptions.childListOneLevel(false);
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            dkRetrieveOptions.resourceContent(true);
            dkRetrieveOptions.partsList(true);
            dkRetrieveOptions.partsAttributes(true);
            DKPidICM pid = (DKPidICM)sourceDDO.getPidObject();
            if (pid.getVersionNumber().equals("0")) {
                pid.setVersionNumber("1");
                dkRetrieveOptions.functionVersionLatest(true);
            }
            sourceDDO.retrieve(dkRetrieveOptions.dkNVPair());
            block7: for (short dataid = 1; dataid <= sourceDDO.dataCount(); dataid = (short)(dataid + 1)) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Data:     Name:  " + sourceDDO.getDataName(dataid) + "  (" + sourceDDO.getDataNameSpace(dataid) + ")");
                String name = sourceDDO.getDataName(dataid);
                Object value = sourceDDO.getData(dataid);
                Short type = (Short)sourceDDO.getDataPropertyByName(dataid, "type");
                switch (type.intValue()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding name: " + name + " : with value : " + value);
                        targetDdo.setData(targetDdo.dataId("ATTR", name), value);
                        continue block7;
                    }
                }
            }
            this.addItemUtil.copyResourceAndPartContent(sourceDDO, targetDdo);
            CMEntity entity = this.connection.getEntity(CMBaseUtil._getEntityName(targetDdo.getPidObject().getObjectType()));
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entity.getName(): " + entity.getName());
            boolean isItemTypeLevelSec = entity.isItemTypeLevelACL();
            if (!isItemTypeLevelSec) {
                short propertyID = targetDdo.propertyId("SYSROOTATTRS.ACLCODE");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "set acl property name:  " + aclName);
                targetDdo.setProperty(propertyID, (Object)aclName);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking Add");
            targetDdo.add();
            this.addItemUtil.addItemToFolder(parentFolder, targetDdo, this.request);
        }
        catch (DKUsageError e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    protected dkResultSetCursor runQuery(String queryString, boolean retrieveLatestVersion, boolean childComponents) {
        String methodName = "runQuery";
        dkResultSetCursor cursor = null;
        try {
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.functionVersionLatest(true);
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            dkRetrieveOptions.childListOneLevel(childComponents);
            dkRetrieveOptions.childAttributes(childComponents);
            dkRetrieveOptions.linksTypeFilter("DKFolder");
            DKNVPair[] options = new DKNVPair[]{new DKNVPair("MAX_RESULTS", (Object)"0"), new DKNVPair("RETRIEVE_OPTION", (Object)dkRetrieveOptions), new DKNVPair("End", null)};
            CMQueryService query = new CMQueryService(this.request, this.connection.getDatastore());
            Date date = Logger.logPerf((Object)this, "runQuery", (ServletRequest)this.request, "teamspaces retrieve started");
            cursor = query.execute(queryString, options);
            Logger.logPerf(this, "runQuery", (ServletRequest)this.request, date, "teamspaces retrieve completed");
        }
        catch (Exception e) {
            Logger.logError((Object)this, "runQuery", (ServletRequest)this.request, "Error executing query " + e.getMessage());
            Logger.logError((Object)this, "runQuery", (ServletRequest)this.request, (Throwable)e);
        }
        return cursor;
    }

    /*
     * Loose catch block
     */
    public void addSearchTemplate(String teamspaceId, String id, String templateName, String templateDesc) throws TeamspaceException {
        String methodName;
        block18: {
            dkDatastoreExt dsExt;
            DKDDO icmddo;
            block17: {
                methodName = "addSearchTemplate";
                Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
                String json = null;
                Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
                icmddo = null;
                dsExt = null;
                try {
                    icmddo = this.connection.getDatastore().createDDOFromPID(teamspaceId);
                    dsExt = (dkDatastoreExt)this.connection.getDatastore().getExtension("DATASTORE_EXTENSION");
                }
                catch (Exception e1) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e1);
                }
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
                dkRetrieveOptions.linksOutbound(false);
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.childAttributes(true);
                dkRetrieveOptions.childListOneLevel(true);
                dkRetrieveOptions.linksTypeFilter("DKFolder");
                dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                DKPidICM pid = (DKPidICM)icmddo.getPidObject();
                if (pid.getVersionNumber().equals("0")) {
                    pid.setVersionNumber("1");
                    dkRetrieveOptions.functionVersionLatest(true);
                }
                icmddo.retrieve(dkRetrieveOptions.dkNVPair());
                String currentUser = dsExt.getDatastore().userName();
                String checkedOutBy = dsExt.checkedOutUserid((dkDataObject)icmddo);
                boolean isCheckedOut = false;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "checked out by =" + checkedOutBy);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "user name currently logged on=" + currentUser);
                if (!dsExt.isCheckedOut((dkDataObject)icmddo)) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "item not checked out.  About to check it out ");
                    this.connection.getDatastore().checkOut((dkDataObject)icmddo);
                }
                String teamspaceChild = TEAMSPACE_CLASS_CHILD;
                short dataid = icmddo.dataId("CHILD", teamspaceChild);
                DKChildCollection children = (DKChildCollection)icmddo.getData(dataid);
                dkIterator iterator = children.createIterator();
                DKDDO child = null;
                if (iterator.more()) {
                    child = (DKDDO)iterator.next();
                }
                if (child != null) {
                    json = (String)child.getDataByName(TEAMSPACE_PROP_JSON);
                    if (json != null) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "json data: " + json);
                        this.teamspaceDB = new TeamspaceDB((ServletRequest)this.request, json);
                        JSONObject search = new JSONObject();
                        search.put("id", id);
                        search.put("name", templateName);
                        search.put("description", templateDesc);
                        this.teamspaceDB.addSearch(search);
                        json = this.teamspaceDB.toJson();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Setting json data: " + json);
                        child.setData(child.dataId("ATTR", TEAMSPACE_PROP_JSON), (Object)json);
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "json was null");
                    }
                }
                if (!dsExt.isCheckedOut((dkDataObject)icmddo)) break block17;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Item is checked out ");
            }
            Object var21_22 = null;
            try {
                if (icmddo != null && dsExt.isCheckedOut((dkDataObject)icmddo)) {
                    icmddo.update(8192);
                }
                break block18;
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
            break block18;
            {
                catch (Exception ex) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)ex);
                    throw new TeamspaceException("Failed to edit teamspace!", ex, 1089);
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                try {
                    if (icmddo != null && dsExt.isCheckedOut((dkDataObject)icmddo)) {
                        icmddo.update(8192);
                    }
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
                throw throwable;
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public List<Teamspace> retrieveTeamspaces(String type, String retrievalOption) throws SecurityException, TeamspaceException {
        return this.retrieveTeamspaces(type, "all", retrievalOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public DKDDO findTeamspace(String type, String state) throws SecurityException, TeamspaceException {
        block20: {
            methodName = "findTeamspace";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            teamspaces = new ArrayList<E>();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type: " + type);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "state: " + state);
            teamspaceClass = "ICMTeamspace";
            if (type.equals("template")) {
                teamspaceClass = "ICMTeamspaceTemplate";
            }
            ddo = null;
            cursor = null;
            queryString = "/" + teamspaceClass + "[@" + "clbState" + "=" + BaseTeamspaceService.State.getEnum(state).getValue() + "]";
            try {
                cursor = this.runQuery(queryString, true, false);
                ddo = cursor.fetchNext();
                if (ddo != null) {
                    // empty if block
                }
                var11_9 = null;
                ** if (cursor == null) goto lbl-1000
            }
            catch (Throwable var10_23) {
                var11_12 = null;
                if (cursor != null) {
                    try {
                        cursor.destroy();
                    }
                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                }
                throw var10_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    cursor.destroy();
                }
                catch (DKException e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block20;
                catch (DKException e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    var11_10 = null;
                    if (cursor != null) {
                        try {
                            cursor.destroy();
                        }
                        catch (DKException e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                    }
                    break block20;
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    var11_11 = null;
                    if (cursor != null) {
                        try {
                            cursor.destroy();
                        }
                        catch (DKException e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                    }
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return ddo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Teamspace> retrieveTeamspaces(String type, String state, String retrievalOption) throws SecurityException, TeamspaceException {
        block22: {
            methodName = "retrieveTeamspaces";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            teamspaces = new ArrayList<Teamspace>();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type: " + type);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "state: " + state);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrievalOption " + retrievalOption);
            cursor = null;
            teamspaceClass = "ICMTeamspace";
            if (type.equals("template")) {
                teamspaceClass = "ICMTeamspaceTemplate";
            }
            queryString = "/" + teamspaceClass;
            if (retrievalOption == "instance") {
                queryString = "/" + teamspaceClass + "[@" + "clbState" + "=" + BaseTeamspaceService.State.getEnum("published").getValue() + "]";
            } else if (!state.equalsIgnoreCase("all")) {
                queryString = "/" + teamspaceClass + "[@" + "clbState" + "=" + BaseTeamspaceService.State.getEnum(state).getValue() + "]";
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "queryString: " + queryString);
            try {
                cursor = retrievalOption.equalsIgnoreCase("allData") != false ? this.runQuery(queryString, true, true) : this.runQuery(queryString, true, false);
                teamspace = null;
                if (cursor != null) {
                    while ((ddo = cursor.fetchNext()) != null) {
                        teamspace = this.createTeamspaceObject(ddo, retrievalOption, type);
                        this._logTeamspaceObject(teamspace, methodName);
                        if (teamspace == null) continue;
                        teamspaces.add(teamspace);
                    }
                }
                var12_13 = null;
                if (cursor == null) break block22;
                ** GOTO lbl74
            }
            catch (DKException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                var12_14 = null;
                if (cursor != null) {
                    try {
                        cursor.destroy();
                    }
                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                }
                break block22;
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                var12_15 = null;
                if (cursor != null) {
                    ** try [egrp 2[TRYBLOCK] [6, 7 : 467->477)] { 
lbl53:
                    // 1 sources

                    cursor.destroy();
lbl55:
                    // 1 sources

                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
lbl58:
                    // 1 sources

                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                }
                break block22;
            }
            {
                catch (Throwable var11_25) {
                    var12_16 = null;
                    if (cursor == null) throw var11_25;
                    ** try [egrp 2[TRYBLOCK] [6, 7 : 467->477)] { 
lbl66:
                    // 1 sources

                    cursor.destroy();
                    throw var11_25;
lbl68:
                    // 1 sources

                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        throw var11_25;
                    }
lbl71:
                    // 1 sources

                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    throw var11_25;
                }
lbl74:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [6, 7 : 467->477)] { 
lbl75:
                // 1 sources

                cursor.destroy();
lbl77:
                // 1 sources

                catch (DKException e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
lbl80:
                // 1 sources

                catch (Exception e) {}
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace size: " + teamspaces.size());
        return teamspaces;
    }

    private void _logTeamspaceObject(Teamspace teamspace, String methodName) {
        if (teamspace != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "-----------------------------------------------------------------");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getName(): " + teamspace.getName());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getDescription(): " + teamspace.getDescription());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getType(): " + teamspace.getType());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getId(): " + teamspace.getId());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getState(): " + teamspace.getState());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspace.getTemplateId(): " + teamspace.getTemplateId());
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The teamspace is null, check to make sure the data model .");
        }
    }

    public void deleteTeamspace(Teamspace teamspace, String type) throws TeamspaceException {
        this.deleteTeamspace(teamspace.getId(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deleteTeamspace(String teamspaceId, String type) throws TeamspaceException {
        String methodName = "deleteTeamspace";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            block22: {
                Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "Delete teamspace called " + teamspaceId);
                DKDDO icmddo = null;
                dkDatastoreExt dsExt = null;
                try {
                    icmddo = this.connection.getDatastore().createDDOFromPID(teamspaceId);
                    dsExt = (dkDatastoreExt)this.connection.getDatastore().getExtension("DATASTORE_EXTENSION");
                }
                catch (Exception e1) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e1);
                }
                if (this.connection.getDatastore() != null && this.connection.getDatastore().isConnected()) {
                    block21: {
                        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
                        dkRetrieveOptions.linksOutbound(true);
                        dkRetrieveOptions.baseAttributes(true);
                        dkRetrieveOptions.childAttributes(true);
                        dkRetrieveOptions.childListOneLevel(true);
                        dkRetrieveOptions.linksTypeFilter("DKFolder");
                        dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                        DKPidICM pid = (DKPidICM)icmddo.getPidObject();
                        if (pid.getVersionNumber().equals("0")) {
                            pid.setVersionNumber("1");
                            dkRetrieveOptions.functionVersionLatest(true);
                        }
                        icmddo.retrieve(dkRetrieveOptions.dkNVPair());
                        String teamspaceName = (String)icmddo.getDataByName(TEAMSPACE_PROP_NAME);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Deleting teamspaceName = " + teamspaceName);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = " + type);
                        String userid = null;
                        try {
                            userid = (String)icmddo.getPropertyByName("Checked_Out_UserID");
                        }
                        catch (DKUsageError e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                        if (userid == null) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking checkout");
                            this.connection.getDatastore().checkOut((dkDataObject)icmddo);
                        }
                        if (StringUtils.equals((String)type, (String)"template")) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking deleteObject");
                            this.connection.getDatastore().deleteObject((dkDataObject)icmddo, -1);
                            break block21;
                        }
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking setData");
                        Integer state = BaseTeamspaceService.State.DELETED.getValue();
                        icmddo.setData(icmddo.dataId("ATTR", TEAMSPACE_PROP_STATE), (Object)state);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking update on ddo");
                        icmddo.update(8192);
                    }
                    Object var12_15 = null;
                    try {
                        if (icmddo != null && dsExt.isCheckedOut((dkDataObject)icmddo)) {
                            icmddo.update(8192);
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    break block22;
                    {
                        catch (DKException dke1) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)dke1);
                            Object var12_16 = null;
                            try {
                                if (icmddo != null && dsExt.isCheckedOut((dkDataObject)icmddo)) {
                                    icmddo.update(8192);
                                }
                                break block22;
                            }
                            catch (Exception e) {
                                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        try {
                            if (icmddo != null && dsExt.isCheckedOut((dkDataObject)icmddo)) {
                                icmddo.update(8192);
                            }
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                        throw throwable;
                    }
                }
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        }
        catch (Exception e) {
            throw new TeamspaceException("Failed to delete the teamspace !", e, 1090);
        }
    }

    public Teamspace retrieveTeamspace(String teamspaceId, String retrievalOptions, String type) throws TeamspaceException, SecurityException {
        String methodName = "retrieveTeamspace";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Teamspace teamspace = null;
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrievalOptions: " + retrievalOptions);
            if (this.connection.getDatastore() != null && this.connection.getDatastore().isConnected()) {
                DKDDO icmddo = this.connection.getDatastore().createDDOFromPID(teamspaceId);
                try {
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.connection.getDatastore());
                    dkRetrieveOptions.linksOutbound(true);
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.basePropertyAclName(true);
                    dkRetrieveOptions.childAttributes(true);
                    dkRetrieveOptions.childListOneLevel(true);
                    dkRetrieveOptions.linksTypeFilter("DKFolder");
                    dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                    DKPidICM pid = (DKPidICM)icmddo.getPidObject();
                    if (pid.getVersionNumber().equals("0")) {
                        pid.setVersionNumber("1");
                        dkRetrieveOptions.functionVersionLatest(true);
                    }
                    icmddo.retrieve(dkRetrieveOptions.dkNVPair());
                    teamspace = this.createTeamspaceObject(icmddo, retrievalOptions, type);
                }
                catch (DKException dke1) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)dke1);
                }
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new TeamspaceException("Failed to retrieve the teamspace !", e, 1092);
        }
        return teamspace;
    }

    private void dumpDdo(DKDDO ddoItem) {
        String methodName = "dumpDdo";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (ddoItem != null) {
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "--------------------------------------------------------");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ddoItem pid:   " + ddoItem.getPidObject().pidString());
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Number of Attributes / Data Items: " + ddoItem.dataCount());
                for (short dataid = 1; dataid <= ddoItem.dataCount(); dataid = (short)(dataid + 1)) {
                    String name = ddoItem.getDataName(dataid);
                    Object value = ddoItem.getData(dataid);
                    Short type = (Short)ddoItem.getDataPropertyByName(dataid, "type");
                    try {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrieve ACL property from ddo");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String typeDescription = "To Be Determined...";
                    switch (type.intValue()) {
                        case 0: {
                            typeDescription = "Undefined";
                            break;
                        }
                        case 1: {
                            typeDescription = "String";
                            break;
                        }
                        case 3: {
                            typeDescription = "Short";
                            break;
                        }
                        case 4: {
                            typeDescription = "Long";
                            break;
                        }
                        case 5: {
                            typeDescription = "Float";
                            break;
                        }
                        case 6: {
                            typeDescription = "Decimal";
                            break;
                        }
                        case 7: {
                            typeDescription = "Date";
                            break;
                        }
                        case 8: {
                            typeDescription = "Time";
                            break;
                        }
                        case 9: {
                            typeDescription = "Timestamp";
                            break;
                        }
                        case 10: {
                            typeDescription = "Double";
                            break;
                        }
                        case 11: {
                            typeDescription = "Byte Array";
                            break;
                        }
                        case 48: {
                            typeDescription = "DDO";
                            break;
                        }
                        case 49: {
                            typeDescription = "XDO";
                            break;
                        }
                        case 50: {
                            typeDescription = "Data Object Base";
                            break;
                        }
                        case 1024: {
                            typeDescription = "Collection";
                            break;
                        }
                        case 1072: {
                            typeDescription = "DDO Collection";
                            break;
                        }
                        case 1073: {
                            typeDescription = "XDO Colleciton";
                            break;
                        }
                        case 1071: {
                            typeDescription = "DKLinkCollection";
                            break;
                        }
                        case 2048: {
                            typeDescription = "Array";
                            break;
                        }
                        default: {
                            typeDescription = "Unknown (" + type + ")";
                        }
                    }
                    if (value != null) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Data Item '" + name + "' of type '" + typeDescription + "' with value: " + value);
                        continue;
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Data Item '" + name + "' of type '" + typeDescription + "' with value: null");
                }
            }
            catch (DKUsageError e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "--------------------------------------------------------");
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private Teamspace createTeamspaceObject(DKDDO ddo, String retrievalOptions, String type) throws SecurityException, TeamspaceException {
        Teamspace teamspace;
        String methodName;
        block37: {
            methodName = "createTeamspaceObject";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            teamspace = null;
            try {
                AccessControlList acl = null;
                this.dumpDdo(ddo);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrievalOptions = " + retrievalOptions);
                String id = ddo.getPidObject().pidString();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "id = " + id);
                String teamspaceName = "";
                teamspaceName = (String)ddo.getDataByName(TEAMSPACE_PROP_NAME);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "teamspaceName = " + teamspaceName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type = " + type);
                String lastModifiedUser = "";
                short propID = ddo.propertyId("SYSROOTATTRS.CREATEUSERID");
                if (propID != 0) {
                    Object obj = ddo.getProperty(propID);
                    lastModifiedUser = (String)obj;
                }
                propID = ddo.propertyId("SYSROOTATTRS.LASTCHANGEDTS");
                Timestamp lastModifiedTimeStamoObject = null;
                String lastModified = null;
                if (propID != 0) {
                    lastModifiedTimeStamoObject = (Timestamp)ddo.getProperty(propID);
                    lastModified = DateUtil.getISODateString(lastModifiedTimeStamoObject, true);
                }
                String description = "";
                Integer tmpState = (Integer)ddo.getDataByName(TEAMSPACE_PROP_STATE);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "tmpState = " + tmpState);
                String state = BaseTeamspaceService.State.PUBLISHED.getStringValue();
                if (tmpState != null) {
                    state = BaseTeamspaceService.State.getEnum(tmpState).getStringValue();
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "state = " + state);
                String defaultClass = "";
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "get teamspace default class ");
                defaultClass = (String)ddo.getDataByName(TEAMSPACE_PROP_DEFAULT_CLASS);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "defaultClass = " + defaultClass);
                description = (String)ddo.getDataByName(TEAMSPACE_PROP_DESCRIPTION);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "description = " + description);
                String json = null;
                boolean hasAdminPriv = false;
                String teamspaceChild = TEAMSPACE_CLASS_CHILD;
                if (type.equals("template")) {
                    teamspaceChild = TEAMSPACE_TEMPLATE_CLASS_CHILD;
                }
                if (retrievalOptions.equals("allData") || retrievalOptions.equals("classes") || retrievalOptions.equals("searches") || retrievalOptions.equals("columns")) {
                    short dataid = ddo.dataId("CHILD", teamspaceChild);
                    DKChildCollection children = (DKChildCollection)ddo.getData(dataid);
                    dkIterator iterator = children.createIterator();
                    DKDDO child = null;
                    if (iterator.more()) {
                        child = (DKDDO)iterator.next();
                    }
                    if (child != null) {
                        this.dumpDdo(child);
                        json = (String)child.getDataByName(TEAMSPACE_PROP_JSON);
                        if (json != null) {
                            json = TeamspaceUtil.localizeRoleNames((ServletRequest)this.request, json);
                            this.teamspaceDB = new TeamspaceDB((ServletRequest)this.request, json);
                        }
                    } else {
                        this.teamspaceDB = null;
                    }
                }
                if (teamspaceName != null) {
                    List<Subject> team = null;
                    if (type.equals("instance") && (retrievalOptions == null || retrievalOptions != null && retrievalOptions.equals("allData"))) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrieved ACL");
                        acl = this.securityService.retrieveACL(ddo);
                        try {
                            dkDatastoreExt dsExt = (dkDatastoreExt)this.connection.getDatastore().getExtension("DATASTORE_EXTENSION");
                            DKCommonPrivilege privilege = this.getCommonPrivilege(ddo, dsExt);
                            hasAdminPriv = privilege.hasAdminPrivilege();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "hasAdminPriv: " + hasAdminPriv);
                        }
                        catch (DKException e1) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e1);
                        }
                        catch (Exception e1) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e1);
                        }
                    }
                    if (retrievalOptions.equals("template") || retrievalOptions.equals("allData")) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "create teamspace object and set json data");
                        teamspace = new Teamspace(this.request, teamspaceName, description, type, ddo.getPidObject().getObjectType(), json, null);
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "create teamspace object without setting json data");
                        teamspace = new Teamspace(this.request, teamspaceName, description, type, ddo.getPidObject().getObjectType(), null, null);
                    }
                    String currentUserName = this.connection.getUserid();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "currentUserName: " + currentUserName);
                    if (hasAdminPriv && teamspace.getCurrentUser() == null) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "currentUser is an admin ");
                        ArrayList<Role> roles = new ArrayList<Role>();
                        List<String> privileges = Arrays.asList(CMDataModel.TEAMSPACE_OWNER_PRIVSET);
                        List<String> mappedPrivileges = CM8SecurityUtils.getMappedPrivileges(privileges, hasAdminPriv, true);
                        Role fullRole = new Role(SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue(), SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue(), SecurityConstants.AppPrivilegeSets.OWNER.getValue(), mappedPrivileges, SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue());
                        roles.add(fullRole);
                        CM8User user = new CM8User(currentUserName.toUpperCase(), currentUserName, null, null, roles);
                        teamspace.setCurrentUser(user);
                    }
                    teamspace.setState(state);
                    teamspace.setId(id);
                    if (lastModified != null) {
                        teamspace.setLastModified(lastModified.toString());
                    }
                    if (lastModifiedUser != null) {
                        teamspace.setLastModifiedUser(lastModifiedUser);
                    }
                    if (defaultClass != null) {
                        teamspace.setDefaultClass(defaultClass);
                    }
                    if (this.teamspaceDB != null && retrievalOptions != null) {
                        List<Subject> teamList;
                        if (retrievalOptions.equals("allData")) {
                            this.retrieveTeamspaceSearches(teamspace);
                            this.retrieveTeamspaceClasses(teamspace);
                            this.retrieveTeamspaceColumns(teamspace);
                            teamList = this.getTeam(teamspace);
                            teamspace.setTeam(teamList);
                            teamspace.setDdo(ddo);
                        } else if (retrievalOptions.equals("searches")) {
                            this.retrieveTeamspaceSearches(teamspace);
                        } else if (retrievalOptions.equals("classes")) {
                            this.retrieveTeamspaceClasses(teamspace);
                        } else if (retrievalOptions.equals("columns")) {
                            this.retrieveTeamspaceColumns(teamspace);
                        } else if (retrievalOptions.equals("team")) {
                            teamList = this.getTeam(teamspace);
                            teamspace.setTeam(teamList);
                        } else {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "unknown retrieval option");
                        }
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "no teamspace db");
                    }
                    team = teamspace.getTeam();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, new StringBuffer().append("new Teamspace(").append(teamspaceName).append(", ").append(description).append(", ").append(ddo.getPidObject().getObjectType()).append(", ").append(json).append(", ").append(team).append(")").toString());
                    if (team != null && acl != null) {
                        if (hasAdminPriv && teamspace.getCurrentUser() != null) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Admin user already set");
                        } else {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Non admin user");
                            CM8User user = this.getCurrentUser(acl, currentUserName.toUpperCase());
                            teamspace.setCurrentUser(user);
                        }
                    }
                    break block37;
                }
                teamspace = null;
            }
            catch (DKUsageError e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return teamspace;
    }

    private List<String> convertJsonArrayToList(JSONArray privsArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int j = 0; j < privsArray.size(); ++j) {
            String priv = (String)privsArray.get(j);
            list.add(priv);
        }
        return list;
    }

    private List<Subject> getTeam(Teamspace teamspace) throws SecurityException {
        Role role;
        int i;
        String methodName = "retrieveTeam";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        HashMap<String, Subject> map = new HashMap<String, Subject>();
        JSONArray membersJson = this.teamspaceDB.getMembers();
        JSONArray rolesArray = this.teamspaceDB.getRoles();
        HashMap<String, Role> rolesMap = new HashMap<String, Role>();
        for (i = 0; i < rolesArray.size(); ++i) {
            boolean isOwner = false;
            JSONObject roleObj = (JSONObject)rolesArray.get(i);
            String roleId = (String)roleObj.get("id");
            String messageId = (String)roleObj.get("messageId");
            String roleName = (String)roleObj.get("name");
            String roleDesc = (String)roleObj.get("description");
            JSONArray privsArray = (JSONArray)roleObj.get("privileges");
            List<String> origPrivList = this.convertJsonArrayToList(privsArray);
            role = new Role(roleId, roleName, roleDesc, origPrivList);
            role.setRoleType(SecurityConstants.RoleType.TEAMSPACE);
            role.setMessageId(messageId);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "add role to roleMap: " + role.toJSON());
            rolesMap.put(roleId, role);
        }
        for (i = 0; i < membersJson.size(); ++i) {
            JSONObject member = (JSONObject)membersJson.get(i);
            String principalId = (String)member.get("id");
            String principalName = (String)member.get("name");
            SecurityConstants.PrincipalType principalType = SecurityConstants.PrincipalType.valueOf(((String)member.get("type")).toUpperCase());
            ArrayList<Role> usrRoles = new ArrayList<Role>();
            if (principalType == SecurityConstants.PrincipalType.USER) {
                String principalSrcId = principalId;
                if (principalId.equals("CURRENT_USER")) {
                    principalSrcId = principalName;
                }
                CM8User user = new CM8User(principalId.toUpperCase(), principalName, null, null, usrRoles);
                CM8TeamspaceService.addMember(map, user);
            } else if (principalType == SecurityConstants.PrincipalType.GROUP) {
                UserGroup userGroup = new UserGroup(principalId.toUpperCase(), principalName, null, null, null, usrRoles);
                CM8TeamspaceService.addMember(map, userGroup);
            }
            JSONArray memberRolesArray = (JSONArray)member.get("roles");
            for (int j = 0; j < memberRolesArray.size(); ++j) {
                String roleId = (String)memberRolesArray.get(j);
                role = (Role)rolesMap.get(roleId);
                usrRoles.add(role);
                HashMap<String, SecurityConstants.PrincipalType> assignees = role.getAssignees();
                if (assignees == null) {
                    assignees = new HashMap();
                    role.setAssigness(assignees);
                }
                if (assignees.containsKey(principalId) || assignees.containsKey(principalName)) continue;
                if (principalId.equals("CURRENT_USER") || principalType == SecurityConstants.PrincipalType.GROUP) {
                    assignees.put(principalName, principalType);
                    continue;
                }
                assignees.put(principalId, principalType);
            }
        }
        ArrayList<Subject> members = new ArrayList<Subject>(map.values());
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return members;
    }

    private void dumpList(List<String> list, String listType) {
        String methodName = "dumpList";
        for (String item : list) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, listType + "  has item : " + item);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, listType + " ---------------------------------------- ");
    }

    private void retrieveTeamspaceSearches(Teamspace teamspace) {
        String methodName = "retrieveTeamspaceSearches";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray searchJsonArray = this.teamspaceDB.getSearches();
        ArrayList<String> searches = new ArrayList<String>();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_searches = " + searchJsonArray);
        if (searchJsonArray != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "number of searches = " + searchJsonArray.size());
            ListIterator iterator = searchJsonArray.listIterator();
            while (iterator.hasNext()) {
                JSONObject object = (JSONObject)iterator.next();
                String searchId = (String)object.get("id");
                try {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "search Id = " + searchId);
                    DKPidICM pid = new DKPidICM(searchId);
                    searchId = pid.pidString();
                }
                catch (DKException e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Id = " + searchId);
                searches.add(searchId);
            }
        }
        teamspace.setSearches(searches);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void retrieveTeamspaceClasses(Teamspace teamspace) {
        String methodName = "retrieveTeamspaceClasses";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONArray jsonArray = this.teamspaceDB.getClasses();
        ArrayList<String> classes = new ArrayList<String>();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "_classes = " + jsonArray);
        if (jsonArray != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "number of classes = " + jsonArray.size());
            ListIterator iterator = jsonArray.listIterator();
            while (iterator.hasNext()) {
                JSONObject object = (JSONObject)iterator.next();
                String classesId = (String)object.get("id");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "classes Id = " + classesId);
                classes.add(classesId);
            }
        }
        teamspace.setClasses(classes);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void retrieveTeamspaceColumns(Teamspace teamspace) {
        String methodName = "retrieveTeamspaceColumns";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        SearchTemplate.ResultsDisplay colProps = this.teamspaceDB.getColumnProperties();
        teamspace.setColumnProperties(colProps);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private DKCommonPrivilege getCommonPrivilege(DKDDO privDDO, dkDatastoreExt dsExt) throws Exception {
        String methodName = "getCommonPrivilege";
        DKCommonPrivilege commonPrivilege = null;
        if (privDDO != null) {
            try {
                commonPrivilege = dsExt.getCommonItemPrivilege((dkDataObject)privDDO);
            }
            catch (RuntimeException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return commonPrivilege;
    }

    public CM8User getCurrentUser(AccessControlList acl, String currentUserName) throws SecurityException {
        String methodName = "getCurrentUser";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        CM8User user = null;
        if (acl != null) {
            List<AccessControlListData> datas = acl.getAclData();
            List<String> groupNames = null;
            try {
                CM8User usrObj = (CM8User)this.securityService.retrieveUser(this.connection.getDatastore().getUserName());
                groupNames = usrObj.getGroups();
            }
            catch (Exception e) {
                // empty catch block
            }
            ArrayList<Role> roles = new ArrayList<Role>();
            if (datas != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "aclData size: " + datas.size());
            }
            for (AccessControlListData aclData : datas) {
                boolean isOwner = false;
                String name = aclData.getName();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "aclData.getName(): " + name);
                if (!name.equalsIgnoreCase(currentUserName) && aclData.getType() == SecurityConstants.PrincipalType.USER) continue;
                SecurityConstants.PrincipalType type = aclData.getType();
                Role role = ((CM8AccessControlListData)aclData).getPrivSet();
                List<String> privileges = role.getPrivileges();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "role name: " + role.getName());
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "-----------------");
                List<String> privsForOwners = Arrays.asList(CMDataModel.TEAMSPACE_OWNER_PRIVSET);
                this.dumpList(privsForOwners, "privs for owner");
                this.dumpList(privileges, "privileges on " + name);
                if (privileges.containsAll(privsForOwners)) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "is owner");
                    isOwner = true;
                } else if (Logger.getLogLevel() > 2 && privsForOwners != null && privileges != null) {
                    for (String priv : privsForOwners) {
                        if (privileges.contains(priv)) continue;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "missing priv: " + priv + " in order to be owner");
                    }
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "-----------------");
                List<String> mappedPrivileges = CM8SecurityUtils.getMappedPrivileges(privileges, false, isOwner);
                this.dumpList(mappedPrivileges, "mapped privs");
                role.setPrivileges(mappedPrivileges);
                role.setName(role.getDescription());
                if (!name.equalsIgnoreCase(currentUserName) && (groupNames == null || !groupNames.contains(name))) continue;
                roles.add(role);
            }
            user = new CM8User(currentUserName.toUpperCase(), currentUserName, null, null, roles);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return user;
    }
}

