/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace.cm8;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKFolder;
import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKMimeTypeDefICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKResults;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKTimestamp;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class CM8FolderUtils {
    public static final String ITEM_NAME = "ICM$NAME";

    public static dkCollection getChildren(DKDatastoreICM dsICM, DKDDO folder, DKRetrieveOptionsICM retrieveOptions) throws Exception {
        short id = folder.dataId("ATTR", "DKFolder");
        if (id == 0) {
            throw new Exception("No DKFolder Attribute Found!  DDO is either not a Folder or Folder Contents have not been explicitly retrieved.");
        }
        DKFolder dkFolder = (DKFolder)folder.getData(id);
        dsICM.retrieveObjects((dkCollection)dkFolder, retrieveOptions.dkNVPair());
        return dkFolder;
    }

    public static DKDDO getChild(ServletRequest request, DKDatastoreICM dsICM, DKDDO parentFolder, String childTypeName, String childName) throws DKUsageError, Exception {
        String methodName = "getChild";
        Logger.logEntry(CM8FolderUtils.class, methodName, request);
        String queryString = "/" + childTypeName + "[@ICM$NAME=\"" + childName + "\"]";
        DKNVPair[] options = new DKNVPair[]{new DKNVPair("MAX_RESULTS", (Object)"1"), new DKNVPair("RETRIEVE_OPTION", (Object)CM8FolderUtils.getBasePlusChildrenRetrieveOptions(dsICM)), new DKNVPair("End", null)};
        DKResults results = (DKResults)dsICM.evaluate(queryString, (short)7, options);
        DKDDO ddo = null;
        Logger.logDebug(CM8FolderUtils.class, methodName, request, "child folders found: " + results.cardinality());
        if (results.cardinality() > 0) {
            ddo = (DKDDO)results.createIterator().next();
        } else {
            Logger.logDebug(CM8FolderUtils.class, methodName, request, "no child folders found");
        }
        Logger.logExit(CM8FolderUtils.class, methodName, request);
        return ddo;
    }

    public static DKDDO getParent(HttpServletRequest request, DKDatastoreICM dsICM, DKDDO item) throws DKUsageError, Exception {
        String methodName = "getParent";
        dsICM.retrieveObject((dkDataObject)item, CM8FolderUtils.getBasePlusParentRetrieveOptions(dsICM).dkNVPair());
        DKDDO parent = null;
        dkCollection parentFolderColl = null;
        short propId = item.propertyId("folder sources");
        if (propId > 0) {
            parentFolderColl = (dkCollection)item.getProperty(propId);
        }
        if (parentFolderColl != null) {
            Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "  --> Found '" + parentFolderColl.cardinality() + "' parents.");
            if (parentFolderColl.cardinality() > 1) {
                Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "      Multiple parent found, this indicates there are hierarchical and non-hierarcical parents.");
            }
            dkIterator iter = parentFolderColl.createIterator();
            while (iter.more()) {
                parent = (DKDDO)iter.next();
            }
        } else {
            Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "  --> Parent not found.  Perhaps you do not have access to the parent.");
        }
        return parent;
    }

    private static DKDDO createDocument(HttpServletRequest request, DKDatastoreICM dsICM, DKDDO parent, String fileName, String itemTypeName) throws DKException, Exception {
        String methodName = "createDocument";
        Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "--> Create single part document with for file: " + fileName + "...");
        DKLobICM lob = (DKLobICM)dsICM.createDDO(itemTypeName, 1);
        File file = new File(fileName);
        String name = file.getName();
        if (!file.exists()) {
            Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "  --> Can't find file with name: " + fileName + ".  Will create document item with no content...");
            CM8FolderUtils.setHierarchicalAttrs((DKDDO)lob, parent, name);
            lob.add();
        } else {
            String path = file.getCanonicalPath();
            long modified = file.lastModified();
            DKTimestamp ts = new DKTimestamp(modified);
            String mimeType = CM8FolderUtils.findMimeType(request, dsICM, name);
            lob.setMimeType(mimeType);
            FileInputStream iStream = new FileInputStream(file);
            CM8FolderUtils.setHierarchicalAttrs((DKDDO)lob, parent, name);
            lob.add((InputStream)iStream, file.length());
        }
        Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "--> Created single part document with name: " + name + ".");
        return lob;
    }

    private static String findMimeType(HttpServletRequest request, DKDatastoreICM dsICM, String name) throws DKException, Exception {
        String methodName = "findMimeType";
        Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "  --> Look up mime type for file name: " + name + ".");
        String mimeType = null;
        int extStart = name.lastIndexOf(46);
        if (extStart != -1) {
            String ext = name.substring(extStart + 1);
            Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "  --> Look up based on extension: [" + ext + "].");
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
            dkCollection mimeTypesColl = dsDefICM.listMimeTypes();
            dkIterator mimeTypesIter = mimeTypesColl.createIterator();
            while (mimeTypesIter.more()) {
                DKMimeTypeDefICM mimeTypeDef = (DKMimeTypeDefICM)mimeTypesIter.next();
                String suffixes = mimeTypeDef.getSuffixes();
                if (suffixes == null) continue;
                StringTokenizer st = new StringTokenizer(suffixes, " ", false);
                while (st.hasMoreTokens()) {
                    String suffix = st.nextToken();
                    if (!suffix.equals(ext)) continue;
                    mimeType = mimeTypeDef.getMimeType();
                }
            }
        }
        if (mimeType == null) {
            Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "  --> Mime type not found, using default...");
            mimeType = "application/octet-stream";
        }
        Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, "  --> Returning mime type: " + mimeType + ".");
        return mimeType;
    }

    public static DKDDO createFolder(DKDatastoreICM dsICM, String entityName, DKDDO parent, String name) throws DKException, Exception {
        DKDDO ddo = dsICM.createDDO(entityName, 2);
        CM8FolderUtils.setHierarchicalAttrs(ddo, parent, name);
        ddo.add();
        return ddo;
    }

    public static void setHierarchicalAttrs(DKDDO ddo, DKDDO parent, String name) throws DKUsageError {
        short dataId = ddo.dataId(ITEM_NAME);
        if (dataId > 0) {
            ddo.setData(dataId, (Object)name);
        }
        ddo.addProperty("PARENT_FOLDER", (Object)parent);
    }

    public static void deleteTree(DKDatastoreICM dsICM, DKDDO folder) throws DKException, Exception {
        dsICM.retrieveObject((dkDataObject)folder, CM8FolderUtils.getBasePlusChildrenRetrieveOptions(dsICM).dkNVPair());
        dkCollection children = CM8FolderUtils.getChildren(dsICM, folder, CM8FolderUtils.getBasePlusChildrenRetrieveOptions(dsICM));
        dkIterator it = children.createIterator();
        while (it.more()) {
            DKDDO child = (DKDDO)it.next();
            short id = child.dataId("ATTR", "DKFolder");
            if (id != 0) {
                CM8FolderUtils.deleteTree(dsICM, child);
                continue;
            }
            child.del();
        }
        folder.del();
    }

    private static void printTree(HttpServletRequest request, DKDatastoreICM dsICM, DKDDO folder, String indent) throws DKUsageError, Exception {
        String methodName = "printTree";
        Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, indent + "--> " + dsICM.getName(folder) + " [Folder]");
        String newIndent = indent + "  ";
        dkCollection children = CM8FolderUtils.getChildren(dsICM, folder, CM8FolderUtils.getBasePlusChildrenRetrieveOptions(dsICM));
        dkIterator it = children.createIterator();
        while (it.more()) {
            DKDDO child = (DKDDO)it.next();
            short id = child.dataId("ATTR", "DKFolder");
            if (id != 0) {
                CM8FolderUtils.printTree(request, dsICM, child, newIndent);
                continue;
            }
            Logger.logDebug(CM8FolderUtils.class, methodName, (ServletRequest)request, newIndent + "--> " + dsICM.getName(child) + " [Doc]");
        }
    }

    static DKAttrDefICM getAttr(DKDatastoreDefICM dsDef, String name, short type, int size) throws DKException, Exception {
        DKAttrDefICM attr = null;
        attr = (DKAttrDefICM)dsDef.retrieveAttr(name);
        return attr;
    }

    public static DKRetrieveOptionsICM getBasePlusChildrenRetrieveOptions(DKDatastoreICM dsICM) throws DKUsageError, Exception {
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.linksOutbound(true);
        dkRetrieveOptions.linksTypeFilter("DKFolder");
        dkRetrieveOptions.behaviorIgnoreNoneFoundError(true);
        return dkRetrieveOptions;
    }

    public static DKRetrieveOptionsICM getBasePlusParentRetrieveOptions(DKDatastoreICM dsICM) throws DKUsageError, Exception {
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.linksInbound(true);
        dkRetrieveOptions.linksInboundFolderSources(true);
        dkRetrieveOptions.linksTypeFilter("DKFolder");
        dkRetrieveOptions.behaviorIgnoreNoneFoundError(true);
        return dkRetrieveOptions;
    }
}

