/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace.cm8;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.MimeType;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKChildCollection;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKDate;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKFolder;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKMimeTypeDefICM;
import com.ibm.mm.sdk.common.DKMimeTypeMgmtICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKParts;
import com.ibm.mm.sdk.common.DKPid;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKTime;
import com.ibm.mm.sdk.common.DKTimestamp;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkAttrDef;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.upload.FormFile;

public class CM8AddItemUtil {
    private WCDateFormat wcDateFormats;
    private DKDatastoreICM dsICM;
    protected BaseUtil utils = new BaseUtil();
    protected HttpServletRequest request;

    public CM8AddItemUtil(HttpServletRequest request, DKDatastoreICM dsICM, WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
        this.request = request;
        this.dsICM = dsICM;
    }

    public void createFolder(String itemType, JSONArray criteriasJsonArray, JSONArray childCompValuesJsonArray) {
        String methodName = "createFolder";
        try {
            DKDDO icmddo = this.dsICM.createDDO(itemType, 2);
            this.setItemTypeAttributes(itemType, criteriasJsonArray, childCompValuesJsonArray, icmddo);
            this.dsICM.addObject((dkDataObject)icmddo, 0);
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
    }

    public DKDDO createTeamspace(String entityName, String childName, Hashtable valuesMap, DKDDO parent, String json, String jsonPropName) {
        String methodName = "createTeamspace";
        try {
            DKDDO icmddo = this.dsICM.createDDO(entityName, 2);
            DKComponentTypeDefICM entityDef = (DKComponentTypeDefICM)this.dsICM.datastoreDef().retrieveEntity(entityName);
            Enumeration attributeNames = valuesMap.keys();
            while (attributeNames.hasMoreElements()) {
                String criteriaName = (String)attributeNames.nextElement();
                String criteriaValue = (String)valuesMap.get(criteriaName);
                short attrType = 0;
                Object dataObj = null;
                dkAttrDef attrDef = entityDef.getAttr(criteriaName);
                if (attrDef == null) continue;
                attrType = attrDef.getType();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute type = " + attrType);
                dataObj = this.setCriteriaValue(criteriaValue, attrType);
                short dataId = icmddo.dataId(criteriaName);
                if (dataObj == null) continue;
                icmddo.setData(dataId, dataObj);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "set child data" + json);
            DKChildCollection children = new DKChildCollection();
            DKDDO childItem = this.dsICM.createChildDDO(entityName, childName);
            Object childDataObj = this.setCriteriaValue(json, (short)19);
            childItem.setData(childItem.dataId("ATTR", jsonPropName), childDataObj);
            children.addElement((Object)childItem);
            icmddo.setData(icmddo.dataId("CHILD", childName), (Object)children);
            icmddo.addProperty("PARENT_FOLDER", (Object)parent);
            return icmddo;
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        return null;
    }

    public void setItemTypeAttributes(String entityName, JSONArray criteriasJsonArray, JSONArray childCompValuesJsonArray, DKDDO icmddo) throws Exception {
        String methodName = "setItemTypeAttributes";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKComponentTypeDefICM entityDef = (DKComponentTypeDefICM)this.dsICM.datastoreDef().retrieveEntity(entityName);
        JSONObject criteria = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "adding the attribute values for the newly created item");
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            String criteriaValue;
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            String criteriaName = criteria.get("name").toString();
            if (criteria.get("value") != null) {
                criteriaValue = (String)criteria.get("value");
            } else {
                JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
                criteriaValue = (String)valuesJsonArray.get(0);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "update Item: attrName=" + criteriaName + " attrValue=" + criteriaValue);
            short attrType = 0;
            Object dataObj = null;
            dkAttrDef attrDef = entityDef.getAttr(criteriaName);
            if (attrDef != null) {
                attrType = attrDef.getType();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute type = " + attrType);
                dataObj = this.setCriteriaValue(criteriaValue, attrType);
                short dataId = icmddo.dataId(criteriaName);
                if (dataObj == null) continue;
                icmddo.setData(dataId, dataObj);
                continue;
            }
            int index = criteriaName.indexOf(46);
            if (index == -1) continue;
            String attrGroupName = criteriaName.substring(0, index);
            Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "     - " + attrGroupName);
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this.dsICM.datastoreDef();
            DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)dsDefICM.retrieveAttrGroup(attrGroupName);
            DKSequentialCollection attrs = (DKSequentialCollection)attrGroupDef.listAttrs();
            dkIterator iter = attrs.createIterator();
            while (iter.more()) {
                DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "     - " + attr.getName() + ":  " + attr.getDescription());
                if (!attr.getName().equals(criteriaName)) continue;
                attrType = attr.getType();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute type = " + attrType);
                dataObj = this.setCriteriaValue(criteriaValue, attrType);
                short dataId = icmddo.dataId(attr.getName());
                if (dataObj == null) continue;
                icmddo.setData(dataId, dataObj);
            }
        }
        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this.dsICM.datastoreDef();
        DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(entityName);
        dkCollection subEntities = itemType.listSubEntities(111);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "There are  - " + childCompValuesJsonArray.size() + " child components");
        for (int iChildCompCounter = 0; iChildCompCounter < childCompValuesJsonArray.size(); ++iChildCompCounter) {
            JSONObject childComponent = (JSONObject)childCompValuesJsonArray.get(iChildCompCounter);
            String childCompName = childComponent.get("name").toString();
            JSONArray childCompCriteriasJsonArray = (JSONArray)childComponent.get("values");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "There are  - " + childCompCriteriasJsonArray.size() + " instances for - " + childCompName);
            DKComponentTypeDefICM selectedSubEntity = this.getSubEntity(subEntities, childCompName);
            DKDDO childItem = null;
            JSONObject childJSON = null;
            boolean allValuesAreNull = true;
            DKChildCollection children = new DKChildCollection();
            for (int iRowCounter = 0; iRowCounter < childCompCriteriasJsonArray.size(); ++iRowCounter) {
                childJSON = (JSONObject)childCompCriteriasJsonArray.get(iRowCounter);
                childItem = this.dsICM.createChildDDO(entityName, childCompName);
                JSONArray valuesJsonArray = (JSONArray)childJSON.get("values");
                for (int a = 0; a < valuesJsonArray.size(); ++a) {
                    criteria = (JSONObject)valuesJsonArray.get(a);
                    String criteriaName = criteria.get("name").toString();
                    criteriaName = criteriaName.substring(childCompName.length() + 1);
                    JSONArray critValJsonArray = (JSONArray)criteria.get("values");
                    String criteriaValue = (String)critValJsonArray.get(0);
                    criteriaValue = criteriaValue.trim();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ADD Item: attrName=" + criteriaName + " attrValue=" + criteriaValue + " attrValueLength=" + criteriaValue.length());
                    if (criteriaValue == null || criteriaValue.length() <= 0) continue;
                    allValuesAreNull = false;
                    dkAttrDef attrDef = selectedSubEntity.getAttr(criteriaName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attrDef =" + attrDef);
                    short attrType = 0;
                    Object dataObj = null;
                    if (attrDef != null) {
                        attrType = attrDef.getType();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "child attribute type = " + attrType);
                        dataObj = this.setCriteriaValue(criteriaValue.trim(), attrType);
                        if (dataObj == null) continue;
                        childItem.setData(childItem.dataId("ATTR", criteriaName), dataObj);
                        continue;
                    }
                    int index = criteriaName.indexOf(46);
                    if (index == -1) continue;
                    String attrGroupName = criteriaName.substring(0, index);
                    Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "     - " + attrGroupName);
                    DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)dsDefICM.retrieveAttrGroup(attrGroupName);
                    DKSequentialCollection attrs = (DKSequentialCollection)attrGroupDef.listAttrs();
                    dkIterator iter = attrs.createIterator();
                    while (iter.more()) {
                        DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                        Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "     - " + attr.getName() + ":  " + attr.getDescription());
                        if (!attr.getName().equals(criteriaName)) continue;
                        attrType = attr.getType();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute type = " + attrType);
                        dataObj = this.setCriteriaValue(criteriaValue, attrType);
                        if (dataObj == null) continue;
                        childItem.setData(childItem.dataId("ATTR", criteriaName), dataObj);
                    }
                }
                if (allValuesAreNull) continue;
                children.addElement((Object)childItem);
            }
            icmddo.setData(icmddo.dataId("CHILD", childCompName), (Object)children);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private DKComponentTypeDefICM getSubEntity(dkCollection subEntities, String childCompName) throws DKUsageError {
        DKComponentTypeDefICM selectedSubEntity = null;
        dkIterator entityIterator = subEntities.createIterator();
        while (entityIterator.more() && !(selectedSubEntity = (DKComponentTypeDefICM)entityIterator.next()).getName().equalsIgnoreCase(childCompName)) {
        }
        return selectedSubEntity;
    }

    private Object setCriteriaValue(String criteriaValue, short attrType) throws Exception {
        SimpleDateFormat dfClient = null;
        SimpleDateFormat dfRepo = null;
        switch (attrType) {
            case 7: {
                dfClient = (SimpleDateFormat)this.getDateFormats().getDateFormat();
                dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(this.request).getDateFormat();
                break;
            }
            case 8: {
                dfClient = (SimpleDateFormat)this.getDateFormats().getTimeFormat();
                dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(this.request).getTimeFormat();
                break;
            }
            case 9: {
                dfClient = (SimpleDateFormat)this.getDateFormats().getTimestampFormat();
                dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(this.request).getTimestampFormat();
                break;
            }
            case 18: 
            case 19: 
            case 25: {
                break;
            }
            default: {
                dfClient = null;
            }
        }
        if (dfClient != null && criteriaValue != null && criteriaValue.trim().length() > 0) {
            Date tempDate = new Date(new Long(criteriaValue));
            criteriaValue = dfRepo.format(tempDate);
        }
        Object dataObj = this.getAttributeValue(attrType, criteriaValue);
        return dataObj;
    }

    private boolean validateItemTypeAttributes(DKDatastoreDefICM dsDefICM, String entityName, JSONArray criteriasJsonArray) throws Exception {
        String methodName = "validateItemTypeAttributes";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        JSONObject criteria = null;
        boolean returnValue = true;
        DKComponentTypeDefICM entityDef = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(entityName);
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
            for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
                criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
                String criteriaName = criteria.get("name").toString();
                short attrType = 0;
                dkAttrDef attrDef = entityDef.getAttr(criteriaName);
                if (attrDef != null) {
                    attrType = attrDef.getType();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute type = " + attrType);
                    short attrTypeInt = attrType;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute type Int= " + attrTypeInt);
                    if (attrType != 19 && attrType != 18 && attrType != 25) continue;
                    returnValue = false;
                    continue;
                }
                int index = criteriaName.indexOf(46);
                if (index == -1) continue;
                String attrGroupName = criteriaName.substring(0, index);
                String attrName = criteriaName.substring(index + 1);
                DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)dsDefICM.retrieveAttrGroup(attrGroupName);
                DKSequentialCollection attrs = (DKSequentialCollection)attrGroupDef.listAttrs();
                dkIterator iter = attrs.createIterator();
                while (iter.more()) {
                    DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                    if (!attrName.equals(attr.getName())) continue;
                    Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "     - " + attr.getName() + ":  " + attr.getDescription());
                    attrType = attr.getType();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "attribute type = " + attrType);
                    switch (attrType) {
                        case 18: 
                        case 19: 
                        case 25: {
                            returnValue = false;
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            returnValue = false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return returnValue;
    }

    private Object getAttributeValue(short attrType, String criteriaValue) {
        String methodName = "getAttributeValue";
        Object dataObj = null;
        if (criteriaValue != null && criteriaValue.length() > 0) {
            switch (attrType) {
                case 0: {
                    dataObj = criteriaValue;
                    break;
                }
                case 1: {
                    dataObj = criteriaValue;
                    break;
                }
                case 3: {
                    dataObj = Short.valueOf(criteriaValue);
                    break;
                }
                case 4: {
                    dataObj = Integer.valueOf(criteriaValue);
                    break;
                }
                case 13: {
                    dataObj = Integer.valueOf(criteriaValue);
                    break;
                }
                case 5: {
                    dataObj = Float.valueOf(criteriaValue);
                    break;
                }
                case 6: {
                    dataObj = new BigDecimal(criteriaValue);
                    break;
                }
                case 7: {
                    dataObj = DKDate.valueOf((String)criteriaValue);
                    break;
                }
                case 8: {
                    dataObj = DKTime.valueOf((String)criteriaValue);
                    break;
                }
                case 9: {
                    if (criteriaValue.indexOf(58) != -1) {
                        dataObj = new DKTimestamp(Timestamp.valueOf(criteriaValue));
                        break;
                    }
                    dataObj = DKTimestamp.valueOf((String)criteriaValue);
                    break;
                }
                case 10: {
                    dataObj = Double.valueOf(criteriaValue);
                    break;
                }
                case 11: 
                case 18: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type is byte array");
                    dataObj = criteriaValue.getBytes();
                    break;
                }
                case 1024: {
                    break;
                }
                default: {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Using default type");
                    dataObj = criteriaValue;
                }
            }
        }
        return dataObj;
    }

    private void setPartContent(HttpServletRequest request, DKDDO icmddo, String entityName, ActionForm form) throws Exception {
        int contentLen;
        InputStream is;
        String methodName = "setPartContent";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        DKParts partColl = null;
        short data_id = icmddo.dataId("ATTR", "DKParts");
        if (data_id == 0) {
            data_id = icmddo.addData("ATTR", "DKParts");
            icmddo.addDataProperty(data_id, "type", (Object)new Short(1073));
            partColl = new DKParts();
            icmddo.setData(data_id, (Object)partColl);
        } else {
            partColl = (DKParts)icmddo.getData(data_id);
            if (partColl == null) {
                partColl = new DKParts();
                icmddo.setData(data_id, (Object)partColl);
            }
        }
        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)this.dsICM.datastoreDef();
        DKComponentTypeDefICM componentTypeDef = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(entityName);
        DKItemTypeDefICM itemType = (DKItemTypeDefICM)dsDefICM.retrieveEntity(componentTypeDef.getItemTypeName());
        String partType = "ICMBASE";
        String requestedPartType = request.getParameter("parm_part_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "part type of the new item is =" + requestedPartType);
        String partMimeType = (String)request.getAttribute("mimetype");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "part mime type of the new item is = " + partMimeType);
        MimeType mimetype = this.getMimeTypeDef(request, partMimeType);
        if (mimetype != null) {
            switch (mimetype.getMimetypeFlag()) {
                case 1: {
                    if (componentTypeDef.isTextSearchable() && CMUtil.hasPartType(itemType, "ICMBASETEXT")) {
                        partType = "ICMBASETEXT";
                        break;
                    }
                    if (CMUtil.hasPartType(itemType, requestedPartType)) {
                        partType = requestedPartType;
                        break;
                    }
                    if (!CMUtil.hasPartType(itemType, "ICMBASE")) break;
                    partType = "ICMBASE";
                    break;
                }
                case 2: {
                    if (CMUtil.hasPartType(itemType, "ICMBASESTREAM")) {
                        partType = "ICMBASESTREAM";
                        break;
                    }
                    if (CMUtil.hasPartType(itemType, requestedPartType)) {
                        partType = requestedPartType;
                        break;
                    }
                    if (!CMUtil.hasPartType(itemType, "ICMBASE")) break;
                    partType = "ICMBASE";
                    break;
                }
                default: {
                    if (CMUtil.hasPartType(itemType, requestedPartType)) {
                        partType = requestedPartType;
                        break;
                    }
                    if (!CMUtil.hasPartType(itemType, "ICMBASE")) break;
                    partType = "ICMBASE";
                }
            }
        }
        String partFilePath = request.getParameter("parm_part_filename");
        String partFileName = Util.getFileNameFromPath(request, partFilePath);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "file name of the new item is =" + partFileName);
        DKLobICM xdo = (DKLobICM)this.dsICM.createDDO(partType.toUpperCase(), 13);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "min cardinality is =" + componentTypeDef.getCardinalityMin());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "max cardinality is = " + componentTypeDef.getCardinalityMax());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parts cardinality is = " + partColl.cardinality());
        xdo.setPartNumber(partColl.cardinality() + 1);
        partColl.addElement((Object)xdo);
        FormFile ff = this.getFormFile(form);
        if (ff != null) {
            is = ff.getInputStream();
            contentLen = ff.getFileSize();
        } else {
            is = request.getInputStream();
            contentLen = request.getContentLength();
        }
        this.setDataStream(xdo, is, contentLen);
        xdo.setMimeType(partMimeType);
        xdo.setOrgFileName(partFileName);
        DKPid ddopid = icmddo.getPidObject();
        String primaryId = ddopid.getPrimaryId();
        DKPid xdopid = xdo.getPidObject();
        xdopid.setPrimaryId(primaryId);
        xdo.setPidObject(xdopid);
        icmddo.setData(data_id, (Object)partColl);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parts cardinality is = " + partColl.cardinality());
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private FormFile getFormFile(ActionForm form) {
        FormFile formFile;
        block1: {
            formFile = ((FileUploadActionForm)form).getUploadFile();
            if (formFile != null) break block1;
            Hashtable fileElements = form.getMultipartRequestHandler().getFileElements();
            Iterator it = fileElements.values().iterator();
            while (it.hasNext() && (formFile = (FormFile)it.next()) == null) {
            }
        }
        return formFile;
    }

    public void setDataStream(DKLobICM _xdoObj, InputStream data, long length) throws Exception {
        if (_xdoObj != null) {
            DKNVPair[] dknv = new DKNVPair[]{new DKNVPair("STREAM", (Object)data), new DKNVPair("LENGTH", (Object)new Long(length))};
            _xdoObj.setAddLocation(dknv);
        }
    }

    private DKDDO setResourcePartContent(HttpServletRequest request, DKDDO xdo, DKDatastoreICM dsICM, String entityName, ActionForm form) throws Exception {
        String methodName = "setResourcePartContent";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String partType = request.getParameter("parm_part_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "part type of the new item is =" + partType);
        String partFilePath = request.getParameter("parm_part_filename");
        String partFileName = Util.getFileNameFromPath(request, partFilePath);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "file name of the new item is =" + partFileName);
        String partMimeType = (String)request.getAttribute("mimetype");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "part mime type of the new item is = " + partMimeType);
        if (xdo instanceof DKLobICM) {
            int contentLen;
            InputStream is;
            FormFile ff = this.getFormFile(form);
            if (ff != null) {
                is = ff.getInputStream();
                contentLen = ff.getFileSize();
            } else {
                is = request.getInputStream();
                contentLen = request.getContentLength();
            }
            this.setDataStream((DKLobICM)xdo, is, contentLen);
            ((DKLobICM)xdo).setMimeType(partMimeType);
            ((DKLobICM)xdo).setOrgFileName(partFileName);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return xdo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addItemToFolder(DKDDO folderDDO, DKDDO ddoObj, HttpServletRequest request) throws DKException, DKUsageError, Exception {
        String methodName;
        block10: {
            methodName = "addItemToFolder";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            short data_id = 0;
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.dsICM);
            dkRetrieveOptions.linksOutbound(true);
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.childAttributes(true);
            dkRetrieveOptions.childListOneLevel(true);
            dkRetrieveOptions.linksTypeFilter("DKFolder");
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            DKPidICM pid = (DKPidICM)folderDDO.getPidObject();
            if (pid.getVersionNumber().equals("0")) {
                pid.setVersionNumber("1");
                dkRetrieveOptions.functionVersionLatest(true);
            }
            folderDDO.retrieve(dkRetrieveOptions.dkNVPair());
            data_id = folderDDO.dataId("ATTR", "DKFolder");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "data id = " + data_id);
            if (data_id != 0) {
                boolean wasCheckedOut;
                DKFolder f = null;
                f = (DKFolder)folderDDO.getData(data_id);
                if (f == null) {
                    f = new DKFolder();
                    f.addElement((Object)ddoObj);
                    folderDDO.setData(data_id, (Object)f);
                } else {
                    f.addElement((Object)ddoObj);
                }
                String userid = null;
                try {
                    userid = (String)folderDDO.getPropertyByName("Checked_Out_UserID");
                }
                catch (DKUsageError e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                }
                boolean bl = wasCheckedOut = userid != null;
                if (!wasCheckedOut) {
                    this.dsICM.checkOut((dkDataObject)folderDDO);
                }
                try {
                    folderDDO.update();
                    Object var12_12 = null;
                    if (wasCheckedOut) break block10;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (!wasCheckedOut) {
                        this.dsICM.checkIn((dkDataObject)folderDDO);
                    }
                    throw throwable;
                }
                this.dsICM.checkIn((dkDataObject)folderDDO);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public MimeType[] getMimeTypeDefs() {
        String methodName = "getMimeTypeDefs";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        MimeType[] mimeTypes = null;
        try {
            DKMimeTypeMgmtICM mime_mgmt = new DKMimeTypeMgmtICM((dkDatastore)this.dsICM);
            dkCollection clo = mime_mgmt.listMimeTypes();
            mimeTypes = new MimeType[clo.cardinality()];
            DKMimeTypeDefICM mimetypedef = null;
            dkIterator iterator = clo.createIterator();
            int i = 0;
            while (iterator.more()) {
                mimetypedef = (DKMimeTypeDefICM)iterator.next();
                MimeType mimeType = new MimeType();
                mimeType.setName(mimetypedef.getName());
                mimeType.setDescription(mimetypedef.getDisplayName());
                mimeType.setType(mimetypedef.getMimeType());
                mimeType.setMimetypeFlag(mimetypedef.getMimeTypeFlag());
                String dkSuffixes = mimetypedef.getSuffixes();
                String[] suffixes = null;
                suffixes = dkSuffixes != null ? dkSuffixes.split(" ") : new String[]{};
                mimeType.setFileExtensions(suffixes);
                mimeTypes[i] = mimeType;
                ++i;
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return mimeTypes;
    }

    public MimeType getMimeTypeDef(HttpServletRequest request, String partMimeType) throws Exception {
        MimeType wcMimeType = null;
        MimeType[] mimeTypes = this.getMimeTypeDefs();
        for (int i = 0; i < mimeTypes.length; ++i) {
            MimeType mimeType = mimeTypes[i];
            if (!mimeType.getType().equalsIgnoreCase(partMimeType)) continue;
            wcMimeType = mimeType;
            break;
        }
        return wcMimeType;
    }

    public BaseUtil getUtils() {
        return this.utils;
    }

    public void setUtils(BaseUtil utils) {
        this.utils = utils;
    }

    private boolean isResource(DKDDO ddo) throws DKUsageError, Exception {
        boolean retval = false;
        retval = ddo instanceof DKLobICM;
        return retval;
    }

    private boolean isDocModel(DKDDO ddo) throws DKUsageError, Exception {
        boolean retval = false;
        short dataid = ddo.dataId("ATTR", "DKParts");
        retval = dataid != 0;
        return retval;
    }

    private static void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        byte[] buf = new byte[4096];
        int len = inStream.read(buf);
        while (len != -1) {
            outStream.write(buf, 0, len);
            len = inStream.read(buf);
        }
        outStream.close();
        inStream.close();
    }

    private void copyStream(InputStream inStream, long sourceLength, DKDDO targetDDO) throws Exception {
        String methodName = "copyStream";
        DKNVPair[] dknv = new DKNVPair[]{new DKNVPair("STREAM", (Object)inStream), new DKNVPair("LENGTH", (Object)new Long(sourceLength))};
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "dknv: " + dknv);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "((DKLobICM) targetDDO): " + (DKLobICM)targetDDO);
        ((DKLobICM)targetDDO).setAddLocation(dknv);
    }

    public void copyResourceAndPartContent(DKDDO sourceDDO, DKDDO targetDDO) throws DKException, Exception {
        String methodName = "copyResourceAndPartContent";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        boolean resource = false;
        boolean docModel = false;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "isResource(sourceDDO): " + this.isResource(sourceDDO));
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "isDocModel(sourceDDO): " + this.isDocModel(sourceDDO));
        resource = this.isResource(sourceDDO);
        if (resource || (docModel = this.isDocModel(sourceDDO))) {
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.dsICM);
            dkRetrieveOptions.resourceContent(true);
            dkRetrieveOptions.partsList(true);
            dkRetrieveOptions.partsAttributes(true);
            if (resource) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Is resource item");
                DKLobICM sourceLob = (DKLobICM)sourceDDO;
                DKLobICM targetLob = (DKLobICM)targetDDO;
                targetLob.setContent(sourceLob.getContent());
                targetLob.setMimeType(sourceLob.getMimeType());
            } else if (docModel) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Is doc model item");
                short sourceDDODataId = sourceDDO.dataId("ATTR", "DKParts");
                short targetDDODataId = targetDDO.dataId("ATTR", "DKParts");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "sourceDDODataId: " + sourceDDODataId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "targetDDODataId: " + targetDDODataId);
                if (sourceDDODataId != 0) {
                    DKParts sourceDkParts = (DKParts)sourceDDO.getData(sourceDDODataId);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Setting target parts");
                    dkIterator sourceIter = sourceDkParts.createIterator();
                    if (sourceIter.more()) {
                        DKDDO sourceDdo = (DKDDO)sourceIter.next();
                        DKLobICM sourceLob = (DKLobICM)sourceDdo;
                        DKParts partColl = null;
                        short data_id = targetDDO.dataId("ATTR", "DKParts");
                        if (data_id == 0) {
                            data_id = targetDDO.addData("ATTR", "DKParts");
                            targetDDO.addDataProperty(data_id, "type", (Object)new Short(1073));
                            partColl = new DKParts();
                            targetDDO.setData(data_id, (Object)partColl);
                        } else {
                            partColl = (DKParts)targetDDO.getData(data_id);
                            if (partColl == null) {
                                partColl = new DKParts();
                                targetDDO.setData(data_id, (Object)partColl);
                            }
                        }
                        DKLobICM xdo = (DKLobICM)this.dsICM.createDDO("ICMBASE", 13);
                        xdo.setPartNumber(partColl.cardinality() + 1);
                        partColl.addElement((Object)xdo);
                        xdo.setMimeType(sourceLob.getMimeType());
                        xdo.setOrgFileName(sourceLob.getOrgFileName());
                        xdo.setContent(sourceLob.getContent());
                        DKPid ddopid = targetDDO.getPidObject();
                        String primaryId = ddopid.getPrimaryId();
                        DKPid xdopid = xdo.getPidObject();
                        xdopid.setPrimaryId(primaryId);
                        xdo.setPidObject(xdopid);
                        targetDDO.setData(data_id, (Object)partColl);
                    }
                }
            } else {
                throw new Exception("Internal Error!  Item should have been a resource or a document model item since already detected it as such.");
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }
}

