/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Set;
import javax.servlet.ServletRequest;

public class TeamspaceUtil {
    public static final String getUniqueId(String seed) {
        return seed + "_" + System.currentTimeMillis();
    }

    public static final String localizeRoleNames(ServletRequest request, String teamspaceJson) {
        String methodName = "localizeRoleName";
        String json = teamspaceJson;
        try {
            JSONObject jsonObj = JSONObject.parse(teamspaceJson);
            if (jsonObj != null) {
                Logger.logDebug(TeamspaceUtil.class, methodName, request, "json: " + jsonObj.toString());
                JSONArray jsonRoles = (JSONArray)jsonObj.get("roles");
                if (jsonRoles != null) {
                    Logger.logDebug(TeamspaceUtil.class, methodName, request, "roles: " + jsonRoles.toString());
                    Object[] rolesArray = jsonRoles.toArray();
                    Logger.logDebug(TeamspaceUtil.class, methodName, request, "roles.length: " + rolesArray.length);
                    for (int i = 0; i < rolesArray.length; ++i) {
                        JSONObject roleObj = (JSONObject)jsonRoles.get(i);
                        boolean debug = false;
                        if (debug) {
                            Set keySet = roleObj.keySet();
                            for (String key : keySet) {
                                Object valueObj = roleObj.get(key);
                                if (!(valueObj instanceof String)) continue;
                                String value = (String)valueObj;
                                Logger.logDebug(TeamspaceUtil.class, methodName, request, "role - key: " + key + ", value: " + value);
                            }
                        }
                        String rid = String.valueOf(roleObj.get("id"));
                        String predefined = String.valueOf(roleObj.get("preDefined"));
                        Logger.logDebug(TeamspaceUtil.class, methodName, request, "teamspace contains role: " + rid + ", preDefined: " + predefined);
                        if (!Boolean.valueOf(predefined).booleanValue()) continue;
                        String messageId = String.valueOf(roleObj.get("messageId"));
                        Logger.logDebug(TeamspaceUtil.class, methodName, request, "predefined role: " + messageId);
                        if (messageId == null || messageId.length() <= 0 || messageId.equals("null")) continue;
                        String name = MessageUtil.getMessage(request.getLocale(), messageId + ".name");
                        String desc = MessageUtil.getMessage(request.getLocale(), messageId + ".description");
                        Logger.logDebug(TeamspaceUtil.class, methodName, request, "localized predefined role: " + name + ", " + desc);
                        roleObj.remove("name");
                        roleObj.put("name", name);
                        roleObj.remove("description");
                        roleObj.put("description", desc);
                    }
                }
                json = jsonObj.toString();
            }
        }
        catch (Exception e) {
            Logger.logError(TeamspaceUtil.class, methodName, request, (Throwable)e);
        }
        return json;
    }
}

