/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace;

import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import javax.servlet.ServletRequest;

public class TeamspaceDB {
    private JSONObject teamspace;
    private ServletRequest request = null;

    public TeamspaceDB(ServletRequest request) {
        String methodName = "TeamspaceDB";
        this.request = request;
        try {
            this.teamspace = new JSONObject();
        }
        catch (NullPointerException e) {
            Logger.logError((Object)this, methodName, request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, request, (Throwable)e);
        }
    }

    public TeamspaceDB(ServletRequest request, String json) {
        String methodName = "TeamspaceDB";
        this.request = request;
        try {
            this.teamspace = (JSONObject)JSON.parse(json);
            Logger.logDebug((Object)this, methodName, request, "teamspace: " + this.teamspace.toString());
        }
        catch (NullPointerException e) {
            Logger.logError((Object)this, methodName, request, (Throwable)e);
        }
        catch (IOException e) {
            Logger.logError((Object)this, methodName, request, (Throwable)e);
        }
    }

    public String toJson() {
        return this.teamspace.toString();
    }

    public String getTeamspaceTemplateId() {
        String templateId = (String)this.teamspace.get("templateId");
        return templateId;
    }

    public void setTeamspaceTemplateId(String id) {
        this.teamspace.put("templateId", id);
    }

    public String getDefaultClass() {
        String defaultClass = (String)this.teamspace.get("defaultClass");
        return defaultClass;
    }

    public void setDefaultClass(String defaultClass) {
        this.teamspace.put("defaultClass", defaultClass);
    }

    public String getDefaultEntryTemplate() {
        String defaultEntryTemplate = (String)this.teamspace.get("defaultEntryTemplate");
        return defaultEntryTemplate;
    }

    public void setDefaultEntryTemplate(String defaultEntryTemplate) {
        this.teamspace.put("defaultEntryTemplate", defaultEntryTemplate);
    }

    public void addClass(JSONObject classId) {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("contentClasses");
        jsonArray.add(classId);
    }

    public void addEntryTemplate(JSONObject entryTemplate) {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("entryTemplates");
        jsonArray.add(entryTemplate);
    }

    public void clearSearches() {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("searchTemplates");
        jsonArray.clear();
    }

    public void addSearch(JSONObject item) {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("searchTemplates");
        jsonArray.add(item);
    }

    public JSONArray getSearches() {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("searchTemplates");
        if (jsonArray != null) {
            jsonArray = (JSONArray)jsonArray.clone();
        }
        return jsonArray;
    }

    public JSONArray getClasses() {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("contentClasses");
        return jsonArray;
    }

    public JSONArray getRoles() {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("roles");
        return jsonArray;
    }

    public JSONArray getMembers() {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("members");
        return jsonArray;
    }

    public JSONArray getEntryTemplates() {
        JSONArray jsonArray = (JSONArray)this.teamspace.get("entryTemplates");
        return jsonArray;
    }

    public String getUsesClasses() {
        String usesClasses = (String)this.teamspace.get("usesClasses");
        return usesClasses;
    }

    public void setUsesClasses(String usesClasses) {
        this.teamspace.put("usesClasses", usesClasses);
    }

    public SearchTemplate.ResultsDisplay getColumnProperties() {
        SearchTemplate.ResultsDisplay columnProps = null;
        Object propsObj = this.teamspace.get("columnProperties");
        if (propsObj instanceof JSONObject) {
            columnProps = new SearchTemplate.ResultsDisplay();
            columnProps.fromJSON((JSONObject)propsObj);
        }
        return columnProps;
    }
}

