/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.teamspace;

import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.Subject;
import com.ibm.ecm.teamspace.TeamspaceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTeamspaceService {
    public static final String TEAMSPACE_RETRIEVAL_TEMPLATE = "template";
    public static final String TEAMSPACE_RETRIEVAL_INSTANCE = "instance";
    public static final String TEAMSPACE_RETRIEVAL_ALL = "allData";
    public static final String TEAMSPACE_RETRIEVAL_SEARCHES = "searches";
    public static final String TEAMSPACE_RETRIEVAL_CLASSES = "classes";
    public static final String TEAMSPACE_RETRIEVAL_COLUMNS = "columns";
    public static final String TEAMSPACE_RETRIEVAL_TEAM = "team";
    public static final String TEAMSPACE_RETRIEVAL_ENTRYTEMPLATES = "entryTemplates";
    public static final String TEAMSPACE_RETRIEVAL_NONE = "none";
    public static final String TEAMSPACE_TYPE_TEMPLATE = "template";
    public static final String TEAMSPACE_TYPE_INSTANCE = "instance";
    public static final String TEAMSPACE_JSON_PROP_SEARCHES = "searchTemplates";
    public static final String TEAMSPACE_JSON_PROP_CLASSES = "contentClasses";
    public static final String TEAMSPACE_JSON_PROP_ROLES = "roles";
    public static final String TEAMSPACE_JSON_PROP_MEMBERS = "members";
    public static final String TEAMSPACE_JSON_PROP_ENTRYTEMPLATES = "entryTemplates";
    public static final String TEAMSPACE_JSON_PROP_TEMPLATE_ID = "templateId";
    public static final String TEAMSPACE_JSON_PROP_DEFAULT_CLASS = "defaultClass";
    public static final String TEAMSPACE_JSON_PROP_DEFAULT_ENTRY_TEMPLATE = "defaultEntryTemplate";
    public static final String TEAMSPACE_JSON_PROP_DEFAULT = "isDefault";
    public static final String TEAMSPACE_JSON_PROP_DEFAULT_VALUE = "Default";
    public static final String TEAMSPACE_JSON_PROP_NAME = "name";
    public static final String TEAMSPACE_JSON_PROP_DESCRIPTION = "description";
    public static final String TEAMSPACE_JSON_PROP_ID = "id";
    public static final String TEAMSPACE_JSON_PROP_ITEMS = "folders";
    public static final String TEAMSPACE_JSON_PROP_DOCID = "docid";
    public static final String TEAMSPACE_JSON_PROP_USES_CLASSES = "usesClasses";
    public static final String TEAMSPACE_JSON_PROP_COLUMN_PROPS = "columnProperties";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_PATH = "path";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_NAME = "name";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_TYPE = "type";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_IS_COPY = "IsCopy";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_PROPERTIES = "properties";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_PROPERTIES_CRITERIA = "criterias";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_CHILD_PROPERTIES_CRITERIA = "childComponentValues";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_TYPE_FOLDER = "folder";
    public static final String TEAMSPACE_JSON_PROP_ITEMS_PROPERTIES_CLASS = "documentType";
    public static final String TEAMSPACE_PROP_STATE_TEMP = "draft";
    public static final String TEAMSPACE_PROP_STATE_DELETED = "deleted";
    public static final String TEAMSPACE_PROP_STATE_PUBLISHED = "published";
    public static final String APPLICATION_NAME = "Navigator";

    protected static void addMember(Map<String, Subject> map, Subject newMember) {
        String name = newMember.getName();
        if (map.containsKey(name)) {
            Subject original = map.get(name);
            List<Role> roles = BaseTeamspaceService.mergeRoles(original.getRoles(), newMember.getRoles());
            original.setRoles(roles);
        } else {
            map.put(name, newMember);
        }
    }

    protected static List<Role> mergeRoles(List<Role> original, List<Role> newRoles) {
        HashMap<String, Role> map = new HashMap<String, Role>();
        if (original != null) {
            for (Role r : original) {
                map.put(r.getId(), r);
            }
        }
        if (newRoles != null) {
            for (Role r : newRoles) {
                map.put(r.getId(), r);
            }
        }
        ArrayList<Role> result = new ArrayList<Role>(map.values());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PUBLISHED{

            public int getValue() {
                return 1;
            }

            public String getStringValue() {
                return BaseTeamspaceService.TEAMSPACE_PROP_STATE_PUBLISHED;
            }
        }
        ,
        DELETED{

            public int getValue() {
                return 2;
            }

            public String getStringValue() {
                return BaseTeamspaceService.TEAMSPACE_PROP_STATE_DELETED;
            }
        }
        ,
        DEFAULT{

            public int getValue() {
                return 3;
            }

            public String getStringValue() {
                return "default";
            }
        }
        ,
        ONLINE{

            public int getValue() {
                return 4;
            }

            public String getStringValue() {
                return "online";
            }
        }
        ,
        OFFLINE{

            public int getValue() {
                return 5;
            }

            public String getStringValue() {
                return "offline";
            }
        };


        public abstract int getValue();

        public abstract String getStringValue();

        public static State getEnum(int value) throws TeamspaceException {
            for (State state : State.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            throw new TeamspaceException("Unsupported state!", 1096);
        }

        public static State getEnum(String value) throws TeamspaceException {
            for (State state : State.values()) {
                if (!state.getStringValue().equalsIgnoreCase(value)) continue;
                return state;
            }
            throw new TeamspaceException("Unsupported state!", 1096);
        }
    }
}

