/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.controller;

import com.ibm.ecm.Constants;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.PluginUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.struts.action.ActionServlet;

public class ControllerServlet
extends ActionServlet
implements Constants {
    protected static final transient Counter _counter = new Counter();
    public static final String CHARSET = "UTF-8";
    protected static final transient ThreadLocal _localCounter = new ThreadLocal();
    private int logLevel = 1;
    private static String logIncludes = null;
    private static String logExcludes = null;
    private static String logUsers = null;
    private static String logHosts = null;
    private boolean configInitialized = false;
    private HttpServletRequest request = null;
    public static String startupTime = new Date().toString();

    protected void initOther(HttpServletRequest request) throws ServletException {
        HttpSession session;
        String methodName = "initOther";
        if (this.configInitialized) {
            return;
        }
        String userid = request != null ? request.getParameter("userid") : null;
        HttpSession httpSession = session = request != null ? request.getSession() : null;
        if (session != null && userid != null) {
            session.setAttribute("session_userid", (Object)userid);
        }
        try {
            Config.initialize((HttpServletRequest)request, (String)this.getServletConfig().getInitParameter("enablePropertiesConfig"), (String)this.getServletConfig().getInitParameter("propertiesFileName"));
            this.configInitialized = true;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        try {
            this.logLevel = Config.getSettingsConfig("navigator").getLoggingLevel();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        Logger.setLogLevel(this.logLevel);
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this.setIncludeExcludeLogging(request);
        super.initOther();
        this.logContextInformation(request);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void setIncludeExcludeLogging(HttpServletRequest request) {
        String methodName = "setIncludeExcludeLogging";
        SettingsConfig settingsConfig = null;
        try {
            settingsConfig = Config.getSettingsConfig("navigator");
        }
        catch (ConfigurationException e1) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e1);
        }
        catch (MissingValueException e1) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e1);
        }
        if (settingsConfig != null) {
            String hosts;
            String users;
            String excludes;
            String includes = settingsConfig.getLoggingClassIncludes();
            if (includes != null && includes.length() > 0) {
                logIncludes = includes;
                Logger.setLogIncludes(request, logIncludes);
            }
            if ((excludes = settingsConfig.getLoggingClassExcludes()) != null && excludes.length() > 0) {
                logExcludes = excludes;
                Logger.setLogExcludes(request, logExcludes);
            }
            if ((users = settingsConfig.getLoggingDebugUsers()) != null && users.length() > 0) {
                logUsers = users;
                Logger.setLogUserIds(request, logUsers);
            }
            if ((hosts = settingsConfig.getLoggingDebugHosts()) != null && hosts.length() > 0) {
                logHosts = hosts;
                Logger.setLogHostNames(request, logHosts);
            }
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "additional properties: ''");
        }
    }

    private void logContextInformation(HttpServletRequest request) {
        String methodName = "logContextInformation";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Server Info: " + this.getServletContext().getServerInfo());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Major Version: " + this.getServletContext().getMajorVersion());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Minor Version: " + this.getServletContext().getMinorVersion());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "ServletContextName: " + this.getServletContext().getServletContextName());
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session;
        this.request = request;
        String methodName = "process";
        try {
            request.setCharacterEncoding(CHARSET);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        String userid = request != null ? request.getParameter("userid") : null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Requested Sessionid = " + request.getRequestedSessionId() + "  isRequestedSessionIdValid=" + request.isRequestedSessionIdValid());
        HttpSession httpSession = session = request != null ? request.getSession() : null;
        if (session != null && userid != null) {
            session.setAttribute("session_userid", (Object)userid);
        }
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        long reqNo = 0L;
        ControllerServlet controllerServlet = this;
        synchronized (controllerServlet) {
            reqNo = this.nextRequestNumber();
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "-------- BEGIN REQUEST " + reqNo + " ---------");
        String queryString = request.getQueryString() != null ? "?" + request.getQueryString() : "";
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, request.getServletPath() + queryString);
        if (session == null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request does not have a session yet");
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request has a session with an id of : " + session.getId());
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Locale: " + request.getLocale());
        this.initOther(request);
        Logger.setLogLevel(this.logLevel);
        Logger.setLogIncludes(request, logIncludes);
        Logger.setLogExcludes(request, logExcludes);
        Logger.setLogUserIds(request, logUsers);
        Logger.setLogHostNames(request, logHosts);
        try {
            if (PluginUtil.isPluginInitializationNeeded()) {
                PluginUtil.initializePlugins(request);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (session != null) {
            Enumeration attrNames = session.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName;
                String object = (String)attrNames.nextElement();
                if (!(object instanceof String) || !(attrName = object).startsWith("initString")) continue;
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "found in session: " + attrName + " = " + session.getAttribute(attrName));
            }
            String localHost = request.getLocalName();
            String sessionHost = (String)session.getAttribute("session_remote_host");
            String requestHost = request.getRemoteHost();
            String remoteAddr = request.getRemoteAddr();
            if (remoteAddr != null && (remoteAddr.equals("127.0.0.1") || remoteAddr.equals("0:0:0:0:0:0:0:1"))) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Localhost originated request detected.  Remote host: " + requestHost + ", Session host: " + sessionHost);
            } else if (!localHost.equals(requestHost)) {
                if (sessionHost != null && !sessionHost.equals(requestHost)) {
                    Logger.logWarning((Object)this, methodName, (ServletRequest)request, "Session may have been hijacked! original connection by: " + sessionHost + " does not match request: " + requestHost);
                    session.setAttribute("session_remote_host", (Object)"hijacked");
                } else {
                    session.setAttribute("session_remote_host", (Object)requestHost);
                }
            }
        }
        super.process(request, response);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "-------- END REQUEST " + reqNo + " ---------");
    }

    public void destroy() {
        String methodName = "destroy";
        PluginUtil.dropPlugins(this.request);
        super.destroy();
    }

    public long getRequestNumber() {
        Long numLong = (Long)_localCounter.get();
        return numLong == null ? -1L : numLong;
    }

    protected long nextRequestNumber() {
        long l = _counter.next();
        _localCounter.set(new Long(l));
        return l;
    }

    protected class ServerCache {
        private LinkedHashMap cache;
        private int MAX_ENTRIES;
        private HttpServletRequest request = null;

        public ServerCache(HttpServletRequest request, int cacheSize) {
            String methodName = "ServerCache";
            this.request = request;
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            this.MAX_ENTRIES = cacheSize;
            this.cache = new LinkedHashMap(cacheSize, 1.0f, true);
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
        }

        protected void put(Object key, Object object) {
            this.cache.put(key, object);
        }

        protected void remove(Object key) {
            this.cache.remove(key);
        }

        protected Object get(Object key) {
            return this.cache.get(key);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            Logger.logDebug((Object)this, "removeEldestEntry", (ServletRequest)this.request, "cache size: " + this.cache.size());
            return this.cache.size() > this.MAX_ENTRIES;
        }
    }

    protected static class Counter {
        protected long _num = 0L;

        protected Counter() {
        }

        public synchronized long getCount() {
            return this._num;
        }

        public synchronized long next() {
            return ++this._num;
        }
    }
}

