/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.viewer;

import com.ibm.ecm.beans.viewer.DocServicesSessionBean;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.viewer.PageImageMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class GetPageImageAction
extends BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        HttpSession session = request.getSession(false);
        MessageResources resources = this.getResources(request);
        PageImageMediator pageImageMediator = (PageImageMediator)this.getMediator(request);
        String docUrl = request.getParameter("docUrl");
        String contentType = request.getParameter("contentType");
        String serverType = request.getParameter("serverType");
        String pageNoString = request.getParameter("pageNo");
        String scaleString = request.getParameter("scale");
        String rotationString = request.getParameter("rotation");
        String invertedString = request.getParameter("inverted");
        String contrastString = request.getParameter("contrast");
        String brightnessString = request.getParameter("brightness");
        boolean jsonRequest = false;
        String jsonRequestB = request.getParameter("jsonRequest");
        if (jsonRequestB != null) {
            jsonRequest = Boolean.parseBoolean(jsonRequestB);
        }
        String displayableWidthString = request.getParameter("displayableWidth");
        String displayableHeightString = request.getParameter("displayableHeight");
        String lastModified = request.getParameter("lastModified");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameters: docUrl = " + docUrl + ", contentType = " + contentType + ", serverType = " + serverType + ", pageNo = " + pageNoString + ", scale = " + scaleString + ", rotation = " + rotationString + ", inverted = " + invertedString + ", contrast = " + contrastString + ", brightness = " + brightnessString + ", displayable width = " + displayableWidthString + ", displayable height = " + displayableHeightString + ", last modified = " + lastModified);
        if (lastModified != null && lastModified.length() != 0) {
            docUrl = docUrl + "&lastModified=" + lastModified;
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Modified image lookup document URL (last modified added): docUrl = " + docUrl);
        }
        if (docUrl == null || docUrl.trim().length() < 1) {
            pageImageMediator.addError("error.parm.null", "docUrl");
            response.setStatus(400);
        }
        if (!(serverType == null || (serverType = serverType.trim()).equals("") || serverType.equals("ci") || serverType.equals("od") || serverType.equals("cm") || serverType.equals("p8") || serverType.equals("cmis"))) {
            pageImageMediator.addError("error.parm.null", "serverType");
            response.setStatus(400);
        }
        if (pageNoString == null) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, "Missing pageNo parameter");
            pageImageMediator.addError("error.parm.null", "pageNo");
            response.setStatus(400);
        }
        int pageNo = Integer.parseInt(pageNoString);
        if (scaleString == null) {
            scaleString = "1.0";
        }
        float scale = Float.parseFloat(scaleString);
        if (rotationString == null) {
            rotationString = "0";
        }
        int rotation = Integer.parseInt(rotationString);
        rotation %= 4;
        rotation = (rotation + 4) % 4;
        if (rotationString == null) {
            rotationString = "false";
        }
        boolean inverted = Boolean.valueOf(invertedString);
        if (brightnessString == null) {
            brightnessString = "0.5";
        }
        float brightness = Float.parseFloat(brightnessString);
        if (contrastString == null) {
            contrastString = "0.5";
        }
        float contrast = Float.parseFloat(contrastString);
        if (displayableWidthString == null) {
            displayableWidthString = "760";
        }
        int displayableWidth = Integer.parseInt(displayableWidthString);
        if (displayableHeightString == null) {
            displayableHeightString = "500";
        }
        int displayableHeight = Integer.parseInt(displayableHeightString);
        if (pageImageMediator.getErrors().isEmpty()) {
            try {
                DocServicesSessionBean docServicesSessionBean;
                HttpSession httpSession = request.getSession();
                synchronized (httpSession) {
                    docServicesSessionBean = (DocServicesSessionBean)request.getSession().getAttribute("docServicesSessionBean");
                    if (docServicesSessionBean == null) {
                        docServicesSessionBean = new DocServicesSessionBean(request.getSession());
                        request.getSession().setAttribute("docServicesSessionBean", (Object)docServicesSessionBean);
                    }
                }
                Cookie[] cookies = request.getCookies();
                StringBuffer cookieProperty = new StringBuffer();
                if (cookies != null) {
                    for (int j = 0; j < cookies.length; ++j) {
                        cookieProperty.append(cookies[j].getName());
                        cookieProperty.append("=");
                        cookieProperty.append(cookies[j].getValue());
                        cookieProperty.append(",");
                    }
                }
                if (jsonRequest) {
                    docServicesSessionBean.getPageImage(cookieProperty.toString(), new URL(request.getRequestURL().toString()), docUrl, contentType, serverType, pageNo, scale, rotation, inverted, brightness, contrast, displayableWidth, displayableHeight, request, response, pageImageMediator);
                    response.setContentType("text/json");
                    ServletOutputStream os = response.getOutputStream();
                    os.write(pageImageMediator.toJSONString().getBytes("UTF8"));
                    os.close();
                } else {
                    docServicesSessionBean.writePage(cookieProperty.toString(), new URL(request.getRequestURL().toString()), docUrl, contentType, serverType, pageNo, scale, rotation, inverted, brightness, contrast, displayableWidth, displayableHeight, request, response);
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                if (jsonRequest) {
                    pageImageMediator.addError("viewingServices.writePageError", e.getMessage());
                }
                pageImageMediator.sendErrorResponse(response);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        return new PageImageMediator(request, this.getResources(request), request.getLocale());
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String docUrl = request.getParameter("docUrl");
        String contentType = request.getParameter("contentType");
        String serverType = request.getParameter("serverType");
        String pageNoString = request.getParameter("pageNo");
        String scaleString = request.getParameter("scale");
        String rotationString = request.getParameter("rotation");
        String invertedString = request.getParameter("inverted");
        String contrastString = request.getParameter("contrast");
        String brightnessString = request.getParameter("brightness");
        boolean jsonRequest = false;
        String displayableWidthString = request.getParameter("displayableWidth");
        String displayableHeightString = request.getParameter("displayableHeight");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameters: docUrl = " + docUrl + " contentType = " + contentType + " serverType = " + serverType + " pageNo = " + pageNoString + " scale = " + scaleString + " rotation = " + rotationString + " inverted = " + invertedString + " contrast = " + contrastString + " brightness = " + brightnessString + " displayable width = " + displayableWidthString + " displayable height = " + displayableHeightString);
    }
}

