/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8WorkItemsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8QueryContinuationData;
import com.ibm.ecm.util.p8.P8Workflow;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkBasket;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8RetrieveNextWorkItemsAction
extends P8BaseAction {
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this.getConfigInfo(request);
        MessageResources resources = this.getResources(request);
        P8WorkItemsMediator workItemsMediator = (P8WorkItemsMediator)this.getMediator(request);
        try {
            HttpSession session = request.getSession();
            String continuationData = request.getParameter("continuationData");
            P8QueryContinuationData queryData = new P8QueryContinuationData(continuationData, true);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "continuationData: " + continuationData);
            String itemsNeededParameter = request.getParameter("itemsNeeded");
            VWWorkBasket myInBasket = (VWWorkBasket)session.getAttribute(queryData.sessionKey);
            if (myInBasket == null) {
                P8Connection connection = this.getConnection(request);
                VWSession vwSession = P8Workflow.getVWSession(connection, request);
                VWRole vwRole = vwSession.fetchMyRole(queryData.processRoleName, queryData.applicationSpaceName);
                myInBasket = vwRole.fetchWorkBasket(queryData.queueName, queryData.inbasketName);
                session.setAttribute(queryData.sessionKey, (Object)myInBasket);
            }
            VWWorkBasket.Column[] columns = myInBasket.getColumns();
            workItemsMediator.setContinuation(true);
            workItemsMediator.setColumns(columns);
            String orderBy = queryData.orderBy;
            String lastWorkRecord = queryData.lastWorkRecord;
            int query_flags = 5;
            if (queryData.descending) {
                query_flags += 16384;
            }
            int itemsNeeded = 0;
            if (itemsNeededParameter != null && !itemsNeededParameter.equals("")) {
                itemsNeeded = Integer.parseInt(itemsNeededParameter);
            }
            int itemsRetrieved = itemsNeeded;
            int buffer_size = this.pageSize;
            VWWorkBasket.QueryResults qr = myInBasket.fetchNextBatch(query_flags, buffer_size, orderBy, null, null, lastWorkRecord, 3);
            if (qr != null) {
                Object[] workObjects = qr.getWorkObjects();
                ArrayList<Object> hits = new ArrayList<Object>(Arrays.asList(workObjects));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Inbasket items needed:" + itemsNeeded);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Inbasket query results count:" + workObjects.length);
                if (workObjects.length >= this.pageSize) {
                    queryData.lastWorkRecord = qr.getLastRecord();
                    continuationData = queryData.saveToString();
                    workItemsMediator.setContinuationData(continuationData);
                } else {
                    session.removeAttribute(continuationData);
                    itemsRetrieved = myInBasket.fetchCount();
                }
                VWQueueElement[] objects = hits.toArray(new VWQueueElement[0]);
                workItemsMediator.setQueueElements(objects);
            } else {
                session.removeAttribute(continuationData);
                itemsRetrieved = myInBasket.fetchCount();
            }
            workItemsMediator.addMessage("search.results.returned.workItems", itemsRetrieved);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Finished adding inbasket query results to session.");
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            workItemsMediator.addError("error.exception.general", e.getMessage());
        }
        if (Logger.isDebugLogged()) {
            String jsonString = workItemsMediator.toJSONString();
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JSON response: " + jsonString);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String key = request.getParameter("continuationData");
        String repository = request.getParameter("repositoryId");
        return key != null && repository != null;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8WorkItemsMediator workItemsMediator = new P8WorkItemsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)workItemsMediator);
        return workItemsMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

