/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8CompleteStepMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8EntryTemplateWorkflow;
import com.ibm.ecm.util.p8.P8Exception;
import com.ibm.ecm.util.p8.P8Workflow;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import java.net.URLDecoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8LaunchWorkflowAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName;
        block13: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
            String objectStoreName = request.getParameter("objectStoreName");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "objectStoreName = " + objectStoreName);
            String objectId = request.getParameter("docid");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "objectId = " + objectId);
            String subject = request.getParameter("subject");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "subject = " + subject);
            String attachmentId = request.getParameter("attachmentId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attachmentId = " + attachmentId);
            String workflowObjectStoreName = request.getParameter("workflowObjectStoreName");
            if (workflowObjectStoreName == null) {
                workflowObjectStoreName = this.getObjectStoreName(repositoryId);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workflowObjectStoreName = " + workflowObjectStoreName);
            String workflowId = request.getParameter("workflowId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workflowId = " + workflowId);
            String workflowVsId = request.getParameter("workflowVsId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workflowVsId = " + workflowVsId);
            String workflowStyle = request.getParameter("workflowStyle");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workflowStyle = " + workflowStyle);
            P8CompleteStepMediator completeStepMediator = (P8CompleteStepMediator)this.getMediator(request);
            try {
                P8Connection connection = this.getConnection(request);
                VWSession vwSession = P8Workflow.getVWSession(connection, request);
                String vwVersion = P8Workflow.fetchWorkflowVersion(request, connection, workflowObjectStoreName, workflowId, workflowVsId);
                if (vwVersion != null) {
                    VWStepElement stepElement;
                    VWAttachment attachment = null;
                    if (attachmentId != null && attachmentId.length() > 0) {
                        attachment = P8Workflow.createAttachment(request, URLDecoder.decode(attachmentId, "UTF-8"));
                    }
                    if ((stepElement = P8EntryTemplateWorkflow.createWorkflow(request, vwSession, vwVersion, subject, attachment)) != null) {
                        stepElement.doDispatch();
                        if (attachment != null && attachment.getType() == 3) {
                            String workflowNumber = null;
                            if (workflowStyle != null) {
                                if (workflowStyle.equalsIgnoreCase("Designer")) {
                                    workflowNumber = workflowStyle;
                                } else if (workflowStyle.equalsIgnoreCase("Approval") || workflowStyle.equalsIgnoreCase("Sequence")) {
                                    workflowNumber = stepElement.getWorkflowNumber();
                                }
                                if (workflowNumber != null) {
                                    P8EntryTemplateWorkflow.saveWorkflowNumber(request, connection, objectStoreName, objectId, null, workflowNumber);
                                }
                            }
                        }
                        completeStepMediator.addMessage("process.step.launched.successful", new Object[0]);
                    }
                    break block13;
                }
                throw new P8Exception("process.error.exception.invalidversion");
            }
            catch (P8Exception p8e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError(P8LaunchWorkflowAction.class, methodName, (ServletRequest)request, (Throwable)p8e);
                completeStepMediator.addError(p8e.getMessageKey(), p8e.getMessageParameters());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError(P8LaunchWorkflowAction.class, methodName, (ServletRequest)request, (Throwable)e);
                completeStepMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private String getObjectStoreName(String repositoryId) {
        String objectStoreName = null;
        DesktopConfig desktopConfig = Config.getDesktopConfig(this.request);
        RepositoryConfig repositoryConfig = desktopConfig.getRepository(repositoryId);
        if (repositoryConfig != null) {
            objectStoreName = repositoryConfig.getObjectStoreDisplayName();
        }
        return objectStoreName;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8CompleteStepMediator completeStepMediator = new P8CompleteStepMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)completeStepMediator);
        return completeStepMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

