/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.collection.ClassWorkflowSubscriptionSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.InstanceWorkflowSubscriptionSet;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.events.ClassWorkflowSubscription;
import com.filenet.api.events.InstanceWorkflowSubscription;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.util.Id;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8WorkflowSubscriptionsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Exception;
import com.ibm.ecm.util.p8.P8Util;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetWorkflowSubscriptionsAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String objectId = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "objectId = " + objectId);
        P8WorkflowSubscriptionsMediator subscriptionsMediator = (P8WorkflowSubscriptionsMediator)this.getMediator(request);
        try {
            P8Connection connection = this.getConnection(request);
            ObjectStore os = P8Util.getObjectStore(request, connection, null);
            ArrayList<InstanceWorkflowSubscription> validSubscriptions = new ArrayList<InstanceWorkflowSubscription>();
            ClassDescription classDesc = null;
            String objectType = null;
            IndependentlyPersistableObject item = P8Util.getPersistableObject(request, connection, objectId);
            if (item instanceof Document) {
                classDesc = ((Document)item).get_ClassDescription();
                objectType = "document";
                InstanceWorkflowSubscriptionSet docSubscriptions = ((Document)item).get_WorkflowSubscriptions();
                for (InstanceWorkflowSubscription subscription : docSubscriptions) {
                    String expression = subscription.get_FilterExpression();
                    boolean valid = true;
                    Boolean isEnabled = subscription.get_IsEnabled();
                    Boolean manualLaunch = subscription.get_EnableManualLaunch();
                    if (!isEnabled.booleanValue() || !manualLaunch.booleanValue()) {
                        valid = false;
                    }
                    if (valid && expression != null && expression.length() > 0) {
                        valid = this.evaluateSubscriptionExpression(os, expression, os.get_Name(), objectId, objectType);
                    }
                    if (!valid) continue;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Adding valid document instance subscription: " + subscription.get_DisplayName());
                    validSubscriptions.add(subscription);
                }
            } else if (item instanceof Folder) {
                classDesc = ((Folder)item).get_ClassDescription();
                objectType = "folder";
                InstanceWorkflowSubscriptionSet folderSubscriptions = ((Folder)item).get_WorkflowSubscriptions();
                for (InstanceWorkflowSubscription subscription : folderSubscriptions) {
                    String expression = subscription.get_FilterExpression();
                    boolean valid = true;
                    Boolean isEnabled = subscription.get_IsEnabled();
                    Boolean manualLaunch = subscription.get_EnableManualLaunch();
                    if (!isEnabled.booleanValue() || !manualLaunch.booleanValue()) {
                        valid = false;
                    }
                    if (valid && expression != null && expression.length() > 0) {
                        valid = this.evaluateSubscriptionExpression(os, expression, os.get_Name(), objectId, objectType);
                    }
                    if (!valid) continue;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Adding valid folder instance subscription: " + subscription.get_DisplayName());
                    validSubscriptions.add(subscription);
                }
            }
            ClassDefinition classDef = Factory.ClassDefinition.fetchInstance((ObjectStore)os, (Id)classDesc.get_Id(), null);
            this.getClassDefinitionSubscriptions(os, classDef, objectId, objectType, true, validSubscriptions);
            if (validSubscriptions.isEmpty()) {
                throw new P8Exception("process.error.exception.nosubscriptions");
            }
            subscriptionsMediator.setValidSubscriptions(validSubscriptions);
            subscriptionsMediator.setItem(item);
        }
        catch (P8Exception p8e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8GetWorkflowSubscriptionsAction.class, methodName, (ServletRequest)request, (Throwable)p8e);
            subscriptionsMediator.addError(p8e.getMessageKey(), p8e.getMessageParameters());
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8GetWorkflowSubscriptionsAction.class, methodName, (ServletRequest)request, (Throwable)e);
            subscriptionsMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private void getClassDefinitionSubscriptions(ObjectStore os, ClassDefinition classDef, String objectId, String objectType, boolean initialClass, ArrayList validSubscriptions) throws Exception {
        String methodName = "getClassDefinitionSubscriptions";
        ClassWorkflowSubscriptionSet classSubscriptions = classDef.get_WorkflowSubscriptions();
        for (ClassWorkflowSubscription subscription : classSubscriptions) {
            String expression = subscription.get_FilterExpression();
            boolean valid = true;
            Boolean isEnabled = subscription.get_IsEnabled();
            Boolean manualLaunch = subscription.get_EnableManualLaunch();
            if (!isEnabled.booleanValue() || !manualLaunch.booleanValue()) {
                valid = false;
            }
            Boolean supportSubclasses = subscription.get_IncludeSubclassesRequested();
            if (valid && !initialClass && !supportSubclasses.booleanValue()) {
                valid = false;
            }
            if (valid && expression != null && expression.length() > 0) {
                valid = this.evaluateSubscriptionExpression(os, expression, os.get_Name(), objectId, objectType);
            }
            if (!valid) continue;
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding valid class instance subscription: " + subscription.get_DisplayName());
            validSubscriptions.add(subscription);
        }
        ClassDefinition superClassDef = classDef.get_SuperclassDefinition();
        if (superClassDef != null) {
            this.getClassDefinitionSubscriptions(os, superClassDef, objectId, objectType, false, validSubscriptions);
        }
    }

    private boolean evaluateSubscriptionExpression(ObjectStore os, String expression, String objectStoreId, String objectId, String objectType) throws Exception {
        if (expression == null) {
            return true;
        }
        boolean evaluation = false;
        String fromClause = " FROM document ";
        if (objectType == "folder") {
            fromClause = " FROM folder ";
        } else if (objectType == "customobject") {
            fromClause = " FROM customobject ";
        }
        String sql = "SELECT Id " + fromClause + "WHERE ((" + expression + ") and This = object('" + objectId + "') )";
        SearchScope scope = new SearchScope(os);
        SearchSQL search = new SearchSQL(sql);
        IndependentObjectSet rows = scope.fetchObjects(search, Integer.valueOf(this.pageSize), null, Boolean.TRUE);
        if (!rows.isEmpty()) {
            evaluation = true;
        }
        return evaluation;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8WorkflowSubscriptionsMediator subscriptionsMediator = new P8WorkflowSubscriptionsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)subscriptionsMediator);
        return subscriptionsMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

