/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8WorkItemsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8QueryContinuationData;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkBasket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8GetWorkItemsAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        P8QueryContinuationData queryData = new P8QueryContinuationData();
        queryData.isWorkBasketData = true;
        this.getConfigInfo(request);
        ActionForward actionForward = null;
        P8WorkItemsMediator workItemsMediator = (P8WorkItemsMediator)this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String applicationSpaceName = request.getParameter("appspace_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Application space name passed in - " + applicationSpaceName);
        String processRoleName = request.getParameter("processrole_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "ProcessRole name passed in - " + processRoleName);
        String inbasketName = request.getParameter("inbasket_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Inbasket name passed in - " + inbasketName);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "User id = " + userid);
        String orderBy = request.getParameter("order_by");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Sorting results by - " + orderBy);
        String descendingOrderParam = request.getParameter("order_descending");
        queryData.descending = StringUtils.equals((String)descendingOrderParam, (String)"true");
        String filterString = request.getParameter("filter_criteria");
        try {
            VWWorkBasket.QueryResults qr;
            JSONObject filters;
            JSONArray filterArray;
            P8Connection connection = this.getConnection(request);
            VWSession vwSession = P8Workflow.getVWSession(connection, request);
            if (applicationSpaceName == null || applicationSpaceName.length() == 0) {
                applicationSpaceName = "DefaultApplication";
            }
            String decodedAppSpaceName = URLDecoder.decode(applicationSpaceName, "UTF-8");
            String decodedRoleName = URLDecoder.decode(processRoleName, "UTF-8");
            queryData.applicationSpaceName = decodedAppSpaceName;
            queryData.processRoleName = decodedRoleName;
            VWRole vwRole = vwSession.fetchMyRole(decodedRoleName, decodedAppSpaceName);
            VWWorkBasket[] myInBaskets = vwRole.fetchWorkBaskets();
            String decodedInbasket = URLDecoder.decode(inbasketName, "UTF-8");
            VWWorkBasket myInBasket = null;
            for (int i = 0; i < myInBaskets.length && !(myInBasket = myInBaskets[i]).getAuthoredName().equals(decodedInbasket); ++i) {
            }
            VWWorkBasket.Column[] columns = myInBasket.getColumns();
            if (orderBy == null || orderBy.equals("") || orderBy.equals("!Name")) {
                orderBy = columns[0].getAuthoredName();
            }
            queryData.orderBy = orderBy;
            int query_flags = 5;
            if (queryData.descending) {
                query_flags += 16384;
            }
            int buffer_size = this.pageSize;
            String sort_column = orderBy;
            String[] filter_names = null;
            Object[] substitution_vars = null;
            String lastWorkRecord = null;
            int fetch_type = 3;
            if (filterString != null && (filterArray = (JSONArray)(filters = (JSONObject)JSON.parse(filterString)).get("filters")) != null) {
                Iterator i = filterArray.iterator();
                filter_names = new String[filterArray.size()];
                substitution_vars = new Object[filterArray.size()];
                for (int j = 0; j < filterArray.size(); ++j) {
                    String value;
                    JSONObject filterJSON = (JSONObject)i.next();
                    filter_names[j] = (String)filterJSON.get("name");
                    if (filterJSON.get("type").equals("xs:timestamp")) {
                        value = (String)filterJSON.get("value");
                        Date dateValue = DateUtil.parseISODate(value, false);
                        substitution_vars[j] = dateValue;
                        continue;
                    }
                    if (filterJSON.get("type").equals("xs:boolean")) {
                        value = (String)filterJSON.get("value");
                        substitution_vars[j] = Boolean.parseBoolean(value);
                        continue;
                    }
                    substitution_vars[j] = filterJSON.get("value");
                }
            }
            if ((qr = myInBasket.fetchNextBatch(query_flags, buffer_size, sort_column, filter_names, substitution_vars, lastWorkRecord, fetch_type)) != null) {
                Object[] workObjects = qr.getWorkObjects();
                ArrayList<Object> hits = new ArrayList<Object>(Arrays.asList(workObjects));
                int fetchCount = myInBasket.fetchCount();
                workItemsMediator.setFetchCount(fetchCount);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Inbasket fetch count:" + fetchCount);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Inbasket query results count:" + workObjects.length);
                if (workObjects.length >= this.pageSize) {
                    queryData.sessionKey = Long.toString(System.currentTimeMillis(), 36);
                    queryData.lastWorkRecord = qr.getLastRecord();
                    queryData.queueName = myInBasket.getQueueName();
                    queryData.inbasketName = myInBasket.getName();
                    request.getSession().setAttribute(queryData.sessionKey, (Object)myInBasket);
                    String continuationData = queryData.saveToString();
                    workItemsMediator.setContinuationData(continuationData);
                }
                VWQueueElement[] objects = hits.toArray(new VWQueueElement[0]);
                workItemsMediator.setQueueElements(objects);
                workItemsMediator.setPageSize(this.pageSize);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " after adding search results to session.");
                workItemsMediator.addMessage("search.results.returned.workItems", hits.size());
            } else {
                workItemsMediator.addMessage("search.results.returned.workItems", 0);
            }
            workItemsMediator.setColumns(columns);
            workItemsMediator.setRepositoryId(repositoryId);
        }
        catch (VWException vwexc) {
            Logger.logError(P8GetWorkItemsAction.class, methodName, (ServletRequest)request, (Throwable)vwexc);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8WorkItemsMediator workItemsMediator = new P8WorkItemsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)workItemsMediator);
        return workItemsMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
        String inbasketName = request.getParameter("inbasket_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Inbasket name passed in - " + inbasketName);
    }
}

