/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8UserPreferencesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetUserPreferencesAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName;
        block8: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            MessageResources messageResources = this.getResources(request);
            request.setCharacterEncoding("UTF-8");
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
            String mode = request.getParameter("mode");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "mode = " + mode);
            P8UserPreferencesMediator userPreferencesMediator = (P8UserPreferencesMediator)this.getMediator(request);
            try {
                VWSession vwSession;
                block9: {
                    JSONObject preferencesJsonObject;
                    VWUserInfo userInfo;
                    block10: {
                        String preferredLocaleName;
                        block11: {
                            P8Connection connection = this.getConnection(request);
                            vwSession = P8Workflow.getVWSession(connection, request);
                            userInfo = vwSession.fetchCurrentUserInfo();
                            if (userInfo != null) {
                                userPreferencesMediator.setUserInfo(userInfo);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Retrieve user information: name = " + userInfo.getName());
                            }
                            if (mode == null || !mode.equals("save")) break block9;
                            userPreferencesMediator.setMode(mode);
                            preferencesJsonObject = (JSONObject)request.getAttribute("json_post");
                            String emailAddress = (String)preferencesJsonObject.get("emailAddress");
                            if (emailAddress != null) {
                                userInfo.setEMailAddress(emailAddress);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Retrieve user information: email = " + emailAddress);
                            } else {
                                userInfo.setEMailAddress("");
                            }
                            preferredLocaleName = (String)preferencesJsonObject.get("preferredLocale");
                            if (preferredLocaleName == null) break block10;
                            String useServerDefault = messageResources.getMessage(userPreferencesMediator.getLocale(), "process.user.info.server.locale");
                            if (!preferredLocaleName.equals(useServerDefault)) break block11;
                            Locale serverLocale = vwSession.fetchServerLocale();
                            if (serverLocale == null) break block10;
                            userInfo.setPreferredLocale(serverLocale);
                            break block10;
                        }
                        Locale[] supportedLocales = vwSession.fetchAvailableLocales();
                        for (int i = 0; i < supportedLocales.length; ++i) {
                            Locale supportedLocale = supportedLocales[i];
                            if (!supportedLocale.getDisplayName().equals(preferredLocaleName)) continue;
                            userInfo.setPreferredLocale(supportedLocale);
                            break;
                        }
                    }
                    this.setNotificationFlag(userInfo, 1, (Boolean)preferencesJsonObject.get("stepNewAssignment"));
                    this.setNotificationFlag(userInfo, 2, (Boolean)preferencesJsonObject.get("expiredStepDeadline"));
                    this.setNotificationFlag(userInfo, 4, (Boolean)preferencesJsonObject.get("stepReminders"));
                    this.setNotificationFlag(userInfo, 512, (Boolean)preferencesJsonObject.get("stepMilestoneReached"));
                    this.setNotificationFlag(userInfo, 32, (Boolean)preferencesJsonObject.get("trackerNewAssignment"));
                    this.setNotificationFlag(userInfo, 64, (Boolean)preferencesJsonObject.get("trackerDeadlineReminders"));
                    this.setNotificationFlag(userInfo, 16, (Boolean)preferencesJsonObject.get("trackerDeadlineExpired"));
                    this.setNotificationFlag(userInfo, 8, (Boolean)preferencesJsonObject.get("trackerException"));
                    this.setNotificationFlag(userInfo, 128, (Boolean)preferencesJsonObject.get("trackerExpiredDeadline"));
                    this.setNotificationFlag(userInfo, 256, (Boolean)preferencesJsonObject.get("trackerMilestoneReached"));
                    String userName = (String)preferencesJsonObject.get("proxyUserShortName");
                    if (userName == null) {
                        userName = "";
                    }
                    userInfo.setProxyUserName(userName);
                    userInfo.save();
                    userPreferencesMediator.addMessage("process.pref.save.successful", new Object[0]);
                    break block8;
                }
                userPreferencesMediator.setVWSession(vwSession);
            }
            catch (VWException vwexc) {
                Logger.logError(P8UserPreferencesMediator.class, methodName, (ServletRequest)request, (Throwable)vwexc);
                userPreferencesMediator.addError("error.exception.general", vwexc.getMessage());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError(P8UserPreferencesMediator.class, methodName, (ServletRequest)request, (Throwable)e);
                userPreferencesMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    public boolean getNotificationFlag(VWUserInfo userInfo, int flag) {
        int flags = userInfo.getNotificationFlags();
        return (flags & flag) != 0;
    }

    public void setNotificationFlag(VWUserInfo userInfo, int flag, boolean value) throws Exception {
        int flags = userInfo.getNotificationFlags();
        if (value) {
            userInfo.setNotificationFlags(flags | flag);
        } else if ((flags & flag) != 0) {
            userInfo.setNotificationFlags(flags ^ flag);
        }
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8UserPreferencesMediator userPreferencesMediator = new P8UserPreferencesMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)userPreferencesMediator);
        return userPreferencesMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String strJsonFormData = this.readJSON(request);
        if (strJsonFormData != null) {
            JSONObject jsonObject = JSONObject.parse(strJsonFormData);
            request.setAttribute("json_post", (Object)jsonObject);
        }
    }
}

