/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8TrackerMilestonesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Workflow;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import java.net.URLDecoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetTrackerMilestonesAction
extends P8BaseAction {
    private int milestoneLevel = 99;

    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        request.setCharacterEncoding("UTF-8");
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String queueName = request.getParameter("queue_name");
        String decodedQueueName = null;
        if (queueName != null) {
            decodedQueueName = URLDecoder.decode(queueName, "UTF-8");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "queueName = " + decodedQueueName);
        }
        String wobNum = request.getParameter("wob_num");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "wobNum = " + wobNum);
        String workSpaceId = request.getParameter("work_space_id");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workSpaceId = " + workSpaceId);
        String workClassId = request.getParameter("work_class_id");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workClassId = " + workClassId);
        String workflowNumber = request.getParameter("workflow_number");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workflowNumber = " + workflowNumber);
        String requestedMilestoneLevel = request.getParameter("milestone_level");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "requestedMilestoneLevel = " + requestedMilestoneLevel);
        if (requestedMilestoneLevel != null) {
            try {
                this.milestoneLevel = Integer.parseInt(requestedMilestoneLevel);
                if (this.milestoneLevel < 0 || this.milestoneLevel > 99) {
                    this.milestoneLevel = 99;
                }
            }
            catch (Exception e) {
                this.milestoneLevel = 99;
            }
        }
        P8TrackerMilestonesMediator milestonesMediator = (P8TrackerMilestonesMediator)this.getMediator(request);
        try {
            P8Connection connection = this.getConnection(request);
            VWSession vwSession = P8Workflow.getVWSession(connection, request);
            VWProcess vwProcess = null;
            boolean lastOnly = false;
            boolean reachedOnly = false;
            if (wobNum != null && decodedQueueName != null) {
                VWStepElement stepElement = P8Workflow.getStepElement(request, wobNum);
                if (stepElement == null) {
                    stepElement = P8Workflow.getStepElement(request, resources, vwSession, decodedQueueName, wobNum);
                    P8Workflow.setStepElement(request, stepElement, wobNum);
                }
                vwProcess = stepElement.fetchProcess();
            } else {
                Integer workSpaceNumber = new Integer(workSpaceId);
                Integer workClassNumber = new Integer(workClassId);
                vwProcess = vwSession.fetchProcess(workSpaceNumber.intValue(), workClassNumber.intValue(), workflowNumber);
                String workClassName = vwProcess.getWorkClassName();
                milestonesMediator.setName(workClassName);
                lastOnly = true;
                reachedOnly = true;
            }
            VWMilestoneElement[] workflowMilestones = vwProcess.fetchFilteredWorkflowMilestones(this.milestoneLevel, lastOnly, reachedOnly);
            milestonesMediator.setWorkflowMilestones(workflowMilestones);
        }
        catch (VWException vwexc) {
            Logger.logError(P8GetTrackerMilestonesAction.class, methodName, (ServletRequest)request, (Throwable)vwexc);
            milestonesMediator.addError("error.exception.general", vwexc.getMessage());
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8GetTrackerMilestonesAction.class, methodName, (ServletRequest)request, (Throwable)e);
            milestonesMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8TrackerMilestonesMediator milestonesMediator = new P8TrackerMilestonesMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)milestonesMediator);
        return milestonesMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

