/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8StepProcessorInformationMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Exception;
import com.ibm.ecm.util.p8.P8Workflow;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWUserInfo;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetStepProcessorInformationAction
extends P8BaseAction {
    private static final int PREFS_CURRENT = 0;
    private static final int PREFS_USER = 1;
    private static final int PREFS_REGION = 2;
    private static final int PREFS_SYSTEM = 3;
    private static final int PREFS_COUNT = 4;
    public static final String STEP = "step";
    public static final String LAUNCH = "launch";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        request.setCharacterEncoding("UTF-8");
        String stepType = request.getParameter("step_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "step_type = " + stepType);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String useApplicationBaseUrl = request.getParameter("useApplicationBaseUrl");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "useApplicationBaseUrl = " + useApplicationBaseUrl);
        P8StepProcessorInformationMediator stepProcessorInformationMediator = (P8StepProcessorInformationMediator)this.getMediator(request);
        try {
            P8Connection connection = this.getConnection(request);
            VWSession vwSession = P8Workflow.getVWSession(connection, request);
            VWStepProcessorInfo stepProcessorInfo = null;
            String vwVersion = null;
            String queueName = null;
            String decodedQueueName = null;
            String wobNum = null;
            String stepId = null;
            String stepName = null;
            int processorType = 1;
            if (stepType != null && stepType.equals(LAUNCH)) {
                processorType = 0;
                String workClassName = request.getParameter("workClassName");
                if (workClassName != null && workClassName.length() > 0) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workClassName = " + workClassName);
                    stepProcessorInfo = vwSession.fetchLaunchStepProcessor(workClassName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "stepId = " + stepProcessorInfo.getId());
                    stepProcessorInformationMediator.setWorkClassName(workClassName);
                } else {
                    String objectStoreName = request.getParameter("object_store");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "objectStoreName = " + objectStoreName);
                    String docId = request.getParameter("docid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docId = " + docId);
                    String vsId = null;
                    if (docId == null) {
                        vsId = request.getParameter("vsId");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "vsId = " + vsId);
                    }
                    if ((vwVersion = P8Workflow.fetchWorkflowVersion(request, connection, objectStoreName, docId, vsId)) == null) throw new P8Exception("process.error.exception.nottransferred");
                    stepProcessorInfo = vwSession.fetchLaunchStepProcessor(vwVersion);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "stepId = " + stepProcessorInfo.getId());
                }
            } else {
                wobNum = request.getParameter("wob_num");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "wobNum = " + wobNum);
                queueName = request.getParameter("queue_name");
                decodedQueueName = URLDecoder.decode(queueName, "UTF-8");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "queueName = " + decodedQueueName);
                stepId = request.getParameter("step_id");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "stepId = " + stepId);
                stepName = request.getParameter("step_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "stepName = " + stepName);
                VWStepElement stepElement = P8Workflow.getStepElement(request, resources, vwSession, decodedQueueName, wobNum);
                P8Workflow.setStepElement(request, stepElement, wobNum);
                stepProcessorInfo = vwSession.fetchStepProcessorInfo(stepId);
            }
            if (stepProcessorInfo != null) {
                Integer[] webAppPrefs = new Integer[4];
                Hashtable settings = new Hashtable();
                String baseUrl = this.getBaseUrl(request);
                this.initializeOpenItemInfo(vwSession, webAppPrefs, settings, baseUrl, useApplicationBaseUrl);
                OpenItemInfo itemInfo = this.getOpenItemInfo(webAppPrefs, settings, stepProcessorInfo, processorType);
                if (itemInfo == null) throw new P8Exception("process.error.exception.taskfromanotherapp");
                String stepProcTemplate = null;
                if (processorType == 1) {
                    stepProcessorInformationMediator.setQueueName(decodedQueueName);
                    stepProcessorInformationMediator.setWobNum(wobNum);
                    stepProcessorInformationMediator.setStepName(stepName);
                    stepProcessorInformationMediator.setStepId(stepId);
                    stepProcTemplate = itemInfo.getSpUrlTemplate();
                } else {
                    stepProcessorInformationMediator.setVWVersion(vwVersion);
                    stepProcTemplate = itemInfo.getLspUrlTemplate();
                }
                String stepProcLocation = stepProcessorInfo.getLocation(itemInfo.getWebAppId());
                String stepProcBaseUrl = itemInfo.getBaseURL();
                stepProcessorInformationMediator.setStepTemplate(stepProcTemplate);
                stepProcessorInformationMediator.setStepLocation(stepProcLocation);
                stepProcessorInformationMediator.setStepBaseUrl(stepProcBaseUrl);
                stepProcessorInformationMediator.setStepHeight(stepProcessorInfo.getHeight());
                stepProcessorInformationMediator.setStepWidth(stepProcessorInfo.getWidth());
                stepProcessorInformationMediator.addMessage("process.step.opened.successful", new Object[0]);
            }
        }
        catch (VWException vwexc) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8GetStepProcessorInformationAction.class, methodName, (ServletRequest)request, (Throwable)vwexc);
            stepProcessorInformationMediator.addError("error.exception.general", vwexc.getMessage());
        }
        catch (P8Exception p8e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8GetStepProcessorInformationAction.class, methodName, (ServletRequest)request, (Throwable)p8e);
            stepProcessorInformationMediator.addError(p8e.getMessageKey(), p8e.getMessageParameters());
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8GetStepProcessorInformationAction.class, methodName, (ServletRequest)request, (Throwable)e);
            stepProcessorInformationMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private OpenItemInfo getOpenItemInfo(Integer[] webAppPrefs, Hashtable settings, VWStepProcessorInfo stepProcInfo, int type) throws Exception {
        String location;
        OpenItemInfo itemInfo;
        String methodName = "getOpenItemInfo";
        for (int index = 0; index < webAppPrefs.length; ++index) {
            Integer key = webAppPrefs[index];
            if (key == null || (itemInfo = (OpenItemInfo)settings.get(key)) == null) continue;
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "index = " + index + ", key = " + key + ", webAppId = " + itemInfo.getWebAppId() + ", itemInfo.baseURL = " + itemInfo.baseURL);
            if (!itemInfo.isValid(type)) continue;
            location = stepProcInfo.getLocation(itemInfo.getWebAppId());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "key = " + key + ", itemInfo.location = " + location);
            if (location == null || location.length() <= 0) continue;
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    Found itemInfo: LspUrlTemplate = " + itemInfo.getLspUrlTemplate());
            return itemInfo;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Did not find a valid itemInfo in preferences, looking at entire list");
        Enumeration keys = settings.keys();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                itemInfo = (OpenItemInfo)settings.get(keys.nextElement());
                if (itemInfo == null) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "webAppId = " + itemInfo.getWebAppId() + ", itemInfo.baseURL = " + itemInfo.baseURL);
                if (!itemInfo.isValid(type)) continue;
                location = stepProcInfo.getLocation(itemInfo.getWebAppId());
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    itemInfo.location = " + location);
                if (location == null || location.length() <= 0) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    Found itemInfo: LspUrlTemplate = " + itemInfo.getLspUrlTemplate());
                return itemInfo;
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Did not find any itemInfo objects that matched (or were valid with a proper location)");
        return null;
    }

    private void initializeOpenItemInfo(VWSession vwSession, Integer[] webAppPrefs, Hashtable settings, String baseUrl, String useApplicationBaseUrl) throws Exception {
        String methodName = "initializeOpenItemInfo";
        VWUserInfo userInfo = vwSession.fetchCurrentUserInfo();
        if (userInfo != null) {
            Object value = userInfo.getFieldValue("F_WebApp");
            this.setWebAppId(webAppPrefs, 1, value);
        }
        this.initializeUsingAttributes(vwSession, 1, webAppPrefs, settings);
        this.initializeUsingAttributes(vwSession, 2, webAppPrefs, settings);
        Integer webAppId = new Integer(vwSession.getDefaultWebApplication());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Default webAppId = " + webAppId);
        OpenItemInfo itemInfo = (OpenItemInfo)settings.get(webAppId);
        if (itemInfo != null) {
            if (useApplicationBaseUrl != null && useApplicationBaseUrl.equals("true")) {
                if (baseUrl != null && baseUrl.length() > 0) {
                    itemInfo.setBaseURL(baseUrl);
                }
            } else {
                String itemInfoBaseUrl = itemInfo.getBaseURL();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "itemInfo: itemInfoBaseUrl = " + itemInfoBaseUrl);
                if ((itemInfoBaseUrl == null || itemInfoBaseUrl.length() == 0) && baseUrl != null && baseUrl.length() > 0) {
                    itemInfo.setBaseURL(baseUrl);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "itemInfo: baseURL = " + baseUrl);
                }
            }
            this.setWebAppId(webAppPrefs, 0, webAppId);
        }
    }

    private void setWebAppId(Integer[] webAppPrefs, int index, Object value) throws Exception {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            if (strValue.length() > 0) {
                try {
                    int webAppId = Integer.parseInt(strValue);
                    if (webAppId != -1) {
                        webAppPrefs[index] = new Integer(webAppId);
                    }
                }
                catch (NumberFormatException ex) {}
            }
        } else if (value instanceof Integer) {
            webAppPrefs[index] = (Integer)value;
        }
    }

    private void initializeUsingAttributes(VWSession vwSession, int type, Integer[] webAppPrefs, Hashtable settings) throws Exception {
        String[] names;
        String methodName = "initializeUsingAttributes";
        VWAttributeInfo vwAttributeInfo = vwSession.fetchAttributes(type);
        if (vwAttributeInfo != null && (names = vwAttributeInfo.getAttributeNames()) != null) {
            for (int index = 0; index < names.length; ++index) {
                String name = names[index];
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Processing name = " + name);
                if (name.startsWith("F_WebApp")) {
                    if (type == 2) {
                        this.setWebAppId(webAppPrefs, 2, vwAttributeInfo.getFieldValue(name));
                        continue;
                    }
                    this.setWebAppId(webAppPrefs, 3, vwAttributeInfo.getFieldValue(name));
                    continue;
                }
                OpenItemInfo itemInfo = null;
                Integer webAppId = this.getIdFromKey(name);
                if (webAppId == null) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "webAppId = " + webAppId);
                if (!settings.containsKey(webAppId)) {
                    itemInfo = new OpenItemInfo(webAppId);
                    settings.put(webAppId, itemInfo);
                }
                if ((itemInfo = (OpenItemInfo)settings.get(webAppId)) == null) continue;
                if (name.startsWith("F_WebServer")) {
                    itemInfo.setBaseURL((String)vwAttributeInfo.getFieldValue(name));
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "webAppId = " + webAppId + ", itemInfo.baseURL = " + itemInfo.getBaseURL());
                    continue;
                }
                if (name.startsWith("F_LSPTemplate")) {
                    itemInfo.setLspUrlTemplate((String)vwAttributeInfo.getFieldValue(name));
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "webAppId = " + webAppId + ", itemInfo.LspUrlTemplate = " + itemInfo.getLspUrlTemplate());
                    continue;
                }
                if (!name.startsWith("F_SPTemplate")) continue;
                itemInfo.setSpUrlTemplate((String)vwAttributeInfo.getFieldValue(name));
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "webAppId = " + webAppId + ", itemInfo.SpUrlTemplate = " + itemInfo.getSpUrlTemplate());
            }
        }
    }

    private Integer getIdFromKey(String key) throws Exception {
        StringTokenizer st;
        if (key != null && key.length() > 0 && (st = new StringTokenizer(key, ".")).hasMoreTokens()) {
            String token = st.nextToken();
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                return Integer.valueOf(token);
            }
        }
        return null;
    }

    private String getBaseUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        String scheme = request.getScheme();
        String sPort = "";
        int port = request.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            sPort = String.valueOf(port);
            url.append(':');
            url.append(sPort);
        }
        try {
            String requestURI = request.getRequestURI();
            int end = requestURI.indexOf(47, 1);
            String contextRoot = requestURI.substring(0, end);
            url.append(contextRoot);
        }
        catch (Exception e) {
            url.append("/navigator");
        }
        return url.toString();
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8StepProcessorInformationMediator stepProcessorInformationMediator = new P8StepProcessorInformationMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)stepProcessorInformationMediator);
        return stepProcessorInformationMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    public class OpenItemInfo {
        public static final int TYPE_LAUNCH = 0;
        public static final int TYPE_STEP = 1;
        private static final String PROTOCOL_HTTP = "http://";
        private static final String PROTOCOL_HTTPS = "https://";
        private static final int PROCESSOR_LAUNCH_DEFAULT = 1;
        private static final int PROCESSOR_STEP_DEFAULT = 2;
        private static final int PROCESSOR_LAUNCH = 4;
        private static final int PROCESSOR_STEP = 8;
        private static final int APP_TYPE_URL = 32;
        private static final int APP_TYPE_JAVA = 64;
        private String baseURL = null;
        private String lspUrlTemplate = null;
        private String spUrlTemplate = null;
        private int webAppId = -1;

        public OpenItemInfo(int webAppId) {
            this.webAppId = webAppId;
        }

        public String getBaseURL() {
            return this.baseURL;
        }

        public void setBaseURL(String baseURL) {
            if (baseURL != null && baseURL.length() > 0) {
                this.baseURL = baseURL.trim();
                if (!this.baseURL.startsWith(PROTOCOL_HTTP) && !this.baseURL.startsWith(PROTOCOL_HTTPS)) {
                    this.baseURL = PROTOCOL_HTTP + this.baseURL;
                }
                if (this.baseURL.endsWith("\"")) {
                    this.baseURL = this.baseURL.substring(0, this.baseURL.length() - 1);
                }
            }
        }

        public String getLspUrlTemplate() {
            return this.lspUrlTemplate;
        }

        public void setLspUrlTemplate(String urlTemplate) {
            this.lspUrlTemplate = urlTemplate.trim();
        }

        public String getSpUrlTemplate() {
            return this.spUrlTemplate;
        }

        public void setSpUrlTemplate(String urlTemplate) {
            this.spUrlTemplate = urlTemplate.trim();
        }

        public int getWebAppId() {
            return this.webAppId;
        }

        public boolean isValid(int type) {
            String methodName = "isValid";
            if (this.baseURL == null || this.baseURL.length() <= PROTOCOL_HTTP.length()) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)P8GetStepProcessorInformationAction.this.request, "    Not valid; baseURL = " + this.baseURL);
                return false;
            }
            if (type == 0) {
                if (this.lspUrlTemplate == null || this.lspUrlTemplate.length() == 0) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)P8GetStepProcessorInformationAction.this.request, "    Not valid; lspUrlTemplate = " + this.lspUrlTemplate);
                    return false;
                }
            } else if (this.spUrlTemplate == null || this.spUrlTemplate.length() == 0) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)P8GetStepProcessorInformationAction.this.request, "    Not valid; spUrlTemplate = " + this.spUrlTemplate);
                return false;
            }
            if (this.webAppId < 0 || this.webAppId > 999) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)P8GetStepProcessorInformationAction.this.request, "    Not valid; webAppId = " + this.webAppId);
                return false;
            }
            return true;
        }

        public String processorTypeToString(int processorType) {
            String retVal = (processorType & 4) == 4 || (processorType & 1) == 1 ? "Launch" : ((processorType & 8) == 8 || (processorType & 2) == 2 ? "Step" : "");
            return retVal;
        }

        public String appTypeToString(int appType) {
            String retVal = (appType & 0x20) == 32 ? "HTML" : ((appType & 0x40) == 64 ? "Java" : "");
            return retVal;
        }
    }
}

