/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.Attachment;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Workflow;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetStepAttachmentItemsAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        request.setCharacterEncoding("UTF-8");
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String queueName = request.getParameter("queue_name");
        String decodedQueueName = URLDecoder.decode(queueName, "UTF-8");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "queueName = " + decodedQueueName);
        String wobNum = request.getParameter("wob_num");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "wobNum = " + wobNum);
        String parameterName = request.getParameter("step_parameter");
        String decodedParameterName = URLDecoder.decode(parameterName, "UTF-8");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parameterName = " + decodedParameterName);
        String filterType = request.getParameter("filter_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "filterType = " + filterType);
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        try {
            P8Connection connection = this.getConnection(request);
            VWSession vwSession = P8Workflow.getVWSession(connection, request);
            VWStepElement stepElement = P8Workflow.getStepElement(request, wobNum);
            if (stepElement == null) {
                if (decodedQueueName == null || decodedQueueName.length() == 0) {
                    String launchVersion = request.getParameter("launch_version");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "launchVersion = " + launchVersion);
                    String attachmentId = request.getParameter("attachmentId");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attachmentId = " + attachmentId);
                    stepElement = P8Workflow.createStepElement(request, vwSession, launchVersion, attachmentId);
                    if (stepElement != null) {
                        P8Workflow.setStepElement(request, stepElement, stepElement.getWorkObjectNumber());
                        searchResultsMediator.setParentDocID(stepElement.getWorkObjectNumber());
                    }
                } else {
                    stepElement = P8Workflow.getStepElement(request, resources, vwSession, decodedQueueName, wobNum);
                    P8Workflow.setStepElement(request, stepElement, wobNum);
                }
            }
            VWParameter parameter = stepElement.getParameter(decodedParameterName);
            VWAttachment[] attachments = (VWAttachment[])P8Workflow.getValue(parameter);
            DesktopConfig desktopConfig = Config.getDesktopConfig(request);
            boolean foldersOnly = false;
            if (filterType != null && filterType.equals("folderSearch")) {
                foldersOnly = true;
            }
            ArrayList<Object> hits = new ArrayList<Object>();
            for (int i = 0; i < attachments.length; ++i) {
                VWAttachment attachment = attachments[i];
                if (attachment == null || attachment.getId() == null && attachment.getVersion() == null || foldersOnly && attachment.getType() != 2) continue;
                String objectStoreName = attachment.getLibraryName();
                if (P8Workflow.getRepositoryId(desktopConfig, repositoryId, objectStoreName) != null) {
                    IndependentlyPersistableObject object = P8Workflow.getPersistableObject(request, connection, attachment);
                    if (object != null) {
                        hits.add(object);
                        ClassDescription classDescription = object.get_ClassDescription();
                        searchResultsMediator.addClassDescription(classDescription);
                        continue;
                    }
                    Attachment p8Attachment = this.createAttachment(request, attachment);
                    hits.add(p8Attachment);
                    continue;
                }
                Attachment p8Attachment = this.createAttachment(request, attachment);
                hits.add(p8Attachment);
            }
            ClassDescription classDescription = searchResultsMediator.getClassDescription();
            if (classDescription == null) {
                classDescription = Factory.ClassDescription.fetchInstance((Scope)connection.getObjectStore(), (String)"Document", null);
                searchResultsMediator.addClassDescription(classDescription);
            }
            P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
            searchResultsBean.setHits(hits);
            searchResultsMediator.setServer(connection);
            searchResultsMediator.setPageSize(this.pageSize);
            searchResultsMediator.setAddColumnSorting(false);
            searchResultsMediator.setNameColumnWidth("20em");
            RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
            if (repositoryConfig != null) {
                String folderNameProperty;
                String docNameProperty;
                String[] folderDefaultColumns = repositoryConfig.getFolderDefaultColumns();
                if (folderDefaultColumns != null && (folderDefaultColumns.length > 1 || folderDefaultColumns.length == 1 && folderDefaultColumns[0] != null && folderDefaultColumns[0].length() > 0)) {
                    searchResultsMediator.setDisplayColumns(folderDefaultColumns);
                }
                if ((docNameProperty = repositoryConfig.getDocNameProperty()) != null && docNameProperty.length() > 0) {
                    searchResultsMediator.setDocNameProperty(docNameProperty);
                }
                if ((folderNameProperty = repositoryConfig.getFolderNameProperty()) != null && folderNameProperty.length() > 0) {
                    searchResultsMediator.setFolderNameProperty(folderNameProperty);
                }
            }
            searchResultsMediator.setSearchResultsBean(searchResultsBean);
        }
        catch (VWException vwexc) {
            Logger.logError(P8GetStepAttachmentItemsAction.class, methodName, (ServletRequest)request, (Throwable)vwexc);
            searchResultsMediator.addError("error.exception.general", vwexc.getMessage());
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8GetStepAttachmentItemsAction.class, methodName, (ServletRequest)request, (Throwable)e);
            searchResultsMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private Attachment createAttachment(HttpServletRequest request, VWAttachment attachment) {
        Attachment p8Attachment = null;
        String name = attachment.getAttachmentName();
        String objectType = "document";
        if (attachment.getType() == 2) {
            objectType = "folder";
        }
        String objectStoreName = attachment.getLibraryName();
        String id = attachment.getId();
        String version = attachment.getVersion();
        p8Attachment = new Attachment(request, name, objectType, objectStoreName, id, version);
        return p8Attachment;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator searchResultsMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)searchResultsMediator);
        return searchResultsMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

