/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.filenet.api.collection.BooleanList;
import com.filenet.api.collection.DateTimeList;
import com.filenet.api.collection.Float64List;
import com.filenet.api.collection.Integer32List;
import com.filenet.api.collection.StringList;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.property.Properties;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8StepElementMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.EncodingUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Exception;
import com.ibm.ecm.util.p8.P8Workflow;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkflowDefinition;
import java.net.URLDecoder;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetLaunchParametersAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName;
        block18: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            MessageResources resources = this.getResources(request);
            request.setCharacterEncoding("UTF-8");
            String repositoryId = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
            String docId = request.getParameter("docid");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docId = " + docId);
            boolean requireLabelDecoding = false;
            String launchVersion = request.getParameter("launch_version");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "launchVersion = " + launchVersion);
            String decodedLaunchVersion = null;
            if (launchVersion != null && launchVersion.length() > 0) {
                String encodedTab = EncodingUtil.encodeLabel("\t");
                if (launchVersion.contains(encodedTab)) {
                    requireLabelDecoding = true;
                }
                decodedLaunchVersion = this.decodeParameter(launchVersion, requireLabelDecoding);
            }
            String workClassName = request.getParameter("workClassName");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workClassName = " + workClassName);
            String decodedWorkClassName = null;
            if (workClassName != null && workClassName.length() > 0) {
                decodedWorkClassName = this.decodeParameter(workClassName, false);
            }
            String attachmentId = request.getParameter("attachmentId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attachmentId = " + attachmentId);
            String propertyMap = request.getParameter("propertyMap");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "propertyMap = " + propertyMap);
            String mode = request.getParameter("mode");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "mode = " + mode);
            P8StepElementMediator launchParametersMediator = (P8StepElementMediator)this.getMediator(request);
            try {
                P8Connection connection = this.getConnection(request);
                VWSession vwSession = P8Workflow.getVWSession(connection, request);
                boolean validIdentifier = true;
                if (decodedLaunchVersion != null) {
                    validIdentifier = vwSession.checkWorkflowIdentifier(decodedLaunchVersion);
                } else if (decodedWorkClassName != null) {
                    decodedLaunchVersion = decodedWorkClassName;
                }
                if (validIdentifier) {
                    VWStepElement stepElement = vwSession.createWorkflow(decodedLaunchVersion);
                    if (stepElement != null) {
                        P8Workflow.setStepElement(request, stepElement, stepElement.getWorkObjectNumber());
                    }
                    launchParametersMediator.setStepElement(stepElement);
                    launchParametersMediator.setRepositoryId(repositoryId);
                    launchParametersMediator.setMode(mode);
                    if (mode != null && mode.equals("et")) {
                        VWWorkflowDefinition workflowDefinition = vwSession.fetchWorkflowDefinition(-1, decodedLaunchVersion, false);
                        launchParametersMediator.setWorkflowDefinition(workflowDefinition);
                    }
                    String mainAttachmentParameterName = null;
                    try {
                        mainAttachmentParameterName = (String)stepElement.getParameterValue("F_MAINATTACHMENT");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (mainAttachmentParameterName != null && attachmentId != null && attachmentId.length() > 0) {
                        String decodedAttachmentId = this.decodeParameter(attachmentId, requireLabelDecoding);
                        VWAttachment mainAttachment = P8Workflow.createAttachment(request, decodedAttachmentId);
                        VWParameter mainAttachmentParameter = stepElement.getParameter(mainAttachmentParameterName);
                        if (mainAttachmentParameter != null) {
                            P8Workflow.addMainAttachment(request, stepElement, mainAttachmentParameter, mainAttachment, mainAttachmentParameterName);
                        }
                        if (propertyMap != null) {
                            String decodedPropertyMap = this.decodeParameter(propertyMap, requireLabelDecoding);
                            IndependentlyPersistableObject item = P8Workflow.getPersistableObject(request, connection, mainAttachment);
                            this.processPropertyMap(stepElement, decodedPropertyMap, item);
                        }
                    }
                    break block18;
                }
                throw new P8Exception("process.error.exception.invalidversion");
            }
            catch (VWException vwexc) {
                Logger.logError(P8GetLaunchParametersAction.class, methodName, (ServletRequest)request, (Throwable)vwexc);
                launchParametersMediator.addError("error.exception.general", vwexc.getMessage());
            }
            catch (P8Exception p8e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError(P8GetLaunchParametersAction.class, methodName, (ServletRequest)request, (Throwable)p8e);
                launchParametersMediator.addError(p8e.getMessageKey(), p8e.getMessageParameters());
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError(P8GetLaunchParametersAction.class, methodName, (ServletRequest)request, (Throwable)e);
                launchParametersMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private String decodeParameter(String parameter, boolean requireLabelDecoding) throws Exception {
        String decodedParameter = null;
        decodedParameter = requireLabelDecoding ? EncodingUtil.decodeLabel(parameter) : URLDecoder.decode(parameter, "UTF-8");
        return decodedParameter;
    }

    private void processPropertyMap(VWStepElement stepElement, String properties, IndependentlyPersistableObject item) throws Exception {
        Properties itemProperties = item.getProperties();
        StringTokenizer pt = new StringTokenizer(properties, ",");
        while (pt.hasMoreTokens()) {
            String itemMap = pt.nextToken();
            String dataFieldName = itemMap.substring(0, itemMap.indexOf(61));
            String propertyName = itemMap.substring(itemMap.indexOf(61) + 1, itemMap.length());
            Object value = itemProperties.getObjectValue(propertyName);
            if (value instanceof String) {
                stepElement.setParameterValue(dataFieldName, value, true);
                continue;
            }
            if (value instanceof StringList) {
                stepElement.setParameterValue(dataFieldName, (Object)((StringList)value).toArray(), true);
                continue;
            }
            if (value instanceof Integer) {
                stepElement.setParameterValue(dataFieldName, value, true);
                continue;
            }
            if (value instanceof Integer32List) {
                stepElement.setParameterValue(dataFieldName, (Object)((Integer32List)value).toArray(), true);
                continue;
            }
            if (value instanceof Double) {
                stepElement.setParameterValue(dataFieldName, value, true);
                continue;
            }
            if (value instanceof Float64List) {
                stepElement.setParameterValue(dataFieldName, (Object)((Float64List)value).toArray(), true);
                continue;
            }
            if (value instanceof Boolean) {
                stepElement.setParameterValue(dataFieldName, value, true);
                continue;
            }
            if (value instanceof BooleanList) {
                stepElement.setParameterValue(dataFieldName, (Object)((BooleanList)value).toArray(), true);
                continue;
            }
            if (value instanceof Date) {
                stepElement.setParameterValue(dataFieldName, value, true);
                continue;
            }
            if (!(value instanceof DateTimeList)) continue;
            stepElement.setParameterValue(dataFieldName, (Object)((DateTimeList)value).toArray(), true);
        }
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8StepElementMediator launchParametersMediator = new P8StepElementMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)launchParametersMediator);
        return launchParametersMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

