/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8WorkItemsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.struts.actions.p8.workflow.P8GetWorkItemsAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8GetInboxWorkItemsAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        this.getConfigInfo(request);
        ActionForward actionForward = null;
        P8WorkItemsMediator workItemsMediator = (P8WorkItemsMediator)this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String queueName = request.getParameter("queue_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "queueName = " + queueName);
        if (queueName == null || queueName.length() == 0) {
            queueName = "Inbox";
        }
        String filterString = request.getParameter("filter_criteria");
        String queryFilter = null;
        try {
            P8Connection connection = this.getConnection(request);
            VWSession vwSession = P8Workflow.getVWSession(connection, request);
            VWQueue vwQueue = vwSession.getQueue(queueName);
            Object[] minValue = null;
            Object[] maxValue = null;
            int queryflags = 5;
            int fetchtype = 3;
            if (filterString != null && filterString.length() > 0) {
                String[] filter_names = null;
                String[] substitution_vars = null;
                String decodedFilterString = URLDecoder.decode(filterString, "UTF-8");
                JSONObject filters = (JSONObject)JSON.parse(decodedFilterString);
                JSONArray filterArray = (JSONArray)filters.get("filters");
                if (filterArray != null) {
                    Iterator i = filterArray.iterator();
                    filter_names = new String[filterArray.size()];
                    substitution_vars = new String[filterArray.size()];
                    for (int j = 0; j < filterArray.size(); ++j) {
                        JSONObject filterJSON = (JSONObject)i.next();
                        filter_names[j] = (String)filterJSON.get("name");
                        substitution_vars[j] = (String)filterJSON.get("value");
                    }
                    for (int k = 0; k < filter_names.length; ++k) {
                        String name = filter_names[k];
                        String value = substitution_vars[k];
                        if (name == null || value == null) continue;
                        queryFilter = name + " = '" + value + "'";
                        if (k >= filter_names.length - 1) continue;
                        queryFilter = queryFilter + " AND ";
                    }
                }
            }
            VWQueueQuery vwQueueQuery = vwQueue.createQuery("PWDefaultOrder", minValue, maxValue, queryflags, queryFilter, null, fetchtype);
            int totalCount = 0;
            int maxCount = 1000;
            ArrayList<VWQueueElement> hits = new ArrayList<VWQueueElement>();
            while (vwQueueQuery.hasNext() && totalCount < maxCount) {
                VWQueueElement vwQueueElement = (VWQueueElement)vwQueueQuery.next();
                if (vwQueueElement == null) continue;
                hits.add(vwQueueElement);
                ++totalCount;
            }
            int fetchCount = vwQueueQuery.fetchCount();
            workItemsMediator.setFetchCount(fetchCount);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Queue query fetch count:" + fetchCount);
            if (totalCount > 0) {
                VWQueueElement[] objects = hits.toArray(new VWQueueElement[0]);
                workItemsMediator.setQueueElements(objects);
                workItemsMediator.setPageSize(this.pageSize);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " after adding search results to session.");
                workItemsMediator.addMessage("search.results.returned.workItems", hits.size());
            } else {
                workItemsMediator.addMessage("search.results.returned.workItems", 0);
            }
            workItemsMediator.setRepositoryId(repositoryId);
        }
        catch (VWException vwexc) {
            Logger.logError(P8GetWorkItemsAction.class, methodName, (ServletRequest)request, (Throwable)vwexc);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8WorkItemsMediator workItemsMediator = new P8WorkItemsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)workItemsMediator);
        return workItemsMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

