/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8.workflow;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.workflow.P8CompleteStepMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8EntryTemplateWorkflow;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8CompleteStepAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        request.setCharacterEncoding("UTF-8");
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        String queueName = request.getParameter("queue_name");
        String decodedQueueName = URLDecoder.decode(queueName, "UTF-8");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "queueName = " + decodedQueueName);
        String wobNum = request.getParameter("wob_num");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "wobNum = " + wobNum);
        String dispatch = request.getParameter("step_dispatch");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "dispatch = " + dispatch);
        String criterias = request.getParameter("criterias");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criterias = " + criterias);
        P8CompleteStepMediator completeStepMediator = (P8CompleteStepMediator)this.getMediator(request);
        try {
            String attachmentId;
            P8Connection connection = this.getConnection(request);
            VWSession vwSession = P8Workflow.getVWSession(connection, request);
            VWStepElement stepElement = P8Workflow.getStepElement(request, wobNum);
            if (stepElement == null) {
                if (decodedQueueName == null || decodedQueueName.length() == 0) {
                    String launchVersion = request.getParameter("launch_version");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "launchVersion = " + launchVersion);
                    attachmentId = request.getParameter("attachmentId");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attachmentId = " + attachmentId);
                    stepElement = P8Workflow.createStepElement(request, vwSession, launchVersion, attachmentId);
                } else {
                    stepElement = P8Workflow.getStepElement(request, resources, vwSession, decodedQueueName, wobNum);
                    completeStepMediator.setParentWobNum(stepElement.getWorkObjectName());
                    stepElement.doLock(true);
                }
            }
            JSONArray criteriasJsonArray = (JSONArray)request.getAttribute("json_post");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criteriasJsonArray.length: " + criteriasJsonArray.size());
            attachmentId = null;
            for (int index = 0; index < criteriasJsonArray.size(); ++index) {
                JSONObject criteria = (JSONObject)criteriasJsonArray.get(index);
                String criteriaName = criteria.get("name").toString();
                JSONArray criteriaValues = null;
                if (criteria.get("value") != null) {
                    if (criteria.get("value") instanceof JSONArray) {
                        criteriaValues = (JSONArray)criteria.get("value");
                    } else {
                        criteriaValues = new JSONArray();
                        criteriaValues.add(criteria.get("value").toString());
                    }
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Update field: name=" + criteriaName + " values=" + criteriaValues);
                VWParameter dataField = stepElement.getParameter(criteriaName);
                if ((dataField == null || dataField.isSystemParameter()) && criteriaName.equals("F_AttachmentId")) {
                    attachmentId = (String)criteriaValues.get(0);
                    continue;
                }
                P8Workflow.setParameter(request, connection, stepElement, dataField, criteriaName, criteriaValues);
            }
            try {
                VWAttachment tempAttachment;
                if (dispatch != null && dispatch.equals("true")) {
                    stepElement.doDispatch();
                } else {
                    stepElement.doSave(true);
                }
                if (attachmentId != null && (tempAttachment = P8Workflow.createAttachment(request, URLDecoder.decode(attachmentId, "UTF-8"))).getType() == 3) {
                    String workflowNumber = stepElement.getWorkflowNumber();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Update Entry Template Workflow Number: attachmentId=" + attachmentId + " workflowNumber=" + workflowNumber);
                    P8EntryTemplateWorkflow.saveWorkflowNumber(request, connection, tempAttachment.getLibraryName(), null, tempAttachment.getId(), workflowNumber);
                }
                P8Workflow.setStepElement(request, null, wobNum);
                completeStepMediator.addMessage("process.step.completed.successful", new Object[0]);
            }
            catch (VWException vwe) {
                String message;
                String messageKey = vwe.getKey();
                if (messageKey.equals("filenet.pe.peorb.serverException")) {
                    message = resources.getMessage(request.getLocale(), "process.step.requires.response");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, message);
                    completeStepMediator.addError("process.step.requires.response");
                }
                message = resources.getMessage(request.getLocale(), "process.error.exception.system");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, message);
                completeStepMediator.addError("process.error.exception.system");
            }
            completeStepMediator.setStepElement(stepElement);
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8CompleteStepAction.class, methodName, (ServletRequest)request, (Throwable)e);
            completeStepMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8CompleteStepMediator completeStepMediator = new P8CompleteStepMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)completeStepMediator);
        return completeStepMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String strJsonFormData = this.readJSON(request);
        JSONArray jsonArray = JSONArray.parse(strJsonFormData);
        request.setAttribute("json_post", (Object)jsonArray);
    }
}

