/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8SearchTemplateDocument;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8UpdateSearchTemplateAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection ceConnection;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        P8SearchResultsMediator mediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection connection2 = ceConnection = connection.getCEConnection();
        synchronized (connection2) {
            try {
                Document checkedOutDoc;
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                String docId = request.getParameter("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docId = " + docId);
                String str = this.readJSON(request);
                JSONObject json = (JSONObject)JSON.parse(str);
                String name = (String)json.get("name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "name = " + name);
                String description = (String)json.get("description");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description = " + description);
                P8SearchTemplateDocument searchDocument = new P8SearchTemplateDocument(request, connection, docId, null, null);
                try {
                    checkedOutDoc = searchDocument.save(name, description, json);
                }
                catch (IllegalAccessException e) {
                    mediator.addError("checkin.error.noMajorVersionPermission", null);
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                if (checkedOutDoc == null) {
                    mediator.addError("checkin.error.notCheckedOut", null);
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                checkedOutDoc.checkout(ReservationType.OBJECT_STORE_DEFAULT, null, null, null);
                checkedOutDoc.save(RefreshMode.REFRESH);
                ObjectStore objStore = connection.getObjectStore();
                ClassDescription classDescription = Factory.ClassDescription.fetchInstance((Scope)objStore, (String)"StoredSearch", null);
                mediator.setServer(connection);
                mediator.setServerName(serverName);
                mediator.addClassDescription(classDescription);
                ArrayList<Document> hits = new ArrayList<Document>(1);
                HashMap<String, String> updatedDocIds = new HashMap<String, String>(1);
                updatedDocIds.put(P8Util.getDocId(checkedOutDoc.getObjectReference()), docId);
                mediator.setUpdatedDocIds(updatedDocIds);
                hits.add(checkedOutDoc);
                P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                searchResultsBean.setHits(hits);
                mediator.setSearchResultsBean(searchResultsBean);
                mediator.addMessage("checkinDocument.success", new Object[0]);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

