/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Document;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8AnnotationExporter;
import com.ibm.ecm.util.p8.P8AnnotationImporter;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8DocID;
import com.ibm.ecm.util.p8.P8Util;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8UpdateAnnotationsAction
extends P8BaseAction {
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        try {
            HttpSession session = request.getSession(false);
            P8Connection connection = null;
            BaseMediator mediator = this.getMediator(request);
            MessageResources messages = mediator.getMessageResources();
            Locale locale = mediator.getLocale();
            P8AnnotationExporter.initialize(session.getServletContext());
            String serverName = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
            String documentID = request.getParameter("docid");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
            String vsID = request.getParameter("vsId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: vsID = " + vsID);
            String version = request.getParameter("version");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: version = " + version);
            connection = this.getConnection(request);
            if (serverName == null) {
                String message = messages.getMessage(locale, "error.parm.null", new Object[]{"repositoryId"});
                throw new Exception(message);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering code area...");
            P8DocID p8DocID = new P8DocID(documentID);
            Document document = P8Util.getDocument(request, connection, p8DocID, vsID, version, null, null);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Fetched document");
            P8AnnotationImporter annotationImporter = new P8AnnotationImporter(request, connection, document);
            String theXml = this.getAnnotationData(request);
            boolean useAnnotationClassSecurity = false;
            RepositoryConfig repoConfig = null;
            if (Config.hasRepositoryConfigUsingIdOrServerName(request, serverName) && (repoConfig = Config.getRepositoryConfigUsingIdOrServerName(request, serverName)) != null) {
                String annotationSecurity = repoConfig.getAnnotationSecurity();
                useAnnotationClassSecurity = annotationSecurity != null && annotationSecurity.equalsIgnoreCase("default");
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Importing updates: " + theXml);
            annotationImporter.importUpdates(request, connection, theXml, useAnnotationClassSecurity);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            response.getWriter().write("NOT OK: <dialog>" + e.getMessage());
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private String getAnnotationData(HttpServletRequest request) {
        String annoSize = request.getParameter("FnAnnoSize");
        double sizeD = Double.parseDouble(annoSize);
        int size = (int)sizeD;
        StringBuffer sb = new StringBuffer(size);
        int fields = Integer.parseInt(request.getParameter("FnNumOfFields"));
        for (int i = 1; i <= fields; ++i) {
            String chunkNumber = i >= 10 ? Integer.toString(i) : "0" + i;
            String chunkKey = "FnAnnoData" + chunkNumber;
            String chunk = request.getParameter(chunkKey);
            sb.append(chunk);
        }
        String annotData = sb.toString();
        return annotData;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String folderName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: folderName = " + folderName);
        String documentID = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
        String transform = request.getParameter("transform");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
    }
}

