/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.constants.VersionStatus;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.User;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8UnlockItemAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        ClassDescription classDescription = null;
        User currentUser = Factory.User.fetchCurrent((Connection)ceConnection, null);
        Connection connection2 = ceConnection;
        synchronized (connection2) {
            try {
                String docId = request.getParameter("docid");
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String folderName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + folderName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
                String[] docIds = request.getParameterValues("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
                ObjectStore objectStore = connection.getObjectStore();
                classDescription = Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)folderName, null);
                searchResultsMediator.addClassDescription(classDescription);
                searchResultsMediator.setServer(connection);
                ArrayList<Object> hits = new ArrayList<Object>();
                ArrayList<String> errorItemNames = new ArrayList<String>();
                boolean checkedOut = false;
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of docids:" + docIds.length);
                if (ceConnection != null) {
                    for (int i = 0; i < docIds.length; ++i) {
                        IndependentlyPersistableObject item = P8Util.getPersistableObject(request, connection, docIds[i]);
                        if (item instanceof Folder) {
                            Folder folder = (Folder)item;
                            folder.unlock();
                            folder.save(RefreshMode.REFRESH);
                            hits.add(folder);
                            continue;
                        }
                        if (item instanceof Document) {
                            Document currVerDoc = (Document)item;
                            try {
                                boolean isCurrentVersion = currVerDoc.get_IsCurrentVersion();
                                if (!isCurrentVersion) {
                                    currVerDoc = (Document)currVerDoc.get_CurrentVersion();
                                }
                                if (checkedOut = currVerDoc.get_IsReserved().booleanValue()) {
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item locked " + currVerDoc.get_Id().toString());
                                    Document reservation = (Document)currVerDoc.get_Reservation();
                                    String checkedOutUserid = reservation.get_Creator();
                                    String loggedOnUserid = currentUser.get_Name();
                                    ReservationType reservationType = reservation.get_ReservationType();
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "checked out by = " + checkedOutUserid);
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "logged on user name = " + loggedOnUserid);
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "reservation type = " + (reservationType == ReservationType.EXCLUSIVE ? "Exclusive" : "Collaborative"));
                                    reservation = (Document)currVerDoc.cancelCheckout();
                                    reservation.save(RefreshMode.NO_REFRESH);
                                    checkedOut = false;
                                    if (((Document)item).get_VersionStatus() == VersionStatus.RESERVATION) {
                                        HashMap<String, String> updatedDocIds = new HashMap<String, String>(1);
                                        updatedDocIds.put(P8Util.getDocId(currVerDoc.getObjectReference()), docIds[i]);
                                        searchResultsMediator.setUpdatedDocIds(updatedDocIds);
                                        currVerDoc.refresh((PropertyFilter)null);
                                        hits.add(currVerDoc);
                                    } else {
                                        item.refresh((PropertyFilter)null);
                                        hits.add(item);
                                    }
                                } else {
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item not checked out");
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "logged on user name = " + currentUser.get_Name());
                                    item.refresh((PropertyFilter)null);
                                    hits.add(item);
                                }
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item value checkedout  = " + checkedOut + " and checked out by " + currentUser.get_Name());
                            }
                            catch (Exception e) {
                                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                                if (currVerDoc == null) continue;
                                errorItemNames.add(currVerDoc.get_Name());
                            }
                            continue;
                        }
                        throw new Exception("Unsupported type of object");
                    }
                }
                P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                searchResultsBean.setHits(hits);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of items found -->  [Vector = " + hits.size() + "] [SearchResults Bean = " + searchResultsBean.size() + "]");
                searchResultsMediator.setPageSize(this.pageSize);
                searchResultsMediator.setSearchResultsBean(searchResultsBean);
                searchResultsMediator.setFolderDescription(classDescription.get_DisplayName());
                if (docIds.length > 1) {
                    if (errorItemNames.size() == 0) {
                        searchResultsMediator.addMessage("document.cancelcheckout.multi.success", String.valueOf(docIds.length));
                    } else if (errorItemNames.size() == docIds.length) {
                        searchResultsMediator.addWarning("document.cancelcheckout.none", new Object[0]);
                    } else {
                        String docNames = "";
                        for (int i = 0; i < errorItemNames.size(); ++i) {
                            if (i > 0) {
                                docNames = docNames + "<br/>";
                            }
                            docNames = docNames + errorItemNames.get(i);
                        }
                        searchResultsMediator.addWarning("document.cancelcheckout.partial", errorItemNames.size(), docNames);
                    }
                } else if (errorItemNames.size() == 0) {
                    searchResultsMediator.addMessage("document.cancelcheckout.successful", new Object[0]);
                } else {
                    searchResultsMediator.addWarning("document.cancelcheckout.error", new Object[0]);
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            this.writeJSONMediator(request, response);
        }
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
    }
}

