/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Document;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8CeSearchUtilProxy;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8SearchRunner;
import com.ibm.ecm.util.p8.P8SearchTemplate;
import com.ibm.ecm.util.p8.P8SearchTemplateDocument;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8SearchAction
extends P8BaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        block27: {
            String methodName = "executeAction";
            Logger.logEntry((Object)this, "executeAction", (ServletRequest)request);
            this.getConfigInfo(request);
            P8SearchResultsMediator mediator = (P8SearchResultsMediator)this.getMediator(request);
            String serverName = request.getParameter("repositoryId");
            String templateName = request.getParameter("template_name");
            String vsId = request.getParameter("vsId");
            String desktopName = request.getParameter("desktop");
            String orderBy = request.getParameter("order_by");
            String teamspaceId = request.getParameter("teamspaceId");
            boolean orderDescending = this.getBooleanRequestParameter(request, "order_descending", false);
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "serverName = " + serverName);
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "templateName = " + templateName);
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "vsId = " + vsId);
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "desktopName = " + desktopName);
            actionForward = null;
            if (serverName == null || serverName.trim().length() == 0) {
                mediator.addError("error.parm.null", "repositoryId");
            } else {
                block26: {
                    ActionForward actionForward2;
                    block25: {
                        P8Connection connection = this.getConnection(request);
                        P8SearchTemplate searchTemplate = new P8SearchTemplate();
                        try {
                            try {
                                mediator.setServer(connection);
                                RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
                                if (repositoryConfig != null) {
                                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "showDocLocation = " + repositoryConfig.isShowDocLocation());
                                    mediator.setShowDocLocation(repositoryConfig.isShowDocLocation());
                                }
                                mediator.setPageSize(this.pageSize);
                                String templateString = this.readJSON(request);
                                if (templateName == null || templateName.isEmpty() && vsId == null || vsId.isEmpty() && templateString == null || templateString.isEmpty()) {
                                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "No criteria or search ID specified");
                                    mediator.addError("error.exception.general");
                                    this.writeJSONMediator(request, response);
                                    Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
                                    actionForward2 = actionForward;
                                    Object var25_27 = null;
                                    break block25;
                                }
                                P8SearchTemplateDocument searchDocument = new P8SearchTemplateDocument(request, connection, templateName, vsId, teamspaceId);
                                JSONObject searchTemplateJson = (JSONObject)JSON.parse(templateString);
                                searchTemplate = searchDocument.getSearchTemplate(searchTemplateJson, true);
                                if (searchTemplate.getObjectStores() == null) {
                                    ObjectStore os = connection.getObjectStore();
                                    searchTemplate.addObjectStore(new P8SearchDefinition.SearchInObjectStore(os.getObjectReference().getObjectIdentity(), os.get_DisplayName()));
                                }
                                if (searchTemplate.getResultsDisplay() != null && (orderBy == null || orderBy.length() == 0)) {
                                    orderBy = searchTemplate.getResultsDisplay().getSortByProperty();
                                    orderDescending = !searchTemplate.getResultsDisplay().getSortAscending();
                                }
                                P8SearchRunner searchRunner = new P8SearchRunner(request, connection, searchTemplate, templateName, teamspaceId);
                                List<Object> hits = searchRunner.runSearch(orderBy, orderDescending, this.pageSize, repositoryConfig.getMaxResults(), repositoryConfig.getTimeoutInSeconds());
                                mediator.setContinuationData(searchRunner.getQueryContinuationData());
                                if (searchTemplate.getResultsDisplay() != null) {
                                    mediator.setDisplayColumns(searchTemplate.getResultsDisplay().getColumns());
                                    ObjectStore firstObjectStore = P8Util.getObjectStore(connection, searchTemplate.getObjectStores().get(0).getId());
                                    mediator.addClassDescription(P8Util.getCachedCD(firstObjectStore, searchTemplate.getFirstClassName()));
                                    mediator.setIncludeSubClasses(searchTemplate.isFirstClassSearchSubclasses());
                                    if (orderBy != null) {
                                        mediator.setSortByProperty(orderBy);
                                        mediator.setSortDirection(orderDescending ? -1 : 1);
                                    }
                                } else {
                                    Collection<ClassDescription> cds = P8SearchAction.findUniqueClassDescriptions(hits);
                                    mediator.setClassDescriptions(cds);
                                }
                                mediator.setSearchResultsBean(new P8SearchResultsBean(request, hits));
                                mediator.addMessage(hits.size() == 1 ? "search.results.returnedOne" : "search.results.returned", hits.size());
                                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, " after adding search results.");
                                break block26;
                            }
                            catch (EngineRuntimeException ere) {
                                this.logFDC(request, response, null, "executeAction");
                                Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)ere);
                                ExceptionCode exceptionCode = ere.getExceptionCode();
                                if (P8CeSearchUtilProxy.isContentSearchInvalidException(ere)) {
                                    mediator.addError("search.exception.cbrInvalidSearch", searchTemplate.getDisplayName());
                                } else if (exceptionCode == ExceptionCode.RETRIEVE_PROPERTY_NOT_DEFINED) {
                                    mediator.addError("search.exception.propertyNotFound", new Object[]{ere});
                                } else if (exceptionCode == ExceptionCode.E_OBJECT_NOT_FOUND) {
                                    mediator.addError("error.exception.opensearchnotfound", templateName);
                                } else {
                                    mediator.addError("error.exception.general", new Object[]{ere});
                                }
                                Object var25_29 = null;
                                this.writeJSONMediator(request, response);
                                break block27;
                            }
                            catch (RuntimeException uoe) {
                                this.logFDC(request, response, null, "executeAction");
                                String errorMsg = uoe.getMessage();
                                if (errorMsg != null && errorMsg.equals("search.exception.unsupportedTeamspaceSearch")) {
                                    Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "No teamspace ID to substitute macro");
                                    mediator.addError("search.exception.unsupportedTeamspaceSearch", searchTemplate.getDisplayName());
                                } else if (errorMsg != null && errorMsg.startsWith("search.exception.")) {
                                    Document document = P8Util.getDocument(request, connection, templateName);
                                    mediator.addError(errorMsg, document.get_Name());
                                    Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)uoe);
                                } else {
                                    mediator.addError("error.exception.general", uoe);
                                    Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)uoe);
                                }
                                Object var25_30 = null;
                                this.writeJSONMediator(request, response);
                                break block27;
                            }
                            catch (Exception e) {
                                this.logFDC(request, response, null, "executeAction");
                                Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)e);
                                mediator.addError("error.exception.general", e);
                                Object var25_31 = null;
                                this.writeJSONMediator(request, response);
                                break block27;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var25_32 = null;
                            this.writeJSONMediator(request, response);
                            throw throwable;
                        }
                    }
                    this.writeJSONMediator(request, response);
                    return actionForward2;
                }
                Object var25_28 = null;
                this.writeJSONMediator(request, response);
            }
        }
        Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator searchResultsMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        return searchResultsMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String templateName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "templateName = " + templateName);
        String folderName = request.getParameter("class_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "folderName = " + folderName);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        boolean isAndSearch = this.getBooleanRequestParameter(request, "andSearch", false);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "isPublicSearch = " + isAndSearch);
    }
}

