/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8QueryContinuationData;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8SearchRunner;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8RetrieveNextPageAction
extends P8BaseAction {
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getConfigInfo(request);
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        P8SearchResultsMediator mediator = (P8SearchResultsMediator)this.getMediator(request);
        try {
            P8Connection connection = this.getConnection(request);
            String continuationData = request.getParameter("continuationData");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "continuationData: " + continuationData);
            P8QueryContinuationData queryData = new P8QueryContinuationData(continuationData, false);
            String itemsNeededParameter = request.getParameter("itemsNeeded");
            String itemsToSkipParameter = request.getParameter("skip");
            String serverName = request.getParameter("repositoryId");
            mediator.setPageSize(this.pageSize);
            mediator.setServerName(serverName);
            mediator.setServer(connection);
            mediator.setContinuation(true);
            P8SearchRunner searchRunner = new P8SearchRunner(request, connection, queryData);
            int itemsNeeded = itemsNeededParameter != null && itemsNeededParameter.length() > 0 ? Integer.parseInt(itemsNeededParameter) : 0;
            int itemsToSkip = itemsToSkipParameter != null && itemsToSkipParameter.length() > 0 ? Integer.parseInt(itemsToSkipParameter) : 0;
            List<Object> hits = searchRunner.retrieveNextPage(this.pageSize, itemsNeeded, itemsToSkip);
            mediator.setContinuationData(searchRunner.getQueryContinuationData());
            Collection<ClassDescription> classDescriptions = P8RetrieveNextPageAction.findUniqueClassDescriptions(hits);
            mediator.setClassDescriptions(classDescriptions);
            mediator.setServerName(serverName);
            mediator.setSearchResultsBean(new P8SearchResultsBean(request, hits));
            mediator.setParentDocID(queryData.folderId);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, " after adding search results to session.");
            mediator.addMessage(hits.size() == 1 ? "search.results.returnedOne" : "search.results.returned", hits.size());
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            mediator.addError("error.exception.general", e.getMessage());
        }
        if (Logger.isDebugLogged()) {
            String jsonString = mediator.toJSONString();
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JSON response: " + jsonString);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator mediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        return mediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String contData = request.getParameter("continuationData");
        String repository = request.getParameter("repositoryId");
        return contData != null && repository != null;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String contData = request.getParameter("continuationData");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: contData = " + contData);
    }
}

