/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.ContentElementList;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentReference;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8DocumentMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.p8.P8Annotation;
import com.ibm.ecm.util.p8.P8AnnotationExporter;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8DocID;
import com.ibm.ecm.util.p8.P8Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.MessageFormat;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8RetrieveDocumentAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    private static final boolean useLastDocument = true;
    private static final boolean useNio = true;
    private static final boolean useBufferedIo = false;
    private static final boolean reportAccessTime = false;

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String clientCodebase;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        Object servers = null;
        HttpSession session = request.getSession(false);
        MessageResources resources = this.getResources(request);
        P8Connection connection = null;
        Object synchObject = new Object();
        Object mimetype = null;
        String fileExtension = "";
        String fileName = "";
        P8AnnotationExporter.initialize(session.getServletContext());
        String serverName = request.getParameter("repositoryId");
        String folderName = request.getParameter("template_name");
        String documentID = request.getParameter("docid");
        String vsID = request.getParameter("vsId");
        String version = request.getParameter("version");
        String transform = request.getParameter("transform");
        String altOutput = request.getParameter("alt_output");
        String altID = request.getParameter("templateid");
        String sElement = request.getParameter("element");
        int element = 0;
        if (sElement != null) {
            element = Integer.valueOf(sElement);
        }
        boolean isViewerRequest = (clientCodebase = request.getHeader("X-Client-Codebase")) != null && clientCodebase.contains("FnJavaV1Files");
        this.logFDC(request, response, null, methodName);
        boolean includeSegmentInfo = this.getBooleanRequestParameter(request, "include_segment_info", false);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: include_segment_info = " + includeSegmentInfo);
        String segmentNumString = request.getParameter("segment_num");
        int segmentNum = -1;
        if (segmentNumString != null) {
            segmentNum = Integer.valueOf(segmentNumString);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: segment_num = " + segmentNumString);
        P8DocumentMediator documentMediator = (P8DocumentMediator)this.getMediator(request);
        if (serverName == null || serverName.trim().length() < 1) {
            documentMediator.addError("error.parm.null", "repositoryId");
        }
        if (folderName == null || folderName.trim().length() < 1) {
            documentMediator.addError("error.parm.null", "template_name");
        }
        if (documentID == null || documentID.trim().length() < 1) {
            documentMediator.addError("error.parm.null", "docid");
        }
        try {
            connection = this.getConnection(request);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            documentMediator.addError("error.exception.general", e.getMessage());
            this.writeJSONMediator(request, response);
            return actionForward;
        }
        try {
            if (serverName == null) {
                documentMediator.addError("error.parm.null", "repositoryId");
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering code area...");
                String[] documentIDs = request.getParameterValues("docid");
                if (documentIDs.length == 1) {
                    LastDocument lastDocument = this.getLastDocument(session);
                    P8DocID p8DocID = new P8DocID(documentID);
                    Document document = null;
                    if (altID != null) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, MessageFormat.format("COLD Template ID specified: {0}", altID));
                        p8DocID.setObjectID(altID);
                        vsID = null;
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, MessageFormat.format("Last document is available: {0}", String.valueOf(lastDocument != null)));
                    if (lastDocument != null) {
                        String key = P8RetrieveDocumentAction.getDocumentKey(p8DocID.toString(), vsID, version);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, MessageFormat.format("Current document key is: {0}", key));
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, MessageFormat.format("Last document key is: {0}", lastDocument.key));
                        if (key.equals(lastDocument.key)) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Using the cached LastDocument");
                            document = lastDocument.document;
                        }
                    }
                    if (document == null) {
                        document = P8Util.getDocument(request, connection, p8DocID, vsID, version, documentMediator, null);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Fetched document");
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Using cached lastDocument.");
                    }
                    documentMediator.setHit(document);
                    boolean handled = false;
                    if (altOutput != null) {
                        if (altOutput.equals("Annotations")) {
                            handled = true;
                            this.sendAnnotationResponse(connection, response, document);
                        } else if (altOutput.equals("JSON")) {
                            handled = true;
                            this.sendJSONResponse(request, response, documentMediator, document);
                        }
                    }
                    if (!handled) {
                        this.sendContentResponse(request, response, document, element);
                    }
                    P8RetrieveDocumentAction.saveAsLastDocument(session, document, documentID, vsID, version);
                } else {
                    String tempFileName;
                    File tempFile = File.createTempFile("ContentNavigator", ".zip");
                    String responseFileName = tempFileName = tempFile.getPath();
                    tempFile.delete();
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempFileName));
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add documents to temp zip file: " + tempFileName);
                    for (int i = 0; i < documentIDs.length; ++i) {
                        Document document = P8Util.getDocument(request, connection, new P8DocID(documentIDs[i]), vsID, version, documentMediator, null);
                        documentMediator.setHit(document);
                        ContentElementList contentElementList = document.get_ContentElements();
                        if (contentElementList == null || element >= contentElementList.size()) continue;
                        ContentElement contentElement = (ContentElement)document.get_ContentElements().get(element);
                        if (contentElement instanceof ContentTransfer) {
                            ContentTransfer contentTransfer = (ContentTransfer)contentElement;
                            fileName = Util.getValidFileName(contentTransfer.get_RetrievalName());
                            int attemptCount = 0;
                            boolean noException = false;
                            String zipEntryName = fileName;
                            while (attemptCount < documentIDs.length && !noException) {
                                try {
                                    zos.putNextEntry(new ZipEntry(zipEntryName));
                                    noException = true;
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add document to temp zip file: " + zipEntryName);
                                }
                                catch (ZipException ze) {
                                    int index = fileName.lastIndexOf(46);
                                    zipEntryName = index > -1 ? fileName.substring(0, index) + "(" + (attemptCount + 2) + ")" + fileName.substring(index) : fileName + "(" + (attemptCount + 2) + ")";
                                    ++attemptCount;
                                }
                            }
                            if (!noException) continue;
                            ReadableByteChannel in = Channels.newChannel(contentTransfer.accessContentStream());
                            WritableByteChannel out = Channels.newChannel(zos);
                            ByteBuffer buffer = ByteBuffer.allocateDirect(32768);
                            while (in.read(buffer) != -1 || buffer.position() > 0) {
                                buffer.flip();
                                out.write(buffer);
                                buffer.compact();
                            }
                            zos.closeEntry();
                            if (i != 0) continue;
                            responseFileName = fileName;
                            continue;
                        }
                        if (contentElement instanceof ContentReference) continue;
                        throw new RuntimeException("Unexpected content element type found on document " + contentElement.getClassName());
                    }
                    int index = responseFileName.lastIndexOf(46);
                    if (index > -1) {
                        responseFileName = responseFileName.substring(0, index);
                    }
                    zos.close();
                    tempFile = new File(tempFileName);
                    response.setHeader("Content-Type", "application/octet-stream");
                    response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, responseFileName + ".zip"));
                    response.setContentLength((int)tempFile.length());
                    ServletOutputStream outputStream = response.getOutputStream();
                    Util.copyStream(new FileInputStream(tempFile), (OutputStream)outputStream, true);
                    tempFile.deleteOnExit();
                }
            }
        }
        catch (Exception e) {
            if (e.getClass().getName().endsWith("ClosedConnectionException") || e.getClass().getName().endsWith("ClientAbortException")) {
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Client closed connection before reading entire response");
            }
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            if (isViewerRequest) {
                response.getWriter().write("NOT OK: <dialog>" + e.getMessage());
            }
            documentMediator.addError("error.exception.general", e.getMessage());
            documentMediator.sendErrorResponse(response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void sendAnnotationResponse(P8Connection connection, HttpServletResponse response, Document document) throws IOException {
        List<P8Annotation> p8Annotations = P8Annotation.getDocumentAnnotations(this.request, connection, document);
        P8AnnotationExporter annotationExporter = new P8AnnotationExporter(p8Annotations);
        response.setContentType("application/octet-stream");
        annotationExporter.export((OutputStream)response.getOutputStream());
    }

    private void sendJSONResponse(HttpServletRequest request, HttpServletResponse response, P8DocumentMediator documentMediator, Document document) {
        String methodName = "sendJSONResponse";
        String mimetype = document.get_MimeType();
        documentMediator.setMimeType(mimetype);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "mimetype = " + mimetype);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "document.get_ContentSize() = " + document.get_ContentSize());
        if (document.get_ContentSize() != null) {
            documentMediator.setPartSize(document.get_ContentSize().longValue());
        }
        this.writeJSONMediator(request, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendContentResponse(HttpServletRequest request, HttpServletResponse response, Document document, int element) throws IOException {
        ContentElementList contentElementList = document.get_ContentElements();
        BufferedInputStream byteArrayContentStream = null;
        if (contentElementList == null || element >= contentElementList.size()) {
            if (request.getParameter("transform") != null) return;
            String message = MessageUtil.getMessage(request.getLocale(), "retrieve.doc.no.content");
            response.setContentLength(message.length());
            response.setContentType("text");
            response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, "temp.txt"));
            ByteArrayInputStream is = new ByteArrayInputStream(message.getBytes());
            byteArrayContentStream = new BufferedInputStream(is);
            this.writeContent(request, response, byteArrayContentStream, "text");
            return;
        } else {
            ContentElement contentElement = (ContentElement)document.get_ContentElements().get(element);
            String mimetype = contentElement.get_ContentType();
            response.setContentType(mimetype);
            if (contentElement instanceof ContentTransfer) {
                ContentTransfer contentTransfer = (ContentTransfer)contentElement;
                Double contentLength = contentTransfer.get_ContentSize();
                if (contentLength != null) {
                    response.setContentLength(contentLength.intValue());
                }
                String fileName = Util.getValidFileName(contentTransfer.get_RetrievalName());
                response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, fileName));
                byteArrayContentStream = new BufferedInputStream(contentTransfer.accessContentStream());
                this.writeContent(request, response, byteArrayContentStream, mimetype);
                return;
            } else {
                if (contentElement instanceof ContentReference) return;
                throw new RuntimeException("Unexpected content element type found on document " + contentElement.getClassName());
            }
        }
    }

    private void writeContent(HttpServletRequest request, HttpServletResponse response, BufferedInputStream byteArrayContentStream, String mimetype) throws IOException {
        ReadableByteChannel in = Channels.newChannel(byteArrayContentStream);
        WritableByteChannel out = Channels.newChannel((OutputStream)response.getOutputStream());
        ByteBuffer buffer = ByteBuffer.allocateDirect(32768);
        while (in.read(buffer) != -1 || buffer.position() > 0) {
            buffer.flip();
            out.write(buffer);
            buffer.compact();
        }
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8DocumentMediator documentMediator = new P8DocumentMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)documentMediator);
        return documentMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String folderName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: folderName = " + folderName);
        String documentID = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
        String vsID = request.getParameter("vsId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: vsID = " + vsID);
        String transform = request.getParameter("transform");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        String altID = request.getParameter("templateid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: id = " + altID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsLastDocument(HttpSession session, Document document, String id, String vsId, String version) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            LastDocument lastDocument = new LastDocument(document, id, vsId, version);
            session.setAttribute("P8RetrieveDocument.LastDocument", (Object)lastDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LastDocument getLastDocument(HttpSession session) {
        LastDocument lastDocument = null;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            long age;
            lastDocument = (LastDocument)session.getAttribute("P8RetrieveDocument.LastDocument");
            if (lastDocument != null && (age = System.currentTimeMillis() - lastDocument.timestamp) > 15000L) {
                session.removeAttribute("P8RetrieveDocument.LastDocument");
                lastDocument = null;
            }
        }
        return lastDocument;
    }

    private static String getDocumentKey(String id, String vsId, String version) {
        return String.valueOf(id) + String.valueOf(vsId) + String.valueOf(version);
    }

    private static class LastDocument {
        private static final String LAST_DOCUMENT_KEY = "P8RetrieveDocument.LastDocument";
        long timestamp = System.currentTimeMillis();
        transient Document document;
        String id;
        String vsId;
        String key;
        String version;

        private LastDocument(Document document, String id, String vsId, String version) {
            this.document = document;
            this.id = id;
            this.vsId = vsId;
            this.version = version;
            this.key = P8RetrieveDocumentAction.getDocumentKey(id, vsId, version);
        }
    }
}

