/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.ObjectStoreSet;
import com.filenet.api.collection.ReferentialContainmentRelationshipSet;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.core.Scope;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8RemoveFromFolderAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    String folderName = "";
    String itemName = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        ClassDescription classDescription = null;
        Connection connection2 = ceConnection;
        synchronized (connection2) {
            try {
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String[] itemPIDs = request.getParameterValues("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
                String folderPID = request.getParameter("folderDocid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPID = " + folderPID);
                this.folderName = folderPID;
                String folderClassName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + folderClassName);
                EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)ceConnection, null);
                Domain domain = entireNetwork.get_LocalDomain();
                ObjectStoreSet objectStoreSet = domain.get_ObjectStores();
                ObjectStore objectStore = (ObjectStore)objectStoreSet.iterator().next();
                classDescription = Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)folderClassName, null);
                UpdatingBatch updateBatch = UpdatingBatch.createUpdatingBatchInstance((Domain)domain, (RefreshMode)RefreshMode.REFRESH);
                searchResultsMediator.addClassDescription(classDescription);
                searchResultsMediator.setServer(connection);
                if (ceConnection != null) {
                    String itemPID = null;
                    int errorCount = 0;
                    boolean itemsNotFound = false;
                    ArrayList<String> errorItemNames = new ArrayList<String>();
                    for (int iItemCounter = 0; iItemCounter < itemPIDs.length; ++iItemCounter) {
                        this.itemName = itemPID = itemPIDs[iItemCounter];
                        try {
                            this.removeFromFolder(connection, itemPID, folderPID, updateBatch);
                            continue;
                        }
                        catch (Exception removeItemFromFolderException) {
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)removeItemFromFolderException);
                            if (removeItemFromFolderException instanceof EngineRuntimeException) {
                                EngineRuntimeException ex = (EngineRuntimeException)((Object)removeItemFromFolderException);
                                if (ex.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                                    itemsNotFound = true;
                                    continue;
                                }
                                ++errorCount;
                                errorItemNames.add(this.itemName);
                                continue;
                            }
                            ++errorCount;
                            errorItemNames.add(this.itemName);
                        }
                    }
                    if (errorCount == 0) {
                        if (itemsNotFound) {
                            searchResultsMediator.addWarning("removeFromFolder.notFound", new Object[0]);
                        } else if (itemPIDs.length > 1) {
                            searchResultsMediator.addMessage("removeFromFolder.multi.success", new Object[0]);
                        } else {
                            searchResultsMediator.addMessage("removeFromFolder.single.success", this.folderName, this.itemName);
                        }
                    } else if (itemPIDs.length > 1) {
                        if (errorCount == itemPIDs.length) {
                            searchResultsMediator.addWarning("removeFromFolder.none", new Object[0]);
                        } else {
                            String docNames = "";
                            Integer errorItemCounter = 0;
                            while (errorItemCounter < errorItemNames.size()) {
                                if (errorItemCounter > 0) {
                                    docNames = docNames + "<br/>";
                                }
                                docNames = docNames + errorItemNames.get(errorItemCounter);
                                Integer n = errorItemCounter;
                                Integer n2 = errorItemCounter = Integer.valueOf(errorItemCounter + 1);
                            }
                            searchResultsMediator.addWarning("removeFromFolder.partial", errorItemCounter.toString(), docNames);
                        }
                    } else {
                        searchResultsMediator.addWarning("removeFromFolder.single.warning", this.folderName, this.itemName);
                    }
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void removeFromFolder(P8Connection connection, String itemPID, String folderPID, UpdatingBatch updateBatch) throws Exception {
        String methodName = "addItemToFolder";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "folder was selected and the pid = " + folderPID);
        String folderId = P8Util.getObjectIdentity(folderPID);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "itemPID = " + itemPID);
        Document doc = (Document)P8Util.getPersistableObject(this.request, connection, itemPID);
        this.itemName = doc.get_Name();
        ReferentialContainmentRelationshipSet containers = doc.get_Containers();
        for (ReferentialContainmentRelationship rcr : containers) {
            Folder container = (Folder)rcr.get_Tail();
            String tailId = container.get_Id().toString();
            if (!tailId.equalsIgnoreCase(folderId)) continue;
            this.folderName = container.get_FolderName();
            rcr.delete();
            rcr.save(RefreshMode.NO_REFRESH);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String[] itemPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
        String pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + itemPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
        String[] folderPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
        pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + folderPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
    }
}

