/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8CriteriasMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchDefinition;
import com.ibm.ecm.util.p8.P8SearchTemplate;
import com.ibm.ecm.util.p8.P8SearchTemplateDocument;
import com.ibm.ecm.util.p8.P8Util;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8OpenSearchTemplateAction
extends P8BaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
        HttpSession session = request.getSession(false);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        Object synchObject = new Object();
        P8CriteriasMediator criteriasMediator = (P8CriteriasMediator)this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String templateId = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "className = " + templateId);
        String vsId = request.getParameter("vsId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "vsId = " + vsId);
        String formType = request.getParameter("form_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "formType = " + formType);
        String teamspaceId = request.getParameter("workspaceId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceId = " + teamspaceId);
        String autoResolveParam = request.getParameter("autoResolve");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "autoResolve = " + autoResolveParam);
        boolean autoResolve = Boolean.valueOf(autoResolveParam);
        if (serverName == null || serverName.trim().length() < 1) {
            criteriasMediator.addError("error.parm.null", "repositoryId");
        } else if (templateId == null || templateId.trim().length() < 1) {
            criteriasMediator.addError("error.parm.null", "template_name");
        } else {
            try {
                criteriasMediator.setServerName(serverName);
                ceConnection = this.getConnection(request).getCEConnection();
                synchObject = ceConnection == null ? new Object() : ceConnection;
                criteriasMediator.setShowFieldHoverHelp(this.getShowFieldHoverHelp());
                Object object = synchObject;
                synchronized (object) {
                    P8SearchTemplateDocument searchDocument = new P8SearchTemplateDocument(request, connection, templateId, vsId, teamspaceId);
                    P8SearchTemplate searchTemplate = searchDocument.getSearchTemplate(autoResolve);
                    criteriasMediator.setProductName(searchTemplate.getProductName());
                    criteriasMediator.setObjectStores(searchTemplate.getObjectStores());
                    criteriasMediator.setObjectType(searchTemplate.getObjectType());
                    criteriasMediator.setFolders(searchTemplate.getFolders());
                    criteriasMediator.setClasses(searchTemplate.getClasses());
                    criteriasMediator.setCriteria(searchTemplate.getSearchCriteria());
                    criteriasMediator.setAndSearch(searchTemplate.isAndSearch());
                    criteriasMediator.setVersionOption(searchTemplate.getVersionOption());
                    criteriasMediator.setTextSearchCriteria(searchTemplate.getTextSearchCriteria());
                    criteriasMediator.setTextSearchCriteriaLayout(searchTemplate.getTextSearchCriteriaLayout());
                    criteriasMediator.setTextSearchType(searchTemplate.getTextSearchType());
                    criteriasMediator.setResultsDisplay(searchTemplate.getResultsDisplay());
                    criteriasMediator.setFormType(formType);
                    criteriasMediator.setHasSavedSearches(false);
                    criteriasMediator.setOperatorHidden(searchTemplate.isOperatorHidden());
                    criteriasMediator.setCriteriaRelationshipHidden(searchTemplate.isCriteriaRelationshipHidden());
                    criteriasMediator.setAutoResolved(searchTemplate.isAutoResolved());
                    criteriasMediator.setPropertyTextAnded(searchTemplate.isPropertyTextAnded());
                    criteriasMediator.setMacros(searchTemplate.getMacros());
                    String productName = searchTemplate.getProductName();
                    if (productName == null || productName.equals("Navigator")) {
                        criteriasMediator.setAutoRun(searchTemplate.isAutoRun());
                        criteriasMediator.setShowInTree(searchTemplate.isShowInTree());
                    }
                    P8SearchDefinition.SearchInObjectStore os = searchTemplate.getObjectStores().get(0);
                    ObjectStore objectStore = P8Util.getObjectStore(connection, os.getId());
                    criteriasMediator.setObjectStore(objectStore);
                    ClassDescription classDescription = P8Util.getCachedCD(objectStore, searchTemplate.getFirstClassName());
                    ArrayList<PropertyDescription> props = P8Util.getPropertyDescriptions(classDescription, searchTemplate.isFirstClassSearchSubclasses(), false, true, false, true);
                    criteriasMediator.setPropertyDescriptionList(props);
                    criteriasMediator.addMessage("folder.open.successful", searchTemplate.getDisplayName());
                }
            }
            catch (Exception e) {
                String message;
                String errorKey = "error.exception.general";
                if (e instanceof EngineRuntimeException) {
                    EngineRuntimeException ex = (EngineRuntimeException)((Object)e);
                    if (ex.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                        errorKey = "error.exception.opensearchnotfound";
                    }
                } else if (e instanceof RuntimeException && (message = e.getMessage()) != null && message.startsWith("search.exception.")) {
                    errorKey = message;
                    Document document = P8Util.getDocument(request, connection, templateId);
                    templateId = document.get_Name();
                }
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                criteriasMediator.addError(errorKey, templateId);
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8CriteriasMediator criteriasMediator = new P8CriteriasMediator(request, this.getResources(request), request.getLocale());
        return criteriasMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String folderName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "folderName = " + folderName);
        String formType = request.getParameter("form_type");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "formType = " + formType);
    }
}

