/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.util.Id;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.FileTypeConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.ecm.util.ForwardPager;
import com.ibm.ecm.util.SearchTemplate;
import com.ibm.ecm.util.p8.P8CeSearchUtilProxy;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Iterator;
import com.ibm.ecm.util.p8.P8Query;
import com.ibm.ecm.util.p8.P8QueryContinuationData;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8OpenFolderAction
extends P8BaseAction {
    private static Set<String> sortableFolderProperties = new HashSet<String>();

    private String getOrderByField(String sortKey, boolean forFolders, boolean descending) {
        if (sortKey == null || forFolders && !sortableFolderProperties.contains(sortKey)) {
            sortKey = "!Name";
        }
        if (sortKey.equals("!MimeTypeIcon")) {
            sortKey = forFolders ? "ContainerType" : "MimeType";
        } else if (sortKey.equals("!Name")) {
            sortKey = forFolders ? "FolderName" : "DocumentTitle";
        }
        String result = sortKey + (descending ? " DESC" : "");
        return result;
    }

    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isFolderSearch;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        P8QueryContinuationData queryData = new P8QueryContinuationData();
        this.getConfigInfo(request);
        String filterType = request.getParameter("filter_type");
        queryData.returnOnlyFolders = isFolderSearch = filterType != null && filterType.equalsIgnoreCase("folderSearch");
        String serverName = request.getParameter("repositoryId");
        String folderId = request.getParameter("docid");
        String orderBy = request.getParameter("order_by");
        if (orderBy != null && orderBy.equals("{NAME}")) {
            orderBy = null;
        }
        String descendingOrderParam = request.getParameter("order_descending");
        queryData.descending = StringUtils.equals((String)descendingOrderParam, (String)"true");
        String workspaceId = request.getParameter("workspaceId");
        String fileTypeFilter = request.getParameter("fileTypeFilter");
        if (fileTypeFilter != null) {
            queryData.fileTypeFilter = fileTypeFilter;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderID: " + folderId);
        P8SearchResultsMediator mediator = (P8SearchResultsMediator)this.getMediator(request);
        mediator.setServerName(serverName);
        mediator.setPageSize(this.pageSize);
        if (isFolderSearch) {
            HashSet<String> additionalProperties = new HashSet<String>(1);
            additionalProperties.add("PathName");
            mediator.setAdditionalProperties(additionalProperties);
        }
        try {
            P8Connection connection = this.getConnection(request);
            mediator.setServer(connection);
            mediator.setSortIndex(3);
            ObjectStore objectStore = P8Util.getObjectStore(request, connection, folderId);
            queryData.objectStoreId = objectStore.get_Id().toString();
            String realFolderId = P8Util.getObjectIdentity(folderId);
            if (realFolderId.equals("/")) {
                queryData.returnOnlyFolders = true;
            }
            if (workspaceId != null && workspaceId.length() > 0) {
                P8TeamspaceService teamspaceService = new P8TeamspaceService(connection.getCEConnection(), connection.getDomain(), connection.getObjectStore(), connection, request);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieving teamspace");
                Teamspace teamspace = teamspaceService.retrieveTeamspace(workspaceId, "columns", "instance");
                SearchTemplate.ResultsDisplay colProps = teamspace.getColumnProperties();
                if (colProps != null) {
                    String sortBy;
                    String[] props = colProps.getColumns();
                    if (props != null && props.length > 0) {
                        mediator.setDisplayColumns(props);
                    }
                    if ((sortBy = colProps.getSortByProperty()) != null && sortBy.length() > 0) {
                        orderBy = sortBy;
                        queryData.descending = !colProps.getSortAscending();
                    }
                }
            }
            List<String> folderProps = Arrays.asList("LockOwner", "LockToken", "LockTimeout", "DateLastModified", "LastModifier", "Creator", "DateCreated", "Id", "FolderName", "ClassDescription", "PathName");
            P8Query dq = new P8Query();
            dq.setFromClause("Folder");
            dq.setRequestedProperties(folderProps);
            dq.setWhereClause("Parent = Object('" + realFolderId + "') AND IsHiddenContainer = false");
            String sortProperty = this.getOrderByField(orderBy, true, queryData.descending);
            dq.setOrderByClause(sortProperty);
            queryData.folderSQL = dq.generateSQL();
            if (!queryData.returnOnlyFolders) {
                List<String> documentProps = null;
                P8Query fq = new P8Query();
                if (connection.isSearchAddOnInstalled() && filterType != null && filterType.equalsIgnoreCase("searchAndFolderSearch")) {
                    documentProps = this.getDocumentPropertyList(connection, true);
                    fq.setFromClause("StoredSearch");
                    fq.setWhereClause("This INFOLDER ('" + realFolderId + "') AND (" + "IcnShowInTree" + " = true OR " + "MimeType" + " = 'application/x-filenet-search') AND VersionStatus = 1");
                    fq.setOrderByClause("DocumentTitle");
                } else {
                    Folder rootFolder = objectStore.get_RootFolder();
                    Id rootFolderId = rootFolder.get_Id();
                    if (realFolderId.equals(rootFolderId.toString())) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Retrieving contents of root folder");
                        documentProps = this.getDocumentPropertyList(connection, true);
                        fq.setFromClause("StoredSearch");
                        fq.setWhereClause("This INFOLDER ('" + realFolderId + "') AND (" + "MimeType" + " = 'application/x-filenet-search') AND VersionStatus = 1");
                        fq.setOrderByClause("DocumentTitle");
                    } else {
                        String mimeTypeFilter;
                        documentProps = this.getDocumentPropertyList(connection, false);
                        fq.setFromClause("Document");
                        StringBuilder whereClause = new StringBuilder();
                        whereClause.append("This INFOLDER ('" + realFolderId + "')");
                        if (queryData.fileTypeFilter != null && (mimeTypeFilter = this.getMimeTypeFilter(queryData.fileTypeFilter)) != null && !mimeTypeFilter.isEmpty()) {
                            whereClause.append(" AND ");
                            whereClause.append(mimeTypeFilter);
                        }
                        fq.setWhereClause(whereClause.toString());
                        String sortPropertyForDocuments = this.getOrderByField(orderBy, false, queryData.descending);
                        fq.setOrderByClause(sortPropertyForDocuments);
                    }
                }
                fq.setRequestedProperties(documentProps);
                fq.setObjectStore(objectStore);
                queryData.documentSQL = fq.generateSQL();
            }
            P8Iterator itr = new P8Iterator((ServletRequest)request, connection, queryData, this.pageSize);
            ForwardPager<Object> pager = new ForwardPager<Object>(itr, this.pageSize);
            List<Object> hits = pager.loadNextPage();
            if (!pager.isEndReached()) {
                queryData.folderId = folderId;
                queryData.sessionKey = Long.toString(System.currentTimeMillis(), 36);
                queryData.itemsToSkip = pager.getNumberOfItemsRetrieved();
                queryData.checkpoint = itr.getNextPageCheckpoint();
                String data = queryData.saveToString();
                mediator.setContinuationData(data);
                if (!P8CeSearchUtilProxy.isCascadeSupported()) {
                    request.getSession().setAttribute(queryData.sessionKey, pager);
                }
            }
            if (pager.isEndReached() || P8CeSearchUtilProxy.isCascadeSupported()) {
                itr.reset();
            }
            Collection<ClassDescription> cds = P8OpenFolderAction.findUniqueClassDescriptions(hits);
            mediator.setClassDescriptions(cds);
            mediator.setServerName(serverName);
            P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request, hits, true);
            mediator.setSearchResultsBean(searchResultsBean);
            mediator.setParentDocID(folderId);
            mediator.setMaxResultsReached(pager.isMaxResultsReached());
            mediator.addMessage(searchResultsBean.size() == 1 ? "openFolder.returnedOne" : "openFolder.returned", searchResultsBean.size());
            RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
            if (repositoryConfig != null) {
                String folderNameProperty;
                String docNameProperty;
                String[] folderDefaultColumns;
                if (mediator.getDisplayColumns() == null && (folderDefaultColumns = repositoryConfig.getFolderDefaultColumns()) != null && (folderDefaultColumns.length > 1 || folderDefaultColumns.length == 1 && folderDefaultColumns[0] != null && folderDefaultColumns[0].length() > 0)) {
                    mediator.setDisplayColumns(folderDefaultColumns);
                }
                if ((docNameProperty = repositoryConfig.getDocNameProperty()) != null && docNameProperty.length() > 0) {
                    mediator.setDocNameProperty(docNameProperty);
                }
                if ((folderNameProperty = repositoryConfig.getFolderNameProperty()) != null && folderNameProperty.length() > 0) {
                    mediator.setFolderNameProperty(folderNameProperty);
                }
            }
        }
        catch (Exception e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            mediator.addError("error.exception.general", e.getMessage());
        }
        if (Logger.isDebugLogged()) {
            String jsonString = mediator.toJSONString();
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JSON response: " + jsonString);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private String getMimeTypeFilter(String fileTypeFilter) throws ConfigurationException, MissingValueException {
        StringBuilder buffer = new StringBuilder();
        if (fileTypeFilter != null || fileTypeFilter.length() > 1) {
            ArrayList<String> fileTypes = new ArrayList<String>();
            if (fileTypeFilter.contains(",")) {
                String[] fileTypeArray;
                for (String fileType : fileTypeArray = fileTypeFilter.split(",")) {
                    fileTypes.add(fileType.trim());
                }
            } else {
                String fileType = fileTypeFilter.trim();
                if (fileType.equalsIgnoreCase("none")) {
                    fileTypes.add("word");
                    fileTypes.add("pdf");
                    fileTypes.add("powerpoint");
                    fileTypes.add("excel");
                } else {
                    fileTypes.add(fileType);
                }
            }
            if (fileTypes.size() > 0) {
                SettingsConfig settingsConfig = Config.getSettingsConfig("navigator");
                Map<String, FileTypeConfig> fileTypeConfigMap = settingsConfig.getMacrosMap("navigator", FileTypeConfig.class);
                for (String fileType : fileTypes) {
                    String[] mimeTypes;
                    FileTypeConfig fileTypeConfig = fileTypeConfigMap.get(fileType);
                    if (fileTypeConfig == null) continue;
                    for (String mimeType : mimeTypes = fileTypeConfig.getContentTypes()) {
                        String operator;
                        if (mimeType == null || mimeType.isEmpty()) continue;
                        String type = mimeType.replaceAll("\\*", "%");
                        String string = operator = type.indexOf("%") > -1 ? " LIKE " : " = ";
                        if (buffer.length() > 0) {
                            buffer.append(" OR ");
                        }
                        buffer.append("MimeType").append(operator).append("'").append(type).append("'");
                    }
                }
            }
        }
        if (buffer.length() > 0) {
            buffer.insert(0, "(").append(")");
        }
        return buffer.toString();
    }

    private List<String> getDocumentPropertyList(P8Connection connection, boolean isSearchesOnly) {
        ArrayList<String> documentProps = new ArrayList<String>(Arrays.asList("LockToken", "LockTimeout", "DateLastModified", "LockOwner", "Id", "DocumentTitle", "ClassDescription", "Creator", "DateCreated", "MimeType", "LastModifier", "IsReserved", "Reservation", "IsCurrentVersion", "VersionSeries", "MajorVersionNumber", "MinorVersionNumber", "ContentSize", "ReplicationGroup", "VersionStatus", "IsVersioningEnabled", "ReservationType", "Owner"));
        if (!isSearchesOnly) {
            documentProps.add("EntryTemplateObjectStoreName");
            documentProps.add("EntryTemplateId");
            documentProps.add("EntryTemplateLaunchedWorkflowNumber");
        }
        if (connection.isSearchAddOnInstalled()) {
            documentProps.add("IcnAutoRun");
            documentProps.add("IcnShowInTree");
        }
        if (connection.isRecordObjectStore()) {
            documentProps.add("RecordInformation");
        }
        return documentProps;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverName = request.getParameter("repositoryId");
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "Request Parameter: documentID = " + pid);
        return serverName != null && pid != null;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator mediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        return mediator;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template");
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
    }

    static {
        sortableFolderProperties.add("FolderName");
        sortableFolderProperties.add("Id");
        sortableFolderProperties.add("LastModifier");
        sortableFolderProperties.add("DateLastModified");
        sortableFolderProperties.add("ContainerType");
    }
}

