/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Connection;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8EntryTemplateMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8EntryTemplate;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8OpenEntryTemplateAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        HttpSession session = request.getSession(false);
        P8EntryTemplateMediator mediator = (P8EntryTemplateMediator)this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String templateId = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "className = " + templateId);
        String formType = request.getParameter("form_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "formType = " + formType);
        boolean allowFailure = this.getBooleanRequestParameter(request, "allow_failure", false);
        if (serverName == null || serverName.trim().length() < 1) {
            mediator.addError("error.parm.null", "repositoryId");
        } else if (templateId == null || templateId.trim().length() < 1) {
            mediator.addError("error.parm.null", "template_name");
        } else {
            try {
                P8Connection connection = this.getConnection(request);
                mediator.setConnection(connection);
                Connection ceConnection = connection.getCEConnection();
                Object synchObject = ceConnection == null ? new Object() : ceConnection;
                mediator.setShowFieldHoverHelp(this.getShowFieldHoverHelp());
                Object object = synchObject;
                synchronized (object) {
                    P8EntryTemplate entryTemplate = null;
                    if (allowFailure) {
                        try {
                            entryTemplate = P8EntryTemplate.loadEntryTemplate(request, connection, templateId, formType.equals("edit"));
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        }
                    } else {
                        entryTemplate = P8EntryTemplate.loadEntryTemplate(request, connection, templateId, formType.equals("edit"));
                    }
                    if (entryTemplate != null) {
                        mediator.setEntryTemplate(entryTemplate);
                        String folderId = entryTemplate.getFolder().getId();
                        if (folderId != null && !folderId.isEmpty()) {
                            String folderDocId = P8Util.getDocId("Folder", entryTemplate.getObjectStore().getId(), folderId);
                            P8SearchResultsMediator searchResultsMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
                            searchResultsMediator.setServer(connection);
                            ArrayList<IndependentlyPersistableObject> hits = new ArrayList<IndependentlyPersistableObject>();
                            IndependentlyPersistableObject object2 = P8Util.getPersistableObject(request, connection, folderDocId);
                            hits.add(object2);
                            P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                            searchResultsBean.setHits(hits);
                            searchResultsMediator.setSearchResultsBean(searchResultsBean);
                            JSONObject folderItem = searchResultsMediator.getResultRow(0);
                            mediator.setEntryTemplateFolder(folderItem);
                        }
                        mediator.addMessage("entryTemplate.open.successful", entryTemplate.getDisplayName());
                    } else {
                        mediator.addMessage("entryTemplate.open.failed", P8Util.getObjectIdentity(templateId));
                    }
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.openEntryTemplate", null);
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8EntryTemplateMediator mediator = new P8EntryTemplateMediator(request, this.getResources(request), request.getLocale());
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String folderName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "folderName = " + folderName);
        String formType = request.getParameter("form_type");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "formType = " + formType);
    }
}

