/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.ReferentialContainmentRelationshipSet;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import java.text.MessageFormat;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8MoveToFolderAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection ceConnection;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection connection2 = ceConnection = connection.getCEConnection();
        synchronized (connection2) {
            block13: {
                try {
                    this.getConfigInfo(request);
                    String serverName = request.getParameter("repositoryId");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                    searchResultsMediator.setServerName(serverName);
                    String[] itemPIDs = request.getParameterValues("docid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
                    String folderPID = request.getParameter("folderDocid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPID = " + folderPID);
                    String newFolderPID = request.getParameter("newFolderDocid");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "newFolderPID = " + newFolderPID);
                    EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)ceConnection, null);
                    Domain domain = entireNetwork.get_LocalDomain();
                    UpdatingBatch updateBatch = UpdatingBatch.createUpdatingBatchInstance((Domain)domain, (RefreshMode)RefreshMode.REFRESH);
                    searchResultsMediator.setServer(connection);
                    if (ceConnection == null) break block13;
                    String itemPID = null;
                    int errorCount = 0;
                    Folder folder = P8Util.getFolder(request, connection, folderPID);
                    Folder newFolder = P8Util.getFolder(request, connection, newFolderPID);
                    String newFolderName = newFolder.get_FolderName();
                    String itemName = "";
                    for (int iItemCounter = 0; iItemCounter < itemPIDs.length; ++iItemCounter) {
                        itemPID = itemPIDs[iItemCounter];
                        try {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPID = " + itemPID);
                            IndependentlyPersistableObject item = P8Util.getPersistableObject(request, connection, itemPID);
                            itemName = item instanceof Folder ? ((Folder)item).get_Name() : ((Document)item).get_Name();
                            this.moveToFolder(connection, item, folder, newFolder, updateBatch);
                        }
                        catch (EngineRuntimeException engineException) {
                            ++errorCount;
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)engineException);
                            ExceptionCode exceptionCode = engineException.getExceptionCode();
                            if (exceptionCode == ExceptionCode.E_NOT_UNIQUE) {
                                searchResultsMediator.addWarning("moveItemNameCollision.warning", new Object[0]);
                            } else if (exceptionCode == ExceptionCode.E_BAD_VALUE) {
                                searchResultsMediator.addWarning("moveIntoChildCollision.warning", itemName, newFolderName);
                            } else {
                                searchResultsMediator.addWarning("moveItems.warning", newFolderName, itemName);
                            }
                        }
                        catch (Exception moveItemException) {
                            ++errorCount;
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)moveItemException);
                            searchResultsMediator.addWarning("moveItems.warning", newFolderName, itemName);
                        }
                        searchResultsMediator.addMessage("moveItems.success", newFolderName, itemName);
                    }
                }
                catch (Exception e) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    searchResultsMediator.addError("error.exception.general", e.getMessage());
                }
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void moveToFolder(P8Connection connection, IndependentlyPersistableObject item, Folder folder, Folder newFolder, UpdatingBatch updateBatch) throws Exception {
        String methodName = "moveToFolder";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (item instanceof Folder) {
            ((Folder)item).move(newFolder);
            item.save(RefreshMode.NO_REFRESH);
        } else {
            ReferentialContainmentRelationship rcr2 = newFolder.file(item, AutoUniqueName.AUTO_UNIQUE, null, DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
            rcr2.save(RefreshMode.NO_REFRESH);
            ReferentialContainmentRelationshipSet containers = ((Document)item).get_Containers();
            String folderId = folder.get_Id().toString();
            for (ReferentialContainmentRelationship rcr : containers) {
                PropertyFilter pf = new PropertyFilter();
                pf.addIncludeProperty(1, null, null, "ContainmentName", null);
                pf.addIncludeProperty(1, null, null, "Tail", null);
                rcr.fetchProperties(pf);
                String containmentName = rcr.get_ContainmentName();
                Folder tail = (Folder)rcr.get_Tail();
                pf = new PropertyFilter();
                pf.addIncludeProperty(1, null, null, "Id", null);
                tail.fetchProperties(pf);
                String tailId = tail.get_Id().toString();
                if (!tailId.equalsIgnoreCase(folderId)) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, MessageFormat.format("Unfile {0} from folder {1}", containmentName, folderId));
                rcr.delete();
                rcr.save(RefreshMode.NO_REFRESH);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String[] itemPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemPIDs sent (count=" + itemPIDs.length + ")");
        String pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + itemPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
        String[] folderPIDs = request.getParameterValues("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "folderPIDs sent (count=" + folderPIDs.length + ")");
        pidList = "";
        for (int iPIDCounter = 0; iPIDCounter < itemPIDs.length; ++iPIDCounter) {
            pidList = pidList + folderPIDs[iPIDCounter] + "\n";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, pidList);
    }
}

