/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.collection.ObjectStoreSet;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.constants.AccessRight;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.mediator.p8.P8LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.SSOLogonAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.J2EEServerUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8RecordsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8LogonAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    public static String WSI_CONNECTION_TYPE = "WSI";
    public static String EJB_CONNECTION_TYPE = "EJB";

    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        P8LogonMediator logonMediator = (P8LogonMediator)this.getMediator(request);
        try {
            try {
                boolean isWebsphere = J2EEServerUtil.getJ2EEAppServerType(this.getServlet().getServletContext()) == "websphere";
                Subject subject = new ContainerLogonAction().doContainerLogin(request, response, request.getParameter("userid"), request.getParameter("password"), isWebsphere, logonMediator);
                if (Config.getApplicationConfig(request).checkAdminAccessForUser(request.getParameter("userid"))) {
                    logonMediator.setIsAdminUser("true");
                } else {
                    logonMediator.setIsAdminUser("false");
                }
            }
            catch (Throwable t) {
                logonMediator.setIsAdminUser("false");
            }
            P8LogonAction.createP8Connection(request, response, logonMediator);
            HttpSession session = Util.replaceSession(request);
        }
        catch (EngineRuntimeException e) {
            ExceptionCode c = e.getExceptionCode();
            if (c.equals(ExceptionCode.E_NOT_AUTHENTICATED)) {
                logonMediator.addError("error.bad.userid.password");
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "E_NOT_AUTHENTICATED");
            } else if (c.equals(ExceptionCode.E_UNEXPECTED_EXCEPTION)) {
                logonMediator.addError("error.server.unavailable");
                this.logFDC(request, response, null, methodName);
                Logger.logError(P8LogonAction.class, methodName, (ServletRequest)request, (Throwable)e);
            } else {
                logonMediator.addError("error.fatal");
                this.logFDC(request, response, null, methodName);
                Logger.logError(P8LogonAction.class, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        catch (Throwable e) {
            if (e.getClass().getName().equals("com.ibm.websphere.security.auth.WSLoginFailedException")) {
                logonMediator.addError("error.bad.userid.password");
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "com.ibm.websphere.security.auth.WSLoginFailedException");
            }
            logonMediator.addError("error.fatal");
            this.logFDC(request, response, null, methodName);
            Logger.logError(P8LogonAction.class, methodName, (ServletRequest)request, e);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    public static void createP8Connection(HttpServletRequest request, HttpServletResponse response, LogonMediator logonMediator) throws Exception {
        P8LogonAction.createP8Connection(request, response, logonMediator, null, null, null, null);
    }

    public static void createP8Connection(HttpServletRequest request, HttpServletResponse response, LogonMediator logonMediator, String userid, String protocol, RepositoryConfig repositoryConfig, Subject subject) throws Exception {
        boolean isSSOLogin;
        P8Connection connection = null;
        String methodName = "createP8Connection";
        if (userid == null) {
            userid = request.getParameter("userid");
        }
        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "displayName = " + repositoryId);
        String desktopName = request.getParameter("desktop");
        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        String serverName = request.getParameter("serverName");
        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "serverName = " + serverName);
        String displayName = request.getParameter("displayName");
        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "displayName = " + displayName);
        String objectStoreName = request.getParameter("objectStore");
        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "objectStoreName = " + objectStoreName);
        if (protocol == null) {
            protocol = request.getParameter("protocol");
        }
        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "protocol = " + protocol);
        String useSSO = "false";
        HttpSession session = request.getSession(true);
        if (repositoryConfig == null) {
            repositoryConfig = Config.getRepositoryConfig(request);
        }
        if (repositoryConfig != null) {
            if (serverName == null) {
                serverName = repositoryConfig.getServerName();
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "serverName = " + serverName);
                displayName = repositoryConfig.getName();
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "displayName = " + displayName);
                objectStoreName = repositoryConfig.getObjectStore();
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "objectStore=" + objectStoreName);
                protocol = repositoryConfig.getProtocol();
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "protocol=" + protocol);
            }
            useSSO = repositoryConfig.getUseSSO();
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "serverName = " + serverName + " useSSO=" + useSSO);
        }
        boolean bl = isSSOLogin = useSSO != null && useSSO.equalsIgnoreCase("TRUE");
        if (protocol == null || protocol.trim().equals("")) {
            protocol = ContainerLogonAction.NEXUS_STANZA;
        }
        if (serverName != null) {
            if (connection == null) {
                int i;
                if (logonMediator.getCurrentRepositoryId() == null && repositoryConfig != null) {
                    logonMediator.setCurrentRepositoryId(repositoryConfig.getObjectId());
                }
                HashMap<String, RepositoryConfig> sameDomainRepositoriesMap = new HashMap<String, RepositoryConfig>();
                HashMap<String, RepositoryConfig> p8SSORepositoryMap = new HashMap<String, RepositoryConfig>();
                Collection<RepositoryConfig> list = Config.getApplicationConfig("navigator").getRepositoriesList();
                P8LogonAction.appendSameDomainRepositories(sameDomainRepositoriesMap, p8SSORepositoryMap, list, displayName, serverName, request);
                list = Config.getDesktopConfig("navigator", desktopName).getRepositoryList();
                P8LogonAction.appendSameDomainRepositories(sameDomainRepositoriesMap, p8SSORepositoryMap, list, displayName, serverName, request);
                ArrayList sameDomainRepositories = new ArrayList(sameDomainRepositoriesMap.values());
                ArrayList p8SSORepositoryList = new ArrayList(p8SSORepositoryMap.values());
                request.setAttribute("userid", (Object)userid);
                request.setAttribute("password", (Object)password);
                request.setAttribute("repositoryId", (Object)displayName);
                UserContext uc = UserContext.get();
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Starting JAAS login.");
                uc.setLocale(request.getLocale());
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, " Obtaining and testing CE connection.");
                Date date = Logger.logPerf(P8LogonAction.class, methodName, (ServletRequest)request, "P8 login start");
                Connection ceConnection = Factory.Connection.getConnection((String)serverName);
                if (subject == null) {
                    subject = UserContext.createSubject((Connection)ceConnection, (String)userid, (String)password, (String)protocol);
                }
                uc.pushSubject(subject);
                Logger.logPerf(P8LogonAction.class, methodName, (ServletRequest)request, date, "P8 login completed");
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "CE connection obtained");
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "JAAS login successful.  subject  =" + subject);
                Domain domain = null;
                EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)ceConnection, null);
                String domainName = null;
                domain = domainName == null || domainName.length() == 0 ? entireNetwork.get_LocalDomain() : Factory.Domain.getInstance((Connection)ceConnection, (String)domainName);
                ObjectStore objectStore = null;
                ObjectStoreSet objectStoreSet = domain.get_ObjectStores();
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Available object stores:");
                for (ObjectStore store : objectStoreSet) {
                    Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "  " + store.get_Name());
                    if (!store.get_SymbolicName().equals(objectStoreName)) continue;
                    objectStore = store;
                }
                if (objectStore == null) {
                    logonMediator.addError("error.server.unavailable");
                    Logger.logError(P8LogonAction.class, methodName, (ServletRequest)request, "object store not found: " + objectStoreName);
                    return;
                }
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Using object store " + objectStore.get_Name());
                Integer accessRights = objectStore.getAccessAllowed();
                if ((accessRights & 0x100000) != 0x100000) {
                    Logger.logError(P8LogonAction.class, methodName, (ServletRequest)request, "Logging in User  does not have Connect privileges to objectstore=" + objectStore.get_Name() + "  serverName=" + serverName);
                    logonMediator.addError("repository.error.nopermissions", repositoryConfig.getObjectId());
                    return;
                }
                User user = entireNetwork.get_CurrentUser();
                String distinguishedName = user.get_DistinguishedName();
                userid = user.get_ShortName();
                logonMediator.setUserDisplayName(user.get_DisplayName());
                if (session != null) {
                    session.setAttribute("session_userid", (Object)userid);
                }
                boolean canAddDoc = (accessRights & AccessRight.STORE_OBJECTS.getValue()) == AccessRight.STORE_OBJECTS.getValue();
                boolean searchAddOnInstalled = false;
                boolean canAddSearch = false;
                connection = new P8Connection(userid, distinguishedName, null, uc, ceConnection, subject, domain, objectStore, user.get_Name(), user.get_DisplayName());
                try {
                    block41: {
                        PropertyFilter filter = new PropertyFilter();
                        filter.addIncludeProperty(0, null, null, "PropertyDefinitions", null);
                        ClassDefinition classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)objectStore, (String)"StoredSearch", (PropertyFilter)filter);
                        PropertyDefinitionList properties = classDefinition.get_PropertyDefinitions();
                        for (PropertyDefinition prop : properties) {
                            if (!prop.get_SymbolicName().equals("IcnShowInTree")) continue;
                            searchAddOnInstalled = true;
                            break;
                        }
                        boolean bl2 = canAddSearch = searchAddOnInstalled && canAddDoc && (classDefinition.getAccessAllowed() & 0x100) == 256;
                        if (canAddDoc) {
                            if (repositoryConfig != null && repositoryConfig.isTeamspacesEnabled()) {
                                boolean createSubFolder;
                                int objectStoreAccessAllowed;
                                Folder rootFolder;
                                try {
                                    classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)objectStore, (String)"ClbTeamspace", (PropertyFilter)filter);
                                    if ((classDefinition.getAccessAllowed() & 0x100) == 256) {
                                        rootFolder = Factory.Folder.fetchInstance((ObjectStore)objectStore, (String)"/ClbTeamspaces", null);
                                        objectStoreAccessAllowed = rootFolder.getAccessAllowed();
                                        boolean bl3 = createSubFolder = (objectStoreAccessAllowed & 0x200) > 0;
                                        if (createSubFolder) {
                                            logonMediator.setPrivAddItemTeamspace("true");
                                            connection.setPrivAddItemTeamspace("true");
                                        }
                                    } else {
                                        Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "user does not have create instance priv");
                                    }
                                }
                                catch (Exception e) {
                                    Logger.logError(P8LogonAction.class, methodName, (ServletRequest)request, (Throwable)e);
                                    logonMediator.setPrivAddItemTeamspace("false");
                                    connection.setPrivAddItemTeamspace("false");
                                }
                                try {
                                    classDefinition = Factory.ClassDefinition.fetchInstance((ObjectStore)objectStore, (String)"ClbTeamspaceTemplate", (PropertyFilter)filter);
                                    if ((classDefinition.getAccessAllowed() & 0x100) == 256) {
                                        rootFolder = Factory.Folder.fetchInstance((ObjectStore)objectStore, (String)"/ClbTeamspace Templates", null);
                                        objectStoreAccessAllowed = rootFolder.getAccessAllowed();
                                        boolean bl4 = createSubFolder = (objectStoreAccessAllowed & 0x200) > 0;
                                        if (createSubFolder) {
                                            logonMediator.setPrivAddItemTeamspaceTemplate("true");
                                            connection.setPrivAddItemTeamspaceTemplate("true");
                                        }
                                        break block41;
                                    }
                                    Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "user does not have create instance priv");
                                }
                                catch (Exception e) {
                                    Logger.logError(P8LogonAction.class, methodName, (ServletRequest)request, (Throwable)e);
                                    logonMediator.setPrivAddItemTeamspaceTemplate("false");
                                    connection.setPrivAddItemTeamspaceTemplate("false");
                                }
                            } else {
                                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Teamspaces are disabled... will not retrieve privs");
                            }
                        }
                    }
                    if (logonMediator instanceof P8LogonMediator) {
                        ((P8LogonMediator)logonMediator).setPassword("");
                    }
                    connection.setPrivAddDoc(canAddDoc ? "true" : "false");
                    connection.setPrivAddItem(canAddDoc ? "true" : "false");
                    connection.setPrivAddSearch(canAddSearch ? "true" : "false");
                    connection.setSearchTemplateSupported(searchAddOnInstalled ? "true" : "false");
                    String connectionPoint = repositoryConfig.getConnectionPoint();
                    if (connectionPoint != null && connectionPoint.length() > 0) {
                        connection.setPrivWorkflow("true");
                    } else {
                        connection.setPrivWorkflow("false");
                    }
                }
                catch (EngineRuntimeException e) {
                    Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "StoredSearch class was not found");
                }
                if (repositoryConfig == null) {
                    P8LogonAction.storeNewConnection(request, connection, null);
                } else {
                    P8LogonAction.storeNewConnection(request, connection, repositoryConfig.getObjectId());
                }
                for (i = 0; i < sameDomainRepositories.size(); ++i) {
                    RepositoryConfig domainRepo = (RepositoryConfig)sameDomainRepositories.get(i);
                    String osName = domainRepo.getObjectStore();
                    P8Connection ssoConnection = new P8Connection(userid, distinguishedName, null, uc, ceConnection, subject, domain.get_Name(), osName, user.get_Name(), user.get_DisplayName());
                    P8LogonAction.storeNewConnection(request, ssoConnection, domainRepo.getObjectId());
                }
                if (logonMediator instanceof P8LogonMediator && isSSOLogin) {
                    for (i = 0; i < p8SSORepositoryList.size(); ++i) {
                        RepositoryConfig ssoRepo = (RepositoryConfig)p8SSORepositoryList.get(i);
                        Connection ssoCEConnection = Factory.Connection.getConnection((String)ssoRepo.getServerName());
                        String osName = ssoRepo.getObjectStore();
                        String domName = null;
                        P8Connection ssoConnection = new P8Connection(userid, distinguishedName, null, uc, ssoCEConnection, subject, domName, osName, user.get_Name(), user.get_DisplayName());
                        P8LogonAction.storeNewConnection(request, ssoConnection, ssoRepo.getObjectId());
                    }
                    SSOLogonAction.doSSOLogonForCM8(request, logonMediator);
                    SSOLogonAction.doSSOLogonForOD(request, response, logonMediator);
                }
                Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("p8_servers");
                logonMediator.setP8ConnectionList(connectionList);
            } else {
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Re-using server object from session.");
            }
            ObjectStore os = connection.getObjectStore();
            if (os != null && logonMediator instanceof P8LogonMediator) {
                P8LogonMediator p8LogonMediator = (P8LogonMediator)logonMediator;
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Record Repository object store: " + os.get_Name());
                String recordType = P8RecordsUtil.getRecordRepositoryType(os).toString();
                p8LogonMediator.setRecordType(recordType);
                connection.setObjectStoreRecordType(recordType);
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Repository Record Type: " + recordType);
                if (recordType.equals(P8RecordsUtil.RecordRepositoryType.FilePlan.toString())) {
                    String datamodel = P8RecordsUtil.getDatamodelType(os).toString();
                    p8LogonMediator.setRecordDatamodelType(datamodel);
                    Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "Repository Datamodel Type: " + datamodel);
                }
            }
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "No action errors returned.");
            logonMediator.addMessage("logon.successful", userid);
        } else {
            logonMediator.addError("error.parm.null", "repositoryId");
        }
    }

    public static void appendSameDomainRepositories(Map<String, RepositoryConfig> sameDomainRepositories, Map<String, RepositoryConfig> p8SSORepositoryList, Collection<RepositoryConfig> repositoryList, String displayName, String serverName, HttpServletRequest request) {
        String methodName = "appendSameDomainRepositories";
        for (RepositoryConfig ssoRepoConfig : repositoryList) {
            if (ssoRepoConfig == null) continue;
            if (ssoRepoConfig.getName() != null && ssoRepoConfig.getName().equals(displayName)) {
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "The P8 server using for logging in '" + ssoRepoConfig.getServerName());
                continue;
            }
            if (!ssoRepoConfig.getType().equals("p8")) continue;
            String useSSO = ssoRepoConfig.getUseSSO();
            if (ssoRepoConfig.getServerName() != null && ssoRepoConfig.getServerName().equalsIgnoreCase(serverName)) {
                sameDomainRepositories.put(ssoRepoConfig.getKey(), ssoRepoConfig);
                Logger.logInfo(P8LogonAction.class, methodName, (ServletRequest)request, "The P8 Repository is configured with the same URL '" + serverName + ". Will be logged in automatically.  RepositoryName=" + ssoRepoConfig.getObjectId());
                continue;
            }
            if (useSSO != null && useSSO.equalsIgnoreCase("TRUE") && P8LogonAction.getConnectionType(ssoRepoConfig.getServerName()).equals(EJB_CONNECTION_TYPE)) {
                p8SSORepositoryList.put(ssoRepoConfig.getKey(), ssoRepoConfig);
                Logger.logInfo(P8LogonAction.class, methodName, (ServletRequest)request, "The P8 server configured is for SSO '" + ssoRepoConfig.getServerName() + ".  RepositoryName=" + ssoRepoConfig.getObjectId());
                continue;
            }
            if (useSSO == null || !useSSO.equalsIgnoreCase("TRUE") || !P8LogonAction.getConnectionType(ssoRepoConfig.getServerName()).equals(WSI_CONNECTION_TYPE)) continue;
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, serverName + " is WSI.  SO we are not doing SSO for the repositories");
        }
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        LogonMediator logonMediator = (LogonMediator)this.getMediator(request);
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        Object server = null;
        if (userid == null || userid.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid was not found");
            logonMediator.addError("error.parm.null", "userid");
            this.setRequestHasErrors(request, true);
        }
        if (password == null || password.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "password was not found");
            logonMediator.addError("error.parm.null", "password");
            this.setRequestHasErrors(request, true);
        }
        if (serverName == null || serverName.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "server name was not found");
            logonMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (this.getRequestHasErrors(request)) {
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            return false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return true;
    }

    public static void storeNewConnection(HttpServletRequest request, P8Connection connection, String repositoryId) {
        if (repositoryId == null) {
            P8LogonAction.setConnection(request, connection);
        } else {
            P8LogonAction.setConnection(request, connection, repositoryId);
        }
    }

    public static Hashtable getServerList(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return (Hashtable)session.getAttribute("p8_servers");
    }

    public static void removeServerList(HttpServletRequest request) {
        String methodName = "removeServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            Hashtable p8_server_List = P8LogonAction.getServerList(request);
            Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "   current P8 connection list: " + p8_server_List);
            if (p8_server_List != null) {
                Logger.logInfo(P8LogonAction.class, methodName, (ServletRequest)request, "current P8 connection list size: " + p8_server_List.size());
                session.removeAttribute("p8_servers");
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "   removed all P8 connections from session: " + p8_server_List);
            }
        }
    }

    public static void setServerList(HttpServletRequest request, Hashtable connectionList) {
        String methodName = "setServerList";
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("p8_servers");
            if (connectionList != null) {
                Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "   add P8 connections from session: " + connectionList);
                Object[] keys = connectionList.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    Logger.logDebug(P8LogonAction.class, methodName, (ServletRequest)request, "   add P8 connection: " + (String)keys[i]);
                    P8Connection connection = (P8Connection)connectionList.get((String)keys[i]);
                    P8LogonAction.storeNewConnection(request, connection, (String)keys[i]);
                }
            }
        }
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        String serverName = (String)this.getAttribute(request, "repositoryId");
        P8LogonMediator logonMediator = new P8LogonMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)logonMediator);
        return logonMediator;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String displayName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "displayName = " + displayName);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
    }

    public static String getConnectionType(String uri) {
        if (uri == null || uri.length() < 4) {
            return null;
        }
        if (uri.substring(0, 4).equalsIgnoreCase("http")) {
            return WSI_CONNECTION_TYPE;
        }
        return EJB_CONNECTION_TYPE;
    }

    private class UserPasswordHandler
    implements CallbackHandler {
        private String userid;
        private String password;
        private HttpSession session = null;

        public UserPasswordHandler(HttpSession session, String userid, String password) {
            this.userid = userid;
            this.password = password;
            this.session = session;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String methodName = "handle";
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextOutputCallback) {
                    TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                    switch (toc.getMessageType()) {
                        case 0: {
                            Logger.logInfo((Object)this, methodName, this.session, "INFORMATION: " + toc.getMessage());
                            break;
                        }
                        case 2: {
                            Logger.logError((Object)this, methodName, this.session, "ERROR: " + toc.getMessage());
                            break;
                        }
                        case 1: {
                            Logger.logWarning((Object)this, methodName, this.session, "WARNING: " + toc.getMessage());
                        }
                    }
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.userid);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                Logger.logWarning((Object)this, methodName, this.session, "Unexpected callback: " + callbacks[i].toString());
            }
        }
    }
}

