/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.constants.VersionStatus;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.security.User;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8LockItemAction
extends P8BaseAction {
    private int pageSize = 0;
    private int maxResults = 0;
    private WCDateFormat wcDateFormats = null;
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        User currentUser = Factory.User.fetchCurrent((Connection)ceConnection, null);
        Connection connection2 = ceConnection;
        synchronized (connection2) {
            try {
                this.getConfigInfo(request);
                String docId = request.getParameter("docid");
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                searchResultsMediator.setServerName(serverName);
                String folderName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + folderName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
                String[] docIds = request.getParameterValues("docid");
                searchResultsMediator.setServer(connection);
                ArrayList<IndependentlyPersistableObject> hits = new ArrayList<IndependentlyPersistableObject>();
                String documentName = null;
                int errorCount = 0;
                int successCount = 0;
                ArrayList<String> errorItemNames = new ArrayList<String>();
                if (ceConnection != null) {
                    for (int i = 0; i < docIds.length; ++i) {
                        documentName = docIds[i];
                        Document document = null;
                        try {
                            boolean isReleased;
                            IndependentlyPersistableObject item = P8Util.getPersistableObject(request, connection, docIds[i]);
                            hits.add(item);
                            document = (Document)item;
                            boolean isCurrentVersion = document.get_IsCurrentVersion();
                            boolean bl = isReleased = document.get_VersionStatus() == VersionStatus.RELEASED;
                            if (!isCurrentVersion) {
                                document = (Document)document.get_CurrentVersion();
                            }
                            if (document.get_IsReserved().booleanValue()) {
                                Document reservation = (Document)document.get_Reservation();
                                String checkedOutUserid = reservation.get_Creator();
                                String loggedOnUserid = currentUser.get_Name();
                                ReservationType reservationType = reservation.get_ReservationType();
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "checked out by = " + checkedOutUserid);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "logged on user name = " + loggedOnUserid);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "reservation type = " + (reservationType == ReservationType.EXCLUSIVE ? "Exclusive" : "Collaborative"));
                                if (docIds.length <= 1 && !checkedOutUserid.equals(connection.getUserId())) {
                                    searchResultsMediator.addError("error.lock.lockedByOtherUser");
                                }
                            } else {
                                document.checkout(ReservationType.OBJECT_STORE_DEFAULT, null, null, null);
                                document.save(RefreshMode.REFRESH);
                                ++successCount;
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item is now locked " + docIds[i]);
                            }
                            boolean checkedOut = document.get_IsReserved();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item value checked out = " + checkedOut + " and checked out by " + currentUser);
                            if (isCurrentVersion) continue;
                            item.refresh();
                            if (!isReleased) continue;
                            searchResultsMediator.setShowCheckoutIfReservation(true);
                            continue;
                        }
                        catch (Exception e) {
                            ++errorCount;
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                            if (document != null) {
                                documentName = document.get_Name();
                            }
                            errorItemNames.add(documentName);
                        }
                    }
                }
                P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                searchResultsBean.setHits(hits);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of items found -->  [Vector = " + hits.size() + "] [SearchResults Bean = " + searchResultsBean.size() + "]");
                searchResultsMediator.setPageSize(this.getPageSize());
                searchResultsMediator.setSearchResultsBean(searchResultsBean);
                if (docIds.length > 1) {
                    if (errorCount == docIds.length && successCount == 0) {
                        searchResultsMediator.addWarning("document.checkout.none", new Object[0]);
                    } else if (errorCount > 0) {
                        String docNames = "";
                        Integer errorItemCounter = 0;
                        while (errorItemCounter < errorItemNames.size()) {
                            if (errorItemCounter > 0) {
                                docNames = docNames + "<br/>";
                            }
                            docNames = docNames + errorItemNames.get(errorItemCounter);
                            Integer n = errorItemCounter;
                            Integer n2 = errorItemCounter = Integer.valueOf(errorItemCounter + 1);
                        }
                        searchResultsMediator.addWarning("document.checkout.partial", errorItemCounter.toString(), docNames);
                    }
                    if (successCount == 1) {
                        searchResultsMediator.addMessage("document.checkout.multi.success.single", new Object[0]);
                    } else if (successCount > 1) {
                        searchResultsMediator.addMessage("document.checkout.multi.success", String.valueOf(successCount));
                    }
                } else if (errorCount == 0) {
                    searchResultsMediator.addMessage("document.checkout.single.success", new Object[0]);
                } else {
                    searchResultsMediator.addWarning("document.checkout.single", new Object[0]);
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator baseMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String docId = request.getParameter("docid");
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "docid param values=" + docId);
    }
}

