/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Connection;
import com.filenet.api.core.ObjectStore;
import com.ibm.ecm.Constants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8TeamspaceListMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.ecm.util.p8.P8Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8ListTeamspaces
extends P8BaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String workspaceType = request.getParameter("workspaceType");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceType = " + workspaceType);
        if (workspaceType == null) {
            workspaceType = "instance";
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceType = " + workspaceType);
        String configInfo = request.getParameter("service_CM_configInfo");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "configURL = " + configInfo);
        String desktopName = request.getParameter("desktop");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        String workspaceId = request.getParameter("workspaceId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + workspaceId);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        P8TeamspaceListMediator workspaceListMediator = (P8TeamspaceListMediator)this.getMediator(request);
        try {
            if (ceConnection != null) {
                ObjectStore objectStore = connection.getObjectStore();
                P8TeamspaceService workspaceService = new P8TeamspaceService(ceConnection, connection.getDomain(), objectStore, connection, request);
                if (workspaceId != null && workspaceId.length() > 0) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieve workspace by id");
                    Teamspace workspace = workspaceService.retrieveTeamspace(workspaceId, "allData", workspaceType);
                    ArrayList<Teamspace> workspaces = new ArrayList<Teamspace>();
                    if (workspace != null) {
                        if (workspace.getState().equals("deleted")) {
                            workspaceListMediator.addError("openTeamspace.error.failed.deleted");
                        } else {
                            workspaces.add(workspace);
                            workspaceListMediator.setTeamspaces(workspaces);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Workpaces were retrieved");
                            workspaceListMediator.addMessage("workspaces.retrieve.successful", new Object[0]);
                        }
                    } else {
                        workspaceListMediator.addError("retrieveTeamspace.error.failed");
                    }
                } else {
                    List<Teamspace> workspaces;
                    if (workspaceType.equals("template")) {
                        String retrieval = "template";
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieve list of template");
                        workspaces = workspaceService.retrieveTeamspaces(workspaceType, "all", retrieval);
                    } else {
                        String retrieval = "instance";
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieve list of teamspace");
                        workspaces = workspaceService.retrieveTeamspaces(workspaceType, "published", retrieval);
                    }
                    Collections.sort(workspaces, new Comparator<Teamspace>(){

                        @Override
                        public int compare(Teamspace w1, Teamspace w2) {
                            return w1.getName().compareTo(w2.getName());
                        }
                    });
                    workspaceListMediator.setTeamspaces(workspaces);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Workpaces were retrieved");
                    workspaceListMediator.addMessage("workspaces.retrieve.successful", new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, e);
            workspaceListMediator.addError("retrieveTeamspace.error.failed", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, "validateRequest", (ServletRequest)request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, "validateRequest", (ServletRequest)request, "serverName = " + serverName);
        P8TeamspaceListMediator workspaceListMediator = (P8TeamspaceListMediator)this.getMediator(request);
        if (serverName == null || serverName.trim().length() < 1) {
            workspaceListMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, "validateRequest", (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8TeamspaceListMediator workpaceListMediator = new P8TeamspaceListMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)workpaceListMediator);
        return workpaceListMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String configInfo = request.getParameter("service_CM_configInfo");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "configURL = " + configInfo);
    }
}

