/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Connection;
import com.filenet.api.core.ObjectStore;
import com.ibm.ecm.Constants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.RoleListMediator;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.p8.P8SecurityService;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8ListRolesAction
extends P8BaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        RoleListMediator rolesListMediator = (RoleListMediator)this.getMediator(request);
        try {
            if (ceConnection != null) {
                MessageResources resources = this.getResources(request);
                Locale locale = request.getLocale();
                ObjectStore objectStore = connection.getObjectStore();
                P8SecurityService secServ = new P8SecurityService(request, ceConnection, objectStore);
                ArrayList<Role> roles = new ArrayList<Role>();
                String name = resources.getMessage(locale, "roles.owner.name");
                String desc = resources.getMessage(locale, "roles.owner.description");
                Role role = new Role("{335B6E5F-8E0D-4426-B548-B485DCF67CAA}", name, desc, P8SecurityService.ALL_PRIVILEGES_P8);
                role.setOwner(true);
                role.setPreDefined(true);
                role.setMessageId("roles.owner");
                roles.add(role);
                Random r = new Random();
                String roleId = "ROLE_" + r.nextLong();
                name = resources.getMessage(locale, "roles.member.name");
                desc = resources.getMessage(locale, "roles.member.description");
                role = new Role(roleId, name, desc, P8SecurityService.MEMBER_PRIVILEGES_P8);
                role.setRoleType(SecurityConstants.RoleType.TEMPLATE);
                role.setOwner(false);
                role.setPreDefined(true);
                role.setMessageId("roles.member");
                roles.add(role);
                r = new Random();
                roleId = "ROLE_" + r.nextLong();
                name = resources.getMessage(locale, "roles.reviewer.name");
                desc = resources.getMessage(locale, "roles.reviewer.description");
                role = new Role(roleId, name, desc, P8SecurityService.REVIEWER_PRIVILEGES_P8);
                role.setRoleType(SecurityConstants.RoleType.TEMPLATE);
                role.setOwner(false);
                role.setPreDefined(true);
                role.setMessageId("roles.reviewer");
                roles.add(role);
                List<Role> templateRoles = secServ.retrieveRoles(SecurityConstants.RoleType.TEMPLATE, false);
                roles.addAll(templateRoles);
                rolesListMediator.setRoles(roles);
            }
            rolesListMediator.addMessage("roles.retrieve.successful", new Object[0]);
        }
        catch (Throwable e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, e);
            rolesListMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        RoleListMediator rolesListMediator = new RoleListMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)rolesListMediator);
        return rolesListMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

