/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.IndependentlyPersistableObject;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.configuration.UserConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.ListFavoritesMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8ListFavoritesAction
extends P8BaseAction {
    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator searchResultsMediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        return searchResultsMediator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName;
        block11: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding("UTF-8");
            }
            P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
            P8Connection connection = this.getConnection(request);
            searchResultsMediator.setServer(connection);
            try {
                try {
                    String osId = request.getParameter("repositoryId");
                    Map<String, UserConfig> userConfigs = this.getConfiguration(request);
                    Collection<FavoriteConfig> favoriteList = new ArrayList<FavoriteConfig>();
                    for (UserConfig userConfig : userConfigs.values()) {
                        for (FavoriteConfig favoriteConfig : userConfig.getFavoriteList()) {
                            if (!favoriteConfig.getRepositoryId().equals(osId.trim())) continue;
                            favoriteList.add(favoriteConfig);
                        }
                    }
                    if (favoriteList.size() > 1) {
                        favoriteList = this.sortFavorites(favoriteList);
                    }
                    ArrayList<IndependentlyPersistableObject> hits = new ArrayList<IndependentlyPersistableObject>();
                    for (FavoriteConfig favoriteConfig : favoriteList) {
                        IndependentlyPersistableObject object = P8Util.getPersistableObject(request, connection, favoriteConfig.getItemId());
                        hits.add(object);
                    }
                    P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                    searchResultsBean.setHits(hits);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, " number of favorite found -->  [Vector = " + hits.size() + "] [SearchResults Bean = " + searchResultsBean.size() + "]");
                    searchResultsMediator.setPageSize(this.pageSize);
                    searchResultsMediator.setSearchResultsBean(searchResultsBean);
                }
                catch (Exception e) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    String favoriteAction = request.getParameter("action");
                    if (favoriteAction != null && favoriteAction.equalsIgnoreCase("favorite")) {
                        searchResultsMediator.addError("error.exception.favoriteNotFound");
                    } else {
                        searchResultsMediator.addError("error.exception.general", e.getMessage());
                    }
                    this.setRequestHasErrors(request, true);
                    Object var16_18 = null;
                    this.writeJSONMediator(request, response);
                    break block11;
                }
                Object var16_17 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                this.writeJSONMediator(request, response);
                throw throwable;
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private Collection<FavoriteConfig> sortFavorites(Collection<FavoriteConfig> favoriteList) {
        ArrayList<FavoriteConfig> resultList = new ArrayList<FavoriteConfig>();
        resultList.addAll(this.findFavoritesByType(favoriteList, "teamspace"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "folder"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "search"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "document"));
        return resultList;
    }

    private Collection<FavoriteConfig> findFavoritesByType(Collection<FavoriteConfig> favoriteList, String type) {
        ArrayList<FavoriteConfig> resultList = new ArrayList<FavoriteConfig>();
        for (FavoriteConfig favorite : favoriteList) {
            if (favorite.getType() == null || !favorite.getType().equals(type)) continue;
            resultList.add(favorite);
        }
        Collections.sort(resultList);
        return resultList;
    }

    private Map<String, UserConfig> getConfiguration(HttpServletRequest request) throws Exception {
        String methodName = "getConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String userIds = request.getParameter("userid");
        String[] ids = userIds.split(",");
        LinkedHashMap<String, UserConfig> userConfigs = new LinkedHashMap<String, UserConfig>();
        try {
            for (String id : ids) {
                if (userConfigs.get(id = id.toLowerCase(request.getLocale())) != null) continue;
                userConfigs.put(id, Config.getUserConfig(appName, id));
            }
        }
        catch (Exception e) {
            ListFavoritesMediator listFavoritesMediator = (ListFavoritesMediator)this.getMediator(request);
            listFavoritesMediator.addError("desktop.configError");
            Logger.logError((Object)this, "getConfiguration", (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return userConfigs;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        String userName = request.getParameter("userid");
        String action = request.getParameter("action");
        String id = request.getParameter("id");
        String osId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: app name = " + appName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: desktop name = " + desktopName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: user id = " + userName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: action = " + action);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: id = " + id);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: os id = " + osId);
        if (userName == null || userName.trim().length() == 0 || osId == null || osId.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "userid", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    private static Collator getCollator(Locale locale) {
        Collator localCollator = null;
        localCollator = locale == null ? Collator.getInstance() : Collator.getInstance(locale);
        return localCollator;
    }
}

