/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.admin.IsolatedRegion;
import com.filenet.api.admin.PEConnectionPoint;
import com.filenet.api.collection.PEConnectionPointSet;
import com.filenet.api.core.Domain;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8ListConnectionPointsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8ListConnectionPointsAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        String action = request.getParameter("action");
        P8ListConnectionPointsMediator listConnectionPointsMediator = (P8ListConnectionPointsMediator)this.getMediator(request);
        try {
            if (action.equals("list")) {
                this.getConnectionPointList(request, response);
            } else {
                Logger.logError((Object)this, "executeBaseAction", (ServletRequest)request, "Invalid action type: " + action);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            listConnectionPointsMediator.addError("desktop.configError");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    private void getConnectionPointList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "getConnectionPointList";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        Vector<String> cpCollection = new Vector<String>();
        P8Connection connection = this.getConnection(request);
        Domain localDomain = connection.getDomain();
        try {
            PEConnectionPointSet set = localDomain.get_PEConnectionPoints();
            int size = ((AbstractEngineSet)set).getList().size();
            if (size != 0) {
                for (PEConnectionPoint connectionPoint : set) {
                    IsolatedRegion isolatedRegion = connectionPoint.get_IsolatedRegion();
                    Integer isoRegionNumber = isolatedRegion.get_IsolatedRegionNumber();
                    cpCollection.add(connectionPoint.get_Name() + ":" + isoRegionNumber.toString());
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        P8ListConnectionPointsMediator listConnectionPointsMediator = (P8ListConnectionPointsMediator)this.getMediator(request);
        listConnectionPointsMediator.setP8ConnectionPointsCollection(cpCollection);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: server = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8ListConnectionPointsMediator baseMediator = new P8ListConnectionPointsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
    }
}

