/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Query;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8GetSearchTemplatesAction
extends P8BaseAction {
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block18: {
            String methodName = "executeAction";
            HttpSession session = request.getSession(false);
            boolean workspaceMode = false;
            Logger.logEntry((Object)this, "executeAction", (ServletRequest)request);
            P8Connection connection = this.getConnection(request);
            Connection ceConnection = connection.getCEConnection();
            P8SearchResultsMediator mediator = (P8SearchResultsMediator)this.getMediator(request);
            String serverName = request.getParameter("repositoryId");
            String workspaceId = request.getParameter("workspaceId");
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "workspaceId = " + workspaceId);
            boolean getTeamspaceSavedSearches = false;
            String getTeamspaceSavedSearchesParm = request.getParameter("getTeamspaceSavedSearches");
            if (getTeamspaceSavedSearchesParm != null) {
                getTeamspaceSavedSearches = Boolean.parseBoolean(getTeamspaceSavedSearchesParm);
            }
            try {
                if (serverName == null || serverName.trim().length() < 1) {
                    mediator.addError("error.parm.null", "repositoryId");
                    break block18;
                }
                mediator.setServerName(serverName);
                mediator.setServer(connection);
                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, " connection = " + ceConnection);
                SearchSQL searchSQL = new SearchSQL();
                StringBuilder selectList = new StringBuilder();
                selectList.append("DocumentTitle,");
                selectList.append("Description").append(",");
                selectList.append("Id").append(",");
                selectList.append("VersionSeries").append(",");
                selectList.append("ClassDescription").append(",");
                selectList.append("MimeType").append(",");
                selectList.append("DateLastModified").append(",");
                selectList.append("Creator").append(",");
                selectList.append("DateCreated").append(",");
                selectList.append("LastModifier").append(",");
                selectList.append("IsReserved").append(",");
                selectList.append("Reservation").append(",");
                selectList.append("IsCurrentVersion").append(",");
                selectList.append("IsFrozenVersion").append(",");
                selectList.append("IsVersioningEnabled").append(",");
                selectList.append("MajorVersionNumber").append(",");
                selectList.append("MinorVersionNumber").append(",");
                selectList.append("VersionStatus").append(",");
                selectList.append("ContentSize").append(",");
                selectList.append("ReplicationGroup");
                if (connection.isSearchAddOnInstalled()) {
                    selectList.append(",").append("IcnAutoRun");
                    selectList.append(",").append("IcnShowInTree");
                }
                searchSQL.setSelectList(selectList.toString());
                searchSQL.setFromClauseInitialValue("StoredSearch", null, true);
                if (getTeamspaceSavedSearches) {
                    String teamspaceFolderId = P8Util.getObjectIdentity(workspaceId);
                    searchSQL.setWhereClause("This INSUBFOLDER ('" + teamspaceFolderId + "') AND (VersionStatus = 1)");
                } else {
                    searchSQL.setWhereClause("VersionStatus = 1");
                }
                searchSQL.setOrderByClause("DocumentTitle");
                ObjectStore objectStore = connection.getObjectStore();
                SearchScope searchScope = new SearchScope(objectStore);
                PropertyFilter filter = null;
                filter = P8Query.getDocumentPropertyFilter();
                IndependentObjectSet resultsObjectSet = searchScope.fetchObjects(searchSQL, Integer.valueOf(0), filter, Boolean.valueOf(true));
                Iterator resultsObjectSetIterator = resultsObjectSet.iterator();
                ArrayList<Document> hits = new ArrayList<Document>();
                if (getTeamspaceSavedSearches) {
                    while (resultsObjectSetIterator.hasNext()) {
                        Document resultsObject = (Document)resultsObjectSetIterator.next();
                        hits.add(resultsObject);
                    }
                } else {
                    List<Object> teamspaceSearchIds = new ArrayList();
                    if (workspaceId != null && workspaceId.length() > 0) {
                        P8TeamspaceService teamspaceService = new P8TeamspaceService(ceConnection, connection.getDomain(), objectStore, connection, request);
                        Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "retrieving teamspace");
                        Teamspace teamspace = teamspaceService.retrieveTeamspace(workspaceId, "searches", "instance");
                        if (teamspace != null) {
                            teamspaceSearchIds = teamspace.getSearches();
                            if (teamspaceSearchIds != null && !teamspaceSearchIds.isEmpty()) {
                                workspaceMode = true;
                            } else {
                                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "No search found in the teamspace.  Defaulting to repository list");
                            }
                        } else {
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "teamspace not found!");
                        }
                    }
                    while (resultsObjectSetIterator.hasNext()) {
                        Document resultsObject = (Document)resultsObjectSetIterator.next();
                        if (workspaceMode) {
                            Properties p = resultsObject.getProperties();
                            String tempId = p.getIdValue("Id").toString();
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "tempId = " + tempId);
                            if (teamspaceSearchIds.contains(tempId)) {
                                Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "found match in workspace. adding it to the collection");
                                hits.add(resultsObject);
                                continue;
                            }
                            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "did not find match in workspace for : " + tempId);
                            continue;
                        }
                        hits.add(resultsObject);
                    }
                }
                P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                searchResultsBean.setHits(hits);
                mediator.setSearchResultsBean(searchResultsBean);
                mediator.addClassDescription(Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)"StoredSearch", null));
            }
            catch (Exception e) {
                this.logFDC(request, response, null, "executeAction");
                Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
        this.writeJSONMediator(request, response);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator mediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

