/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.core.Document;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.security.SecurityPolicy;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8ItemMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8SecurityPolicy;
import com.ibm.ecm.util.p8.P8Util;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetItemAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        Object servers = null;
        HttpSession session = request.getSession(false);
        MessageResources resources = this.getResources(request);
        P8Connection connection = null;
        Object synchObject = new Object();
        String mimetype = null;
        String fileExtension = "";
        String fileName = "";
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String folderName = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: folderName = " + folderName);
        String documentID = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
        String transform = request.getParameter("transform");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        boolean includeSegmentInfo = this.getBooleanRequestParameter(request, "include_segment_info", false);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: include_segment_info = " + includeSegmentInfo);
        String segmentNumString = request.getParameter("segment_num");
        int segmentNum = -1;
        if (segmentNumString != null) {
            segmentNum = Integer.valueOf(segmentNumString);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: segment_num = " + segmentNumString);
        P8ItemMediator itemMediator = (P8ItemMediator)this.getMediator(request);
        if (serverName == null || serverName.trim().length() < 1) {
            itemMediator.addError("error.parm.null", "repositoryId");
        }
        if (folderName == null || folderName.trim().length() < 1) {
            itemMediator.addError("error.parm.null", "template_name");
        }
        if (documentID == null || documentID.trim().length() < 1) {
            itemMediator.addError("error.parm.null", "docid");
        }
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        itemMediator.setRepositoryConfig(repositoryConfig);
        try {
            connection = this.getConnection(request);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            itemMediator.addError("error.exception.general", e.getMessage());
            this.writeJSONMediator(request, response);
            return actionForward;
        }
        Object object = synchObject = connection == null ? new Object() : connection;
        synchronized (object) {
            try {
                block17: {
                    try {
                        Document document;
                        SecurityPolicy secPolicy;
                        if (serverName == null) {
                            itemMediator.addError("error.parm.null", "repositoryId");
                            break block17;
                        }
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering code area...");
                        ObjectStore objectStore = P8Util.getObjectStore(request, connection, documentID);
                        itemMediator.setObjectStore(objectStore);
                        IndependentlyPersistableObject item = P8Util.getPersistableObject(request, connection, documentID);
                        itemMediator.setHit(item);
                        if (item instanceof Document && (secPolicy = (document = (Document)item).get_SecurityPolicy()) != null) {
                            P8SecurityPolicy sp = new P8SecurityPolicy(connection, secPolicy);
                            itemMediator.setSecurityPolicy(sp);
                        }
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Fetched document");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "mimetype = " + mimetype);
                        this.writeJSONMediator(request, response);
                    }
                    catch (Exception e) {
                        if (e.getClass().getName().endsWith("ClosedConnectionException") || e.getClass().getName().endsWith("ClientAbortException")) {
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Client closed connection before reading entire response");
                        } else {
                            this.logFDC(request, response, null, methodName);
                            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                            itemMediator.addError("error.exception.general", e.getMessage());
                            this.writeJSONMediator(request, response);
                        }
                        Object var33_35 = null;
                    }
                }
                Object var33_34 = null;
            }
            catch (Throwable throwable) {
                Object var33_36 = null;
                throw throwable;
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8ItemMediator itemMediator = new P8ItemMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)itemMediator);
        return itemMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String folderName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: folderName = " + folderName);
        String documentID = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + documentID);
        String transform = request.getParameter("transform");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
    }
}

