/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.AnnotationSet;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.core.Annotation;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.util.Id;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8EntryTemplatesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8FolderTemplates;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.ecm.util.p8.P8WcmPrefsObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8GetEntryTemplatesAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    private static final List<String> TEMPLATE_PROPERTIES = Arrays.asList("Id", "VersionSeries", "DocumentTitle", "EntryTemplateDescription", "TargetObjectStoreName");

    public int searchForAllEntryTemplates(ObjectStore objectStore, P8EntryTemplatesMediator mediator, String mimeType) {
        int entryTemplateCount = 0;
        SearchSQL searchSQL = new SearchSQL();
        searchSQL.setFromClauseInitialValue("EntryTemplate", null, true);
        StringBuilder sqlWhere = new StringBuilder();
        if (mimeType != null && mimeType.length() > 0) {
            sqlWhere.append("MimeType = '").append(mimeType).append("' AND ");
        }
        sqlWhere.append("VersionStatus").append(" = ").append(1);
        searchSQL.setWhereClause(sqlWhere.toString());
        searchSQL.setOrderByClause("DocumentTitle");
        SearchScope searchScope = new SearchScope(objectStore);
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "DocumentTitle", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "EntryTemplateDescription", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "TargetObjectStoreName", null));
        IndependentObjectSet resultsObjectSet = searchScope.fetchObjects(searchSQL, Integer.valueOf(0), pf, Boolean.valueOf(false));
        for (IndependentlyPersistableObject resultsObject : resultsObjectSet) {
            Properties p = resultsObject.getProperties();
            String id = P8Util.getDocId(resultsObject.getObjectReference());
            String name = p.getStringValue("DocumentTitle");
            String description = p.getStringValue("EntryTemplateDescription");
            String osName = p.getStringValue("TargetObjectStoreName");
            mediator.addEntryTemplate(id, name, description, osName);
            ++entryTemplateCount;
        }
        return entryTemplateCount;
    }

    public int retrieveEntryTemplatesAssociatedWithFolder(P8Connection connection, ObjectStore objectStore, P8EntryTemplatesMediator mediator, String folderDocId, String rootFolderId) throws Exception {
        String methodName = "retrieveEntryTemplatesAssociatedWithFolder";
        int entryTemplateCount = 0;
        String rootFolderObjectId = "";
        if (rootFolderId != null && rootFolderId.length() > 0) {
            rootFolderObjectId = P8Util.getObjectIdentity(rootFolderId);
        }
        String folderId = P8Util.getObjectIdentity(folderDocId);
        ArrayList<String> folderIds = new ArrayList<String>();
        folderIds.add(folderId);
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(0, null, null, "Parent", null);
        pf.addIncludeProperty(0, null, null, "Id", null);
        Folder folder = Factory.Folder.fetchInstance((ObjectStore)objectStore, (Id)new Id(folderId), (PropertyFilter)pf);
        while (folder.getProperties().isPropertyPresent("Parent") && (rootFolderObjectId.length() <= 0 || !rootFolderObjectId.equals(folder.get_Id().toString())) && (folder = folder.get_Parent()) != null) {
            folderIds.add(folder.get_Id().toString());
        }
        if (folderIds == null || folderIds.size() < 1) {
            return 0;
        }
        pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "AnnotatedObject", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Id", null));
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("DateLastModified").append(",");
        sqlSelect.append("MimeType").append(",");
        sqlSelect.append("AnnotatedObject");
        SearchSQL search = new SearchSQL();
        search.setSelectList(sqlSelect.toString());
        search.setFromClauseInitialValue("Annotation", null, true);
        StringBuilder sqlWhere = new StringBuilder();
        for (String listFolderId : folderIds) {
            if (sqlWhere.length() > 0) {
                sqlWhere.append(" OR ");
            }
            sqlWhere.append("AnnotatedObject").append(" = Object('").append(listFolderId).append("')");
        }
        sqlWhere.insert(0, "(").append(")");
        sqlWhere.append(" AND ").append("MimeType").append(" = '").append("application/x-filenet-folderprefs-templates").append("'");
        search.setWhereClause(sqlWhere.toString());
        SearchScope scope = new SearchScope(objectStore);
        AnnotationSet annotations = (AnnotationSet)scope.fetchObjects(search, null, pf, Boolean.valueOf(false));
        if (annotations == null) {
            return 0;
        }
        Annotation annotation = null;
        HashMap<String, Annotation> annotsMap = new HashMap<String, Annotation>();
        for (Annotation ann : annotations) {
            String f = ann.get_AnnotatedObject().getProperties().getIdValue("Id").toString();
            annotsMap.put(f, ann);
        }
        for (String f : folderIds) {
            Annotation folderAnnotation = (Annotation)annotsMap.get(f);
            if (folderAnnotation == null) continue;
            annotation = folderAnnotation;
            break;
        }
        if (annotation == null) {
            return 0;
        }
        pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "ContentElements", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Content", null));
        annotation.fetchProperties(pf);
        ContentElementList contents = annotation.get_ContentElements();
        int numTemplates = 0;
        Iterator iter = contents.iterator();
        while (iter.hasNext()) {
            StringBuilder sqlWhereTemplates = new StringBuilder();
            ContentTransfer content = (ContentTransfer)iter.next();
            InputStream stream = content.accessContentStream();
            P8FolderTemplates folderTemplates = (P8FolderTemplates)P8WcmPrefsObject.loadPreferences(stream);
            List<P8FolderTemplates.P8FolderTemplate> templates = folderTemplates.getFolderTemplates();
            numTemplates = templates.size();
            for (P8FolderTemplates.P8FolderTemplate template : templates) {
                String templateId = template.getTemplateVersionSeriesId();
                if (sqlWhereTemplates.length() > 0) {
                    sqlWhereTemplates.append(" OR ");
                }
                sqlWhereTemplates.append("VersionSeries").append(" = Object('").append(templateId).append("')");
            }
            if (sqlWhereTemplates.length() == 0) continue;
            sqlWhereTemplates.insert(0, "(").append(")");
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ").append(StringUtils.join(TEMPLATE_PROPERTIES, (String)", "));
            sql.append(" FROM ").append("Document");
            sql.append(" WHERE ").append("(").append((CharSequence)sqlWhereTemplates).append(")");
            sql.append(" AND ").append("VersionStatus").append(" = ").append(1);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Query to get entry template properties: " + sql);
            SearchScope scopeTemplates = new SearchScope(objectStore);
            SearchSQL searchTemplates = new SearchSQL();
            searchTemplates.setQueryString(sql.toString());
            pf = new PropertyFilter();
            pf.addIncludeProperty(1, null, null, "Id", null);
            RepositoryRowSet rows = scopeTemplates.fetchRows(searchTemplates, Integer.valueOf(numTemplates), pf, Boolean.FALSE);
            HashMap<String, Properties> resultsMap = new HashMap<String, Properties>();
            for (RepositoryRow row : rows) {
                Properties props = row.getProperties();
                VersionSeries vs = (VersionSeries)props.getEngineObjectValue("VersionSeries");
                String versionSeriesId = vs.get_Id().toString();
                resultsMap.put(versionSeriesId, props);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "templates.size(): " + templates.size());
            for (P8FolderTemplates.P8FolderTemplate template : templates) {
                String templateId = template.getTemplateVersionSeriesId();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "templateId: " + templateId);
                Properties props = (Properties)resultsMap.get(templateId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "props: " + props);
                if (props == null) continue;
                String id = props.getIdValue("Id").toString();
                String name = props.getStringValue("DocumentTitle");
                String description = props.getStringValue("EntryTemplateDescription");
                String osName = props.getStringValue("TargetObjectStoreName");
                String osId = null;
                if (osName.equals(objectStore.get_Name())) {
                    osId = objectStore.get_Id().toString();
                } else {
                    ObjectStore templateObjectStore = P8Util.getObjectStore(connection, osName);
                    if (templateObjectStore == null) continue;
                    osId = templateObjectStore.get_Id().toString();
                }
                String docId = P8Util.getDocId("EntryTemplate", osId, id);
                mediator.addEntryTemplate(docId, name, description, osName);
                ++entryTemplateCount;
            }
        }
        return entryTemplateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        P8Connection connection;
        String methodName = "executeAction";
        HttpSession session = request.getSession(false);
        MessageResources resources = this.getResources(request);
        Logger.logEntry((Object)this, "executeAction", (ServletRequest)request);
        P8Connection p8Connection = connection = this.getConnection(request);
        synchronized (p8Connection) {
            P8EntryTemplatesMediator mediator = (P8EntryTemplatesMediator)this.getMediator(request);
            String serverName = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "serverName = " + serverName);
            if (serverName == null || serverName.trim().length() < 1) {
                mediator.addError("error.parm.null", "repositoryId");
            }
            String folderDocId = request.getParameter("folderDocid");
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "folderDocId = " + folderDocId);
            String rootFolderId = request.getParameter("rootFolderId");
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "rootFolderId = " + rootFolderId);
            String filter = request.getParameter("filter_type");
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "filter = " + filter);
            String mimeType = null;
            if (filter.equals("Document")) {
                mimeType = "application/x-filenet-documententrytemplate";
            } else if (filter.equals("Folder")) {
                mimeType = "application/x-filenet-folderentrytemplate";
            }
            Logger.logDebug((Object)this, "executeAction", (ServletRequest)request, "mimeType = " + (mimeType != null ? mimeType : ""));
            try {
                if (serverName != null) {
                    mediator.setRepositoryId(serverName);
                    ObjectStore objectStore = P8Util.getObjectStore(request, connection, null);
                    int entryTemplateCount = 0;
                    entryTemplateCount = folderDocId != null && folderDocId.length() > 0 ? this.retrieveEntryTemplatesAssociatedWithFolder(connection, objectStore, mediator, folderDocId, rootFolderId) : this.searchForAllEntryTemplates(objectStore, mediator, mimeType);
                    mediator.addMessage("entryTemplates.search.successful", entryTemplateCount);
                } else {
                    mediator.addError("error.parm.null");
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, "executeAction");
                Logger.logError((Object)this, "executeAction", (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
            Logger.logExit((Object)this, "executeAction", (ServletRequest)request);
        }
        this.writeJSONMediator(request, response);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8EntryTemplatesMediator mediator = new P8EntryTemplatesMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

