/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.RealmSet;
import com.filenet.api.constants.PrincipalSearchAttribute;
import com.filenet.api.constants.PrincipalSearchSortType;
import com.filenet.api.constants.PrincipalSearchType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.security.Realm;
import com.ibm.ecm.Constants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8FindUsersGroupsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8FindUsersGroupsAction
extends P8BaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        request.setCharacterEncoding("UTF-8");
        MessageResources resources = this.getResources(request);
        ActionForward actionForward = null;
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        P8FindUsersGroupsMediator findUsersGroupsMediator = (P8FindUsersGroupsMediator)this.getMediator(request);
        try {
            if (ceConnection != null) {
                String searchString = request.getParameter("searchString");
                String directoryName = request.getParameter("directoryName");
                String searchType = request.getParameter("searchType");
                String sortType = request.getParameter("sortType");
                String max = request.getParameter("maxResult");
                String searchAttribute = request.getParameter("searchAttribute");
                Realm realm = this.getRealm(ceConnection, directoryName);
                PrincipalSearchType principalSearchType = this.getSearchType(searchType);
                PrincipalSearchSortType principalSortType = this.getSortType(sortType);
                PrincipalSearchAttribute principalSearchAttribute = this.getSearchAttribute(searchAttribute);
                boolean isFindUsers = mapping.getPath().endsWith("/findUsers");
                Object ios = isFindUsers ? realm.findUsers(searchString, principalSearchType, principalSearchAttribute, principalSortType, Integer.getInteger(max), null) : realm.findGroups(searchString, principalSearchType, principalSearchAttribute, principalSortType, Integer.getInteger(max), null);
                findUsersGroupsMediator.setUserGroupSet((IndependentObjectSet)ios);
                findUsersGroupsMediator.setPageSize(Integer.parseInt(max));
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Users or groups were retrieved");
                findUsersGroupsMediator.addMessage(isFindUsers ? "users.retrieve.successful" : "groups.retrieve.successful", new Object[0]);
            }
        }
        catch (Throwable e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, e);
            findUsersGroupsMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private Realm getRealm(Connection connection, String domainName) {
        Realm realm = null;
        RealmSet realmSet = Factory.EntireNetwork.fetchInstance((Connection)connection, null).get_AllRealms();
        Iterator it = realmSet.iterator();
        while (it.hasNext() && !(realm = (Realm)it.next()).get_Name().equals(domainName)) {
        }
        return realm;
    }

    private PrincipalSearchType getSearchType(String searchType) {
        int type = Integer.parseInt(searchType);
        switch (type) {
            case 4: {
                return PrincipalSearchType.CONTAINS;
            }
            case 5: {
                return PrincipalSearchType.EXACT;
            }
            case 0: {
                return PrincipalSearchType.NONE;
            }
            case 2: {
                return PrincipalSearchType.PREFIX_MATCH;
            }
            case 3: {
                return PrincipalSearchType.SUFFIX_MATCH;
            }
            case 1: {
                return PrincipalSearchType.CUSTOM;
            }
        }
        return PrincipalSearchType.PREFIX_MATCH;
    }

    private PrincipalSearchSortType getSortType(String sortType) {
        int type = Integer.parseInt(sortType);
        switch (type) {
            case 1: {
                return PrincipalSearchSortType.ASCENDING;
            }
            case 2: {
                return PrincipalSearchSortType.DESCENDING;
            }
        }
        return PrincipalSearchSortType.NONE;
    }

    private PrincipalSearchAttribute getSearchAttribute(String searchAttribute) {
        if (searchAttribute == null) {
            return PrincipalSearchAttribute.DISPLAY_NAME;
        }
        int type = Integer.parseInt(searchAttribute);
        switch (type) {
            case 2: {
                return PrincipalSearchAttribute.DISPLAY_NAME;
            }
            case 1: {
                return PrincipalSearchAttribute.SHORT_NAME;
            }
        }
        return PrincipalSearchAttribute.NONE;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        String searchString = request.getParameter("searchString");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: searchString = " + searchString);
        if (searchString == null || searchString.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "searchString");
            this.setRequestHasErrors(request, true);
        }
        String directoryName = request.getParameter("directoryName");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: directoryName = " + directoryName);
        if (directoryName == null || directoryName.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "directoryName");
            this.setRequestHasErrors(request, true);
        }
        String searchType = request.getParameter("searchType");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: searchType = " + searchType);
        if (searchType == null || searchType.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "searchType");
            this.setRequestHasErrors(request, true);
        }
        String sortType = request.getParameter("sortType");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: sortType = " + sortType);
        if (sortType == null || sortType.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "sortType");
            this.setRequestHasErrors(request, true);
        }
        String max = request.getParameter("maxResult");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: maxResult = " + max);
        if (max == null || max.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "maxResult");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8FindUsersGroupsMediator userGroupListMediator = new P8FindUsersGroupsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)userGroupListMediator);
        return userGroupListMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

