/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchScope;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8ClassesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.p8.P8TeamspaceService;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.json.java.JSONArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8FindClassesAction
extends P8BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    private static final String FILTER_TYPE_SEARCH = "search";
    private static final String INCLUDE_HIDDEN_CLASSES = "includeHiddenClasses";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        ActionForward actionForward = null;
        HttpSession session = request.getSession(false);
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        P8Connection p8Connection = connection;
        synchronized (p8Connection) {
            boolean includeHiddenClasses;
            String itemListParam;
            P8ClassesMediator mediator = (P8ClassesMediator)this.getMediator(request);
            String serverName = request.getParameter("repositoryId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
            String workspaceId = request.getParameter("workspaceId");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + workspaceId);
            String parentClassName = request.getParameter("class_name");
            if (parentClassName != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parentClassName      = " + parentClassName);
            }
            if ((itemListParam = request.getParameter("itemList")) != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemListParam      = " + itemListParam);
            }
            String filterType = request.getParameter("filter_type");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "filterType = " + filterType);
            boolean bl = includeHiddenClasses = request.getAttribute(INCLUDE_HIDDEN_CLASSES) != null;
            if (serverName == null || serverName.trim().length() < 1) {
                mediator.addError("error.parm.null", "repositoryId");
            }
            try {
                if (serverName != null) {
                    mediator.setServerDisplayName(serverName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, " connection = " + ceConnection);
                    List<Object> _classes = new ArrayList();
                    boolean teamspaceMode = false;
                    if (workspaceId != null && workspaceId.length() > 0) {
                        P8TeamspaceService teamspaceService = new P8TeamspaceService(ceConnection, connection.getDomain(), connection.getObjectStore(), connection, request);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieving teamspace");
                        Teamspace teamspace = teamspaceService.retrieveTeamspace(workspaceId, "classes", "instance");
                        if (teamspace != null) {
                            _classes = teamspace.getClasses();
                            if (_classes != null && !_classes.isEmpty()) {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "_classes: " + _classes.size());
                                teamspaceMode = true;
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspace mode is true");
                            } else {
                                teamspaceMode = true;
                                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "No classes found in the teamspace.");
                            }
                        } else {
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "teamspace not found!");
                        }
                    }
                    ObjectStore objectStore = connection.getObjectStore();
                    Iterator classDescriptionIterator = null;
                    if (parentClassName == null) {
                        if (itemListParam != null && itemListParam.length() > 0 && !teamspaceMode) {
                            JSONArray array = JSONArray.parse(itemListParam);
                            String[] classList = new String[array.size()];
                            for (int i = 0; i < array.size(); ++i) {
                                classList[i] = (String)array.get(i);
                            }
                            ClassDescriptionSet lst = this.getClassDefinitions(objectStore, classList);
                            classDescriptionIterator = lst.iterator();
                        } else if (teamspaceMode) {
                            if (_classes == null) {
                                _classes = new ArrayList();
                            }
                            String[] sl = _classes.toArray(new String[0]);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "_classes in workspace size = " + sl.length);
                            if (sl.length > 0) {
                                ClassDescriptionSet lst = this.getClassDefinitions(objectStore, sl);
                                classDescriptionIterator = lst.iterator();
                            }
                        } else {
                            classDescriptionIterator = objectStore.get_ClassDescriptions().iterator();
                        }
                    } else {
                        ClassDefinition parentClass = this.getSubClassDefinitions(objectStore, parentClassName);
                        classDescriptionIterator = parentClass.get_ImmediateSubclassDefinitions().iterator();
                        mediator.setParentClass(parentClass);
                    }
                    int classCount = 0;
                    while (classDescriptionIterator != null && classDescriptionIterator.hasNext()) {
                        boolean includeStoredSearch;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "classDescriptionIterator.hasNext() = " + classDescriptionIterator.hasNext());
                        Object nextClass = classDescriptionIterator.next();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "class = " + classCount);
                        if (nextClass instanceof ClassDescription) {
                            ClassDescription classDescription = (ClassDescription)nextClass;
                            boolean bl2 = includeStoredSearch = FILTER_TYPE_SEARCH.equals(filterType) && classDescription.get_SymbolicName().equals("StoredSearch");
                            if (!includeStoredSearch && (!includeHiddenClasses && classDescription.get_IsHidden().booleanValue() || !classDescription.describedIsOfClass("Document").booleanValue() && !classDescription.describedIsOfClass("Folder").booleanValue())) continue;
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "addclass = " + classCount);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "classDescription.get_Id() = " + classDescription.get_Id());
                            mediator.addClass(classDescription);
                            ++classCount;
                            continue;
                        }
                        if (!(nextClass instanceof ClassDefinition)) continue;
                        ClassDefinition classDef = (ClassDefinition)nextClass;
                        boolean bl3 = includeStoredSearch = FILTER_TYPE_SEARCH.equals(filterType) && classDef.get_SymbolicName().equals("StoredSearch");
                        if (!includeStoredSearch && !includeHiddenClasses && classDef.get_IsHidden().booleanValue() || !this.canReadClass(classDef)) continue;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "classDef.get_Id() = " + classDef.get_Id());
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "addclass = " + classCount);
                        mediator.addClass(classDef);
                        ++classCount;
                    }
                    int classesToDisplay = classCount;
                    if (classesToDisplay > this.getMaxFolders()) {
                        mediator.addMessage("folders.search.successful.maxItems", classCount, this.getMaxFolders());
                        classesToDisplay = this.getMaxFolders();
                    } else {
                        mediator.addMessage("folders.search.successful", classCount);
                    }
                    if (classCount == 0 && parentClassName == null && !teamspaceMode) {
                        mediator.addWarning("folders.search.nothingfound", new Object[0]);
                    }
                    mediator.setMaxClasses(classesToDisplay);
                } else {
                    mediator.addError("error.parm.null");
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
        }
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8ClassesMediator mediator = new P8ClassesMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }

    private static PropertyFilter getSubClassesPropertyFilter() {
        PropertyFilter pf = new PropertyFilter();
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "ImmediateSubclassDescriptions", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(0), null, null, "ImmediateSubclassDefinitions", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "SymbolicName", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "Id", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "DisplayName", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "IsHidden", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "AllowsInstances", null));
        pf.addIncludeProperty(new FilterElement(Integer.valueOf(1), null, null, "DescriptiveText", null));
        return pf;
    }

    private ClassDefinition getSubClassDefinitions(ObjectStore objectStore, String className) {
        ClassDefinition parentClass = Factory.ClassDefinition.fetchInstance((ObjectStore)objectStore, (String)className, (PropertyFilter)P8FindClassesAction.getSubClassesPropertyFilter());
        return parentClass;
    }

    private ClassDescriptionSet getClassDefinitions(ObjectStore objectStore, String[] classList) {
        String methodName = "getClassDefinitions";
        for (int i = 0; i < classList.length; ++i) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "classList      = " + classList[i]);
        }
        SearchScope search = new SearchScope(objectStore);
        String[] classNames = classList;
        PropertyFilter myFilter = P8FindClassesAction.getSubClassesPropertyFilter();
        ClassDescriptionSet classDescriptionSet = search.fetchSearchableClassDescriptions(classNames, myFilter);
        return classDescriptionSet;
    }

    private boolean canReadClass(ClassDefinition classDef) {
        return (classDef.getAccessAllowed() & 1) == 1;
    }
}

