/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.p8;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Containable;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.Scope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.ibm.ecm.Constants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.p8.P8SearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Permission;
import com.ibm.ecm.util.p8.P8SearchResultsBean;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class P8EditAttributesAction
extends P8BaseAction
implements Constants {
    private int pageSize = 0;
    private int maxResults = 0;
    private WCDateFormat wcDateFormats = null;
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = connection.getCEConnection();
        ClassDescription classDescription = null;
        Connection connection2 = ceConnection;
        synchronized (connection2) {
            P8SearchResultsMediator searchResultsMediator = (P8SearchResultsMediator)this.getMediator(request);
            HashMap updatedDocIds = new HashMap(1);
            try {
                String origDocId;
                this.getConfigInfo(request);
                String serverName = request.getParameter("repositoryId");
                String folderName = request.getParameter("template_name");
                String newDocId = origDocId = request.getParameter("docid");
                String clientSiteVersionControlSetting = request.getParameter("parm_version_control");
                String strJsonChildComponentValues = request.getParameter("childComponentValues");
                JSONArray jsonArray = (JSONArray)this.getJSONRequest(request);
                JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                JSONArray criteriasJsonArray = (JSONArray)jsonObj.get("criterias");
                JSONArray permissionJsonArray = (JSONArray)jsonObj.get("acl");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + folderName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + origDocId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: versionControl = " + clientSiteVersionControlSetting);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: strJsonChildComponentValues = " + strJsonChildComponentValues);
                searchResultsMediator.setServerName(serverName);
                ObjectStore objectStore = connection.getObjectStore();
                classDescription = Factory.ClassDescription.fetchInstance((Scope)objectStore, (String)folderName, null);
                searchResultsMediator.addClassDescription(classDescription);
                searchResultsMediator.setServer(connection);
                IndependentlyPersistableObject item = P8Util.getPersistableObject(request, connection, origDocId);
                this.updateItem(criteriasJsonArray, clientSiteVersionControlSetting, item, request, searchResultsMediator, updatedDocIds);
                if (permissionJsonArray != null) {
                    this.updatePermissions(connection, item, permissionJsonArray, request, searchResultsMediator);
                }
                ArrayList<IndependentlyPersistableObject> hits = new ArrayList<IndependentlyPersistableObject>(1);
                hits.add(item);
                P8SearchResultsBean searchResultsBean = new P8SearchResultsBean(request);
                searchResultsBean.setHits(hits);
                searchResultsMediator.setPageSize(this.getPageSize());
                searchResultsMediator.setUpdatedDocIds(updatedDocIds);
                searchResultsMediator.setSearchResultsBean(searchResultsBean);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("editProperies.error", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private IndependentObject updateItem(JSONArray criteriasJsonArray, String clientSiteVersionControlSetting, IndependentlyPersistableObject item, HttpServletRequest request, P8SearchResultsMediator searchResultsMediator, HashMap updatedDocIds) throws Exception {
        String methodName = "updateItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        P8Connection connection = this.getConnection(request);
        Connection ceConnection = this.getConnection(request).getCEConnection();
        String origDocId = request.getParameter("docid");
        boolean createNewVersion = true;
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "create new version? " + createNewVersion);
        boolean isCheckedOut = false;
        try {
            if (ceConnection == null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Problems during check out check. Either there is no connection to cm (DKDatastoreICM) or check out is not supported.");
                isCheckedOut = false;
                searchResultsMediator.addError("editProperties.error.server");
            }
            ClassDescription classDescription = item.get_ClassDescription();
            P8Util.setProperties(request, (IndependentObject)item, criteriasJsonArray, classDescription);
            item.save(RefreshMode.REFRESH);
            updatedDocIds.put(item.getObjectReference(), origDocId);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            searchResultsMediator.addError("editProperies.error", e.getMessage());
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return item;
    }

    private void updatePermissions(P8Connection connection, IndependentlyPersistableObject ipo, JSONArray permissionsJsonArray, HttpServletRequest request, P8SearchResultsMediator searchResultsMediator) throws Exception {
        String methodName;
        block6: {
            methodName = "updatePermissions";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            try {
                AccessPermissionList apl = P8Permission.getPermissionsFromJSON(permissionsJsonArray);
                if (apl == null) break block6;
                Containable item = (Containable)ipo;
                String name = item.get_Name();
                ipo.getProperties().putValue("Permissions", (DependentObjectList)apl);
                ipo.save(RefreshMode.NO_REFRESH);
                try {
                    ipo.refresh();
                    apl = item.get_Permissions();
                    List<P8Permission> permissions = P8Permission.getPermissions(connection, apl, true);
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("acl", P8Permission.permissionsToJSONObject(permissions));
                    searchResultsMediator.setACLJson(jsonObj);
                }
                catch (EngineRuntimeException ere) {
                    ExceptionCode exceptionCode = ere.getExceptionCode();
                    String exceptionMessage = ere.getLocalizedMessage();
                    if (exceptionCode == ExceptionCode.E_OBJECT_NOT_FOUND) {
                        searchResultsMediator.addError("error.exception.updateditemnotfound", name);
                        break block6;
                    }
                    searchResultsMediator.addError("editProperies.error", exceptionMessage);
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                String exceptionMessage = e.getMessage();
                if (exceptionMessage == null || exceptionMessage.equals("")) {
                    exceptionMessage = e.toString();
                }
                searchResultsMediator.addError("editProperies.error", exceptionMessage);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template_name");
        String pid = request.getParameter("docid");
        String strJsonFormData = request.getParameter("criterias");
        return serverName != null && itemTypeName != null && pid != null && strJsonFormData != null;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        P8SearchResultsMediator mediator = new P8SearchResultsMediator(request, this.getResources(request), request.getLocale());
        return mediator;
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template_name");
        String pid = request.getParameter("docid");
        String strJsonFormData = request.getParameter("criterias");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: jsonFormData = " + strJsonFormData);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
    }

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String strJsonFormData = this.readJSON(request);
        JSONArray jsonArray = JSONArray.parse(strJsonFormData);
        request.setAttribute("json_post", (Object)jsonArray);
    }
}

